/*
 * Decompiled with CFR 0.152.
 */
package com.wavesenterprise.protobuf.service.contract;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.StringValue;
import com.google.protobuf.StringValueOrBuilder;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import com.wavesenterprise.protobuf.constants.Constants;
import com.wavesenterprise.protobuf.service.contract.ContractCryptoService;
import com.wavesenterprise.protobuf.service.contract.DecryptDataRequestOrBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class DecryptDataRequest
extends GeneratedMessageV3
implements DecryptDataRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int RECIPIENT_FIELD_NUMBER = 1;
    private volatile Object recipient_;
    public static final int PASSWORD_FIELD_NUMBER = 2;
    private StringValue password_;
    public static final int ENCRYPTED_DATA_FIELD_NUMBER = 3;
    private ByteString encryptedData_;
    public static final int WRAPPED_KEY_FIELD_NUMBER = 4;
    private volatile Object wrappedKey_;
    public static final int SENDER_PUBLIC_KEY_FIELD_NUMBER = 5;
    private volatile Object senderPublicKey_;
    public static final int CRYPTO_ALGO_FIELD_NUMBER = 6;
    private int cryptoAlgo_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final DecryptDataRequest DEFAULT_INSTANCE = new DecryptDataRequest();
    private static final Parser<DecryptDataRequest> PARSER = new AbstractParser<DecryptDataRequest>(){

        public DecryptDataRequest parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return new DecryptDataRequest(input, extensionRegistry);
        }
    };

    private DecryptDataRequest(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private DecryptDataRequest() {
        this.recipient_ = "";
        this.encryptedData_ = ByteString.EMPTY;
        this.wrappedKey_ = "";
        this.senderPublicKey_ = "";
        this.cryptoAlgo_ = 0;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new DecryptDataRequest();
    }

    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    private DecryptDataRequest(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
            throw new NullPointerException();
        }
        UnknownFieldSet.Builder unknownFields = UnknownFieldSet.newBuilder();
        try {
            boolean done = false;
            block16: while (!done) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        done = true;
                        continue block16;
                    }
                    case 10: {
                        String s = input.readStringRequireUtf8();
                        this.recipient_ = s;
                        continue block16;
                    }
                    case 18: {
                        StringValue.Builder subBuilder = null;
                        if (this.password_ != null) {
                            subBuilder = this.password_.toBuilder();
                        }
                        this.password_ = (StringValue)input.readMessage(StringValue.parser(), extensionRegistry);
                        if (subBuilder == null) continue block16;
                        subBuilder.mergeFrom(this.password_);
                        this.password_ = subBuilder.buildPartial();
                        continue block16;
                    }
                    case 26: {
                        this.encryptedData_ = input.readBytes();
                        continue block16;
                    }
                    case 34: {
                        String s = input.readStringRequireUtf8();
                        this.wrappedKey_ = s;
                        continue block16;
                    }
                    case 42: {
                        String s = input.readStringRequireUtf8();
                        this.senderPublicKey_ = s;
                        continue block16;
                    }
                    case 48: {
                        int rawValue;
                        this.cryptoAlgo_ = rawValue = input.readEnum();
                        continue block16;
                    }
                }
                if (this.parseUnknownField(input, unknownFields, extensionRegistry, tag)) continue;
                done = true;
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage((MessageLite)this);
        }
        catch (UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)this);
        }
        catch (IOException e) {
            throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)this);
        }
        finally {
            this.unknownFields = unknownFields.build();
            this.makeExtensionsImmutable();
        }
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return ContractCryptoService.internal_static_wavesenterprise_DecryptDataRequest_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return ContractCryptoService.internal_static_wavesenterprise_DecryptDataRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(DecryptDataRequest.class, Builder.class);
    }

    @Override
    public String getRecipient() {
        Object ref = this.recipient_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.recipient_ = s;
        return s;
    }

    @Override
    public ByteString getRecipientBytes() {
        Object ref = this.recipient_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.recipient_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasPassword() {
        return this.password_ != null;
    }

    @Override
    public StringValue getPassword() {
        return this.password_ == null ? StringValue.getDefaultInstance() : this.password_;
    }

    @Override
    public StringValueOrBuilder getPasswordOrBuilder() {
        return this.getPassword();
    }

    @Override
    public ByteString getEncryptedData() {
        return this.encryptedData_;
    }

    @Override
    public String getWrappedKey() {
        Object ref = this.wrappedKey_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.wrappedKey_ = s;
        return s;
    }

    @Override
    public ByteString getWrappedKeyBytes() {
        Object ref = this.wrappedKey_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.wrappedKey_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getSenderPublicKey() {
        Object ref = this.senderPublicKey_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.senderPublicKey_ = s;
        return s;
    }

    @Override
    public ByteString getSenderPublicKeyBytes() {
        Object ref = this.senderPublicKey_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.senderPublicKey_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getCryptoAlgoValue() {
        return this.cryptoAlgo_;
    }

    @Override
    public Constants.CryptoAlgo getCryptoAlgo() {
        Constants.CryptoAlgo result = Constants.CryptoAlgo.valueOf(this.cryptoAlgo_);
        return result == null ? Constants.CryptoAlgo.UNRECOGNIZED : result;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if (!GeneratedMessageV3.isStringEmpty((Object)this.recipient_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.recipient_);
        }
        if (this.password_ != null) {
            output.writeMessage(2, (MessageLite)this.getPassword());
        }
        if (!this.encryptedData_.isEmpty()) {
            output.writeBytes(3, this.encryptedData_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.wrappedKey_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)4, (Object)this.wrappedKey_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.senderPublicKey_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)5, (Object)this.senderPublicKey_);
        }
        if (this.cryptoAlgo_ != Constants.CryptoAlgo.UNKNOWN_CRYPTO_ALGO.getNumber()) {
            output.writeEnum(6, this.cryptoAlgo_);
        }
        this.unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.recipient_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.recipient_);
        }
        if (this.password_ != null) {
            size += CodedOutputStream.computeMessageSize((int)2, (MessageLite)this.getPassword());
        }
        if (!this.encryptedData_.isEmpty()) {
            size += CodedOutputStream.computeBytesSize((int)3, (ByteString)this.encryptedData_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.wrappedKey_)) {
            size += GeneratedMessageV3.computeStringSize((int)4, (Object)this.wrappedKey_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.senderPublicKey_)) {
            size += GeneratedMessageV3.computeStringSize((int)5, (Object)this.senderPublicKey_);
        }
        if (this.cryptoAlgo_ != Constants.CryptoAlgo.UNKNOWN_CRYPTO_ALGO.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)6, (int)this.cryptoAlgo_);
        }
        this.memoizedSize = size += this.unknownFields.getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DecryptDataRequest)) {
            return super.equals(obj);
        }
        DecryptDataRequest other = (DecryptDataRequest)obj;
        if (!this.getRecipient().equals(other.getRecipient())) {
            return false;
        }
        if (this.hasPassword() != other.hasPassword()) {
            return false;
        }
        if (this.hasPassword() && !this.getPassword().equals((Object)other.getPassword())) {
            return false;
        }
        if (!this.getEncryptedData().equals((Object)other.getEncryptedData())) {
            return false;
        }
        if (!this.getWrappedKey().equals(other.getWrappedKey())) {
            return false;
        }
        if (!this.getSenderPublicKey().equals(other.getSenderPublicKey())) {
            return false;
        }
        if (this.cryptoAlgo_ != other.cryptoAlgo_) {
            return false;
        }
        return this.unknownFields.equals((Object)other.unknownFields);
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + DecryptDataRequest.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getRecipient().hashCode();
        if (this.hasPassword()) {
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getPassword().hashCode();
        }
        hash = 37 * hash + 3;
        hash = 53 * hash + this.getEncryptedData().hashCode();
        hash = 37 * hash + 4;
        hash = 53 * hash + this.getWrappedKey().hashCode();
        hash = 37 * hash + 5;
        hash = 53 * hash + this.getSenderPublicKey().hashCode();
        hash = 37 * hash + 6;
        hash = 53 * hash + this.cryptoAlgo_;
        this.memoizedHashCode = hash = 29 * hash + this.unknownFields.hashCode();
        return hash;
    }

    public static DecryptDataRequest parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (DecryptDataRequest)PARSER.parseFrom(data);
    }

    public static DecryptDataRequest parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (DecryptDataRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static DecryptDataRequest parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (DecryptDataRequest)PARSER.parseFrom(data);
    }

    public static DecryptDataRequest parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (DecryptDataRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static DecryptDataRequest parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (DecryptDataRequest)PARSER.parseFrom(data);
    }

    public static DecryptDataRequest parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (DecryptDataRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static DecryptDataRequest parseFrom(InputStream input) throws IOException {
        return (DecryptDataRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static DecryptDataRequest parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (DecryptDataRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static DecryptDataRequest parseDelimitedFrom(InputStream input) throws IOException {
        return (DecryptDataRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static DecryptDataRequest parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (DecryptDataRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static DecryptDataRequest parseFrom(CodedInputStream input) throws IOException {
        return (DecryptDataRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static DecryptDataRequest parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (DecryptDataRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return DecryptDataRequest.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(DecryptDataRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static DecryptDataRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<DecryptDataRequest> parser() {
        return PARSER;
    }

    public Parser<DecryptDataRequest> getParserForType() {
        return PARSER;
    }

    public DecryptDataRequest getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements DecryptDataRequestOrBuilder {
        private Object recipient_ = "";
        private StringValue password_;
        private SingleFieldBuilderV3<StringValue, StringValue.Builder, StringValueOrBuilder> passwordBuilder_;
        private ByteString encryptedData_ = ByteString.EMPTY;
        private Object wrappedKey_ = "";
        private Object senderPublicKey_ = "";
        private int cryptoAlgo_ = 0;

        public static final Descriptors.Descriptor getDescriptor() {
            return ContractCryptoService.internal_static_wavesenterprise_DecryptDataRequest_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return ContractCryptoService.internal_static_wavesenterprise_DecryptDataRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(DecryptDataRequest.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                // empty if block
            }
        }

        public Builder clear() {
            super.clear();
            this.recipient_ = "";
            if (this.passwordBuilder_ == null) {
                this.password_ = null;
            } else {
                this.password_ = null;
                this.passwordBuilder_ = null;
            }
            this.encryptedData_ = ByteString.EMPTY;
            this.wrappedKey_ = "";
            this.senderPublicKey_ = "";
            this.cryptoAlgo_ = 0;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return ContractCryptoService.internal_static_wavesenterprise_DecryptDataRequest_descriptor;
        }

        public DecryptDataRequest getDefaultInstanceForType() {
            return DecryptDataRequest.getDefaultInstance();
        }

        public DecryptDataRequest build() {
            DecryptDataRequest result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public DecryptDataRequest buildPartial() {
            DecryptDataRequest result = new DecryptDataRequest(this);
            result.recipient_ = this.recipient_;
            if (this.passwordBuilder_ == null) {
                result.password_ = this.password_;
            } else {
                result.password_ = (StringValue)this.passwordBuilder_.build();
            }
            result.encryptedData_ = this.encryptedData_;
            result.wrappedKey_ = this.wrappedKey_;
            result.senderPublicKey_ = this.senderPublicKey_;
            result.cryptoAlgo_ = this.cryptoAlgo_;
            this.onBuilt();
            return result;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof DecryptDataRequest) {
                return this.mergeFrom((DecryptDataRequest)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(DecryptDataRequest other) {
            if (other == DecryptDataRequest.getDefaultInstance()) {
                return this;
            }
            if (!other.getRecipient().isEmpty()) {
                this.recipient_ = other.recipient_;
                this.onChanged();
            }
            if (other.hasPassword()) {
                this.mergePassword(other.getPassword());
            }
            if (other.getEncryptedData() != ByteString.EMPTY) {
                this.setEncryptedData(other.getEncryptedData());
            }
            if (!other.getWrappedKey().isEmpty()) {
                this.wrappedKey_ = other.wrappedKey_;
                this.onChanged();
            }
            if (!other.getSenderPublicKey().isEmpty()) {
                this.senderPublicKey_ = other.senderPublicKey_;
                this.onChanged();
            }
            if (other.cryptoAlgo_ != 0) {
                this.setCryptoAlgoValue(other.getCryptoAlgoValue());
            }
            this.mergeUnknownFields(other.unknownFields);
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            DecryptDataRequest parsedMessage = null;
            try {
                parsedMessage = (DecryptDataRequest)PARSER.parsePartialFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                parsedMessage = (DecryptDataRequest)e.getUnfinishedMessage();
                throw e.unwrapIOException();
            }
            finally {
                if (parsedMessage != null) {
                    this.mergeFrom(parsedMessage);
                }
            }
            return this;
        }

        @Override
        public String getRecipient() {
            Object ref = this.recipient_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.recipient_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getRecipientBytes() {
            Object ref = this.recipient_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.recipient_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setRecipient(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.recipient_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearRecipient() {
            this.recipient_ = DecryptDataRequest.getDefaultInstance().getRecipient();
            this.onChanged();
            return this;
        }

        public Builder setRecipientBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            DecryptDataRequest.checkByteStringIsUtf8((ByteString)value);
            this.recipient_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasPassword() {
            return this.passwordBuilder_ != null || this.password_ != null;
        }

        @Override
        public StringValue getPassword() {
            if (this.passwordBuilder_ == null) {
                return this.password_ == null ? StringValue.getDefaultInstance() : this.password_;
            }
            return (StringValue)this.passwordBuilder_.getMessage();
        }

        public Builder setPassword(StringValue value) {
            if (this.passwordBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.password_ = value;
                this.onChanged();
            } else {
                this.passwordBuilder_.setMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder setPassword(StringValue.Builder builderForValue) {
            if (this.passwordBuilder_ == null) {
                this.password_ = builderForValue.build();
                this.onChanged();
            } else {
                this.passwordBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder mergePassword(StringValue value) {
            if (this.passwordBuilder_ == null) {
                this.password_ = this.password_ != null ? StringValue.newBuilder((StringValue)this.password_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                this.passwordBuilder_.mergeFrom((AbstractMessage)value);
            }
            return this;
        }

        public Builder clearPassword() {
            if (this.passwordBuilder_ == null) {
                this.password_ = null;
                this.onChanged();
            } else {
                this.password_ = null;
                this.passwordBuilder_ = null;
            }
            return this;
        }

        public StringValue.Builder getPasswordBuilder() {
            this.onChanged();
            return (StringValue.Builder)this.getPasswordFieldBuilder().getBuilder();
        }

        @Override
        public StringValueOrBuilder getPasswordOrBuilder() {
            if (this.passwordBuilder_ != null) {
                return (StringValueOrBuilder)this.passwordBuilder_.getMessageOrBuilder();
            }
            return this.password_ == null ? StringValue.getDefaultInstance() : this.password_;
        }

        private SingleFieldBuilderV3<StringValue, StringValue.Builder, StringValueOrBuilder> getPasswordFieldBuilder() {
            if (this.passwordBuilder_ == null) {
                this.passwordBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getPassword(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.password_ = null;
            }
            return this.passwordBuilder_;
        }

        @Override
        public ByteString getEncryptedData() {
            return this.encryptedData_;
        }

        public Builder setEncryptedData(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.encryptedData_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearEncryptedData() {
            this.encryptedData_ = DecryptDataRequest.getDefaultInstance().getEncryptedData();
            this.onChanged();
            return this;
        }

        @Override
        public String getWrappedKey() {
            Object ref = this.wrappedKey_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.wrappedKey_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getWrappedKeyBytes() {
            Object ref = this.wrappedKey_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.wrappedKey_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setWrappedKey(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.wrappedKey_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearWrappedKey() {
            this.wrappedKey_ = DecryptDataRequest.getDefaultInstance().getWrappedKey();
            this.onChanged();
            return this;
        }

        public Builder setWrappedKeyBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            DecryptDataRequest.checkByteStringIsUtf8((ByteString)value);
            this.wrappedKey_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public String getSenderPublicKey() {
            Object ref = this.senderPublicKey_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.senderPublicKey_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getSenderPublicKeyBytes() {
            Object ref = this.senderPublicKey_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.senderPublicKey_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setSenderPublicKey(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.senderPublicKey_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearSenderPublicKey() {
            this.senderPublicKey_ = DecryptDataRequest.getDefaultInstance().getSenderPublicKey();
            this.onChanged();
            return this;
        }

        public Builder setSenderPublicKeyBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            DecryptDataRequest.checkByteStringIsUtf8((ByteString)value);
            this.senderPublicKey_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public int getCryptoAlgoValue() {
            return this.cryptoAlgo_;
        }

        public Builder setCryptoAlgoValue(int value) {
            this.cryptoAlgo_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public Constants.CryptoAlgo getCryptoAlgo() {
            Constants.CryptoAlgo result = Constants.CryptoAlgo.valueOf(this.cryptoAlgo_);
            return result == null ? Constants.CryptoAlgo.UNRECOGNIZED : result;
        }

        public Builder setCryptoAlgo(Constants.CryptoAlgo value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.cryptoAlgo_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearCryptoAlgo() {
            this.cryptoAlgo_ = 0;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

