/*
 * Decompiled with CFR 0.152.
 */
package com.wda.sdbc.postgresql;

import com.wda.sdbc.PostgreSql$;
import com.wda.sdbc.base.Batch;
import com.wda.sdbc.base.Connection;
import com.wda.sdbc.base.IntParameter;
import com.wda.sdbc.base.Row;
import com.wda.sdbc.postgresql.PostgreSqlSuite;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.ConfigMap;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.TestData;
import org.scalatest.fixture.FunSuiteLike;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Seq$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u00152A!\u0001\u0002\u0001\u0017\tq!+[2i%\u0016\u001cX\u000f\u001c;Ta\u0016\u001c'BA\u0002\u0005\u0003)\u0001xn\u001d;he\u0016\u001c\u0018\u000f\u001c\u0006\u0003\u000b\u0019\tAa\u001d3cG*\u0011q\u0001C\u0001\u0004o\u0012\f'\"A\u0005\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001a\u0001\u0003\u0005\u0002\u000e\u001d5\t!!\u0003\u0002\u0010\u0005\ty\u0001k\\:uOJ,7+\u001d7Tk&$X\r\u0005\u0002\u0012-5\t!C\u0003\u0002\u0014)\u0005I1oY1mCR,7\u000f\u001e\u0006\u0002+\u0005\u0019qN]4\n\u0005]\u0011\"A\u0005\"fM>\u0014X-\u00118e\u0003\u001a$XM]#bG\"DQ!\u0007\u0001\u0005\u0002i\ta\u0001P5oSRtD#A\u000e\u0011\u00055\u0001\u0001\"B\u000f\u0001\t#r\u0012!C1gi\u0016\u0014X)Y2i)\u0005y\u0002C\u0001\u0011$\u001b\u0005\t#\"\u0001\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\n#\u0001B+oSR\u0004")
public class RichResultSpec
extends PostgreSqlSuite
implements BeforeAndAfterEach {
    public /* synthetic */ Status org$scalatest$BeforeAndAfterEach$$super$runTest(String testName, Args args) {
        return FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public void beforeEach() {
        BeforeAndAfterEach.class.beforeEach((BeforeAndAfterEach)this);
    }

    public void beforeEach(ConfigMap configMap) {
        BeforeAndAfterEach.class.beforeEach((BeforeAndAfterEach)this, (ConfigMap)configMap);
    }

    public void beforeEach(TestData testData) {
        BeforeAndAfterEach.class.beforeEach((BeforeAndAfterEach)this, (TestData)testData);
    }

    public void afterEach(ConfigMap configMap) {
        BeforeAndAfterEach.class.afterEach((BeforeAndAfterEach)this, (ConfigMap)configMap);
    }

    public void afterEach(TestData testData) {
        BeforeAndAfterEach.class.afterEach((BeforeAndAfterEach)this, (TestData)testData);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfterEach.class.runTest((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public void afterEach() {
        this.withPg(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Connection.Connection x$2) {
                x$2.execute("DROP TABLE IF EXISTS tbl;", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
        });
    }

    public RichResultSpec() {
        BeforeAndAfterEach.class.$init$((BeforeAndAfterEach)this);
        this.test("option() selects nothing from an empty table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RichResultSpec $outer;

            public final void apply(Connection.Connection connection) {
                Option result;
                PostgreSql$.MODULE$.Update().apply("CREATE TABLE tbl (x int)", PostgreSql$.MODULE$.Update().apply$default$2()).execute(connection);
                Option $org_scalatest_assert_macro_left = result = PostgreSql$.MODULE$.Select().apply("SELECT * FROM tbl", PostgreSql$.MODULE$.Select().apply$default$2(), PostgreSql$.MODULE$.GetterToRowSingleton(PostgreSql$.MODULE$.IntGetter())).option(connection);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Selecting from an empty table yielded a row.");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("option() selects something from a nonempty table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RichResultSpec $outer;

            public final void apply(Connection.Connection connection) {
                PostgreSql$.MODULE$.Update().apply("CREATE TABLE tbl (x serial)", PostgreSql$.MODULE$.Update().apply$default$2()).execute(connection);
                PostgreSql$.MODULE$.Update().apply("INSERT INTO tbl DEFAULT VALUES", PostgreSql$.MODULE$.Update().apply$default$2()).execute(connection);
                Option result = PostgreSql$.MODULE$.Select().apply("SELECT * FROM tbl", PostgreSql$.MODULE$.Select().apply$default$2(), PostgreSql$.MODULE$.GetterToRowSingleton(PostgreSql$.MODULE$.IntGetter())).option(connection);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(result.isDefined(), "result.isDefined");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Selecting from a table with a row did not yeild a row.");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("seq() works on an empty result", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RichResultSpec $outer;

            public final void apply(Connection.Connection connection) {
                scala.collection.immutable.Seq results;
                PostgreSql$.MODULE$.Update().apply("CREATE TABLE tbl (x serial)", PostgreSql$.MODULE$.Update().apply$default$2()).execute(connection);
                scala.collection.immutable.Seq $org_scalatest_assert_macro_left = results = PostgreSql$.MODULE$.Select().apply("SELECT * FROM tbl", PostgreSql$.MODULE$.Select().apply$default$2(), PostgreSql$.MODULE$.GetterToRowSingleton(PostgreSql$.MODULE$.IntGetter())).seq(connection);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("seq() works on a single result", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RichResultSpec $outer;

            public final void apply(Connection.Connection connection) {
                scala.collection.immutable.Seq results;
                scala.collection.immutable.Seq $org_scalatest_assert_macro_left = results = PostgreSql$.MODULE$.Select().apply("SELECT 1::integer", PostgreSql$.MODULE$.Select().apply$default$2(), PostgreSql$.MODULE$.GetterToRowSingleton(PostgreSql$.MODULE$.IntGetter())).seq(connection);
                scala.collection.immutable.Seq $org_scalatest_assert_macro_right = (scala.collection.immutable.Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}));
                scala.collection.immutable.Seq seq = $org_scalatest_assert_macro_left;
                scala.collection.immutable.Seq seq2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("seq() works on several results", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RichResultSpec $outer;

            public final void apply(Connection.Connection connection) {
                scala.collection.immutable.Seq results;
                scala.collection.immutable.Seq randoms = (scala.collection.immutable.Seq)Seq$.MODULE$.fill(10, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return Random$.MODULE$.nextInt();
                    }
                });
                PostgreSql$.MODULE$.Update().apply("CREATE TABLE tbl (x int)", PostgreSql$.MODULE$.Update().apply$default$2()).execute(connection);
                Batch.Batch batch = (Batch.Batch)randoms.foldLeft((Object)PostgreSql$.MODULE$.Batch().apply("INSERT INTO tbl (x) VALUES ($x)", PostgreSql$.MODULE$.Batch().apply$default$2()), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Batch.Batch apply(Batch.Batch x0$1, int x1$1) {
                        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)BoxesRunTime.boxToInteger((int)x1$1));
                        if (tuple2 != null) {
                            Batch.Batch batch = (Batch.Batch)tuple2._1();
                            int r = tuple2._2$mcI$sp();
                            Batch.Batch batch2 = batch.addBatch((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"x"), (Object)PostgreSql$.MODULE$.ToOptionParameterValue((Object)BoxesRunTime.boxToInteger((int)r), (Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final IntParameter.QInt apply(int value) {
                                    return PostgreSql$.MODULE$.QInt(value);
                                }
                            }))}));
                            return batch2;
                        }
                        throw new MatchError((Object)tuple2);
                    }
                });
                scala.collection.immutable.Seq insertions = batch.batch(connection);
                int $org_scalatest_assert_macro_left = BoxesRunTime.unboxToInt((Object)insertions.sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                int $org_scalatest_assert_macro_right = randoms.size();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                scala.collection.immutable.Seq $org_scalatest_assert_macro_left2 = results = PostgreSql$.MODULE$.Select().apply("SELECT x FROM tbl", PostgreSql$.MODULE$.Select().apply$default$2(), PostgreSql$.MODULE$.GetterToRowSingleton(PostgreSql$.MODULE$.IntGetter())).seq(connection);
                scala.collection.immutable.Seq $org_scalatest_assert_macro_right2 = randoms;
                scala.collection.immutable.Seq seq = $org_scalatest_assert_macro_left2;
                scala.collection.immutable.Seq seq2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(seq != null ? !seq.equals(seq2) : seq2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("using SelectForUpdate to update a value works", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RichResultSpec $outer;

            public final void apply(Connection.Connection connection) {
                scala.collection.immutable.Seq randoms = (scala.collection.immutable.Seq)((SeqLike)Seq$.MODULE$.fill(10, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return Random$.MODULE$.nextInt();
                    }
                })).sorted((Ordering)Ordering.Int$.MODULE$);
                PostgreSql$.MODULE$.Update().apply("CREATE TABLE tbl (id serial PRIMARY KEY, x int)", PostgreSql$.MODULE$.Update().apply$default$2()).execute(connection);
                scala.collection.immutable.Seq incrementedRandoms = (scala.collection.immutable.Seq)randoms.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(int x$1) {
                        return this.apply$mcII$sp(x$1);
                    }

                    public int apply$mcII$sp(int x$1) {
                        return x$1 + 1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Batch.Batch batch = (Batch.Batch)randoms.foldRight((Object)PostgreSql$.MODULE$.Batch().apply("INSERT INTO tbl (x) VALUES ($x)", PostgreSql$.MODULE$.Batch().apply$default$2()), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Batch.Batch apply(int x0$2, Batch.Batch x1$2) {
                        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$2), (Object)x1$2);
                        if (tuple2 != null) {
                            int r = tuple2._1$mcI$sp();
                            Batch.Batch batch = (Batch.Batch)tuple2._2();
                            Batch.Batch batch2 = batch.addBatch((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"x"), (Object)PostgreSql$.MODULE$.ToOptionParameterValue((Object)BoxesRunTime.boxToInteger((int)r), (Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final IntParameter.QInt apply(int value) {
                                    return PostgreSql$.MODULE$.QInt(value);
                                }
                            }))}));
                            return batch2;
                        }
                        throw new MatchError((Object)tuple2);
                    }
                });
                batch.batch(connection);
                connection.iteratorForUpdate("SELECT * FROM tbl", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Row.MutableRow row) {
                        row.update("x", (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)row.apply("x", PostgreSql$.MODULE$.IntGetter())) + 1)), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final IntParameter.QInt apply(int value) {
                                return PostgreSql$.MODULE$.QInt(value);
                            }
                        });
                    }
                });
                scala.collection.immutable.Seq incrementedFromDb = connection.seq("SELECT x FROM tbl ORDER BY x ASC", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]), PostgreSql$.MODULE$.GetterToRowSingleton(PostgreSql$.MODULE$.IntGetter()));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(((IterableLike)incrementedFromDb.zip((GenIterable)incrementedRandoms, Seq$.MODULE$.canBuildFrom())).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<Object, Object> xs) {
                        return xs._1$mcI$sp() == xs._2$mcI$sp();
                    }
                }), "incrementedFromDb.zip[Int, Int, scala.collection.immutable.Seq[(Int, Int)]](incrementedRandoms)(immutable.this.Seq.canBuildFrom[(Int, Int)]).forall(((xs: (Int, Int)) => xs._1.==(xs._2)))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

