/*
 * Decompiled with CFR 0.152.
 */
package com.wda.sdbc.sqlserver;

import com.wda.sdbc.SqlServer$;
import com.wda.sdbc.sqlserver.SqlServerSpec$;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalatest.FunSuite;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001e1A!\u0001\u0002\u0001\u0017\ti1+\u001d7TKJ4XM]*qK\u000eT!a\u0001\u0003\u0002\u0013M\fHn]3sm\u0016\u0014(BA\u0003\u0007\u0003\u0011\u0019HMY2\u000b\u0005\u001dA\u0011aA<eC*\t\u0011\"A\u0002d_6\u001c\u0001a\u0005\u0002\u0001\u0019A\u0011QBE\u0007\u0002\u001d)\u0011q\u0002E\u0001\ng\u000e\fG.\u0019;fgRT\u0011!E\u0001\u0004_J<\u0017BA\n\u000f\u0005!1UO\\*vSR,\u0007\"B\u000b\u0001\t\u00031\u0012A\u0002\u001fj]&$h\bF\u0001\u0018!\tA\u0002!D\u0001\u0003\u0001")
public class SqlServerSpec
extends FunSuite {
    public SqlServerSpec() {
        this.test("Can parse UTC timestamps from ", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SqlServerSpec $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String asString = "2014-10-21 19:55:15.9600000 +00:00";
                DateTime manual = new DateTime(2014, 10, 21, 19, 55, 15, 960, DateTimeZone.UTC);
                DateTime parsed = DateTime.parse((String)asString, (DateTimeFormatter)SqlServer$.MODULE$.dateTimeFormatter());
                long $org_scalatest_assert_macro_left = new Duration((ReadableInstant)manual, (ReadableInstant)parsed).getMillis();
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Can parse EST timestamps from ", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SqlServerSpec $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String asString = "2014-10-21 15:59:08.2405747 -04:00";
                DateTime manual = new DateTime(2014, 10, 21, 15, 59, 8, 240, DateTimeZone.forOffsetHours((int)-4));
                DateTime parsed = DateTime.parse((String)asString, (DateTimeFormatter)SqlServer$.MODULE$.dateTimeFormatter());
                long $org_scalatest_assert_macro_left = new Duration((ReadableInstant)manual, (ReadableInstant)parsed).getMillis();
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Can parse timestamp with minute offsets from ", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SqlServerSpec $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String asString = "2014-10-21 15:59:08.2405747 -04:30";
                DateTime manual = new DateTime(2014, 10, 21, 15, 59, 8, 240, DateTimeZone.forOffsetHoursMinutes((int)-4, (int)-30));
                DateTime parsed = DateTime.parse((String)asString, (DateTimeFormatter)SqlServer$.MODULE$.dateTimeFormatter());
                long $org_scalatest_assert_macro_left = new Duration((ReadableInstant)manual, (ReadableInstant)parsed).getMillis();
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Can quote a single identifier.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SqlServerSpec $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String manual = "identifier";
                String quoted = SqlServer$.MODULE$.Identifier().quote("identifier");
                String $org_scalatest_assert_macro_left = manual;
                String $org_scalatest_assert_macro_right = quoted;
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Can quote a single complex identifier.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SqlServerSpec $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String manual = "[complex identifier]";
                String quoted = SqlServer$.MODULE$.Identifier().quote("complex identifier");
                String $org_scalatest_assert_macro_left = manual;
                String $org_scalatest_assert_macro_right = quoted;
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Can quote a two part identifier.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SqlServerSpec $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String manual = "[first part].[second part]";
                String quoted = SqlServer$.MODULE$.Identifier().quote((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"first part", "second part"}));
                String $org_scalatest_assert_macro_left = manual;
                String $org_scalatest_assert_macro_right = quoted;
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Can quote a three part identifier.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SqlServerSpec $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String manual = "[first part].[second part].[third part]";
                String quoted = SqlServer$.MODULE$.Identifier().quote((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"first part", "second part", "third part"}));
                String $org_scalatest_assert_macro_left = manual;
                String $org_scalatest_assert_macro_right = quoted;
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Escapes double quotes.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SqlServerSpec $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq tests = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"has]quote"})), (Object)"[has]]quote]"), new Tuple2((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"has]quote", "noHasQuote"})), (Object)"[has]]quote].noHasQuote"), new Tuple2((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"has]double]]quotes", "noHasQuote"})), (Object)"[has]]double]]]]quotes].noHasQuote")}));
                tests.withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<Seq<String>, String> check$ifrefutable$1) {
                        Tuple2<Seq<String>, String> tuple2 = check$ifrefutable$1;
                        boolean bl = tuple2 != null;
                        return bl;
                    }
                }).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;

                    public final void apply(Tuple2<Seq<String>, String> x$1) {
                        Tuple2<Seq<String>, String> tuple2 = x$1;
                        if (tuple2 != null) {
                            String quoted;
                            Seq identifier = (Seq)tuple2._1();
                            String expectedResult = (String)tuple2._2();
                            String $org_scalatest_assert_macro_left = quoted = SqlServer$.MODULE$.Identifier().quote(identifier);
                            String $org_scalatest_assert_macro_right = expectedResult;
                            String string = $org_scalatest_assert_macro_left;
                            String string2 = $org_scalatest_assert_macro_right;
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null));
                            this.$outer.com$wda$sdbc$sqlserver$SqlServerSpec$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ SqlServerSpec com$wda$sdbc$sqlserver$SqlServerSpec$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Empty identifiers are not allowed.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SqlServerSpec $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return SqlServer$.MODULE$.Identifier().quote("");
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

