/*
 * Decompiled with CFR 0.152.
 */
package com.wda.sdbc.sqlserver;

import com.wda.sdbc.SqlServer$;
import com.wda.sdbc.base.Connection;
import com.wda.sdbc.base.DateTimeParameterAsString;
import com.wda.sdbc.base.InstantParameter;
import com.wda.sdbc.base.LocalDateTimeParameter;
import com.wda.sdbc.sqlserver.Setters;
import com.wda.sdbc.sqlserver.SqlServerSuite;
import java.sql.Timestamp;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableInstant;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.ConfigMap;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.TestData;
import org.scalatest.fixture.FunSuiteLike;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u00152A!\u0001\u0002\u0001\u0017\tQ1+\u001a;uKJ\u001c\u0006/Z2\u000b\u0005\r!\u0011!C:rYN,'O^3s\u0015\t)a!\u0001\u0003tI\n\u001c'BA\u0004\t\u0003\r9H-\u0019\u0006\u0002\u0013\u0005\u00191m\\7\u0004\u0001M\u0019\u0001\u0001\u0004\t\u0011\u00055qQ\"\u0001\u0002\n\u0005=\u0011!AD*rYN+'O^3s'VLG/\u001a\t\u0003#Yi\u0011A\u0005\u0006\u0003'Q\t\u0011b]2bY\u0006$Xm\u001d;\u000b\u0003U\t1a\u001c:h\u0013\t9\"C\u0001\nCK\u001a|'/Z!oI\u00063G/\u001a:FC\u000eD\u0007\"B\r\u0001\t\u0003Q\u0012A\u0002\u001fj]&$h\bF\u0001\u001c!\ti\u0001\u0001C\u0003\u001e\u0001\u0011Ec$\u0001\u0006cK\u001a|'/Z#bG\"$\u0012a\b\t\u0003A\rj\u0011!\t\u0006\u0002E\u0005)1oY1mC&\u0011A%\t\u0002\u0005+:LG\u000f")
public class SetterSpec
extends SqlServerSuite
implements BeforeAndAfterEach {
    public /* synthetic */ Status org$scalatest$BeforeAndAfterEach$$super$runTest(String testName, Args args) {
        return FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public void beforeEach(ConfigMap configMap) {
        BeforeAndAfterEach.class.beforeEach((BeforeAndAfterEach)this, (ConfigMap)configMap);
    }

    public void beforeEach(TestData testData) {
        BeforeAndAfterEach.class.beforeEach((BeforeAndAfterEach)this, (TestData)testData);
    }

    public void afterEach() {
        BeforeAndAfterEach.class.afterEach((BeforeAndAfterEach)this);
    }

    public void afterEach(ConfigMap configMap) {
        BeforeAndAfterEach.class.afterEach((BeforeAndAfterEach)this, (ConfigMap)configMap);
    }

    public void afterEach(TestData testData) {
        BeforeAndAfterEach.class.afterEach((BeforeAndAfterEach)this, (TestData)testData);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfterEach.class.runTest((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public void beforeEach() {
        this.withSql(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Connection.Connection connection) {
                connection.execute("IF object_id('dbo.tbl') IS NOT NULL DROP TABLE tbl", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                SqlServer$.MODULE$.ConnectionToJDBCConnection(connection).commit();
            }
        });
    }

    public SetterSpec() {
        BeforeAndAfterEach.class.$init$((BeforeAndAfterEach)this);
        this.test("Inserting and selecting a DateTime works.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SetterSpec $outer;

            public final void apply(Connection.Connection connection) {
                DateTime now = DateTime.now();
                SqlServer$.MODULE$.Update().apply("CREATE TABLE tbl (t datetimeoffset NOT NULL)", SqlServer$.MODULE$.Update().apply$default$2()).execute(connection);
                SqlServer$.MODULE$.Update().apply("INSERT INTO tbl (t) VALUES ($v)", SqlServer$.MODULE$.Update().apply$default$2()).on((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"v"), (Object)SqlServer$.MODULE$.ToOptionParameterValue((Object)now, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final DateTimeParameterAsString.QDateTime apply(DateTime value) {
                        return SqlServer$.MODULE$.QDateTime(value);
                    }
                }))})).execute(connection);
                SqlServer$.MODULE$.ConnectionToJDBCConnection(connection).commit();
                Timestamp asTimestamp = (Timestamp)SqlServer$.MODULE$.Select().apply("SELECT t FROM tbl", SqlServer$.MODULE$.Select().apply$default$2(), SqlServer$.MODULE$.GetterToRowSingleton(SqlServer$.MODULE$.TimestampGetter())).single(connection);
                DateTime asDateTime = (DateTime)SqlServer$.MODULE$.Select().apply("SELECT t FROM tbl", SqlServer$.MODULE$.Select().apply$default$2(), SqlServer$.MODULE$.GetterToRowSingleton(SqlServer$.MODULE$.DateTimeGetter())).single(connection);
                this.$outer.assertResult(BoxesRunTime.boxToLong((long)now.getMillis()), BoxesRunTime.boxToLong((long)asTimestamp.getTime()));
                this.$outer.assertResult(BoxesRunTime.boxToLong((long)now.getMillis()), BoxesRunTime.boxToLong((long)asDateTime.getMillis()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Inserting and selecting an Instant works.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SetterSpec $outer;

            public final void apply(Connection.Connection connection) {
                Instant now = Instant.now();
                SqlServer$.MODULE$.Update().apply("CREATE TABLE tbl (t datetime NOT NULL)", SqlServer$.MODULE$.Update().apply$default$2()).execute(connection);
                SqlServer$.MODULE$.Update().apply("INSERT INTO tbl (t) VALUES ($v)", SqlServer$.MODULE$.Update().apply$default$2()).on((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"v"), (Object)SqlServer$.MODULE$.ToOptionParameterValue((Object)now, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final InstantParameter.QInstant apply(Instant value) {
                        return SqlServer$.MODULE$.QInstant(value);
                    }
                }))})).execute(connection);
                SqlServer$.MODULE$.ConnectionToJDBCConnection(connection).commit();
                Timestamp asTimestamp = (Timestamp)SqlServer$.MODULE$.Select().apply("SELECT t FROM tbl", SqlServer$.MODULE$.Select().apply$default$2(), SqlServer$.MODULE$.GetterToRowSingleton(SqlServer$.MODULE$.TimestampGetter())).single(connection);
                Instant asDateTime = (Instant)SqlServer$.MODULE$.Select().apply("SELECT t FROM tbl", SqlServer$.MODULE$.Select().apply$default$2(), SqlServer$.MODULE$.GetterToRowSingleton(SqlServer$.MODULE$.InstantGetter())).single(connection);
                long $org_scalatest_assert_macro_left = RichLong$.MODULE$.abs$extension(Predef$.MODULE$.longWrapper(now.getMillis() - asTimestamp.getTime()));
                int $org_scalatest_assert_macro_right = 4;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < (long)$org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                long $org_scalatest_assert_macro_left2 = RichLong$.MODULE$.abs$extension(Predef$.MODULE$.longWrapper(now.getMillis() - asDateTime.getMillis()));
                int $org_scalatest_assert_macro_right2 = 4;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 < (long)$org_scalatest_assert_macro_right2);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Inserting and selecting a LocalDateTime works.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SetterSpec $outer;

            public final void apply(Connection.Connection connection) {
                LocalDateTime now = LocalDateTime.now();
                SqlServer$.MODULE$.Update().apply("CREATE TABLE tbl (t datetime NOT NULL)", SqlServer$.MODULE$.Update().apply$default$2()).execute(connection);
                SqlServer$.MODULE$.Update().apply("INSERT INTO tbl (t) VALUES ($v)", SqlServer$.MODULE$.Update().apply$default$2()).on((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"v"), (Object)SqlServer$.MODULE$.ToOptionParameterValue((Object)now, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LocalDateTimeParameter.QLocalDateTime apply(LocalDateTime value) {
                        return SqlServer$.MODULE$.QLocalDateTime(value);
                    }
                }))})).execute(connection);
                SqlServer$.MODULE$.ConnectionToJDBCConnection(connection).commit();
                LocalDateTime asLocalDateTime = (LocalDateTime)SqlServer$.MODULE$.Select().apply("SELECT t FROM tbl", SqlServer$.MODULE$.Select().apply$default$2(), SqlServer$.MODULE$.GetterToRowSingleton(SqlServer$.MODULE$.LocalDateTimeGetter())).single(connection);
                long difference = new Duration((ReadableInstant)now.toDateTime(), (ReadableInstant)asLocalDateTime.toDateTime()).getMillis();
                long $org_scalatest_assert_macro_left = RichLong$.MODULE$.abs$extension(Predef$.MODULE$.longWrapper(difference));
                int $org_scalatest_assert_macro_right = 4;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < (long)$org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Inserting and selecting a UUID works.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SetterSpec $outer;

            public final void apply(Connection.Connection connection) {
                UUID id = UUID.randomUUID();
                SqlServer$.MODULE$.Update().apply("CREATE TABLE tbl (t uniqueidentifier NOT NULL)", SqlServer$.MODULE$.Update().apply$default$2()).execute(connection);
                SqlServer$.MODULE$.Update().apply("INSERT INTO tbl (t) VALUES ($v)", SqlServer$.MODULE$.Update().apply$default$2()).on((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"v"), (Object)SqlServer$.MODULE$.ToOptionParameterValue((Object)id, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Setters.QUUID apply(UUID value) {
                        return SqlServer$.MODULE$.QUUID(value);
                    }
                }))})).execute(connection);
                SqlServer$.MODULE$.ConnectionToJDBCConnection(connection).commit();
                UUID asUUID = (UUID)SqlServer$.MODULE$.Select().apply("SELECT t FROM tbl", SqlServer$.MODULE$.Select().apply$default$2(), SqlServer$.MODULE$.GetterToRowSingleton(SqlServer$.MODULE$.UUIDGetter())).single(connection);
                this.$outer.assertResult(id, asUUID);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

