/*
 * Decompiled with CFR 0.152.
 */
package com.webencyclop.core.mftool;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.webencyclop.core.mftool.models.Data;
import com.webencyclop.core.mftool.models.input.InputSchemeDetails;
import com.webencyclop.core.mftool.models.input.Scheme;
import com.webencyclop.core.mftool.models.output.SchemeDetails;
import com.webencyclop.core.mftool.models.output.SchemeNameCodePair;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class MFTool {
    public static final String BASE_URL = "https://api.mfapi.in";
    private final OkHttpClient client = new OkHttpClient();
    private final List<SchemeNameCodePair> schemeNameCodePairList = new ArrayList<SchemeNameCodePair>();
    private final Map<String, SchemeDetails> schemeDetailMap = new HashMap<String, SchemeDetails>();
    private final Map<String, List<Data>> schemeNavMap = new HashMap<String, List<Data>>();
    ObjectMapper mapper = new ObjectMapper();

    public List<SchemeNameCodePair> matchingScheme(String searchTerm) throws IOException {
        if (this.schemeNameCodePairList.isEmpty()) {
            this.updateSchemeNameCodePairList();
        }
        return this.schemeNameCodePairList.stream().filter(obj -> obj.getName().contains(searchTerm)).sorted().collect(Collectors.toList());
    }

    public List<SchemeNameCodePair> allSchemes() throws IOException {
        if (this.schemeNameCodePairList.isEmpty()) {
            this.updateSchemeNameCodePairList();
        }
        return this.schemeNameCodePairList.stream().sorted().collect(Collectors.toList());
    }

    public SchemeDetails schemeDetails(String code) throws IOException {
        if (!this.schemeDetailMap.containsKey(code)) {
            this.updateSchemeDetails(code);
        }
        return this.schemeDetailMap.get(code);
    }

    public List<Data> historicNavForScheme(String code) throws IOException {
        if (!this.schemeDetailMap.containsKey(code)) {
            this.updateSchemeDetails(code);
        }
        return this.schemeNavMap.get(code);
    }

    public BigDecimal getCurrentNav(String code) throws IOException {
        if (!this.schemeDetailMap.containsKey(code)) {
            this.updateSchemeDetails(code);
        }
        return this.schemeNavMap.get(code).get(0).getNav();
    }

    public BigDecimal getNavFor(String code, LocalDate date) throws IOException {
        if (!this.schemeDetailMap.containsKey(code)) {
            this.updateSchemeDetails(code);
        }
        return ((Data)this.schemeNavMap.get(code).stream().filter(data -> this.compareDate(date, data.getDate())).collect(Collectors.toList()).get(0)).getNav();
    }

    private void updateSchemeDetails(String code) throws IOException {
        Request request = new Request.Builder().url("https://api.mfapi.in/mf/" + code).build();
        Response response = this.client.newCall(request).execute();
        InputSchemeDetails schemeDetails = (InputSchemeDetails)this.mapper.readValue(Objects.requireNonNull(response.body()).string(), InputSchemeDetails.class);
        this.schemeDetailMap.put(code, schemeDetails.mapToSchemeDetail());
        this.schemeNavMap.put(code, schemeDetails.mapToNav());
    }

    private void updateSchemeNameCodePairList() throws IOException {
        Request request = new Request.Builder().url("https://api.mfapi.in/mf").build();
        Response response = this.client.newCall(request).execute();
        List list = (List)this.mapper.readValue(Objects.requireNonNull(response.body()).string(), (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, Scheme.class));
        this.schemeNameCodePairList.addAll(list.stream().map(o -> o.map((Scheme)o)).collect(Collectors.toList()));
    }

    private boolean compareDate(LocalDate date1, LocalDate date2) {
        if (date1.getYear() != date2.getYear()) {
            return false;
        }
        if (date1.getMonth() != date2.getMonth()) {
            return false;
        }
        return date1.getDayOfMonth() == date2.getDayOfMonth();
    }
}

