/*
 * Decompiled with CFR 0.152.
 */
package com.wedeploy.api.log;

public interface Logger {
    public static final Object[] NO_ARGS = new Object[0];

    default public void debug(String message) {
        this.debug(message, NO_ARGS);
    }

    public void debug(String var1, Object ... var2);

    default public void error(String message) {
        this.error(message, NO_ARGS);
    }

    public void error(String var1, Object ... var2);

    default public void error(String message, Throwable throwable) {
        this.error(message, throwable, NO_ARGS);
    }

    public void error(String var1, Throwable var2, Object ... var3);

    public String getName();

    default public void info(String message) {
        this.info(message, NO_ARGS);
    }

    public void info(String var1, Object ... var2);

    public boolean isDebugEnabled();

    public boolean isEnabled(Level var1);

    public boolean isErrorEnabled();

    public boolean isInfoEnabled();

    public boolean isTraceEnabled();

    public boolean isWarnEnabled();

    default public void log(Level level, String message) {
        this.log(level, message, NO_ARGS);
    }

    public void log(Level var1, String var2, Object ... var3);

    public void setLevel(String var1, Level var2);

    default public void trace(String message) {
        this.trace(message, NO_ARGS);
    }

    public void trace(String var1, Object ... var2);

    default public void warn(String message) {
        this.warn(message, NO_ARGS);
    }

    public void warn(String var1, Object ... var2);

    default public void warn(String message, Throwable throwable) {
        this.warn(message, throwable, NO_ARGS);
    }

    public void warn(String var1, Throwable var2, Object ... var3);

    public static enum Level {
        TRACE(1),
        DEBUG(2),
        INFO(3),
        WARN(4),
        ERROR(5);

        private final int value;

        public boolean isEnabledFor(Level level) {
            return this.value >= level.value;
        }

        private Level(int value) {
            this.value = value;
        }
    }
}

