/*
 * Decompiled with CFR 0.152.
 */
package com.wedeploy.api.query;

import com.wedeploy.api.query.Embodied;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Geo<T>
implements Embodied {
    protected final T body;

    public static BoundingBox boundingBox(Object upperLeft, Object lowerRight) {
        return new BoundingBox(upperLeft, lowerRight);
    }

    public static Circle circle(Object center, String radius) {
        return new Circle(center, radius);
    }

    public static Line line(Object ... points) {
        return new Line(points);
    }

    public static Point point(double lat, double lon) {
        return new Point(lat, lon);
    }

    public static Polygon polygon(Object ... points) {
        return new Polygon(points);
    }

    @Override
    public Object body() {
        return this.body;
    }

    public String toString() {
        return this.bodyAsJson();
    }

    private Geo(T body) {
        this.body = body;
    }

    public static final class Polygon
    extends Geo<Map> {
        private final List lines = new ArrayList();

        public Polygon hole(Object ... points) {
            this.lines.add(Arrays.asList(points));
            return this;
        }

        protected Polygon(Object ... points) {
            super(new HashMap());
            this.lines.add(Arrays.asList(points));
            ((Map)this.body).put("type", "polygon");
            ((Map)this.body).put("coordinates", this.lines);
        }
    }

    public static final class Point
    extends Geo<List> {
        protected Point(double lat, double lon) {
            super(Arrays.asList(lon, lat));
        }
    }

    public static final class Line
    extends Geo<Map> {
        protected Line(Object ... points) {
            super(new HashMap());
            ((Map)this.body).put("type", "linestring");
            ((Map)this.body).put("coordinates", Arrays.asList(points));
        }
    }

    public static final class Circle
    extends Geo<Map> {
        public Object center() {
            return ((Map)this.body).get("coordinates");
        }

        public String radius() {
            return (String)((Map)this.body).get("radius");
        }

        protected Circle(Object center, String radius) {
            super(new HashMap());
            ((Map)this.body).put("type", "circle");
            ((Map)this.body).put("coordinates", center);
            ((Map)this.body).put("radius", radius);
        }
    }

    public static final class BoundingBox
    extends Geo<Map> {
        public List<Object> points() {
            return (List)((Map)this.body).get("coordinates");
        }

        protected BoundingBox(Object upperLeft, Object lowerRight) {
            super(new HashMap());
            ((Map)this.body).put("type", "envelope");
            ((Map)this.body).put("coordinates", Arrays.asList(upperLeft, lowerRight));
        }
    }
}

