/*
 * Decompiled with CFR 0.152.
 */
package com.wedeploy.api.security;

import com.wedeploy.api.security.HashEngineException;
import com.wedeploy.api.security.HashGenerator;
import com.wedeploy.api.security.HashGeneratorFactory;
import java.util.HashMap;
import java.util.Map;

public class HashEngine {
    private static HashGeneratorFactory factory;
    private static final HashEngine instance;
    private Map<String, HashGenerator> generators = new HashMap<String, HashGenerator>();

    public static HashEngine instance() {
        return instance;
    }

    public static void setFactory(HashGeneratorFactory factory) {
        HashEngine.factory = factory;
    }

    public HashGenerator lookup(String algorithm) {
        HashGenerator generator = this.generators.get(algorithm);
        if (generator != null) {
            return generator;
        }
        if (factory == null) {
            throw new HashEngineException("No hash generator factory set.");
        }
        generator = factory.create(algorithm);
        this.generators.put(algorithm, generator);
        return generator;
    }

    public HashEngine register(String algorithm, HashGenerator generator) {
        this.generators.put(algorithm, generator);
        return this;
    }

    protected HashEngine() {
    }

    protected void clearEngine() {
        factory = null;
        this.generators.clear();
    }

    static {
        instance = new HashEngine();
    }
}

