/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * <p>
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * <p>
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * <p>
 * 3. Neither the name of Liferay, Inc. nor the names of its contributors may
 * be used to endorse or promote products derived from this software without
 * specific prior written permission.
 * <p>
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

package com.wedeploy.api.log;

import com.wedeploy.api.WeDeployException;

public class LoggerFactory {

	/**
	 * Returns logger for given class.
	 */
	public static Logger getLogger(Class clazz) {
		return getLogger(clazz.getName());
	}

	/**
	 * Returns logger for given name.
	 */
	public static Logger getLogger(String name) {
		initLoggerFactory();

		return loggerFactory.getLogger(name);
	}

	/**
	 * Sets custom default implementation class name.
	 *
	 * @see #setLoggerFactory(LoggerFactoryInterface)
	 */
	public static void setDefaultImplClass(String className) {
		defaultClassName = className;
	}

	/**
	 * Sets default logger factory instance. If set, default name will not be
	 * used.
	 *
	 * @see #setDefaultImplClass(String)
	 */
	public static void setLoggerFactory(LoggerFactoryInterface loggerFactory) {
		LoggerFactory.loggerFactory = loggerFactory;
	}

	protected LoggerFactory() {
	}

	protected static String defaultClassName =
		LoggerFactory.class.getPackage().getName() + ".impl.LoggerImpl";

	private static void initLoggerFactory() {
		if (loggerFactory != null) {
			return;
		}

		Class<?> clazz = LoggerFactory.class;

		ClassLoader classLoader = clazz.getClassLoader();

		Class<?> loggerClass = null;

		try {
			loggerClass = classLoader.loadClass(defaultClassName);
		} catch (ClassNotFoundException cnfe) {
			throw new WeDeployException(
				"Logger implementation not found: " + defaultClassName, cnfe);
		}

		try {
			loggerFactory = (LoggerFactoryInterface) loggerClass.newInstance();
		} catch (Exception e) {
			throw new WeDeployException(
				"Invalid Logger implementation: " + defaultClassName, e);
		}
	}

	private static LoggerFactoryInterface loggerFactory;

}
