/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.core.email.base;

import com.weicoder.core.email.Email;
import java.util.List;

public abstract class BaseEmail
implements Email {
    protected String host;
    protected String from;
    protected String password;
    protected boolean auth;
    protected String charset;

    @Override
    public final void send(String to, String subject, String msg) {
        this.send(to, subject, msg, false);
    }

    @Override
    public final void send(String to, String subject, String msg, String attach) {
        this.send(to, subject, msg, attach, false);
    }

    @Override
    public final void sendHTML(String to, String subject, String msg) {
        this.send(to, subject, msg, true);
    }

    @Override
    public final void sendHTML(String to, String subject, String msg, String attach) {
        this.send(to, subject, msg, attach, true);
    }

    @Override
    public final void send(String to, String subject, String msg, boolean flag) {
        this.send(new String[]{to}, subject, msg, flag);
    }

    @Override
    public final void send(String to, String subject, String msg, String attach, boolean flag) {
        this.send(new String[]{to}, subject, msg, attach, flag);
    }

    @Override
    public final void send(String[] to, String subject, String msg) {
        this.send(to, subject, msg, false);
    }

    @Override
    public final void send(String[] to, String subject, String msg, String attach) {
        this.send(to, subject, msg, attach, false);
    }

    @Override
    public final void sendHTML(String[] to, String subject, String msg) {
        this.send(to, subject, msg, true);
    }

    @Override
    public final void sendHTML(String[] to, String subject, String msg, String attach) {
        this.send(to, subject, msg, attach, true);
    }

    @Override
    public final void send(List<String> to, String subject, String msg) {
        this.send(to.toArray(new String[to.size()]), subject, msg, false);
    }

    @Override
    public final void send(List<String> to, String subject, String msg, String attach) {
        this.send(to.toArray(new String[to.size()]), subject, msg, attach, false);
    }

    @Override
    public final void sendHTML(List<String> to, String subject, String msg) {
        this.send(to.toArray(new String[to.size()]), subject, msg, true);
    }

    @Override
    public final void sendHTML(List<String> to, String subject, String msg, String attach) {
        this.send(to.toArray(new String[to.size()]), subject, msg, attach, true);
    }

    @Override
    public final void send(String[] to, String subject, String msg, boolean flag) {
        if (flag) {
            this.sendHtmlEmail(to, subject, msg);
        } else {
            this.sendSimpleEmail(to, subject, msg);
        }
    }

    @Override
    public final void send(String[] to, String subject, String msg, String attach, boolean flag) {
        if (flag) {
            this.sendHtmlEmail(to, subject, msg, attach);
        } else {
            this.sendMultiPartEmail(to, subject, msg, attach);
        }
    }

    @Override
    public final String getHost() {
        return this.host;
    }

    @Override
    public final void setHost(String host) {
        this.host = host;
    }

    @Override
    public final String getFrom() {
        return this.from;
    }

    @Override
    public final void setFrom(String from) {
        this.from = from;
    }

    @Override
    public final String getPassword() {
        return this.password;
    }

    @Override
    public final void setPassword(String password) {
        this.password = password;
    }

    @Override
    public final boolean isAuth() {
        return this.auth;
    }

    @Override
    public final void setAuth(boolean auth) {
        this.auth = auth;
    }

    @Override
    public final String getCharset() {
        return this.charset;
    }

    @Override
    public final void setCharset(String charset) {
        this.charset = charset;
    }

    public BaseEmail(String host, String from, String password, boolean auth, String charset) {
        this.auth = auth;
        this.host = host;
        this.from = from;
        this.password = password;
        this.charset = charset;
    }

    protected abstract void sendSimpleEmail(String[] var1, String var2, String var3);

    protected abstract void sendMultiPartEmail(String[] var1, String var2, String var3, String var4);

    protected abstract void sendHtmlEmail(String[] var1, String var2, String var3);

    protected abstract void sendHtmlEmail(String[] var1, String var2, String var3, String var4);
}

