/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.core.email.factory;

import com.weicoder.common.factory.Factory;
import com.weicoder.core.email.Email;
import com.weicoder.core.email.impl.EmailApache;
import com.weicoder.core.email.impl.EmailJava;
import com.weicoder.core.params.CoreParams;

public final class EmailFactory
extends Factory<Email> {
    private static final EmailFactory FACTORY = new EmailFactory();

    public static Email getEmail() {
        return (Email)FACTORY.getInstance();
    }

    public static Email newEmail(String host, String from, String password) {
        return FACTORY.newInstance(host, from, password, CoreParams.EMAIL_AUTH, CoreParams.EMAIL_ENCODING);
    }

    public static Email newEmail(String host, String from, String password, boolean auth, String charset) {
        return FACTORY.newInstance(host, from, password, auth, charset);
    }

    public Email newInstance() {
        return this.newInstance(CoreParams.EMAIL_HOST, CoreParams.EMAIL_FROM, CoreParams.EMAIL_PASSWORD);
    }

    public Email newInstance(String host, String from, String password) {
        return this.newInstance(host, from, password, CoreParams.EMAIL_AUTH, CoreParams.EMAIL_ENCODING);
    }

    public Email newInstance(String host, String from, String password, boolean auth, String charset) {
        switch (CoreParams.EMAIL_PARSE) {
            case "Apache": {
                return new EmailApache(host, from, password, auth, charset);
            }
        }
        return new EmailJava(host, from, password, auth, charset);
    }

    private EmailFactory() {
    }
}

