/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.core.email.impl;

import com.weicoder.common.log.Logs;
import com.weicoder.common.util.EmptyUtil;
import com.weicoder.common.util.StringUtil;
import com.weicoder.core.email.base.BaseEmail;
import java.net.URL;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.URLDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public final class EmailJava
extends BaseEmail {
    public EmailJava(String host, String from, String password, boolean auth, String charset) {
        super(host, from, password, auth, charset);
    }

    @Override
    protected void sendSimpleEmail(String[] to, String subject, String msg) {
        this.sendEmail(to, subject, msg, null, false);
    }

    @Override
    protected void sendMultiPartEmail(String[] to, String subject, String msg, String attach) {
        this.sendEmail(to, subject, msg, attach, false);
    }

    @Override
    protected void sendHtmlEmail(String[] to, String subject, String msg) {
        this.sendEmail(to, subject, msg, null, true);
    }

    @Override
    protected void sendHtmlEmail(String[] to, String subject, String msg, String attach) {
        this.sendEmail(to, subject, msg, attach, true);
    }

    private void sendEmail(String[] to, String subject, String msg, String attach, boolean flag) {
        try {
            Properties props = new Properties();
            props.put("mail.smtp.host", this.getHost());
            props.put("mail.smtp.auth", (Object)this.isAuth());
            Session mailSession = Session.getDefaultInstance((Properties)props);
            MimeMessage message = new MimeMessage(mailSession);
            message.setFrom((Address)new InternetAddress(this.getFrom()));
            for (int i = 0; i < to.length; ++i) {
                message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(to[i]));
            }
            message.setSubject(subject);
            if (flag) {
                message.setContent((Object)msg, this.getCharset());
            } else {
                message.setText(msg);
            }
            if (!EmptyUtil.isEmpty((String)attach)) {
                MimeBodyPart messageBodyPart = new MimeBodyPart();
                Object source = null;
                source = attach.indexOf("http") == -1 ? new FileDataSource(attach) : new URLDataSource(new URL(attach));
                messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
                String name = StringUtil.subStringLast((String)attach, (String)"/", (String)".");
                messageBodyPart.setText(name);
                messageBodyPart.setFileName(name);
                MimeMultipart multipart = new MimeMultipart();
                multipart.addBodyPart((BodyPart)messageBodyPart);
                message.setContent((Multipart)multipart);
            }
            message.saveChanges();
            Transport.send((Message)message);
        }
        catch (Exception e) {
            Logs.error((Throwable)e);
        }
    }
}

