/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.core.excel.base;

import com.weicoder.common.lang.Lists;
import com.weicoder.common.lang.Maps;
import com.weicoder.common.util.EmptyUtil;
import com.weicoder.core.excel.Excel;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class BaseExcel
implements Excel {
    private int index;

    @Override
    public final List<List<String>> readSheet() {
        return this.readSheet(this.index);
    }

    @Override
    public final List<List<String>> readSheetByAll() {
        int num = this.getSheets();
        List list = Lists.newList();
        for (int i = 0; i < num; ++i) {
            list.addAll(this.readSheet(i));
        }
        return list;
    }

    @Override
    public final List<List<String>> readSheet(int index) {
        this.setIndex(index);
        int rows = this.getRows();
        int cols = this.getColumns();
        List lsRow = Lists.newList((int)rows);
        List lsCol = null;
        for (int i = 0; i < rows; ++i) {
            lsCol = Lists.newList((int)cols);
            for (int j = 0; j < cols; ++j) {
                lsCol.add(this.readContents(i, j));
            }
            lsRow.add(lsCol);
        }
        return lsRow;
    }

    @Override
    public final List<List<String>> readSheet(String sheetName) {
        int index = this.getSheetIndex(sheetName);
        if (index == -1) {
            return Collections.emptyList();
        }
        return this.readSheet(index);
    }

    @Override
    public final List<Map<String, String>> readSheetByCol(String sheetName) {
        int index = this.getSheetIndex(sheetName);
        if (index == -1) {
            return Collections.emptyList();
        }
        return this.readSheetByCol(index);
    }

    @Override
    public final List<Map<String, String>> readSheetByCol() {
        return this.readSheetByCol(this.index);
    }

    @Override
    public final List<Map<String, String>> readSheetByColByAll() {
        int num = this.getSheets();
        List list = Lists.newList();
        for (int i = 0; i < num; ++i) {
            list.addAll(this.readSheetByCol(i));
        }
        return list;
    }

    @Override
    public final List<Map<String, String>> readSheetByCol(int index) {
        Object[] colNames = this.getColumnNames(index);
        List<List<String>> lsList = this.readSheet(index);
        if (EmptyUtil.isEmpty((Object[])colNames) || EmptyUtil.isEmpty(lsList)) {
            return Collections.emptyList();
        }
        int size = lsList.size();
        List lsMap = Lists.newList((int)(size - 1));
        List<String> list = null;
        Map map = null;
        int num = colNames.length;
        for (int i = 1; i < size; ++i) {
            list = lsList.get(i);
            map = Maps.newMap();
            for (int j = 0; j < num; ++j) {
                map.put(colNames[j], list.get(j));
            }
            lsMap.add(map);
        }
        return lsMap;
    }

    @Override
    public final String readContents() {
        return this.readContents(0, 0);
    }

    @Override
    public final String readContents(int index, int row, int col) {
        this.setIndex(index);
        return this.readContents(row, col);
    }

    @Override
    public final void writeSheet(List<List<String>> list) {
        this.writeSheet(list, this.index);
    }

    @Override
    public final void writeSheet(List<List<String>> list, int index) {
        this.setIndex(index);
        List<String> ls = null;
        for (int i = 0; i < list.size(); ++i) {
            ls = list.get(i);
            for (int j = 0; j < ls.size(); ++j) {
                this.writeContents(i, j, ls.get(j));
            }
        }
    }

    @Override
    public final void writeSheetByCol(List<Map<String, String>> list) {
        this.writeSheetByCol(list, this.index);
    }

    @Override
    public final void writeContents(String content) {
        this.writeContents(0, 0, content);
    }

    @Override
    public final void writeContentsByNewRow(int col, String content) {
        this.writeContents(this.getRows() + 1, col, content);
    }

    @Override
    public final void writeContentsByNewRow(String content) {
        this.writeContents(this.getRows() + 1, 0, content);
    }

    @Override
    public final void writeContentsByNewCol(int row, String content) {
        this.writeContents(row, this.getColumns() + 1, content);
    }

    @Override
    public final void writeContentsByNewCol(String content) {
        this.writeContents(0, this.getColumns() + 1, content);
    }

    @Override
    public final void writeContents(int index, int row, int col, String content) {
        this.setIndex(index);
        this.writeContents(row, col, content);
    }

    @Override
    public final String[] getColumnNames() {
        return this.getColumnNames(this.index);
    }

    @Override
    public final String[] getColumnNames(String name) {
        int index = this.getSheetIndex(name);
        if (index == -1) {
            return null;
        }
        return this.getColumnNames(index);
    }

    @Override
    public final String[] getColumnNames(int index) {
        this.setIndex(index);
        int cols = this.getColumns();
        String[] colNames = new String[cols];
        for (int i = 0; i < cols; ++i) {
            colNames[i] = this.readContents(0, i);
        }
        return colNames;
    }

    @Override
    public final int getColumnIndexByName(String colName) {
        int ci = -1;
        String[] colNames = this.getColumnNames();
        for (int i = 0; i < colNames.length; ++i) {
            if (!colNames[i].equals(colName)) continue;
            ci = i;
            break;
        }
        return ci;
    }

    @Override
    public final int getIndex() {
        return this.index;
    }

    @Override
    public final void setIndex(int index) {
        this.index = index;
    }

    @Override
    public final String getSheetName() {
        return this.getSheetName(this.index);
    }

    @Override
    public final int getColumns() {
        return this.getColumns(this.index);
    }

    @Override
    public final int getRows() {
        return this.getRows(this.index);
    }

    @Override
    public final void writeSheet(List<List<String>> list, String sheetName) {
        this.writeSheet(list, this.getSheetIndex(sheetName));
    }

    @Override
    public final void writeSheetByCol(List<Map<String, String>> list, String sheetName) {
        this.writeSheetByCol(list, this.getSheetIndex(sheetName));
    }

    @Override
    public final void writeSheetByCol(List<Map<String, String>> list, int index) {
        this.setIndex(index);
        Map<String, String> map = null;
        for (int i = 0; i < list.size(); ++i) {
            map = list.get(i);
            for (Map.Entry<String, String> e : map.entrySet()) {
                this.writeContents(i, this.getColumnIndexByName(e.getKey()), e.getValue());
            }
        }
    }
}

