/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.core.xml.builder;

import com.weicoder.core.params.CoreParams;
import com.weicoder.core.xml.Attribute;
import com.weicoder.core.xml.Document;
import com.weicoder.core.xml.Element;
import com.weicoder.core.xml.input.XMLRead;
import com.weicoder.core.xml.jdom2.AttributeJDom2;
import com.weicoder.core.xml.jdom2.DocumentJDom2;
import com.weicoder.core.xml.jdom2.ElementJDom2;
import com.weicoder.core.xml.jdom2.input.XMLReadJDom2;
import com.weicoder.core.xml.jdom2.output.FormatJDom2;
import com.weicoder.core.xml.jdom2.output.XMLWriteJDom2;
import com.weicoder.core.xml.output.Format;
import com.weicoder.core.xml.output.XMLWrite;
import java.io.File;
import java.io.InputStream;

public final class XmlBuilder {
    public static Format createFormat() {
        return XmlBuilder.createFormat(CoreParams.XML_ENCODING);
    }

    public static Format createFormat(String encoding) {
        return new FormatJDom2(encoding);
    }

    public static Document createDocument() {
        return new DocumentJDom2();
    }

    public static Document createDocument(String root) {
        return XmlBuilder.createDocument(XmlBuilder.createElement(root));
    }

    public static Document createDocument(Element e) {
        return new DocumentJDom2(e);
    }

    public static Element createElement() {
        return XmlBuilder.createElement(CoreParams.XML_ROOT);
    }

    public static Element createElement(String name) {
        return new ElementJDom2(name);
    }

    public static Attribute createAttribute(String name, String value) {
        return new AttributeJDom2(name, value);
    }

    public static XMLWrite createXMLOutput() {
        return XmlBuilder.createXMLOutput(XmlBuilder.createFormat());
    }

    public static XMLWrite createXMLOutput(Format format) {
        return new XMLWriteJDom2(format);
    }

    public static XMLRead createXMLRead() {
        return new XMLReadJDom2();
    }

    public static Document readDocument(String xml) {
        return XmlBuilder.createXMLRead().build(xml);
    }

    public static Document readDocument(File file) {
        return XmlBuilder.createXMLRead().build(file);
    }

    public static Document readDocument(InputStream in) {
        return XmlBuilder.createXMLRead().build(in);
    }

    private XmlBuilder() {
    }
}

