/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.socket;

import com.weicoder.common.lang.Maps;
import com.weicoder.common.log.Logs;
import com.weicoder.common.util.BeanUtil;
import com.weicoder.common.util.ClassUtil;
import com.weicoder.common.util.EmptyUtil;
import com.weicoder.socket.Client;
import com.weicoder.socket.Closed;
import com.weicoder.socket.Connected;
import com.weicoder.socket.Handler;
import com.weicoder.socket.Server;
import com.weicoder.socket.Session;
import com.weicoder.socket.Socket;
import com.weicoder.socket.impl.netty.NettyClient;
import com.weicoder.socket.impl.netty.NettyServer;
import com.weicoder.socket.manager.Manager;
import com.weicoder.socket.params.SocketParams;
import java.util.Map;

public final class Sockets {
    private static final Map<String, Server> SERVERS = Maps.getConcurrentMap();
    private static final Map<String, Client> CLIENTS = Maps.getConcurrentMap();
    private static final Map<String, Manager> MANAGERS = Maps.getConcurrentMap();

    public static void init() {
        if (SocketParams.POWER) {
            for (String name : SocketParams.NAMES) {
                Sockets.init(name);
            }
            Sockets.start();
        }
    }

    public static Socket init(String name) {
        Socket socket = null;
        socket = !EmptyUtil.isEmpty((CharSequence)SocketParams.getHost(name)) && SocketParams.isClient(name) ? Sockets.addClient(name) : Sockets.addServer(name);
        MANAGERS.put(name, new Manager());
        for (String c : SocketParams.getHandler(name)) {
            try {
                socket.addHandler((Handler)BeanUtil.newInstance((String)c));
            }
            catch (Exception ex) {
                Logs.warn((Throwable)ex);
            }
        }
        for (String p : SocketParams.getPackages(name)) {
            for (Class c : ClassUtil.getAssignedClass((String)p, Handler.class)) {
                try {
                    socket.addHandler((Handler)BeanUtil.newInstance((Class)c));
                }
                catch (Exception ex) {
                    Logs.warn((Throwable)ex);
                }
            }
        }
        socket.connected((Connected)BeanUtil.newInstance((String)SocketParams.getConnected(name)));
        socket.closed((Closed)BeanUtil.newInstance((String)SocketParams.getClosed(name)));
        return socket;
    }

    public static Server addServer(String name) {
        return Sockets.addServer(Sockets.getServer(name));
    }

    public static Server addServer(Server server) {
        SERVERS.put(server.name(), server);
        return server;
    }

    public static Client addClient(String name) {
        return Sockets.addClient(Sockets.getClient(name));
    }

    public static Client addClient(Client client) {
        CLIENTS.put(client.name(), client);
        return client;
    }

    public static void send(short id, Object message) {
        for (String name : SERVERS.keySet()) {
            Sockets.send(name, id, message);
        }
    }

    public static void send(String name, short id, Object message) {
        for (String key : Sockets.manager(name).keys()) {
            Sockets.send(name, key, id, message);
        }
    }

    public static void send(String name, String key, short id, Object message) {
        for (Session session : Sockets.manager(name).sessions(key)) {
            session.send(id, message);
        }
    }

    public static Server server(String name) {
        return SERVERS.get(name);
    }

    public static Server server() {
        return Sockets.server("");
    }

    public static Manager manager(String name) {
        return MANAGERS.get(name);
    }

    public static Manager manager() {
        return Sockets.manager("");
    }

    public static Client client(String name) {
        return CLIENTS.get(name);
    }

    public static Client client() {
        return Sockets.client("");
    }

    public static void start() {
        for (Server server : SERVERS.values()) {
            server.bind();
        }
        for (Client client : CLIENTS.values()) {
            client.connect();
        }
    }

    private static Server getServer(String name) {
        return new NettyServer(name);
    }

    private static Client getClient(String name) {
        return new NettyClient(name);
    }

    private Sockets() {
    }
}

