/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.socket.base;

import com.weicoder.common.binary.Buffer;
import com.weicoder.common.constants.ArrayConstants;
import com.weicoder.common.lang.Bytes;
import com.weicoder.common.lang.Conversion;
import com.weicoder.common.log.Logs;
import com.weicoder.common.schedule.ScheduledUtile;
import com.weicoder.common.util.StringUtil;
import com.weicoder.common.zip.ZipEngine;
import com.weicoder.socket.Session;
import com.weicoder.socket.message.Null;
import com.weicoder.socket.params.SocketParams;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public abstract class BaseSession
implements Session {
    protected String name;
    protected int id;
    protected String ip;
    protected int port;
    protected Buffer buffer;
    protected boolean zip;

    public BaseSession(String name) {
        this.name = name;
        this.zip = SocketParams.isZip(name);
        this.buffer = new Buffer();
        if (SocketParams.WRITE > 0L) {
            ScheduledUtile.rate(() -> this.flush(), (long)SocketParams.WRITE);
        }
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public String ip() {
        return this.ip;
    }

    @Override
    public int port() {
        return this.port;
    }

    @Override
    public byte[] send(short id, Object message) {
        return this.send(this.pack(id, message));
    }

    @Override
    public byte[] send(Object message) {
        return this.send(this.pack(message));
    }

    @Override
    public byte[] buffer(short id, Object message) {
        return this.buffer.write(this.pack(id, message));
    }

    @Override
    public byte[] buffer(Object message) {
        return this.buffer.write(this.pack(message));
    }

    @Override
    public void flush() {
        if (this.buffer.hasRemaining()) {
            byte[] data = this.buffer.array();
            this.buffer.clear();
            this.write(data);
            Logs.info((String)("name=" + this.name + ";socket=" + this.id + ";buffer send len=" + data.length), (Object[])new Object[0]);
        }
    }

    @Override
    public byte[] send(byte[] data) {
        if (SocketParams.WRITE > 0L) {
            this.buffer.write(data);
        } else {
            this.write(data);
            Logs.info((String)("name=" + this.name + ";socket=" + this.id + ";send len=" + data.length + ";id=" + Bytes.toShort((byte[])data, (int)4)), (Object[])new Object[0]);
        }
        return data;
    }

    @Override
    public void close() {
        if (SocketParams.WRITE > 0L) {
            while (this.buffer.hasRemaining()) {
                try {
                    Thread.sleep(SocketParams.WRITE + 5L);
                }
                catch (InterruptedException e) {
                    Logs.debug((Throwable)e);
                }
            }
        }
        this.close0();
    }

    protected void address(SocketAddress address) {
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inet = (InetSocketAddress)address;
            this.ip = inet.getHostName();
            this.port = inet.getPort();
        } else {
            String host = address.toString();
            this.ip = StringUtil.subString((String)host, (String)"/", (String)":");
            this.port = Conversion.toInt((Object)StringUtil.subString((String)host, (String)":"));
        }
    }

    protected byte[] pack(short id, Object message) {
        byte[] data = this.toBytes(message);
        return Bytes.toBytes((Object[])new Object[]{Conversion.toShort((Object)(data.length + 2)), id, data});
    }

    protected byte[] pack(Object message) {
        byte[] data = this.toBytes(message);
        return Bytes.toBytes((Object[])new Object[]{Conversion.toShort((Object)data.length), data});
    }

    protected byte[] toBytes(Object message) {
        Logs.info((String)("name=" + this.name + ";socket=" + this.id + ";message=" + message), (Object[])new Object[0]);
        byte[] data = null;
        data = message == null || message instanceof Null ? ArrayConstants.BYTES_EMPTY : (message instanceof String ? StringUtil.toBytes((String)Conversion.toString((Object)message)) : Bytes.toBytes((Object)message));
        return this.zip && data.length > 127 ? ZipEngine.compress((Object)data) : data;
    }

    protected abstract void close0();
}

