/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.socket.heart;

import com.weicoder.common.lang.Conversion;
import com.weicoder.common.lang.Maps;
import com.weicoder.common.log.Logs;
import com.weicoder.common.schedule.ScheduledUtile;
import com.weicoder.common.util.CloseUtil;
import com.weicoder.common.util.DateUtil;
import com.weicoder.socket.Handler;
import com.weicoder.socket.Session;
import com.weicoder.socket.message.Null;
import java.util.Map;

public final class Heart
implements Handler<Null> {
    private Map<Integer, Integer> times;
    private Map<Integer, Session> sessions;
    private int heart;
    private short id;
    private boolean isPack;

    public Heart(short id, int time, boolean isPack) {
        this.id = id;
        this.heart = time;
        this.isPack = isPack;
        this.times = Maps.getConcurrentMap();
        this.sessions = Maps.getConcurrentMap();
        ScheduledUtile.delay(() -> {
            int curr = DateUtil.getTime();
            Logs.debug((String)("heart check=" + DateUtil.getDate()), (Object[])new Object[0]);
            for (Map.Entry<Integer, Integer> e : this.times.entrySet()) {
                int t = Conversion.toInt((Object)e.getValue());
                if (curr - t <= this.heart) continue;
                CloseUtil.close((AutoCloseable[])new AutoCloseable[]{this.sessions.get(e.getKey())});
                this.sessions.remove(e.getKey());
                this.times.remove(e.getKey());
                Logs.info((String)("heart close session=" + e.getKey()), (Object[])new Object[0]);
            }
        }, (int)this.heart);
    }

    public void add(Session session) {
        this.sessions.put(session.id(), session);
        this.times.put(session.id(), DateUtil.getTime());
    }

    public void remove(Session session) {
        this.sessions.remove(session.id());
        this.times.remove(session.id());
    }

    @Override
    public short id() {
        return this.id;
    }

    @Override
    public void handler(Session session, Null data) {
        this.times.put(session.id(), DateUtil.getTime());
        if (this.isPack) {
            session.send(this.id, data);
        }
    }
}

