/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.socket.impl.netty;

import com.weicoder.socket.base.BaseClient;
import com.weicoder.socket.impl.netty.NettyHandler;
import com.weicoder.socket.impl.netty.NettySession;
import com.weicoder.socket.params.SocketParams;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;

public final class NettyClient
extends BaseClient {
    private Bootstrap bootstrap = new Bootstrap();
    private ChannelFuture future;
    private NettyHandler handler;

    public NettyClient(String name) {
        super(name);
        this.handler = new NettyHandler(name, this.process);
        this.bootstrap.group((EventLoopGroup)new NioEventLoopGroup(1));
        this.bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true);
        this.bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)false);
        this.bootstrap.option(ChannelOption.SO_LINGER, (Object)0);
        this.bootstrap.option(ChannelOption.SO_SNDBUF, (Object)32768);
        this.bootstrap.option(ChannelOption.SO_RCVBUF, (Object)8192);
        this.bootstrap.channel(NioSocketChannel.class);
        this.bootstrap.handler((ChannelHandler)this.handler);
        this.bootstrap.remoteAddress(SocketParams.getHost(name), SocketParams.getPort(name));
    }

    @Override
    public void connect() {
        this.future = this.bootstrap.connect().awaitUninterruptibly();
        this.session(new NettySession(this.name, this.future.channel()));
    }
}

