/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.socket.impl.netty;

import com.weicoder.socket.Session;
import com.weicoder.socket.impl.netty.NettySession;
import com.weicoder.socket.process.Process;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;

@ChannelHandler.Sharable
public final class NettyHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private String name;
    private Process process;

    public NettyHandler(String name, Process process) {
        this.name = name;
        this.process = process;
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        this.process.closed(this.getSesson(ctx.channel()));
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.process.connected(this.getSesson(ctx.channel()));
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        byte[] data = new byte[msg.readableBytes()];
        msg.readBytes(data);
        this.process.process(this.getSesson(ctx.channel()), data);
    }

    private Session getSesson(Channel channel) {
        int id = channel.hashCode();
        Session s = this.process.session(id);
        if (s == null) {
            s = new NettySession(this.name, channel);
        }
        return s;
    }
}

