/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.socket.impl.netty;

import com.weicoder.common.constants.SystemConstants;
import com.weicoder.socket.base.BaseServer;
import com.weicoder.socket.impl.netty.NettyHandler;
import com.weicoder.socket.params.SocketParams;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;

public final class NettyServer
extends BaseServer {
    private ServerBootstrap bootstrap = new ServerBootstrap();
    private NettyHandler handler;

    public NettyServer(String name) {
        super(name);
        this.handler = new NettyHandler(name, this.process);
        this.bootstrap.group((EventLoopGroup)new NioEventLoopGroup(1), (EventLoopGroup)new NioEventLoopGroup(SystemConstants.CPU_NUM * 2));
        this.bootstrap.childOption(ChannelOption.SO_REUSEADDR, (Object)true);
        this.bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)true);
        this.bootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)false);
        this.bootstrap.childOption(ChannelOption.SO_LINGER, (Object)0);
        this.bootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)32768);
        this.bootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)8192);
        this.bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)true);
        this.bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true);
        this.bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)false);
        this.bootstrap.option(ChannelOption.SO_LINGER, (Object)0);
        this.bootstrap.option(ChannelOption.SO_SNDBUF, (Object)32768);
        this.bootstrap.option(ChannelOption.SO_RCVBUF, (Object)8192);
        this.bootstrap.channel(NioServerSocketChannel.class);
        this.bootstrap.childHandler((ChannelHandler)this.handler);
        this.bootstrap.localAddress(SocketParams.getPort(name));
    }

    @Override
    public void bind() {
        this.bootstrap.bind();
    }
}

