/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.socket.manager;

import com.weicoder.common.lang.Lists;
import com.weicoder.common.lang.Maps;
import com.weicoder.common.log.Logs;
import com.weicoder.common.util.DateUtil;
import com.weicoder.common.util.EmptyUtil;
import com.weicoder.common.util.ExecutorUtil;
import com.weicoder.socket.Session;
import com.weicoder.socket.empty.SessionEmpty;
import com.weicoder.socket.params.SocketParams;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class Manager {
    private Map<String, Map<Long, Session>> registers = Maps.getConcurrentMap();
    private Map<Long, String> keys = Maps.getConcurrentMap();
    private Map<Long, Long> ids = Maps.getConcurrentMap();

    public Manager() {
        for (String register : SocketParams.REGISTERS) {
            this.registers.put(register, new ConcurrentHashMap());
        }
    }

    public boolean register(String key, Session session) {
        return this.register(key, session.id(), session);
    }

    public boolean register(String key, long id, Session session) {
        Map<Long, Session> register = this.registers.get(key);
        if (register == null) {
            return false;
        }
        register.put(id, session);
        long sid = session.id();
        this.keys.put(sid, key);
        this.ids.put(sid, id);
        return true;
    }

    public Session remove(String key, long id) {
        Map<Long, Session> register = this.registers.get(key);
        if (register == null) {
            return SessionEmpty.EMPTY;
        }
        return register.remove(id);
    }

    public Session remove(long id) {
        if (this.keys.containsKey(id) && this.ids.containsKey(id)) {
            return this.remove(this.keys.get(id), this.ids.get(id));
        }
        return SessionEmpty.EMPTY;
    }

    public Session remove(Session session) {
        return this.remove(session.id());
    }

    public Session get(String key, long id) {
        Session session = this.registers.get(key).get(id);
        return session == null ? SessionEmpty.EMPTY : session;
    }

    public Session get(int id) {
        return this.get(this.keys.get(id), this.ids.get(id));
    }

    public boolean exists(Session session) {
        return this.ids.containsKey(session.id());
    }

    public List<Session> sessions(String key) {
        return Lists.getList(this.registers.get(key).values());
    }

    public List<Session> sessions() {
        List sessions = Lists.getList();
        for (String key : this.keys()) {
            sessions.addAll(this.sessions(key));
        }
        return sessions;
    }

    public Set<String> keys() {
        return this.registers.keySet();
    }

    public int size() {
        int sum = 0;
        for (String key : this.keys()) {
            sum += this.size(key);
        }
        return sum;
    }

    public int size(String key) {
        return Maps.size(this.registers.get(key));
    }

    public void broad(short id, Object message) {
        List sessions = Lists.getList();
        for (Map<Long, Session> map : this.registers.values()) {
            sessions.addAll(map.values());
        }
        this.broad(sessions, id, message);
    }

    public void broad(String key, short id, Object message) {
        this.broad(this.sessions(key), id, message);
    }

    public void broad(String key, List<Long> ids, short id, Object message) {
        List sessions = Lists.getList();
        long curr = System.currentTimeMillis();
        Logs.info((String)("manager broad start key=" + key + ";ids=" + ids.size() + ";id=" + id + ";time=" + DateUtil.getTheDate()), (Object[])new Object[0]);
        Map<Long, Session> map = this.registers.get(key);
        for (Long sid : ids) {
            sessions.add(map.get(sid));
        }
        Logs.info((String)("manager broad end key=" + key + ";ids=" + ids.size() + ";id=" + id + ";time=" + (System.currentTimeMillis() - curr)), (Object[])new Object[0]);
        this.broad(sessions, id, message);
    }

    private void broad(List<Session> sessions, short id, Object message) {
        if (EmptyUtil.isEmpty(sessions)) {
            return;
        }
        int size = sessions.size();
        int broad = SocketParams.BROAD;
        byte[] data = sessions.get(0).send(id, message);
        Logs.info((String)("manager broad num=" + size + ";broad=" + broad + ";id=" + id + ";data=" + data.length + ";time=" + DateUtil.getTheDate()), (Object[])new Object[0]);
        if (broad == 0 || size <= broad) {
            this.broad(Lists.subList(sessions, (int)1, (int)size), data);
        } else {
            int i = 1;
            while (i < size) {
                List list = Lists.subList(sessions, (int)i, (int)(i += broad));
                ExecutorUtil.execute(() -> this.broad(list, data));
            }
        }
    }

    private void broad(List<Session> sessions, byte[] data) {
        long curr = System.currentTimeMillis();
        Logs.debug((String)("manager pool broad start size=" + sessions.size() + ";time=" + DateUtil.getTheDate()), (Object[])new Object[0]);
        for (Session session : sessions) {
            if (session == null) continue;
            session.write(data);
        }
        Logs.debug((String)("manager pool broad end size=" + sessions.size() + ";time=" + (System.currentTimeMillis() - curr)), (Object[])new Object[0]);
    }
}

