/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.socket.params;

import com.weicoder.common.constants.ArrayConstants;
import com.weicoder.common.params.Params;

public final class SocketParams {
    private static final String PREFIX = "socket";
    public static final String HOST = Params.getString((String)"socket.host");
    public static final int PORT = Params.getInt((String)"socket.port");
    public static final boolean POWER = Params.getBoolean((String)"socket.power", (boolean)false);
    public static final boolean SPRING = Params.getBoolean((String)"socket.spring", (boolean)false);
    public static final String[] NAMES = Params.getStringArray((String)"socket.names", (String[])new String[]{""});
    public static final String[] REGISTERS = Params.getStringArray((String)"socket.registers", (String[])new String[]{""});
    public static final long WRITE = Params.getLong((String)"socket.write", (long)0L);
    public static final int BROAD = Params.getInt((String)"socket.broad", (int)10000);

    public static String getHost(String name) {
        return Params.getString((String)Params.getKey((String)PREFIX, (String)name, (String)"host"));
    }

    public static int getPort(String name) {
        return Params.getInt((String)Params.getKey((String)PREFIX, (String)name, (String)"port"));
    }

    public static int getOver(String name) {
        return Params.getInt((String)Params.getKey((String)PREFIX, (String)name, (String)"over"), (int)10);
    }

    public static int getTime(String name) {
        return Params.getInt((String)Params.getKey((String)PREFIX, (String)name, (String)"time"), (int)(SocketParams.isClient(name) ? 0 : 5));
    }

    public static boolean isZip(String name) {
        return Params.getBoolean((String)Params.getKey((String)PREFIX, (String)name, (String)"zip"), (boolean)false);
    }

    public static short getHeartId(String name) {
        return Params.getShort((String)Params.getKey((String)PREFIX, (String)name, (String)"heart.id"), (short)0);
    }

    public static int getHeartTime(String name) {
        return Params.getInt((String)Params.getKey((String)PREFIX, (String)name, (String)"heart.time"));
    }

    public static boolean isHeartPack(String name) {
        return Params.getBoolean((String)Params.getKey((String)PREFIX, (String)name, (String)"heart.pack"), (boolean)true);
    }

    public static String getLogin(String name) {
        return Params.getString((String)Params.getKey((String)PREFIX, (String)name, (String)"login"));
    }

    public static boolean isClient(String name) {
        return Params.getBoolean((String)Params.getKey((String)PREFIX, (String)name, (String)"client"), (boolean)false);
    }

    public static String[] getHandler(String name) {
        return Params.getStringArray((String)Params.getKey((String)PREFIX, (String)name, (String)"handler"), (String[])ArrayConstants.STRING_EMPTY);
    }

    public static String getPackage(String name) {
        return Params.getString((String)Params.getKey((String)PREFIX, (String)name, (String)"package"));
    }

    public static String[] getPackages(String name) {
        return Params.getStringArray((String)Params.getKey((String)PREFIX, (String)name, (String)"packages"), (String[])ArrayConstants.STRING_EMPTY);
    }

    public static String getConnected(String name) {
        return Params.getString((String)Params.getKey((String)PREFIX, (String)name, (String)"connected"));
    }

    public static String getClosed(String name) {
        return Params.getString((String)Params.getKey((String)PREFIX, (String)name, (String)"closed"));
    }

    private SocketParams() {
    }
}

