/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.socket.process;

import com.weicoder.common.binary.Binary;
import com.weicoder.common.binary.Buffer;
import com.weicoder.common.binary.ByteArray;
import com.weicoder.common.lang.Bytes;
import com.weicoder.common.lang.Conversion;
import com.weicoder.common.lang.Maps;
import com.weicoder.common.log.Logs;
import com.weicoder.common.schedule.ScheduledUtile;
import com.weicoder.common.util.ClassUtil;
import com.weicoder.common.util.CloseUtil;
import com.weicoder.common.util.DateUtil;
import com.weicoder.common.util.StringUtil;
import com.weicoder.common.zip.ZipEngine;
import com.weicoder.socket.Closed;
import com.weicoder.socket.Connected;
import com.weicoder.socket.Handler;
import com.weicoder.socket.Session;
import com.weicoder.socket.Sockets;
import com.weicoder.socket.heart.Heart;
import com.weicoder.socket.manager.Manager;
import com.weicoder.socket.message.Null;
import com.weicoder.socket.params.SocketParams;
import java.util.Arrays;
import java.util.Map;

public final class Process {
    private Map<Short, Handler<Object>> handlers = Maps.getMap();
    private Map<Integer, Session> sessions = Maps.getConcurrentMap();
    private Map<Integer, Integer> times = Maps.getConcurrentMap();
    private Map<Integer, Buffer> buffers = Maps.getConcurrentMap();
    private Map<String, Boolean> limits = Maps.getConcurrentMap();
    private Map<String, Integer> overs = Maps.getConcurrentMap();
    private Manager manager;
    private Heart heart;
    private Connected connected;
    private Closed closed;
    private short heartId;
    private String name;
    private boolean zip;

    public Process(String name) {
        int htime;
        this.name = name;
        this.zip = SocketParams.isZip(name);
        if (!SocketParams.isClient(name)) {
            this.manager = Sockets.manager(name);
        }
        if ((htime = SocketParams.getHeartTime(name)) > 0 && !SocketParams.isClient(name)) {
            this.heartId = SocketParams.getHeartId(name);
            this.heart = new Heart(this.heartId, htime, SocketParams.isHeartPack(name));
            this.addHandler(this.heart);
        }
        int time = SocketParams.getTime(name);
        int over = SocketParams.getOver(name);
        if (time > 0) {
            ScheduledUtile.rate(() -> {
                try {
                    int curr = DateUtil.getTime();
                    for (Map.Entry<Integer, Integer> e : this.times.entrySet()) {
                        if (curr - e.getValue() < time) continue;
                        Session session = this.sessions.get(e.getKey());
                        String ip = session.ip();
                        int num = Conversion.toInt((Object)this.overs.get(ip));
                        if (num > over) {
                            this.limits.put(ip, true);
                        }
                        this.overs.put(ip, ++num);
                        session.close();
                        Logs.info((String)StringUtil.add((Object[])new Object[]{"name=", name, ";overtime close id=", e.getKey()}), (Object[])new Object[0]);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }, (int)1);
        }
    }

    public void connected(Connected connected) {
        this.connected = connected;
    }

    public void closed(Closed closed) {
        this.closed = closed;
    }

    public void addHandler(Handler<?> handler) {
        this.handlers.put(handler.id(), handler);
    }

    public void connected(Session session) {
        if (Conversion.toBoolean((Object)this.limits.get(session.ip()))) {
            CloseUtil.close((AutoCloseable[])new AutoCloseable[]{session});
            Logs.info((String)StringUtil.add((Object[])new Object[]{"name=", this.name, ";limits ip=", session.ip(), " close id=", session.id()}), (Object[])new Object[0]);
            return;
        }
        boolean is = true;
        if (this.connected != null) {
            is = this.connected.connected(session);
        }
        if (is) {
            this.sessions.put(session.id(), session);
            this.buffers.put(session.id(), new Buffer());
            this.times.put(session.id(), DateUtil.getTime());
            if (this.manager != null) {
                this.manager.register(this.name, session);
            }
            if (this.heart != null) {
                this.heart.add(session);
            }
        } else {
            CloseUtil.close((AutoCloseable[])new AutoCloseable[]{session});
            Logs.info((String)StringUtil.add((Object[])new Object[]{"name=", this.name, ";connected - close id=", session.id()}), (Object[])new Object[0]);
        }
        Logs.info((String)StringUtil.add((Object[])new Object[]{"name=", this.name, ";socket conn=", session.id(), ";ip=", session.ip(), ";is=", is}), (Object[])new Object[0]);
    }

    public void closed(Session session) {
        try {
            if (this.closed != null) {
                this.closed.closed(session);
            }
            if (this.manager != null) {
                this.manager.remove(this.name, session.id());
            }
        }
        catch (Exception e) {
            Logs.error((Throwable)e);
        }
        this.sessions.remove(session.id());
        this.buffers.remove(session.id());
        if (this.heart != null) {
            this.heart.remove(session);
        }
        Logs.info((String)StringUtil.add((Object[])new Object[]{"name=", this.name, ";socket close=", session.id(), ";ip=", session.ip()}), (Object[])new Object[0]);
    }

    public Session session(int id) {
        return this.sessions.get(id);
    }

    public void process(Session session, byte[] message) {
        int sid = session.id();
        Logs.debug((String)StringUtil.add((Object[])new Object[]{"name=", this.name, ";socket=", sid, ";receive=", sid, ";len=", message.length, ";message=", Arrays.toString(message)}), (Object[])new Object[0]);
        Buffer buff = this.buffers.get(sid);
        buff.write(message);
        while (buff.remaining() >= 4) {
            short length;
            if (this.times.containsKey(sid)) {
                this.times.remove(sid);
            }
            if (this.limits.containsKey(sid)) {
                this.limits.remove(sid);
            }
            if ((length = buff.readShort()) < 2 || length > Short.MAX_VALUE) {
                CloseUtil.close((AutoCloseable[])new AutoCloseable[]{session});
                Logs.info((String)StringUtil.add((Object[])new Object[]{"name=", this.name, ";error len close id=", session.id(), ";len=" + length}), (Object[])new Object[0]);
                return;
            }
            if (buff.remaining() < length) {
                buff.offset(buff.offset() - 2);
                break;
            }
            short id = buff.readShort();
            Handler<Object> handler = this.handlers.get(id);
            String log = StringUtil.add((Object[])new Object[]{"name=", this.name, ";socket=", sid, ";receive len=", length, ";id=", id, ";handler=", handler, ";time=", DateUtil.getTheDate()});
            if (id == this.heartId) {
                Logs.debug((String)log, (Object[])new Object[0]);
            } else {
                Logs.info((String)log, (Object[])new Object[0]);
            }
            int len = length - 2;
            byte[] data = new byte[len];
            if (len > 0) {
                buff.read(data);
                if (this.zip) {
                    data = ZipEngine.extract((Object)data);
                }
            }
            if (handler == null) {
                Logs.warn((String)StringUtil.add((Object[])new Object[]{"name=", this.name, ";socket=", sid, ";handler message discard id=", id, ";message len=", len}), (Object[])new Object[0]);
                return;
            }
            try {
                long curr = System.currentTimeMillis();
                if (len == 0) {
                    handler.handler(session, null);
                    log = StringUtil.add((Object[])new Object[]{"name=", this.name, ";socket=", sid, ";handler message is null end time=", System.currentTimeMillis() - curr});
                    if (id == this.heartId) {
                        Logs.debug((String)log, (Object[])new Object[0]);
                    } else {
                        Logs.info((String)log, (Object[])new Object[0]);
                    }
                } else {
                    Class type = ClassUtil.getGenericClass(handler.getClass());
                    Object mess = null;
                    if (type.equals(String.class)) {
                        mess = StringUtil.toString((byte[])data);
                    } else if (Binary.class.isAssignableFrom(type)) {
                        mess = Bytes.toBinary((Binary)((Binary)ClassUtil.newInstance((Class)type)), (byte[])data);
                    } else if (ByteArray.class.isAssignableFrom(type)) {
                        mess = ((ByteArray)ClassUtil.newInstance((Class)type)).array(data);
                    } else if (type.equals(Null.class)) {
                        mess = Null.NULL;
                    } else if (type.equals(Buffer.class)) {
                        mess = new Buffer(data);
                    } else if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
                        mess = Bytes.toInt((byte[])data);
                    } else if (type.equals(Long.TYPE) || type.equals(Long.class)) {
                        mess = Bytes.toLong((byte[])data);
                    } else if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
                        mess = Bytes.toLong((byte[])data);
                    } else if (type.equals(Float.TYPE) || type.equals(Float.class)) {
                        mess = Float.valueOf(Bytes.toFloat((byte[])data));
                    } else if (type.equals(Double.TYPE) || type.equals(Double.class)) {
                        mess = Bytes.toDouble((byte[])data);
                    } else if (type.equals(Byte.TYPE) || type.equals(Byte.class)) {
                        mess = data[0];
                    } else if (type.equals(byte[].class)) {
                        mess = data;
                    } else {
                        log = StringUtil.add((Object[])new Object[]{"name=", this.name, ";socket=", sid, ";handler data not null data.length=", data.length});
                        if (id == this.heartId) {
                            Logs.debug((String)log, (Object[])new Object[0]);
                        } else {
                            Logs.info((String)log, (Object[])new Object[0]);
                        }
                        mess = Null.NULL;
                    }
                    log = StringUtil.add((Object[])new Object[]{"name=", this.name, ";socket=", sid, ";handler message=", mess, ";time=", System.currentTimeMillis() - curr});
                    if (id == this.heartId) {
                        Logs.debug((String)log, (Object[])new Object[0]);
                    } else {
                        Logs.info((String)log, (Object[])new Object[0]);
                    }
                    curr = System.currentTimeMillis();
                    handler.handler(session, mess);
                    log = StringUtil.add((Object[])new Object[]{"name=", this.name, ";socket=", sid, ";handler end time=", System.currentTimeMillis() - curr});
                    if (id == this.heartId) {
                        Logs.debug((String)log, (Object[])new Object[0]);
                    } else {
                        Logs.info((String)log, (Object[])new Object[0]);
                    }
                }
            }
            catch (Exception e) {
                Logs.error((Throwable)e);
            }
            if (buff.remaining() != 0) continue;
            buff.clear();
            break;
        }
    }
}

