/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.socket;

import com.weicoder.common.constants.ArrayConstants;
import com.weicoder.common.lang.Bytes;
import com.weicoder.common.lang.Conversion;
import com.weicoder.common.util.StringUtil;
import com.weicoder.common.zip.ZipEngine;
import com.weicoder.socket.Client;
import com.weicoder.socket.Server;
import com.weicoder.socket.manager.Manager;
import com.weicoder.socket.netty.NettyClient;
import com.weicoder.socket.netty.NettyServer;
import com.weicoder.socket.params.SocketParams;

public final class Sockets {
    private static Server server;
    private static Client client;
    private static Manager manager;
    private static boolean zip;

    public static void init() {
        zip = SocketParams.ZIP;
        manager = new Manager();
        if (SocketParams.CONFIG.exists("client.host")) {
            client = new NettyClient("client");
        }
        if (SocketParams.CONFIG.exists("server.host")) {
            server = new NettyServer("server");
        }
        if (server != null) {
            server.bind();
        }
        if (client != null) {
            client.connect();
        }
    }

    public static Server server() {
        return server;
    }

    public static Manager manager() {
        return manager;
    }

    public static Client client() {
        return client;
    }

    public static byte[] pack(short id, Object message) {
        byte[] data = Sockets.toBytes(message);
        return Bytes.toBytes((Object[])new Object[]{Conversion.toShort((Object)(data.length + 2)), id, data});
    }

    public static byte[] pack(Object message) {
        byte[] data = Sockets.toBytes(message);
        return Bytes.toBytes((Object[])new Object[]{Conversion.toShort((Object)data.length), data});
    }

    public static byte[] toBytes(Object message) {
        byte[] data = null;
        data = message == null ? ArrayConstants.BYTES_EMPTY : (message instanceof String ? StringUtil.toBytes((String)Conversion.toString((Object)message)) : Bytes.toBytes((Object)message));
        return zip && data.length > 127 ? ZipEngine.compress((Object)data) : data;
    }

    private Sockets() {
    }
}

