/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.socket.manager;

import com.weicoder.common.concurrent.ScheduledUtil;
import com.weicoder.common.lang.Lists;
import com.weicoder.common.lang.Maps;
import com.weicoder.common.log.Logs;
import com.weicoder.common.util.CloseUtil;
import com.weicoder.common.util.DateUtil;
import com.weicoder.common.util.EmptyUtil;
import com.weicoder.socket.Session;
import com.weicoder.socket.Sockets;
import com.weicoder.socket.params.SocketParams;
import java.util.List;
import java.util.Map;

public final class Manager {
    private Map<Long, Session> registers = Maps.newConcurrentMap();

    public Manager() {
        ScheduledUtil.rate(() -> {
            int curr = DateUtil.getTime();
            int n = 0;
            for (Session s : this.sessions()) {
                if (curr - s.getHeart() >= SocketParams.TIMEOUT) {
                    Logs.info((String)"heart close session={}", (Object[])new Object[]{s.getId()});
                    this.registers.remove(s.getId());
                    CloseUtil.close((AutoCloseable[])new AutoCloseable[]{s});
                }
                ++n;
            }
            Logs.debug((String)"testing heart num={}", (Object[])new Object[]{n});
        }, (int)SocketParams.TIME);
    }

    public void register(Session session) {
        this.registers.put(session.getId(), session);
    }

    public Session remove(Session session) {
        return this.remove(session.getId());
    }

    public Session remove(long id) {
        return this.registers.remove(id);
    }

    public Session get(long id) {
        return this.registers.get(id);
    }

    public boolean exists(Session session) {
        return this.registers.containsValue(session);
    }

    public List<Session> sessions() {
        return Lists.newList(this.registers.values());
    }

    public int size() {
        return this.registers.size();
    }

    public void broad(short id, Object message) {
        this.broad(this.sessions(), id, message);
    }

    private void broad(List<Session> sessions, short id, Object message) {
        if (EmptyUtil.isEmpty(sessions)) {
            return;
        }
        Logs.info((String)"manager broad num={};id={};time={}", (Object[])new Object[]{sessions.size(), id, DateUtil.getTheDate()});
        this.broad(sessions, Sockets.pack(id, message));
    }

    private void broad(List<Session> sessions, byte[] data) {
        long curr = System.currentTimeMillis();
        Logs.debug((String)"manager pool broad start size={};time=", (Object[])new Object[]{sessions.size(), DateUtil.getTheDate()});
        for (Session session : sessions) {
            session.send(data);
        }
        Logs.debug((String)"manager pool broad end size={};time={}", (Object[])new Object[]{sessions.size(), System.currentTimeMillis() - curr});
    }
}

