/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.socket.process;

import com.weicoder.common.binary.Binary;
import com.weicoder.common.binary.Buffer;
import com.weicoder.common.binary.ByteArray;
import com.weicoder.common.lang.Bytes;
import com.weicoder.common.lang.Maps;
import com.weicoder.common.log.Logs;
import com.weicoder.common.util.BeanUtil;
import com.weicoder.common.util.ClassUtil;
import com.weicoder.common.util.CloseUtil;
import com.weicoder.common.util.DateUtil;
import com.weicoder.common.util.EmptyUtil;
import com.weicoder.common.util.StringUtil;
import com.weicoder.common.zip.ZipEngine;
import com.weicoder.socket.Closed;
import com.weicoder.socket.Connected;
import com.weicoder.socket.Session;
import com.weicoder.socket.Sockets;
import com.weicoder.socket.annotation.Handler;
import com.weicoder.socket.annotation.Head;
import com.weicoder.socket.manager.Manager;
import com.weicoder.socket.params.SocketParams;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Map;

public final class Process {
    private Map<Short, Handler> handlers = Maps.newMap();
    private Map<Short, Method> methods = Maps.newMap();
    private Manager manager;
    private Connected connected;
    private Closed closed;
    private String name;
    private boolean zip;

    public Process(String name) {
        this.name = name;
        this.zip = SocketParams.isZip(name);
        this.manager = Sockets.manager();
        this.connected = (Connected)BeanUtil.newInstance((String)SocketParams.getConnected(name));
        this.closed = (Closed)BeanUtil.newInstance((String)SocketParams.getClosed(name));
        for (Class c : ClassUtil.getAnnotationClass(Handler.class)) {
            Handler h = (Handler)BeanUtil.newInstance((Class)c);
            if (!name.equals(h.value())) continue;
            for (Method m : c.getDeclaredMethods()) {
                if (!Modifier.isPublic(m.getModifiers()) || !m.isAnnotationPresent(Head.class)) continue;
                short id = m.getAnnotation(Head.class).id();
                this.methods.put(id, m);
                this.handlers.put(id, h);
            }
        }
    }

    public void connected(Session session) {
        boolean is = true;
        if (this.connected != null) {
            is = this.connected.connected(session);
        }
        if (is) {
            this.manager.register(session);
        } else {
            CloseUtil.close((AutoCloseable[])new AutoCloseable[]{session});
            Logs.info((String)"name={};connected - close id={}", (Object[])new Object[]{this.name, session.getId()});
        }
        Logs.info((String)"name={};socket conn={};ip={};is={}", (Object[])new Object[]{this.name, session.getId(), session.getIp(), is});
    }

    public void closed(Session session) {
        if (this.closed != null) {
            this.closed.closed(session);
        }
        this.manager.remove(session.getId());
        Logs.info((String)"name={};socket close={};ip={}", (Object[])new Object[]{this.name, session.getId(), session.getIp()});
    }

    public void process(Session session, byte[] message) {
        long sid = session.getId();
        Logs.debug((String)"name={};socket={};len={};message={}", (Object[])new Object[]{this.name, sid, message.length, Arrays.toString(message)});
        Buffer buff = session.buffer();
        buff.write(message);
        while (buff.remaining() >= 4) {
            Method m;
            short length = buff.readShort();
            if (length < 2 || length > Short.MAX_VALUE) {
                CloseUtil.close((AutoCloseable[])new AutoCloseable[]{session});
                Logs.info((String)"name={};error len close id={};len={}", (Object[])new Object[]{this.name, session.getId(), length});
                return;
            }
            if (buff.remaining() < length) {
                buff.offset(buff.offset() - 2);
                break;
            }
            short id = buff.readShort();
            int len = length - 2;
            byte[] data = new byte[len];
            if (len > 0) {
                buff.read(data);
                if (this.zip) {
                    data = ZipEngine.extract((Object)data);
                }
            }
            if ((m = this.methods.get(id)) == null) {
                Logs.warn((String)"name={};socket={};handler message discard id={};message len={}", (Object[])new Object[]{this.name, sid, id, len});
                return;
            }
            Logs.info((String)"name={};socket={};receive len={};id={};method={};time={}", (Object[])new Object[]{this.name, sid, length, id, m, DateUtil.getTheDate()});
            try {
                long curr = System.currentTimeMillis();
                m.invoke((Object)this.handlers.get(id), this.getParames(m, data, session));
                session.setHeart(DateUtil.getTime());
                Logs.info((String)"name={};socket={};handler end time={}", (Object[])new Object[]{this.name, sid, System.currentTimeMillis() - curr});
            }
            catch (Exception e) {
                Logs.error((Throwable)e);
            }
            if (buff.remaining() != 0) continue;
            buff.clear();
            break;
        }
    }

    private Object[] getParames(Method m, byte[] data, Session session) {
        if (EmptyUtil.isEmpty((byte[])data)) {
            return null;
        }
        Object[] pars = m.getParameters();
        Object[] params = null;
        if (!EmptyUtil.isEmpty((Object[])pars)) {
            params = new Object[pars.length];
            for (int i = 0; i < pars.length; ++i) {
                Object p = pars[i];
                Class<?> type = ((Parameter)p).getType();
                params[i] = Session.class.isAssignableFrom(type) ? session : (Manager.class.equals(type) ? Sockets.manager() : (type.equals(String.class) ? StringUtil.toString((byte[])data) : (Binary.class.isAssignableFrom(type) ? Bytes.toBinary(type, (byte[])data) : (ByteArray.class.isAssignableFrom(type) ? ((ByteArray)ClassUtil.newInstance(type)).array(data) : (type.equals(Buffer.class) ? new Buffer(data) : (type.equals(Integer.TYPE) || type.equals(Integer.class) ? Integer.valueOf(Bytes.toInt((byte[])data)) : (type.equals(Long.TYPE) || type.equals(Long.class) ? Long.valueOf(Bytes.toLong((byte[])data)) : (type.equals(Boolean.TYPE) || type.equals(Boolean.class) ? Boolean.valueOf(Bytes.toBoolean((byte[])data)) : (type.equals(Float.TYPE) || type.equals(Float.class) ? Float.valueOf(Bytes.toFloat((byte[])data)) : (type.equals(Double.TYPE) || type.equals(Double.class) ? Double.valueOf(Bytes.toDouble((byte[])data)) : (type.equals(Byte.TYPE) || type.equals(Byte.class) ? Byte.valueOf(data[0]) : (type.equals(byte[].class) ? (Object)data : null))))))))))));
            }
        }
        return params;
    }
}

