/*
 * Decompiled with CFR 0.152.
 */
package com.withorb.api.core.handlers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.google.common.collect.ListMultimap;
import com.withorb.api.core.handlers.StringHandler;
import com.withorb.api.core.http.HttpResponse;
import com.withorb.api.errors.BadRequestException;
import com.withorb.api.errors.InternalServerException;
import com.withorb.api.errors.NotFoundException;
import com.withorb.api.errors.OrbError;
import com.withorb.api.errors.OrbException;
import com.withorb.api.errors.PermissionDeniedException;
import com.withorb.api.errors.RateLimitException;
import com.withorb.api.errors.UnauthorizedException;
import com.withorb.api.errors.UnexpectedStatusCodeException;
import com.withorb.api.errors.UnprocessableEntityException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0006H\u0002\u001a,\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\b0\u0001\"\u0004\b\u0000\u0010\b*\b\u0012\u0004\u0012\u0002H\b0\u00012\f\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0000\u00a8\u0006\t"}, d2={"errorHandler", "Lcom/withorb/api/core/http/HttpResponse$Handler;", "Lcom/withorb/api/errors/OrbError;", "jsonMapper", "Lcom/fasterxml/jackson/databind/json/JsonMapper;", "buffered", "Lcom/withorb/api/core/http/HttpResponse;", "withErrorHandler", "T", "orb-java-core"})
@JvmName(name="ErrorHandler")
@SourceDebugExtension(value={"SMAP\nErrorHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ErrorHandler.kt\ncom/withorb/api/core/handlers/ErrorHandler\n+ 2 JsonHandler.kt\ncom/withorb/api/core/handlers/JsonHandler\n*L\n1#1,126:1\n13#2,9:127\n*S KotlinDebug\n*F\n+ 1 ErrorHandler.kt\ncom/withorb/api/core/handlers/ErrorHandler\n*L\n23#1:127,9\n*E\n"})
public final class ErrorHandler {
    public static final /* synthetic */ HttpResponse.Handler errorHandler(JsonMapper jsonMapper) {
        Intrinsics.checkNotNullParameter((Object)jsonMapper, (String)"jsonMapper");
        boolean $i$f$jsonHandler = false;
        HttpResponse.Handler handler = new HttpResponse.Handler<OrbError>(jsonMapper){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public OrbError handle(@NotNull HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<OrbError>(){});
                }
                catch (Exception e) {
                    throw new OrbException("Error reading response", e);
                }
            }
        };
        return new HttpResponse.Handler<OrbError>((HttpResponse.Handler<OrbError>)handler){
            final /* synthetic */ HttpResponse.Handler<OrbError> $handler;
            {
                this.$handler = $handler;
            }

            @NotNull
            public OrbError handle(@NotNull HttpResponse response) {
                OrbError orbError;
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    orbError = this.$handler.handle(response);
                }
                catch (Exception e) {
                    orbError = OrbError.Companion.builder().build();
                }
                return orbError;
            }
        };
    }

    public static final /* synthetic */ HttpResponse.Handler withErrorHandler(HttpResponse.Handler $this$withErrorHandler, HttpResponse.Handler errorHandler2) {
        Intrinsics.checkNotNullParameter((Object)$this$withErrorHandler, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)errorHandler2, (String)"errorHandler");
        return new HttpResponse.Handler<T>($this$withErrorHandler, errorHandler2){
            final /* synthetic */ HttpResponse.Handler<T> $this_withErrorHandler;
            final /* synthetic */ HttpResponse.Handler<OrbError> $errorHandler;
            {
                this.$this_withErrorHandler = $receiver;
                this.$errorHandler = $errorHandler;
            }

            public T handle(@NotNull HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                int statusCode = response.statusCode();
                boolean bl = 200 <= statusCode ? statusCode < 300 : false;
                if (bl) {
                    return this.$this_withErrorHandler.handle(response);
                }
                if (statusCode == 400) {
                    HttpResponse buffered2 = ErrorHandler.access$buffered(response);
                    throw new BadRequestException(buffered2.headers(), (String)StringHandler.stringHandler().handle(buffered2), this.$errorHandler.handle(buffered2));
                }
                if (statusCode == 401) {
                    HttpResponse buffered3 = ErrorHandler.access$buffered(response);
                    throw new UnauthorizedException(buffered3.headers(), (String)StringHandler.stringHandler().handle(buffered3), this.$errorHandler.handle(buffered3));
                }
                if (statusCode == 403) {
                    HttpResponse buffered4 = ErrorHandler.access$buffered(response);
                    throw new PermissionDeniedException(buffered4.headers(), (String)StringHandler.stringHandler().handle(buffered4), this.$errorHandler.handle(buffered4));
                }
                if (statusCode == 404) {
                    HttpResponse buffered5 = ErrorHandler.access$buffered(response);
                    throw new NotFoundException(buffered5.headers(), (String)StringHandler.stringHandler().handle(buffered5), this.$errorHandler.handle(buffered5));
                }
                if (statusCode == 422) {
                    HttpResponse buffered6 = ErrorHandler.access$buffered(response);
                    throw new UnprocessableEntityException(buffered6.headers(), (String)StringHandler.stringHandler().handle(buffered6), this.$errorHandler.handle(buffered6));
                }
                if (statusCode == 429) {
                    HttpResponse buffered7 = ErrorHandler.access$buffered(response);
                    throw new RateLimitException(buffered7.headers(), (String)StringHandler.stringHandler().handle(buffered7), this.$errorHandler.handle(buffered7));
                }
                boolean bl2 = 500 <= statusCode ? statusCode < 600 : false;
                if (bl2) {
                    HttpResponse buffered8 = ErrorHandler.access$buffered(response);
                    throw new InternalServerException(statusCode, buffered8.headers(), (String)StringHandler.stringHandler().handle(buffered8), this.$errorHandler.handle(buffered8));
                }
                HttpResponse buffered9 = ErrorHandler.access$buffered(response);
                throw new UnexpectedStatusCodeException(statusCode, buffered9.headers(), (String)StringHandler.stringHandler().handle(buffered9), this.$errorHandler.handle(buffered9));
            }
        };
    }

    private static final HttpResponse buffered(HttpResponse $this$buffered) {
        byte[] body = ByteStreamsKt.readBytes((InputStream)$this$buffered.body());
        return new HttpResponse($this$buffered, body){
            final /* synthetic */ HttpResponse $this_buffered;
            final /* synthetic */ byte[] $body;
            {
                this.$this_buffered = $receiver;
                this.$body = $body;
            }

            public int statusCode() {
                return this.$this_buffered.statusCode();
            }

            @NotNull
            public ListMultimap<String, String> headers() {
                return this.$this_buffered.headers();
            }

            @NotNull
            public InputStream body() {
                return new ByteArrayInputStream(this.$body);
            }

            public void close() {
                this.$this_buffered.close();
            }
        };
    }

    public static final /* synthetic */ HttpResponse access$buffered(HttpResponse $receiver) {
        return ErrorHandler.buffered($receiver);
    }
}

