/*
 * Decompiled with CFR 0.152.
 */
package com.withorb.api.services.blocking;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.google.common.collect.Multimap;
import com.withorb.api.core.ClientOptions;
import com.withorb.api.core.JsonValue;
import com.withorb.api.core.RequestOptions;
import com.withorb.api.core.handlers.EmptyHandler;
import com.withorb.api.core.handlers.ErrorHandler;
import com.withorb.api.core.http.HttpMethod;
import com.withorb.api.core.http.HttpRequest;
import com.withorb.api.core.http.HttpRequestBody;
import com.withorb.api.core.http.HttpResponse;
import com.withorb.api.errors.OrbError;
import com.withorb.api.errors.OrbException;
import com.withorb.api.models.Customer;
import com.withorb.api.models.CustomerCreateParams;
import com.withorb.api.models.CustomerDeleteParams;
import com.withorb.api.models.CustomerFetchByExternalIdParams;
import com.withorb.api.models.CustomerFetchParams;
import com.withorb.api.models.CustomerListPage;
import com.withorb.api.models.CustomerListParams;
import com.withorb.api.models.CustomerUpdateByExternalIdParams;
import com.withorb.api.models.CustomerUpdateParams;
import com.withorb.api.services.blocking.CustomerService;
import com.withorb.api.services.blocking.customers.BalanceTransactionService;
import com.withorb.api.services.blocking.customers.BalanceTransactionServiceImpl;
import com.withorb.api.services.blocking.customers.CostService;
import com.withorb.api.services.blocking.customers.CostServiceImpl;
import com.withorb.api.services.blocking.customers.CreditService;
import com.withorb.api.services.blocking.customers.CreditServiceImpl;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010'\u001a\u00020(2\u0006\u0010#\u001a\u00020)2\u0006\u0010%\u001a\u00020&H\u0016J\u0018\u0010*\u001a\u00020\u00122\u0006\u0010#\u001a\u00020+2\u0006\u0010%\u001a\u00020&H\u0016J\u0018\u0010,\u001a\u00020\u00122\u0006\u0010#\u001a\u00020-2\u0006\u0010%\u001a\u00020&H\u0016J\u0018\u0010.\u001a\u00020/2\u0006\u0010#\u001a\u0002002\u0006\u0010%\u001a\u00020&H\u0016J\u0018\u00101\u001a\u00020\u00122\u0006\u0010#\u001a\u0002022\u0006\u0010%\u001a\u00020&H\u0016J\u0018\u00103\u001a\u00020\u00122\u0006\u0010#\u001a\u0002042\u0006\u0010%\u001a\u00020&H\u0016R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0013\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\n\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/withorb/api/services/blocking/CustomerServiceImpl;", "Lcom/withorb/api/services/blocking/CustomerService;", "clientOptions", "Lcom/withorb/api/core/ClientOptions;", "(Lcom/withorb/api/core/ClientOptions;)V", "balanceTransactions", "Lcom/withorb/api/services/blocking/customers/BalanceTransactionService;", "getBalanceTransactions", "()Lcom/withorb/api/services/blocking/customers/BalanceTransactionService;", "balanceTransactions$delegate", "Lkotlin/Lazy;", "costs", "Lcom/withorb/api/services/blocking/customers/CostService;", "getCosts", "()Lcom/withorb/api/services/blocking/customers/CostService;", "costs$delegate", "createHandler", "Lcom/withorb/api/core/http/HttpResponse$Handler;", "Lcom/withorb/api/models/Customer;", "credits", "Lcom/withorb/api/services/blocking/customers/CreditService;", "getCredits", "()Lcom/withorb/api/services/blocking/customers/CreditService;", "credits$delegate", "deleteHandler", "Ljava/lang/Void;", "errorHandler", "Lcom/withorb/api/errors/OrbError;", "fetchByExternalIdHandler", "fetchHandler", "listHandler", "Lcom/withorb/api/models/CustomerListPage$Response;", "updateByExternalIdHandler", "updateHandler", "create", "params", "Lcom/withorb/api/models/CustomerCreateParams;", "requestOptions", "Lcom/withorb/api/core/RequestOptions;", "delete", "", "Lcom/withorb/api/models/CustomerDeleteParams;", "fetch", "Lcom/withorb/api/models/CustomerFetchParams;", "fetchByExternalId", "Lcom/withorb/api/models/CustomerFetchByExternalIdParams;", "list", "Lcom/withorb/api/models/CustomerListPage;", "Lcom/withorb/api/models/CustomerListParams;", "update", "Lcom/withorb/api/models/CustomerUpdateParams;", "updateByExternalId", "Lcom/withorb/api/models/CustomerUpdateByExternalIdParams;", "orb-java-core"})
@SourceDebugExtension(value={"SMAP\nCustomerServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomerServiceImpl.kt\ncom/withorb/api/services/blocking/CustomerServiceImpl\n+ 2 JsonHandler.kt\ncom/withorb/api/core/handlers/JsonHandler\n+ 3 HttpRequestBodies.kt\ncom/withorb/api/core/HttpRequestBodies\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,288:1\n13#2,9:289\n13#2,9:298\n13#2,9:307\n13#2,9:316\n13#2,9:325\n13#2,9:334\n17#3:343\n17#3:345\n17#3:346\n1#4:344\n*S KotlinDebug\n*F\n+ 1 CustomerServiceImpl.kt\ncom/withorb/api/services/blocking/CustomerServiceImpl\n*L\n54#1:289,9\n92#1:298,9\n123#1:307,9\n191#1:316,9\n222#1:325,9\n256#1:334,9\n78#1:343\n109#1:345\n275#1:346\n*E\n"})
public final class CustomerServiceImpl
implements CustomerService {
    @NotNull
    private final ClientOptions clientOptions;
    @NotNull
    private final HttpResponse.Handler<OrbError> errorHandler;
    @NotNull
    private final Lazy costs$delegate;
    @NotNull
    private final Lazy credits$delegate;
    @NotNull
    private final Lazy balanceTransactions$delegate;
    @NotNull
    private final HttpResponse.Handler<Customer> createHandler;
    @NotNull
    private final HttpResponse.Handler<Customer> updateHandler;
    @NotNull
    private final HttpResponse.Handler<CustomerListPage.Response> listHandler;
    @NotNull
    private final HttpResponse.Handler<Void> deleteHandler;
    @NotNull
    private final HttpResponse.Handler<Customer> fetchHandler;
    @NotNull
    private final HttpResponse.Handler<Customer> fetchByExternalIdHandler;
    @NotNull
    private final HttpResponse.Handler<Customer> updateByExternalIdHandler;

    public CustomerServiceImpl(@NotNull ClientOptions clientOptions) {
        Intrinsics.checkNotNullParameter((Object)clientOptions, (String)"clientOptions");
        this.clientOptions = clientOptions;
        this.errorHandler = ErrorHandler.errorHandler(this.clientOptions.jsonMapper());
        this.costs$delegate = LazyKt.lazy((Function0)((Function0)new Function0<CostServiceImpl>(this){
            final /* synthetic */ CustomerServiceImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final CostServiceImpl invoke() {
                return new CostServiceImpl(CustomerServiceImpl.access$getClientOptions$p(this.this$0));
            }
        }));
        this.credits$delegate = LazyKt.lazy((Function0)((Function0)new Function0<CreditServiceImpl>(this){
            final /* synthetic */ CustomerServiceImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final CreditServiceImpl invoke() {
                return new CreditServiceImpl(CustomerServiceImpl.access$getClientOptions$p(this.this$0));
            }
        }));
        this.balanceTransactions$delegate = LazyKt.lazy((Function0)((Function0)new Function0<BalanceTransactionServiceImpl>(this){
            final /* synthetic */ CustomerServiceImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final BalanceTransactionServiceImpl invoke() {
                return new BalanceTransactionServiceImpl(CustomerServiceImpl.access$getClientOptions$p(this.this$0));
            }
        }));
        JsonMapper jsonMapper$iv = this.clientOptions.jsonMapper();
        boolean $i$f$jsonHandler = false;
        this.createHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<Customer>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public Customer handle(@NotNull HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<Customer>(){});
                }
                catch (Exception e) {
                    throw new OrbException("Error reading response", e);
                }
            }
        }, this.errorHandler);
        jsonMapper$iv = this.clientOptions.jsonMapper();
        $i$f$jsonHandler = false;
        this.updateHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<Customer>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public Customer handle(@NotNull HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<Customer>(){});
                }
                catch (Exception e) {
                    throw new OrbException("Error reading response", e);
                }
            }
        }, this.errorHandler);
        jsonMapper$iv = this.clientOptions.jsonMapper();
        $i$f$jsonHandler = false;
        this.listHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<CustomerListPage.Response>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public CustomerListPage.Response handle(@NotNull HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<CustomerListPage.Response>(){});
                }
                catch (Exception e) {
                    throw new OrbException("Error reading response", e);
                }
            }
        }, this.errorHandler);
        this.deleteHandler = ErrorHandler.withErrorHandler(EmptyHandler.emptyHandler(), this.errorHandler);
        jsonMapper$iv = this.clientOptions.jsonMapper();
        $i$f$jsonHandler = false;
        this.fetchHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<Customer>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public Customer handle(@NotNull HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<Customer>(){});
                }
                catch (Exception e) {
                    throw new OrbException("Error reading response", e);
                }
            }
        }, this.errorHandler);
        jsonMapper$iv = this.clientOptions.jsonMapper();
        $i$f$jsonHandler = false;
        this.fetchByExternalIdHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<Customer>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public Customer handle(@NotNull HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<Customer>(){});
                }
                catch (Exception e) {
                    throw new OrbException("Error reading response", e);
                }
            }
        }, this.errorHandler);
        jsonMapper$iv = this.clientOptions.jsonMapper();
        $i$f$jsonHandler = false;
        this.updateByExternalIdHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<Customer>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public Customer handle(@NotNull HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<Customer>(){});
                }
                catch (Exception e) {
                    throw new OrbException("Error reading response", e);
                }
            }
        }, this.errorHandler);
    }

    private final CostService getCosts() {
        Lazy lazy = this.costs$delegate;
        return (CostService)lazy.getValue();
    }

    private final CreditService getCredits() {
        Lazy lazy = this.credits$delegate;
        return (CreditService)lazy.getValue();
    }

    private final BalanceTransactionService getBalanceTransactions() {
        Lazy lazy = this.balanceTransactions$delegate;
        return (BalanceTransactionService)lazy.getValue();
    }

    @Override
    @NotNull
    public CostService costs() {
        return this.getCosts();
    }

    @Override
    @NotNull
    public CreditService credits() {
        return this.getCredits();
    }

    @Override
    @NotNull
    public BalanceTransactionService balanceTransactions() {
        return this.getBalanceTransactions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Customer create(@NotNull CustomerCreateParams params, @NotNull RequestOptions requestOptions) {
        void jsonMapper$iv;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String[] stringArray = new String[]{"customers"};
        HttpRequest.Builder builder = HttpRequest.Companion.builder().method(HttpMethod.POST).addPathSegments(stringArray).putAllQueryParams((Multimap<String, String>)((Multimap)this.clientOptions.queryParams())).putAllQueryParams(params.getQueryParams$orb_java_core()).putAllHeaders((Multimap<String, String>)((Multimap)this.clientOptions.headers())).putAllHeaders(params.getHeaders$orb_java_core());
        stringArray = this.clientOptions.jsonMapper();
        CustomerCreateParams.CustomerCreateBody value$iv = params.getBody$orb_java_core();
        boolean $i$f$json = false;
        HttpRequest request2 = builder.body(new HttpRequestBody((JsonMapper)jsonMapper$iv, value$iv){
            @Nullable
            private byte[] cachedBytes;
            final /* synthetic */ JsonMapper $jsonMapper;
            final /* synthetic */ T $value;
            {
                this.$jsonMapper = $jsonMapper;
                this.$value = $value;
            }

            private final byte[] serialize() {
                if (this.cachedBytes != null) {
                    Intrinsics.checkNotNull((Object)this.cachedBytes);
                    return this.cachedBytes;
                }
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                try {
                    this.$jsonMapper.writeValue((OutputStream)buffer, this.$value);
                    this.cachedBytes = buffer.toByteArray();
                    Intrinsics.checkNotNull((Object)this.cachedBytes);
                    return this.cachedBytes;
                }
                catch (Exception e) {
                    throw new OrbException("Error writing request", e);
                }
            }

            public void writeTo(@NotNull OutputStream outputStream) {
                Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                outputStream.write(this.serialize());
            }

            @NotNull
            public String contentType() {
                return "application/json";
            }

            public long contentLength() {
                return this.serialize().length;
            }

            public boolean repeatable() {
                return true;
            }

            public void close() {
            }
        }).build();
        HttpResponse response = this.clientOptions.httpClient().execute(request2, requestOptions);
        boolean bl = false;
        Object object = response;
        Throwable throwable = null;
        try {
            Object it = (HttpResponse)object;
            boolean bl2 = false;
            it = this.createHandler.handle((HttpResponse)it);
        }
        catch (Throwable it) {
            throwable = it;
            throw it;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
        }
        Object $this$create_u24lambda_u242_u24lambda_u241 = object = it;
        boolean bl3 = false;
        Boolean bl4 = requestOptions.getResponseValidation();
        if (bl4 != null ? bl4.booleanValue() : this.clientOptions.responseValidation()) {
            ((Customer)$this$create_u24lambda_u242_u24lambda_u241).validate();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Customer update(@NotNull CustomerUpdateParams params, @NotNull RequestOptions requestOptions) {
        void jsonMapper$iv;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String[] stringArray = new String[]{"customers", params.getPathParam(0)};
        HttpRequest.Builder builder = HttpRequest.Companion.builder().method(HttpMethod.PUT).addPathSegments(stringArray).putAllQueryParams((Multimap<String, String>)((Multimap)this.clientOptions.queryParams())).putAllQueryParams(params.getQueryParams$orb_java_core()).putAllHeaders((Multimap<String, String>)((Multimap)this.clientOptions.headers())).putAllHeaders(params.getHeaders$orb_java_core());
        stringArray = this.clientOptions.jsonMapper();
        CustomerUpdateParams.CustomerUpdateBody value$iv = params.getBody$orb_java_core();
        boolean $i$f$json = false;
        HttpRequest request2 = builder.body(new /* invalid duplicate definition of identical inner class */).build();
        HttpResponse response = this.clientOptions.httpClient().execute(request2, requestOptions);
        boolean bl = false;
        Object object = response;
        Throwable throwable = null;
        try {
            Object it = (HttpResponse)object;
            boolean bl2 = false;
            it = this.updateHandler.handle((HttpResponse)it);
        }
        catch (Throwable it) {
            throwable = it;
            throw it;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
        }
        Object $this$update_u24lambda_u245_u24lambda_u244 = object = it;
        boolean bl3 = false;
        Boolean bl4 = requestOptions.getResponseValidation();
        if (bl4 != null ? bl4.booleanValue() : this.clientOptions.responseValidation()) {
            ((Customer)$this$update_u24lambda_u245_u24lambda_u244).validate();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CustomerListPage list(@NotNull CustomerListParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String[] stringArray = new String[]{"customers"};
        HttpRequest request2 = HttpRequest.Companion.builder().method(HttpMethod.GET).addPathSegments(stringArray).putAllQueryParams((Multimap<String, String>)((Multimap)this.clientOptions.queryParams())).putAllQueryParams(params.getQueryParams$orb_java_core()).putAllHeaders((Multimap<String, String>)((Multimap)this.clientOptions.headers())).putAllHeaders(params.getHeaders$orb_java_core()).build();
        HttpResponse response = this.clientOptions.httpClient().execute(request2, requestOptions);
        boolean bl = false;
        Object object = response;
        Throwable throwable = null;
        try {
            Object it = (HttpResponse)object;
            boolean bl2 = false;
            it = this.listHandler.handle((HttpResponse)it);
        }
        catch (Throwable it) {
            throwable = it;
            throw it;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
        }
        Object $this$list_u24lambda_u249_u24lambda_u247 = object = it;
        boolean bl3 = false;
        Boolean bl4 = requestOptions.getResponseValidation();
        if (bl4 != null ? bl4.booleanValue() : this.clientOptions.responseValidation()) {
            ((CustomerListPage.Response)$this$list_u24lambda_u249_u24lambda_u247).validate();
        }
        Object it = object;
        boolean bl5 = false;
        return CustomerListPage.Companion.of(this, params, (CustomerListPage.Response)it);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(@NotNull CustomerDeleteParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        Object object = new String[]{"customers", params.getPathParam(0)};
        Object $this$delete_u24lambda_u2411 = object = HttpRequest.Companion.builder().method(HttpMethod.DELETE).addPathSegments((String[])object).putAllQueryParams((Multimap<String, String>)((Multimap)this.clientOptions.queryParams())).putAllQueryParams(params.getQueryParams$orb_java_core()).putAllHeaders((Multimap<String, String>)((Multimap)this.clientOptions.headers())).putAllHeaders(params.getHeaders$orb_java_core());
        boolean bl = false;
        params.getBody$orb_java_core().ifPresent(arg_0 -> CustomerServiceImpl.delete$lambda$11$lambda$10((Function1)new Function1<Map<String, ? extends JsonValue>, Unit>((HttpRequest.Builder)$this$delete_u24lambda_u2411, this){
            final /* synthetic */ HttpRequest.Builder $this_apply;
            final /* synthetic */ CustomerServiceImpl this$0;
            {
                this.$this_apply = $receiver;
                this.this$0 = $receiver2;
                super(1);
            }

            public final void invoke(@NotNull Map<String, ? extends JsonValue> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                JsonMapper jsonMapper$iv = CustomerServiceImpl.access$getClientOptions$p(this.this$0).jsonMapper();
                boolean $i$f$json = false;
                this.$this_apply.body(new /* invalid duplicate definition of identical inner class */);
            }
        }, arg_0));
        HttpRequest request2 = ((HttpRequest.Builder)object).build();
        HttpResponse response = this.clientOptions.httpClient().execute(request2, requestOptions);
        boolean bl2 = false;
        AutoCloseable autoCloseable = response;
        Throwable throwable = null;
        try {
            HttpResponse it = (HttpResponse)autoCloseable;
            boolean bl3 = false;
            Void void_ = this.deleteHandler.handle(it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Customer fetch(@NotNull CustomerFetchParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String[] stringArray = new String[]{"customers", params.getPathParam(0)};
        HttpRequest request2 = HttpRequest.Companion.builder().method(HttpMethod.GET).addPathSegments(stringArray).putAllQueryParams((Multimap<String, String>)((Multimap)this.clientOptions.queryParams())).putAllQueryParams(params.getQueryParams$orb_java_core()).putAllHeaders((Multimap<String, String>)((Multimap)this.clientOptions.headers())).putAllHeaders(params.getHeaders$orb_java_core()).build();
        HttpResponse response = this.clientOptions.httpClient().execute(request2, requestOptions);
        boolean bl = false;
        Object object = response;
        Throwable throwable = null;
        try {
            Object it = (HttpResponse)object;
            boolean bl2 = false;
            it = this.fetchHandler.handle((HttpResponse)it);
        }
        catch (Throwable it) {
            throwable = it;
            throw it;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
        }
        Object $this$fetch_u24lambda_u2416_u24lambda_u2415 = object = it;
        boolean bl3 = false;
        Boolean bl4 = requestOptions.getResponseValidation();
        if (bl4 != null ? bl4.booleanValue() : this.clientOptions.responseValidation()) {
            ((Customer)$this$fetch_u24lambda_u2416_u24lambda_u2415).validate();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Customer fetchByExternalId(@NotNull CustomerFetchByExternalIdParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String[] stringArray = new String[]{"customers", "external_customer_id", params.getPathParam(0)};
        HttpRequest request2 = HttpRequest.Companion.builder().method(HttpMethod.GET).addPathSegments(stringArray).putAllQueryParams((Multimap<String, String>)((Multimap)this.clientOptions.queryParams())).putAllQueryParams(params.getQueryParams$orb_java_core()).putAllHeaders((Multimap<String, String>)((Multimap)this.clientOptions.headers())).putAllHeaders(params.getHeaders$orb_java_core()).build();
        HttpResponse response = this.clientOptions.httpClient().execute(request2, requestOptions);
        boolean bl = false;
        Object object = response;
        Throwable throwable = null;
        try {
            Object it = (HttpResponse)object;
            boolean bl2 = false;
            it = this.fetchByExternalIdHandler.handle((HttpResponse)it);
        }
        catch (Throwable it) {
            throwable = it;
            throw it;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
        }
        Object $this$fetchByExternalId_u24lambda_u2419_u24lambda_u2418 = object = it;
        boolean bl3 = false;
        Boolean bl4 = requestOptions.getResponseValidation();
        if (bl4 != null ? bl4.booleanValue() : this.clientOptions.responseValidation()) {
            ((Customer)$this$fetchByExternalId_u24lambda_u2419_u24lambda_u2418).validate();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Customer updateByExternalId(@NotNull CustomerUpdateByExternalIdParams params, @NotNull RequestOptions requestOptions) {
        void jsonMapper$iv;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String[] stringArray = new String[]{"customers", "external_customer_id", params.getPathParam(0)};
        HttpRequest.Builder builder = HttpRequest.Companion.builder().method(HttpMethod.PUT).addPathSegments(stringArray).putAllQueryParams((Multimap<String, String>)((Multimap)this.clientOptions.queryParams())).putAllQueryParams(params.getQueryParams$orb_java_core()).putAllHeaders((Multimap<String, String>)((Multimap)this.clientOptions.headers())).putAllHeaders(params.getHeaders$orb_java_core());
        stringArray = this.clientOptions.jsonMapper();
        CustomerUpdateByExternalIdParams.CustomerUpdateByExternalIdBody value$iv = params.getBody$orb_java_core();
        boolean $i$f$json = false;
        HttpRequest request2 = builder.body(new /* invalid duplicate definition of identical inner class */).build();
        HttpResponse response = this.clientOptions.httpClient().execute(request2, requestOptions);
        boolean bl = false;
        Object object = response;
        Throwable throwable = null;
        try {
            Object it = (HttpResponse)object;
            boolean bl2 = false;
            it = this.updateByExternalIdHandler.handle((HttpResponse)it);
        }
        catch (Throwable it) {
            throwable = it;
            throw it;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
        }
        Object $this$updateByExternalId_u24lambda_u2422_u24lambda_u2421 = object = it;
        boolean bl3 = false;
        Boolean bl4 = requestOptions.getResponseValidation();
        if (bl4 != null ? bl4.booleanValue() : this.clientOptions.responseValidation()) {
            ((Customer)$this$updateByExternalId_u24lambda_u2422_u24lambda_u2421).validate();
        }
        return object;
    }

    private static final void delete$lambda$11$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ ClientOptions access$getClientOptions$p(CustomerServiceImpl $this) {
        return $this.clientOptions;
    }
}

