/*
 * Decompiled with CFR 0.152.
 */
package com.withorb.api.services.blocking;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.google.common.collect.Multimap;
import com.withorb.api.core.ClientOptions;
import com.withorb.api.core.JsonValue;
import com.withorb.api.core.RequestOptions;
import com.withorb.api.core.handlers.ErrorHandler;
import com.withorb.api.core.http.HttpMethod;
import com.withorb.api.core.http.HttpRequest;
import com.withorb.api.core.http.HttpRequestBody;
import com.withorb.api.core.http.HttpResponse;
import com.withorb.api.errors.OrbError;
import com.withorb.api.errors.OrbException;
import com.withorb.api.models.EventDeprecateParams;
import com.withorb.api.models.EventDeprecateResponse;
import com.withorb.api.models.EventIngestParams;
import com.withorb.api.models.EventIngestResponse;
import com.withorb.api.models.EventSearchParams;
import com.withorb.api.models.EventSearchResponse;
import com.withorb.api.models.EventUpdateParams;
import com.withorb.api.models.EventUpdateResponse;
import com.withorb.api.services.blocking.EventService;
import com.withorb.api.services.blocking.events.BackfillService;
import com.withorb.api.services.blocking.events.BackfillServiceImpl;
import com.withorb.api.services.blocking.events.VolumeService;
import com.withorb.api.services.blocking.events.VolumeServiceImpl;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010\"\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010$\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020%2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0016\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\n\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006&"}, d2={"Lcom/withorb/api/services/blocking/EventServiceImpl;", "Lcom/withorb/api/services/blocking/EventService;", "clientOptions", "Lcom/withorb/api/core/ClientOptions;", "(Lcom/withorb/api/core/ClientOptions;)V", "backfills", "Lcom/withorb/api/services/blocking/events/BackfillService;", "getBackfills", "()Lcom/withorb/api/services/blocking/events/BackfillService;", "backfills$delegate", "Lkotlin/Lazy;", "deprecateHandler", "Lcom/withorb/api/core/http/HttpResponse$Handler;", "Lcom/withorb/api/models/EventDeprecateResponse;", "errorHandler", "Lcom/withorb/api/errors/OrbError;", "ingestHandler", "Lcom/withorb/api/models/EventIngestResponse;", "searchHandler", "Lcom/withorb/api/models/EventSearchResponse;", "updateHandler", "Lcom/withorb/api/models/EventUpdateResponse;", "volume", "Lcom/withorb/api/services/blocking/events/VolumeService;", "getVolume", "()Lcom/withorb/api/services/blocking/events/VolumeService;", "volume$delegate", "deprecate", "params", "Lcom/withorb/api/models/EventDeprecateParams;", "requestOptions", "Lcom/withorb/api/core/RequestOptions;", "ingest", "Lcom/withorb/api/models/EventIngestParams;", "search", "Lcom/withorb/api/models/EventSearchParams;", "update", "Lcom/withorb/api/models/EventUpdateParams;", "orb-java-core"})
@SourceDebugExtension(value={"SMAP\nEventServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventServiceImpl.kt\ncom/withorb/api/services/blocking/EventServiceImpl\n+ 2 JsonHandler.kt\ncom/withorb/api/core/handlers/JsonHandler\n+ 3 HttpRequestBodies.kt\ncom/withorb/api/core/HttpRequestBodies\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,438:1\n13#2,9:439\n13#2,9:448\n13#2,9:457\n13#2,9:466\n17#3:475\n17#3:477\n17#3:478\n1#4:476\n*S KotlinDebug\n*F\n+ 1 EventServiceImpl.kt\ncom/withorb/api/services/blocking/EventServiceImpl\n*L\n44#1:439,9\n113#1:448,9\n177#1:457,9\n395#1:466,9\n99#1:475\n381#1:477\n425#1:478\n*E\n"})
public final class EventServiceImpl
implements EventService {
    @NotNull
    private final ClientOptions clientOptions;
    @NotNull
    private final HttpResponse.Handler<OrbError> errorHandler;
    @NotNull
    private final Lazy backfills$delegate;
    @NotNull
    private final Lazy volume$delegate;
    @NotNull
    private final HttpResponse.Handler<EventUpdateResponse> updateHandler;
    @NotNull
    private final HttpResponse.Handler<EventDeprecateResponse> deprecateHandler;
    @NotNull
    private final HttpResponse.Handler<EventIngestResponse> ingestHandler;
    @NotNull
    private final HttpResponse.Handler<EventSearchResponse> searchHandler;

    public EventServiceImpl(@NotNull ClientOptions clientOptions) {
        Intrinsics.checkNotNullParameter((Object)clientOptions, (String)"clientOptions");
        this.clientOptions = clientOptions;
        this.errorHandler = ErrorHandler.errorHandler(this.clientOptions.jsonMapper());
        this.backfills$delegate = LazyKt.lazy((Function0)((Function0)new Function0<BackfillServiceImpl>(this){
            final /* synthetic */ EventServiceImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final BackfillServiceImpl invoke() {
                return new BackfillServiceImpl(EventServiceImpl.access$getClientOptions$p(this.this$0));
            }
        }));
        this.volume$delegate = LazyKt.lazy((Function0)((Function0)new Function0<VolumeServiceImpl>(this){
            final /* synthetic */ EventServiceImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final VolumeServiceImpl invoke() {
                return new VolumeServiceImpl(EventServiceImpl.access$getClientOptions$p(this.this$0));
            }
        }));
        JsonMapper jsonMapper$iv = this.clientOptions.jsonMapper();
        boolean $i$f$jsonHandler = false;
        this.updateHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<EventUpdateResponse>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public EventUpdateResponse handle(@NotNull HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<EventUpdateResponse>(){});
                }
                catch (Exception e) {
                    throw new OrbException("Error reading response", e);
                }
            }
        }, this.errorHandler);
        jsonMapper$iv = this.clientOptions.jsonMapper();
        $i$f$jsonHandler = false;
        this.deprecateHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<EventDeprecateResponse>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public EventDeprecateResponse handle(@NotNull HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<EventDeprecateResponse>(){});
                }
                catch (Exception e) {
                    throw new OrbException("Error reading response", e);
                }
            }
        }, this.errorHandler);
        jsonMapper$iv = this.clientOptions.jsonMapper();
        $i$f$jsonHandler = false;
        this.ingestHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<EventIngestResponse>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public EventIngestResponse handle(@NotNull HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<EventIngestResponse>(){});
                }
                catch (Exception e) {
                    throw new OrbException("Error reading response", e);
                }
            }
        }, this.errorHandler);
        jsonMapper$iv = this.clientOptions.jsonMapper();
        $i$f$jsonHandler = false;
        this.searchHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<EventSearchResponse>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public EventSearchResponse handle(@NotNull HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<EventSearchResponse>(){});
                }
                catch (Exception e) {
                    throw new OrbException("Error reading response", e);
                }
            }
        }, this.errorHandler);
    }

    private final BackfillService getBackfills() {
        Lazy lazy = this.backfills$delegate;
        return (BackfillService)lazy.getValue();
    }

    private final VolumeService getVolume() {
        Lazy lazy = this.volume$delegate;
        return (VolumeService)lazy.getValue();
    }

    @Override
    @NotNull
    public BackfillService backfills() {
        return this.getBackfills();
    }

    @Override
    @NotNull
    public VolumeService volume() {
        return this.getVolume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public EventUpdateResponse update(@NotNull EventUpdateParams params, @NotNull RequestOptions requestOptions) {
        void jsonMapper$iv;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String[] stringArray = new String[]{"events", params.getPathParam(0)};
        HttpRequest.Builder builder = HttpRequest.Companion.builder().method(HttpMethod.PUT).addPathSegments(stringArray).putAllQueryParams((Multimap<String, String>)((Multimap)this.clientOptions.queryParams())).putAllQueryParams(params.getQueryParams$orb_java_core()).putAllHeaders((Multimap<String, String>)((Multimap)this.clientOptions.headers())).putAllHeaders(params.getHeaders$orb_java_core());
        stringArray = this.clientOptions.jsonMapper();
        EventUpdateParams.EventUpdateBody value$iv = params.getBody$orb_java_core();
        boolean $i$f$json = false;
        HttpRequest request2 = builder.body(new HttpRequestBody((JsonMapper)jsonMapper$iv, value$iv){
            @Nullable
            private byte[] cachedBytes;
            final /* synthetic */ JsonMapper $jsonMapper;
            final /* synthetic */ T $value;
            {
                this.$jsonMapper = $jsonMapper;
                this.$value = $value;
            }

            private final byte[] serialize() {
                if (this.cachedBytes != null) {
                    Intrinsics.checkNotNull((Object)this.cachedBytes);
                    return this.cachedBytes;
                }
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                try {
                    this.$jsonMapper.writeValue((OutputStream)buffer, this.$value);
                    this.cachedBytes = buffer.toByteArray();
                    Intrinsics.checkNotNull((Object)this.cachedBytes);
                    return this.cachedBytes;
                }
                catch (Exception e) {
                    throw new OrbException("Error writing request", e);
                }
            }

            public void writeTo(@NotNull OutputStream outputStream) {
                Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                outputStream.write(this.serialize());
            }

            @NotNull
            public String contentType() {
                return "application/json";
            }

            public long contentLength() {
                return this.serialize().length;
            }

            public boolean repeatable() {
                return true;
            }

            public void close() {
            }
        }).build();
        HttpResponse response = this.clientOptions.httpClient().execute(request2, requestOptions);
        boolean bl = false;
        Object object = response;
        Throwable throwable = null;
        try {
            Object it = (HttpResponse)object;
            boolean bl2 = false;
            it = this.updateHandler.handle((HttpResponse)it);
        }
        catch (Throwable it) {
            throwable = it;
            throw it;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
        }
        Object $this$update_u24lambda_u242_u24lambda_u241 = object = it;
        boolean bl3 = false;
        Boolean bl4 = requestOptions.getResponseValidation();
        if (bl4 != null ? bl4.booleanValue() : this.clientOptions.responseValidation()) {
            ((EventUpdateResponse)$this$update_u24lambda_u242_u24lambda_u241).validate();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public EventDeprecateResponse deprecate(@NotNull EventDeprecateParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        Object object = new String[]{"events", params.getPathParam(0), "deprecate"};
        Object $this$deprecate_u24lambda_u244 = object = HttpRequest.Companion.builder().method(HttpMethod.PUT).addPathSegments((String[])object).putAllQueryParams((Multimap<String, String>)((Multimap)this.clientOptions.queryParams())).putAllQueryParams(params.getQueryParams$orb_java_core()).putAllHeaders((Multimap<String, String>)((Multimap)this.clientOptions.headers())).putAllHeaders(params.getHeaders$orb_java_core());
        boolean bl = false;
        params.getBody$orb_java_core().ifPresent(arg_0 -> EventServiceImpl.deprecate$lambda$4$lambda$3((Function1)new Function1<Map<String, ? extends JsonValue>, Unit>((HttpRequest.Builder)$this$deprecate_u24lambda_u244, this){
            final /* synthetic */ HttpRequest.Builder $this_apply;
            final /* synthetic */ EventServiceImpl this$0;
            {
                this.$this_apply = $receiver;
                this.this$0 = $receiver2;
                super(1);
            }

            public final void invoke(@NotNull Map<String, ? extends JsonValue> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                JsonMapper jsonMapper$iv = EventServiceImpl.access$getClientOptions$p(this.this$0).jsonMapper();
                boolean $i$f$json = false;
                this.$this_apply.body(new /* invalid duplicate definition of identical inner class */);
            }
        }, arg_0));
        HttpRequest request2 = ((HttpRequest.Builder)object).build();
        HttpResponse response = this.clientOptions.httpClient().execute(request2, requestOptions);
        boolean bl2 = false;
        Object object2 = response;
        Throwable throwable = null;
        try {
            Object it = (HttpResponse)object2;
            boolean bl3 = false;
            it = this.deprecateHandler.handle((HttpResponse)it);
        }
        catch (Throwable it) {
            throwable = it;
            throw it;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object2, (Throwable)throwable);
        }
        Object $this$deprecate_u24lambda_u247_u24lambda_u246 = object2 = it;
        boolean bl4 = false;
        Boolean bl5 = requestOptions.getResponseValidation();
        if (bl5 != null ? bl5.booleanValue() : this.clientOptions.responseValidation()) {
            ((EventDeprecateResponse)$this$deprecate_u24lambda_u247_u24lambda_u246).validate();
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public EventIngestResponse ingest(@NotNull EventIngestParams params, @NotNull RequestOptions requestOptions) {
        void jsonMapper$iv;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String[] stringArray = new String[]{"ingest"};
        HttpRequest.Builder builder = HttpRequest.Companion.builder().method(HttpMethod.POST).addPathSegments(stringArray).putAllQueryParams((Multimap<String, String>)((Multimap)this.clientOptions.queryParams())).putAllQueryParams(params.getQueryParams$orb_java_core()).putAllHeaders((Multimap<String, String>)((Multimap)this.clientOptions.headers())).putAllHeaders(params.getHeaders$orb_java_core());
        stringArray = this.clientOptions.jsonMapper();
        EventIngestParams.EventIngestBody value$iv = params.getBody$orb_java_core();
        boolean $i$f$json = false;
        HttpRequest request2 = builder.body(new /* invalid duplicate definition of identical inner class */).build();
        HttpResponse response = this.clientOptions.httpClient().execute(request2, requestOptions);
        boolean bl = false;
        Object object = response;
        Throwable throwable = null;
        try {
            Object it = (HttpResponse)object;
            boolean bl2 = false;
            it = this.ingestHandler.handle((HttpResponse)it);
        }
        catch (Throwable it) {
            throwable = it;
            throw it;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
        }
        Object $this$ingest_u24lambda_u2410_u24lambda_u249 = object = it;
        boolean bl3 = false;
        Boolean bl4 = requestOptions.getResponseValidation();
        if (bl4 != null ? bl4.booleanValue() : this.clientOptions.responseValidation()) {
            ((EventIngestResponse)$this$ingest_u24lambda_u2410_u24lambda_u249).validate();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public EventSearchResponse search(@NotNull EventSearchParams params, @NotNull RequestOptions requestOptions) {
        void jsonMapper$iv;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String[] stringArray = new String[]{"events", "search"};
        HttpRequest.Builder builder = HttpRequest.Companion.builder().method(HttpMethod.POST).addPathSegments(stringArray).putAllQueryParams((Multimap<String, String>)((Multimap)this.clientOptions.queryParams())).putAllQueryParams(params.getQueryParams$orb_java_core()).putAllHeaders((Multimap<String, String>)((Multimap)this.clientOptions.headers())).putAllHeaders(params.getHeaders$orb_java_core());
        stringArray = this.clientOptions.jsonMapper();
        EventSearchParams.EventSearchBody value$iv = params.getBody$orb_java_core();
        boolean $i$f$json = false;
        HttpRequest request2 = builder.body(new /* invalid duplicate definition of identical inner class */).build();
        HttpResponse response = this.clientOptions.httpClient().execute(request2, requestOptions);
        boolean bl = false;
        Object object = response;
        Throwable throwable = null;
        try {
            Object it = (HttpResponse)object;
            boolean bl2 = false;
            it = this.searchHandler.handle((HttpResponse)it);
        }
        catch (Throwable it) {
            throwable = it;
            throw it;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
        }
        Object $this$search_u24lambda_u2413_u24lambda_u2412 = object = it;
        boolean bl3 = false;
        Boolean bl4 = requestOptions.getResponseValidation();
        if (bl4 != null ? bl4.booleanValue() : this.clientOptions.responseValidation()) {
            ((EventSearchResponse)$this$search_u24lambda_u2413_u24lambda_u2412).validate();
        }
        return object;
    }

    private static final void deprecate$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ ClientOptions access$getClientOptions$p(EventServiceImpl $this) {
        return $this.clientOptions;
    }
}

