/*
 * Decompiled with CFR 0.152.
 */
package com.withorb.api.core;

import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.withorb.api.core.BaseDeserializer;
import com.withorb.api.core.JsonArray;
import com.withorb.api.core.JsonBoolean;
import com.withorb.api.core.JsonMissing;
import com.withorb.api.core.JsonNull;
import com.withorb.api.core.JsonNumber;
import com.withorb.api.core.JsonObject;
import com.withorb.api.core.JsonString;
import com.withorb.api.core.JsonValue;
import com.withorb.api.core.KnownValue;
import com.withorb.api.errors.OrbInvalidDataException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonDeserialize(using=Deserializer.class)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 (*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0002:\u0004'()*B\t\b\u0004\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u0007\u001a\u00020\u0006J\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\tJ\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\tJ\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\tJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\tJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\tJ\u0006\u0010\u0011\u001a\u00020\u0010J\u0012\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00130\tJ\u0018\u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u000b0\u00150\tJ\u0017\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u0010H\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0019\u0010\u001a\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0017\u001a\u00020\u0010H\u0000\u00a2\u0006\u0004\b\u001b\u0010\u0019J1\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u0000\"\b\b\u0001\u0010\u001d*\u00020\u00022\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u001d0\u001fH\u0000\u00a2\u0006\u0002\b J\u001a\u0010!\u001a\u00020\"2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\"0\u001fJ%\u0010!\u001a\u0002H\u001d\"\u0004\b\u0001\u0010\u001d2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u001d0%\u00a2\u0006\u0002\u0010&\u0082\u0001\u0002\u000b+\u00a8\u0006,"}, d2={"Lcom/withorb/api/core/JsonField;", "T", "", "<init>", "()V", "isMissing", "", "isNull", "asKnown", "Ljava/util/Optional;", "asUnknown", "Lcom/withorb/api/core/JsonValue;", "asBoolean", "asNumber", "", "asString", "", "asStringOrThrow", "asArray", "", "asObject", "", "getRequired", "name", "getRequired$orb_java_core", "(Ljava/lang/String;)Ljava/lang/Object;", "getNullable", "getNullable$orb_java_core", "map", "R", "transform", "Lkotlin/Function1;", "map$orb_java_core", "accept", "", "consume", "visitor", "Lcom/withorb/api/core/JsonField$Visitor;", "(Lcom/withorb/api/core/JsonField$Visitor;)Ljava/lang/Object;", "Visitor", "Companion", "IsMissing", "Deserializer", "Lcom/withorb/api/core/KnownValue;", "orb-java-core"})
@SourceDebugExtension(value={"SMAP\nValues.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Values.kt\ncom/withorb/api/core/JsonField\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,541:1\n1557#2:542\n1628#2,3:543\n126#3:546\n153#3,3:547\n*S KotlinDebug\n*F\n+ 1 Values.kt\ncom/withorb/api/core/JsonField\n*L\n87#1:542\n87#1:543,3\n106#1:546\n106#1:547,3\n*E\n"})
public abstract class JsonField<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private JsonField() {
    }

    public final boolean isMissing() {
        return this instanceof JsonMissing;
    }

    public final boolean isNull() {
        return this instanceof JsonNull;
    }

    @NotNull
    public final Optional<? extends T> asKnown() {
        Optional optional;
        if (this instanceof KnownValue) {
            Optional optional2 = Optional.of(((KnownValue)this).value());
            optional = optional2;
            Intrinsics.checkNotNullExpressionValue(optional2, (String)"of(...)");
        } else {
            Optional optional3 = Optional.empty();
            optional = optional3;
            Intrinsics.checkNotNullExpressionValue(optional3, (String)"empty(...)");
        }
        return optional;
    }

    @NotNull
    public final Optional<? extends JsonValue> asUnknown() {
        Optional<Object> optional;
        if (this instanceof JsonValue) {
            Optional<JsonField> optional2 = Optional.of(this);
            optional = optional2;
            Intrinsics.checkNotNullExpressionValue(optional2, (String)"of(...)");
        } else {
            Optional optional3 = Optional.empty();
            optional = optional3;
            Intrinsics.checkNotNullExpressionValue(optional3, (String)"empty(...)");
        }
        return optional;
    }

    @NotNull
    public final Optional<Boolean> asBoolean() {
        Optional<Boolean> optional;
        JsonField jsonField = this;
        if (jsonField instanceof JsonBoolean) {
            Optional<Boolean> optional2 = Optional.of(((JsonBoolean)this).value());
            optional = optional2;
            Intrinsics.checkNotNullExpressionValue(optional2, (String)"of(...)");
        } else if (jsonField instanceof KnownValue) {
            Object t = ((KnownValue)this).value();
            Optional<Boolean> optional3 = Optional.ofNullable(t instanceof Boolean ? (Boolean)t : null);
            optional = optional3;
            Intrinsics.checkNotNullExpressionValue(optional3, (String)"ofNullable(...)");
        } else {
            Optional optional4 = Optional.empty();
            optional = optional4;
            Intrinsics.checkNotNullExpressionValue(optional4, (String)"empty(...)");
        }
        return optional;
    }

    @NotNull
    public final Optional<Number> asNumber() {
        Optional<Number> optional;
        JsonField jsonField = this;
        if (jsonField instanceof JsonNumber) {
            Optional<Number> optional2 = Optional.of(((JsonNumber)this).value());
            optional = optional2;
            Intrinsics.checkNotNullExpressionValue(optional2, (String)"of(...)");
        } else if (jsonField instanceof KnownValue) {
            Object t = ((KnownValue)this).value();
            Optional<Number> optional3 = Optional.ofNullable(t instanceof Number ? (Number)((Number)t) : (Number)null);
            optional = optional3;
            Intrinsics.checkNotNullExpressionValue(optional3, (String)"ofNullable(...)");
        } else {
            Optional optional4 = Optional.empty();
            optional = optional4;
            Intrinsics.checkNotNullExpressionValue(optional4, (String)"empty(...)");
        }
        return optional;
    }

    @NotNull
    public final Optional<String> asString() {
        Optional<String> optional;
        JsonField jsonField = this;
        if (jsonField instanceof JsonString) {
            Optional<String> optional2 = Optional.of(((JsonString)this).value());
            optional = optional2;
            Intrinsics.checkNotNullExpressionValue(optional2, (String)"of(...)");
        } else if (jsonField instanceof KnownValue) {
            Object t = ((KnownValue)this).value();
            Optional<String> optional3 = Optional.ofNullable(t instanceof String ? (String)t : null);
            optional = optional3;
            Intrinsics.checkNotNullExpressionValue(optional3, (String)"ofNullable(...)");
        } else {
            Optional optional4 = Optional.empty();
            optional = optional4;
            Intrinsics.checkNotNullExpressionValue(optional4, (String)"empty(...)");
        }
        return optional;
    }

    @NotNull
    public final String asStringOrThrow() {
        String string = this.asString().orElseThrow(JsonField::asStringOrThrow$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"orElseThrow(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Optional<List<JsonValue>> asArray() {
        Optional<List<JsonValue>> optional;
        JsonField jsonField = this;
        if (jsonField instanceof JsonArray) {
            Optional<List<JsonValue>> optional2 = Optional.of(((JsonArray)this).values());
            optional = optional2;
            Intrinsics.checkNotNullExpressionValue(optional2, (String)"of(...)");
        } else if (jsonField instanceof KnownValue) {
            List list;
            Object t = ((KnownValue)this).value();
            List list2 = t instanceof List ? (List)t : null;
            if (list2 != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = list2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    JsonValue jsonValue;
                    Object item$iv$iv;
                    Object t2 = item$iv$iv = iterator2.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    try {
                        void it;
                        jsonValue = JsonValue.Companion.from(it);
                    }
                    catch (IllegalArgumentException e) {
                        Optional<List<JsonValue>> optional3 = Optional.empty();
                        Intrinsics.checkNotNullExpressionValue(optional3, (String)"empty(...)");
                        return optional3;
                    }
                    collection.add(jsonValue);
                }
                list = (List)destination$iv$iv;
            } else {
                list = null;
            }
            Optional<Object> optional4 = Optional.ofNullable(list);
            Intrinsics.checkNotNullExpressionValue(optional4, (String)"ofNullable(...)");
            optional = optional4;
        } else {
            Optional optional5 = Optional.empty();
            optional = optional5;
            Intrinsics.checkNotNullExpressionValue(optional5, (String)"empty(...)");
        }
        return optional;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Optional<Map<String, JsonValue>> asObject() {
        Optional<Map<String, JsonValue>> optional;
        JsonField jsonField = this;
        if (jsonField instanceof JsonObject) {
            Optional<Map<String, JsonValue>> optional2 = Optional.of(((JsonObject)this).values());
            optional = optional2;
            Intrinsics.checkNotNullExpressionValue(optional2, (String)"of(...)");
        } else if (jsonField instanceof KnownValue) {
            Map map;
            Map map2;
            Object t = ((KnownValue)this).value();
            Map map3 = map2 = t instanceof Map ? (Map)t : null;
            if (map2 != null) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Map map4 = map2;
                boolean $i$f$map = false;
                void var7_6 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.size());
                boolean $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    JsonValue jsonValue;
                    Map.Entry item$iv$iv;
                    Map.Entry entry = item$iv$iv = iterator2.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (!(key instanceof String)) {
                        Optional<Map<String, JsonValue>> optional3 = Optional.empty();
                        Intrinsics.checkNotNullExpressionValue(optional3, (String)"empty(...)");
                        return optional3;
                    }
                    try {
                        jsonValue = JsonValue.Companion.from(value);
                    }
                    catch (IllegalArgumentException e) {
                        Optional<Map<String, JsonValue>> optional4 = Optional.empty();
                        Intrinsics.checkNotNullExpressionValue(optional4, (String)"empty(...)");
                        return optional4;
                    }
                    JsonValue jsonValue2 = jsonValue;
                    collection.add(TuplesKt.to(key, (Object)jsonValue2));
                }
                map = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            } else {
                map = null;
            }
            Optional<Object> optional5 = Optional.ofNullable(map);
            Intrinsics.checkNotNullExpressionValue(optional5, (String)"ofNullable(...)");
            optional = optional5;
        } else {
            Optional optional6 = Optional.empty();
            optional = optional6;
            Intrinsics.checkNotNullExpressionValue(optional6, (String)"empty(...)");
        }
        return optional;
    }

    public final /* synthetic */ Object getRequired$orb_java_core(String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        JsonField jsonField = this;
        if (!(jsonField instanceof KnownValue)) {
            if (jsonField instanceof JsonMissing) {
                throw new OrbInvalidDataException('`' + name + "` is not set", null, 2, null);
            }
            if (jsonField instanceof JsonNull) {
                throw new OrbInvalidDataException('`' + name + "` is null", null, 2, null);
            }
            throw new OrbInvalidDataException('`' + name + "` is invalid, received " + this, null, 2, null);
        }
        return ((KnownValue)this).value();
    }

    public final /* synthetic */ Object getNullable$orb_java_core(String name) {
        Object t;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        JsonField jsonField = this;
        if (jsonField instanceof KnownValue) {
            t = ((KnownValue)this).value();
        } else if (jsonField instanceof JsonMissing) {
            t = null;
        } else if (jsonField instanceof JsonNull) {
            t = null;
        } else {
            throw new OrbInvalidDataException('`' + name + "` is invalid, received " + this, null, 2, null);
        }
        return t;
    }

    public final /* synthetic */ JsonField map$orb_java_core(Function1 transform) {
        JsonField jsonField;
        Intrinsics.checkNotNullParameter((Object)transform, (String)"transform");
        JsonField jsonField2 = this;
        if (jsonField2 instanceof KnownValue) {
            jsonField = KnownValue.Companion.of(transform.invoke(((KnownValue)this).value()));
        } else if (jsonField2 instanceof JsonValue) {
            jsonField = this;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return jsonField;
    }

    public final /* synthetic */ void accept(Function1 consume) {
        Intrinsics.checkNotNullParameter((Object)consume, (String)"consume");
        this.asKnown().ifPresent(arg_0 -> JsonField.accept$lambda$3(consume, arg_0));
    }

    public final <R> R accept(@NotNull Visitor<? super T, ? extends R> visitor) {
        R r;
        Intrinsics.checkNotNullParameter(visitor, (String)"visitor");
        JsonField jsonField = this;
        if (jsonField instanceof KnownValue) {
            r = visitor.visitKnown(((KnownValue)this).value());
        } else if (jsonField instanceof JsonValue) {
            r = ((JsonValue)this).accept(visitor);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return r;
    }

    private static final OrbInvalidDataException asStringOrThrow$lambda$0() {
        return new OrbInvalidDataException("Value is not a string", null, 2, null);
    }

    private static final void accept$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final <T> JsonField<T> of(@NotNull T value) {
        return Companion.of(value);
    }

    @JvmStatic
    @NotNull
    public static final <T> JsonField<T> ofNullable(@Nullable T value) {
        return Companion.ofNullable(value);
    }

    public /* synthetic */ JsonField(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\b\b\u0001\u0010\u0006*\u00020\u00012\u0006\u0010\u0007\u001a\u0002H\u0006H\u0007\u00a2\u0006\u0002\u0010\bJ'\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\b\b\u0001\u0010\u0006*\u00020\u00012\b\u0010\u0007\u001a\u0004\u0018\u0001H\u0006H\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\n"}, d2={"Lcom/withorb/api/core/JsonField$Companion;", "", "<init>", "()V", "of", "Lcom/withorb/api/core/JsonField;", "T", "value", "(Ljava/lang/Object;)Lcom/withorb/api/core/JsonField;", "ofNullable", "orb-java-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final <T> JsonField<T> of(@NotNull T value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return KnownValue.Companion.of(value);
        }

        @JvmStatic
        @NotNull
        public final <T> JsonField<T> ofNullable(@Nullable T value) {
            return value == null ? (JsonField)JsonNull.Companion.of() : (JsonField)KnownValue.Companion.of(value);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0013\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J$\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0018\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u0002*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0014\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\t\u001a\u00020\nH\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/withorb/api/core/JsonField$Deserializer;", "Lcom/withorb/api/core/BaseDeserializer;", "Lcom/withorb/api/core/JsonField;", "type", "Lcom/fasterxml/jackson/databind/JavaType;", "<init>", "(Lcom/fasterxml/jackson/databind/JavaType;)V", "createContextual", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "context", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "property", "Lcom/fasterxml/jackson/databind/BeanProperty;", "deserialize", "Lcom/fasterxml/jackson/core/ObjectCodec;", "node", "Lcom/fasterxml/jackson/databind/JsonNode;", "getNullValue", "orb-java-core"})
    @SourceDebugExtension(value={"SMAP\nValues.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Values.kt\ncom/withorb/api/core/JsonField$Deserializer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,541:1\n1#2:542\n*E\n"})
    public static final class Deserializer
    extends BaseDeserializer<JsonField<?>> {
        @Nullable
        private final JavaType type;

        public Deserializer(@Nullable JavaType type) {
            super(Reflection.getOrCreateKotlinClass(JsonField.class));
            this.type = type;
        }

        public /* synthetic */ Deserializer(JavaType javaType, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                javaType = null;
            }
            this(javaType);
        }

        @Override
        @NotNull
        public JsonDeserializer<JsonField<?>> createContextual(@NotNull DeserializationContext context, @Nullable BeanProperty property) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            JavaType javaType = context.getContextualType();
            return (JsonDeserializer)new Deserializer((JavaType)(javaType != null ? javaType.containedType(0) : null));
        }

        @Override
        @NotNull
        protected JsonField<?> deserialize(@NotNull ObjectCodec $this$deserialize, @NotNull JsonNode node) {
            Object object;
            block3: {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)$this$deserialize, (String)"<this>");
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    object = this.type;
                    if (object == null) break block2;
                    JavaType it = object;
                    boolean bl = false;
                    Object object2 = BaseDeserializer.tryDeserialize$default((BaseDeserializer)this, $this$deserialize, node, this.type, null, 4, null);
                    object = object2;
                    if (object2 == null) break block2;
                    Object it2 = object;
                    boolean bl2 = false;
                    JsonField<JavaType> jsonField = Companion.of(it2);
                    object = jsonField;
                    if (jsonField != null) break block3;
                }
                object = JsonValue.Companion.fromJsonNode(node);
            }
            return object;
        }

        @NotNull
        public JsonField<?> getNullValue(@NotNull DeserializationContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return JsonNull.Companion.of();
        }

        public Deserializer() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/withorb/api/core/JsonField$IsMissing;", "", "<init>", "()V", "equals", "", "other", "hashCode", "", "orb-java-core"})
    public static final class IsMissing {
        public boolean equals(@Nullable Object other) {
            return other instanceof JsonMissing;
        }

        public int hashCode() {
            return Objects.hash(new Object[0]);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u0000*\u0006\b\u0001\u0010\u0001 \u0000*\u0006\b\u0002\u0010\u0002 \u00012\b\u0012\u0004\u0012\u0002H\u00020\u0003J\u0015\u0010\u0004\u001a\u00028\u00022\u0006\u0010\u0005\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0006\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lcom/withorb/api/core/JsonField$Visitor;", "T", "R", "Lcom/withorb/api/core/JsonValue$Visitor;", "visitKnown", "value", "(Ljava/lang/Object;)Ljava/lang/Object;", "orb-java-core"})
    public static interface Visitor<T, R>
    extends JsonValue.Visitor<R> {
        default public R visitKnown(T value) {
            return this.visitDefault();
        }
    }
}

