/*
 * Decompiled with CFR 0.152.
 */
package com.withorb.api.models;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.withorb.api.core.BaseDeserializer;
import com.withorb.api.core.BaseSerializer;
import com.withorb.api.core.JsonField;
import com.withorb.api.core.JsonValue;
import com.withorb.api.core.Utils;
import com.withorb.api.errors.OrbInvalidDataException;
import com.withorb.api.models.AmountDiscount;
import com.withorb.api.models.PercentageDiscount;
import com.withorb.api.models.TrialDiscount;
import com.withorb.api.models.UsageDiscount;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonDeserialize(using=Deserializer.class)
@JsonSerialize(using=Serializer.class)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u0000 %2\u00020\u0001:\u0004%&'(BE\b\u0002\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eJ\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eJ\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eJ\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0010J\u0006\u0010\u0012\u001a\u00020\u0010J\u0006\u0010\u0013\u001a\u00020\u0010J\u0006\u0010\u0014\u001a\u00020\u0003J\u0006\u0010\u0015\u001a\u00020\u0005J\u0006\u0010\u0016\u001a\u00020\u0007J\u0006\u0010\u0017\u001a\u00020\tJ\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eJ\u001f\u0010\u0018\u001a\u0002H\u0019\"\u0004\b\u0000\u0010\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001b\u00a2\u0006\u0002\u0010\u001cJ\u0006\u0010\u001e\u001a\u00020\u0000J\u0013\u0010\u001f\u001a\u00020\u00102\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020$H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/withorb/api/models/Discount;", "", "percentage", "Lcom/withorb/api/models/PercentageDiscount;", "trial", "Lcom/withorb/api/models/TrialDiscount;", "usage", "Lcom/withorb/api/models/UsageDiscount;", "amount", "Lcom/withorb/api/models/AmountDiscount;", "_json", "Lcom/withorb/api/core/JsonValue;", "<init>", "(Lcom/withorb/api/models/PercentageDiscount;Lcom/withorb/api/models/TrialDiscount;Lcom/withorb/api/models/UsageDiscount;Lcom/withorb/api/models/AmountDiscount;Lcom/withorb/api/core/JsonValue;)V", "Ljava/util/Optional;", "isPercentage", "", "isTrial", "isUsage", "isAmount", "asPercentage", "asTrial", "asUsage", "asAmount", "accept", "T", "visitor", "Lcom/withorb/api/models/Discount$Visitor;", "(Lcom/withorb/api/models/Discount$Visitor;)Ljava/lang/Object;", "validated", "validate", "equals", "other", "hashCode", "", "toString", "", "Companion", "Visitor", "Deserializer", "Serializer", "orb-java-core"})
public final class Discount {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final PercentageDiscount percentage;
    @Nullable
    private final TrialDiscount trial;
    @Nullable
    private final UsageDiscount usage;
    @Nullable
    private final AmountDiscount amount;
    @Nullable
    private final JsonValue _json;
    private boolean validated;

    private Discount(PercentageDiscount percentage, TrialDiscount trial, UsageDiscount usage, AmountDiscount amount, JsonValue _json) {
        this.percentage = percentage;
        this.trial = trial;
        this.usage = usage;
        this.amount = amount;
        this._json = _json;
    }

    /* synthetic */ Discount(PercentageDiscount percentageDiscount, TrialDiscount trialDiscount, UsageDiscount usageDiscount, AmountDiscount amountDiscount, JsonValue jsonValue, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            percentageDiscount = null;
        }
        if ((n & 2) != 0) {
            trialDiscount = null;
        }
        if ((n & 4) != 0) {
            usageDiscount = null;
        }
        if ((n & 8) != 0) {
            amountDiscount = null;
        }
        if ((n & 0x10) != 0) {
            jsonValue = null;
        }
        this(percentageDiscount, trialDiscount, usageDiscount, amountDiscount, jsonValue);
    }

    @NotNull
    public final Optional<PercentageDiscount> percentage() {
        Optional<PercentageDiscount> optional = Optional.ofNullable(this.percentage);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    @NotNull
    public final Optional<TrialDiscount> trial() {
        Optional<TrialDiscount> optional = Optional.ofNullable(this.trial);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    @NotNull
    public final Optional<UsageDiscount> usage() {
        Optional<UsageDiscount> optional = Optional.ofNullable(this.usage);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    @NotNull
    public final Optional<AmountDiscount> amount() {
        Optional<AmountDiscount> optional = Optional.ofNullable(this.amount);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    public final boolean isPercentage() {
        return this.percentage != null;
    }

    public final boolean isTrial() {
        return this.trial != null;
    }

    public final boolean isUsage() {
        return this.usage != null;
    }

    public final boolean isAmount() {
        return this.amount != null;
    }

    @NotNull
    public final PercentageDiscount asPercentage() {
        return (PercentageDiscount)Utils.getOrThrow(this.percentage, "percentage");
    }

    @NotNull
    public final TrialDiscount asTrial() {
        return (TrialDiscount)Utils.getOrThrow(this.trial, "trial");
    }

    @NotNull
    public final UsageDiscount asUsage() {
        return (UsageDiscount)Utils.getOrThrow(this.usage, "usage");
    }

    @NotNull
    public final AmountDiscount asAmount() {
        return (AmountDiscount)Utils.getOrThrow(this.amount, "amount");
    }

    @NotNull
    public final Optional<JsonValue> _json() {
        Optional<JsonValue> optional = Optional.ofNullable(this._json);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    public final <T> T accept(@NotNull Visitor<? extends T> visitor) {
        Intrinsics.checkNotNullParameter(visitor, (String)"visitor");
        return this.percentage != null ? visitor.visitPercentage(this.percentage) : (this.trial != null ? visitor.visitTrial(this.trial) : (this.usage != null ? visitor.visitUsage(this.usage) : (this.amount != null ? visitor.visitAmount(this.amount) : visitor.unknown(this._json))));
    }

    @NotNull
    public final Discount validate() {
        Discount discount;
        Discount $this$validate_u24lambda_u240 = discount = this;
        boolean bl = false;
        if (!$this$validate_u24lambda_u240.validated) {
            $this$validate_u24lambda_u240.accept((Visitor)new Visitor<Unit>(){

                public void visitPercentage(PercentageDiscount percentage) {
                    Intrinsics.checkNotNullParameter((Object)percentage, (String)"percentage");
                    percentage.validate();
                }

                public void visitTrial(TrialDiscount trial) {
                    Intrinsics.checkNotNullParameter((Object)trial, (String)"trial");
                    trial.validate();
                }

                public void visitUsage(UsageDiscount usage) {
                    Intrinsics.checkNotNullParameter((Object)usage, (String)"usage");
                    usage.validate();
                }

                public void visitAmount(AmountDiscount amount) {
                    Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
                    amount.validate();
                }
            });
            $this$validate_u24lambda_u240.validated = true;
        }
        return discount;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Discount && Intrinsics.areEqual((Object)this.percentage, (Object)((Discount)other).percentage) && Intrinsics.areEqual((Object)this.trial, (Object)((Discount)other).trial) && Intrinsics.areEqual((Object)this.usage, (Object)((Discount)other).usage) && Intrinsics.areEqual((Object)this.amount, (Object)((Discount)other).amount);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.percentage, this.trial, this.usage, this.amount};
        return Objects.hash(objectArray);
    }

    @NotNull
    public String toString() {
        String string;
        if (this.percentage != null) {
            string = "Discount{percentage=" + this.percentage + '}';
        } else if (this.trial != null) {
            string = "Discount{trial=" + this.trial + '}';
        } else if (this.usage != null) {
            string = "Discount{usage=" + this.usage + '}';
        } else if (this.amount != null) {
            string = "Discount{amount=" + this.amount + '}';
        } else if (this._json != null) {
            string = "Discount{_unknown=" + this._json + '}';
        } else {
            throw new IllegalStateException("Invalid Discount");
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final Discount ofPercentage(@NotNull PercentageDiscount percentage) {
        return Companion.ofPercentage(percentage);
    }

    @JvmStatic
    @NotNull
    public static final Discount ofTrial(@NotNull TrialDiscount trial) {
        return Companion.ofTrial(trial);
    }

    @JvmStatic
    @NotNull
    public static final Discount ofUsage(@NotNull UsageDiscount usage) {
        return Companion.ofUsage(usage);
    }

    @JvmStatic
    @NotNull
    public static final Discount ofAmount(@NotNull AmountDiscount amount) {
        return Companion.ofAmount(amount);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0007\u00a8\u0006\u0011"}, d2={"Lcom/withorb/api/models/Discount$Companion;", "", "<init>", "()V", "ofPercentage", "Lcom/withorb/api/models/Discount;", "percentage", "Lcom/withorb/api/models/PercentageDiscount;", "ofTrial", "trial", "Lcom/withorb/api/models/TrialDiscount;", "ofUsage", "usage", "Lcom/withorb/api/models/UsageDiscount;", "ofAmount", "amount", "Lcom/withorb/api/models/AmountDiscount;", "orb-java-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Discount ofPercentage(@NotNull PercentageDiscount percentage) {
            Intrinsics.checkNotNullParameter((Object)percentage, (String)"percentage");
            return new Discount(percentage, null, null, null, null, 30, null);
        }

        @JvmStatic
        @NotNull
        public final Discount ofTrial(@NotNull TrialDiscount trial) {
            Intrinsics.checkNotNullParameter((Object)trial, (String)"trial");
            return new Discount(null, trial, null, null, null, 29, null);
        }

        @JvmStatic
        @NotNull
        public final Discount ofUsage(@NotNull UsageDiscount usage) {
            Intrinsics.checkNotNullParameter((Object)usage, (String)"usage");
            return new Discount(null, null, usage, null, null, 27, null);
        }

        @JvmStatic
        @NotNull
        public final Discount ofAmount(@NotNull AmountDiscount amount) {
            Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
            return new Discount(null, null, null, amount, null, 23, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0014\u0010\u0005\u001a\u00020\u0002*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, d2={"Lcom/withorb/api/models/Discount$Deserializer;", "Lcom/withorb/api/core/BaseDeserializer;", "Lcom/withorb/api/models/Discount;", "<init>", "()V", "deserialize", "Lcom/fasterxml/jackson/core/ObjectCodec;", "node", "Lcom/fasterxml/jackson/databind/JsonNode;", "orb-java-core"})
    @SourceDebugExtension(value={"SMAP\nDiscount.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Discount.kt\ncom/withorb/api/models/Discount$Deserializer\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,210:1\n51#2:211\n51#2:212\n51#2:213\n51#2:214\n*S KotlinDebug\n*F\n+ 1 Discount.kt\ncom/withorb/api/models/Discount$Deserializer\n*L\n163#1:211\n169#1:212\n175#1:213\n181#1:214\n*E\n"})
    public static final class Deserializer
    extends BaseDeserializer<Discount> {
        public Deserializer() {
            super(Reflection.getOrCreateKotlinClass(Discount.class));
        }

        @Override
        @NotNull
        protected Discount deserialize(@NotNull ObjectCodec $this$deserialize, @NotNull JsonNode node) {
            JsonValue json2;
            block16: {
                String discountType;
                Intrinsics.checkNotNullParameter((Object)$this$deserialize, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                json2 = JsonValue.Companion.fromJsonNode(node);
                Object object = (Map)OptionalsKt.getOrNull(json2.asObject());
                String string = discountType = object != null && (object = (JsonValue)object.get("discount_type")) != null && (object = ((JsonField)object).asString()) != null ? (String)OptionalsKt.getOrNull(object) : null;
                if (string == null) break block16;
                int n = -1;
                switch (string.hashCode()) {
                    case -1413853096: {
                        if (string.equals("amount")) {
                            n = 1;
                        }
                        break;
                    }
                    case -921832806: {
                        if (string.equals("percentage")) {
                            n = 2;
                        }
                        break;
                    }
                    case 111574433: {
                        if (string.equals("usage")) {
                            n = 3;
                        }
                        break;
                    }
                    case 110628630: {
                        if (string.equals("trial")) {
                            n = 4;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 2: {
                        boolean $i$f$jacksonTypeRef = false;
                        PercentageDiscount percentageDiscount = (PercentageDiscount)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<PercentageDiscount>(){}, Deserializer::deserialize$lambda$0);
                        if (percentageDiscount == null) break;
                        PercentageDiscount it = percentageDiscount;
                        boolean bl = false;
                        return new Discount(it, null, null, null, json2, 14, null);
                    }
                    case 4: {
                        boolean $i$f$jacksonTypeRef = false;
                        TrialDiscount trialDiscount = (TrialDiscount)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<TrialDiscount>(){}, Deserializer::deserialize$lambda$2);
                        if (trialDiscount == null) break;
                        TrialDiscount it = trialDiscount;
                        boolean bl = false;
                        return new Discount(null, it, null, null, json2, 13, null);
                    }
                    case 3: {
                        boolean $i$f$jacksonTypeRef = false;
                        UsageDiscount usageDiscount = (UsageDiscount)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<UsageDiscount>(){}, Deserializer::deserialize$lambda$4);
                        if (usageDiscount == null) break;
                        UsageDiscount it = usageDiscount;
                        boolean bl = false;
                        return new Discount(null, null, it, null, json2, 11, null);
                    }
                    case 1: {
                        boolean $i$f$jacksonTypeRef = false;
                        AmountDiscount amountDiscount = (AmountDiscount)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<AmountDiscount>(){}, Deserializer::deserialize$lambda$6);
                        if (amountDiscount == null) break;
                        AmountDiscount it = amountDiscount;
                        boolean bl = false;
                        return new Discount(null, null, null, it, json2, 7, null);
                    }
                }
            }
            return new Discount(null, null, null, null, json2, 15, null);
        }

        private static final Unit deserialize$lambda$0(PercentageDiscount it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            it.validate();
            return Unit.INSTANCE;
        }

        private static final Unit deserialize$lambda$2(TrialDiscount it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            it.validate();
            return Unit.INSTANCE;
        }

        private static final Unit deserialize$lambda$4(UsageDiscount it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            it.validate();
            return Unit.INSTANCE;
        }

        private static final Unit deserialize$lambda$6(AmountDiscount it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            it.validate();
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/withorb/api/models/Discount$Serializer;", "Lcom/withorb/api/core/BaseSerializer;", "Lcom/withorb/api/models/Discount;", "<init>", "()V", "serialize", "", "value", "generator", "Lcom/fasterxml/jackson/core/JsonGenerator;", "provider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "orb-java-core"})
    public static final class Serializer
    extends BaseSerializer<Discount> {
        public Serializer() {
            super(Reflection.getOrCreateKotlinClass(Discount.class));
        }

        public void serialize(@NotNull Discount value, @NotNull JsonGenerator generator, @NotNull SerializerProvider provider) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            if (value.percentage != null) {
                generator.writeObject((Object)value.percentage);
            } else if (value.trial != null) {
                generator.writeObject((Object)value.trial);
            } else if (value.usage != null) {
                generator.writeObject((Object)value.usage);
            } else if (value.amount != null) {
                generator.writeObject((Object)value.amount);
            } else if (value._json != null) {
                generator.writeObject((Object)value._json);
            } else {
                throw new IllegalStateException("Invalid Discount");
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002J\u0015\u0010\u0003\u001a\u00028\u00002\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0007\u001a\u00028\u00002\u0006\u0010\b\u001a\u00020\tH&\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\rH&\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\u0011H&\u00a2\u0006\u0002\u0010\u0012J\u0017\u0010\u0013\u001a\u00028\u00002\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0017\u00c0\u0006\u0001"}, d2={"Lcom/withorb/api/models/Discount$Visitor;", "T", "", "visitPercentage", "percentage", "Lcom/withorb/api/models/PercentageDiscount;", "(Lcom/withorb/api/models/PercentageDiscount;)Ljava/lang/Object;", "visitTrial", "trial", "Lcom/withorb/api/models/TrialDiscount;", "(Lcom/withorb/api/models/TrialDiscount;)Ljava/lang/Object;", "visitUsage", "usage", "Lcom/withorb/api/models/UsageDiscount;", "(Lcom/withorb/api/models/UsageDiscount;)Ljava/lang/Object;", "visitAmount", "amount", "Lcom/withorb/api/models/AmountDiscount;", "(Lcom/withorb/api/models/AmountDiscount;)Ljava/lang/Object;", "unknown", "json", "Lcom/withorb/api/core/JsonValue;", "(Lcom/withorb/api/core/JsonValue;)Ljava/lang/Object;", "orb-java-core"})
    public static interface Visitor<T> {
        public T visitPercentage(@NotNull PercentageDiscount var1);

        public T visitTrial(@NotNull TrialDiscount var1);

        public T visitUsage(@NotNull UsageDiscount var1);

        public T visitAmount(@NotNull AmountDiscount var1);

        default public T unknown(@Nullable JsonValue json2) {
            throw new OrbInvalidDataException("Unknown Discount: " + json2, null, 2, null);
        }
    }
}

