/*
 * Decompiled with CFR 0.152.
 */
package com.withorb.api.services.blocking;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.withorb.api.core.ClientOptions;
import com.withorb.api.core.ObjectMappers;
import com.withorb.api.core.PrepareRequest;
import com.withorb.api.core.RequestOptions;
import com.withorb.api.core.handlers.ErrorHandler;
import com.withorb.api.core.http.HttpMethod;
import com.withorb.api.core.http.HttpRequest;
import com.withorb.api.core.http.HttpRequestBody;
import com.withorb.api.core.http.HttpResponse;
import com.withorb.api.core.http.HttpResponseFor;
import com.withorb.api.core.http.HttpResponseForKt;
import com.withorb.api.errors.OrbError;
import com.withorb.api.models.Item;
import com.withorb.api.models.ItemCreateParams;
import com.withorb.api.models.ItemFetchParams;
import com.withorb.api.models.ItemListPage;
import com.withorb.api.models.ItemListParams;
import com.withorb.api.models.ItemUpdateParams;
import com.withorb.api.services.blocking.ItemService;
import java.io.OutputStream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001a"}, d2={"Lcom/withorb/api/services/blocking/ItemServiceImpl;", "Lcom/withorb/api/services/blocking/ItemService;", "clientOptions", "Lcom/withorb/api/core/ClientOptions;", "<init>", "(Lcom/withorb/api/core/ClientOptions;)V", "withRawResponse", "Lcom/withorb/api/services/blocking/ItemService$WithRawResponse;", "getWithRawResponse", "()Lcom/withorb/api/services/blocking/ItemService$WithRawResponse;", "withRawResponse$delegate", "Lkotlin/Lazy;", "create", "Lcom/withorb/api/models/Item;", "params", "Lcom/withorb/api/models/ItemCreateParams;", "requestOptions", "Lcom/withorb/api/core/RequestOptions;", "update", "Lcom/withorb/api/models/ItemUpdateParams;", "list", "Lcom/withorb/api/models/ItemListPage;", "Lcom/withorb/api/models/ItemListParams;", "fetch", "Lcom/withorb/api/models/ItemFetchParams;", "WithRawResponseImpl", "orb-java-core"})
public final class ItemServiceImpl
implements ItemService {
    @NotNull
    private final ClientOptions clientOptions;
    @NotNull
    private final Lazy withRawResponse$delegate;

    public ItemServiceImpl(@NotNull ClientOptions clientOptions) {
        Intrinsics.checkNotNullParameter((Object)clientOptions, (String)"clientOptions");
        this.clientOptions = clientOptions;
        this.withRawResponse$delegate = LazyKt.lazy(() -> ItemServiceImpl.withRawResponse_delegate$lambda$0(this));
    }

    private final ItemService.WithRawResponse getWithRawResponse() {
        Lazy lazy = this.withRawResponse$delegate;
        return (ItemService.WithRawResponse)lazy.getValue();
    }

    @Override
    @NotNull
    public ItemService.WithRawResponse withRawResponse() {
        return this.getWithRawResponse();
    }

    @Override
    @NotNull
    public Item create(@NotNull ItemCreateParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        return this.withRawResponse().create(params, requestOptions).parse();
    }

    @Override
    @NotNull
    public Item update(@NotNull ItemUpdateParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        return this.withRawResponse().update(params, requestOptions).parse();
    }

    @Override
    @NotNull
    public ItemListPage list(@NotNull ItemListParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        return this.withRawResponse().list(params, requestOptions).parse();
    }

    @Override
    @NotNull
    public Item fetch(@NotNull ItemFetchParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        return this.withRawResponse().fetch(params, requestOptions).parse();
    }

    private static final WithRawResponseImpl withRawResponse_delegate$lambda$0(ItemServiceImpl this$0) {
        return new WithRawResponseImpl(this$0.clientOptions);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\r\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\f2\u0006\u0010\r\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\r\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/withorb/api/services/blocking/ItemServiceImpl$WithRawResponseImpl;", "Lcom/withorb/api/services/blocking/ItemService$WithRawResponse;", "clientOptions", "Lcom/withorb/api/core/ClientOptions;", "<init>", "(Lcom/withorb/api/core/ClientOptions;)V", "errorHandler", "Lcom/withorb/api/core/http/HttpResponse$Handler;", "Lcom/withorb/api/errors/OrbError;", "createHandler", "Lcom/withorb/api/models/Item;", "create", "Lcom/withorb/api/core/http/HttpResponseFor;", "params", "Lcom/withorb/api/models/ItemCreateParams;", "requestOptions", "Lcom/withorb/api/core/RequestOptions;", "updateHandler", "update", "Lcom/withorb/api/models/ItemUpdateParams;", "listHandler", "Lcom/withorb/api/models/ItemListPage$Response;", "list", "Lcom/withorb/api/models/ItemListPage;", "Lcom/withorb/api/models/ItemListParams;", "fetchHandler", "fetch", "Lcom/withorb/api/models/ItemFetchParams;", "orb-java-core"})
    @SourceDebugExtension(value={"SMAP\nItemServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ItemServiceImpl.kt\ncom/withorb/api/services/blocking/ItemServiceImpl$WithRawResponseImpl\n+ 2 JsonHandler.kt\ncom/withorb/api/core/handlers/JsonHandler\n+ 3 HttpRequestBodies.kt\ncom/withorb/api/core/http/HttpRequestBodies\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,163:1\n13#2,8:164\n13#2,8:172\n13#2,8:180\n13#2,8:188\n22#3:196\n34#3:197\n22#3:198\n34#3:199\n1#4:200\n*S KotlinDebug\n*F\n+ 1 ItemServiceImpl.kt\ncom/withorb/api/services/blocking/ItemServiceImpl$WithRawResponseImpl\n*L\n55#1:164,8\n82#1:172,8\n109#1:180,8\n137#1:188,8\n65#1:196\n65#1:197\n92#1:198\n92#1:199\n*E\n"})
    public static final class WithRawResponseImpl
    implements ItemService.WithRawResponse {
        @NotNull
        private final ClientOptions clientOptions;
        @NotNull
        private final HttpResponse.Handler<OrbError> errorHandler;
        @NotNull
        private final HttpResponse.Handler<Item> createHandler;
        @NotNull
        private final HttpResponse.Handler<Item> updateHandler;
        @NotNull
        private final HttpResponse.Handler<ItemListPage.Response> listHandler;
        @NotNull
        private final HttpResponse.Handler<Item> fetchHandler;

        public WithRawResponseImpl(@NotNull ClientOptions clientOptions) {
            Intrinsics.checkNotNullParameter((Object)clientOptions, (String)"clientOptions");
            this.clientOptions = clientOptions;
            this.errorHandler = ErrorHandler.errorHandler(this.clientOptions.jsonMapper());
            JsonMapper jsonMapper$iv = this.clientOptions.jsonMapper();
            boolean $i$f$jsonHandler = false;
            this.createHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<Item>(jsonMapper$iv){
                final /* synthetic */ JsonMapper $jsonMapper;
                {
                    this.$jsonMapper = $jsonMapper;
                }

                public Item handle(HttpResponse response) {
                    Object object;
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    try {
                        boolean $i$f$jacksonTypeRef = false;
                        object = this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<Item>(){});
                    }
                    catch (Exception e) {
                        throw ObjectMappers.enhanceJacksonException("Error reading response", e);
                    }
                    return object;
                }
            }, this.errorHandler);
            jsonMapper$iv = this.clientOptions.jsonMapper();
            $i$f$jsonHandler = false;
            this.updateHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<Item>(jsonMapper$iv){
                final /* synthetic */ JsonMapper $jsonMapper;
                {
                    this.$jsonMapper = $jsonMapper;
                }

                public Item handle(HttpResponse response) {
                    Object object;
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    try {
                        boolean $i$f$jacksonTypeRef = false;
                        object = this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<Item>(){});
                    }
                    catch (Exception e) {
                        throw ObjectMappers.enhanceJacksonException("Error reading response", e);
                    }
                    return object;
                }
            }, this.errorHandler);
            jsonMapper$iv = this.clientOptions.jsonMapper();
            $i$f$jsonHandler = false;
            this.listHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<ItemListPage.Response>(jsonMapper$iv){
                final /* synthetic */ JsonMapper $jsonMapper;
                {
                    this.$jsonMapper = $jsonMapper;
                }

                public ItemListPage.Response handle(HttpResponse response) {
                    Object object;
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    try {
                        boolean $i$f$jacksonTypeRef = false;
                        object = this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<ItemListPage.Response>(){});
                    }
                    catch (Exception e) {
                        throw ObjectMappers.enhanceJacksonException("Error reading response", e);
                    }
                    return object;
                }
            }, this.errorHandler);
            jsonMapper$iv = this.clientOptions.jsonMapper();
            $i$f$jsonHandler = false;
            this.fetchHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<Item>(jsonMapper$iv){
                final /* synthetic */ JsonMapper $jsonMapper;
                {
                    this.$jsonMapper = $jsonMapper;
                }

                public Item handle(HttpResponse response) {
                    Object object;
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    try {
                        boolean $i$f$jacksonTypeRef = false;
                        object = this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<Item>(){});
                    }
                    catch (Exception e) {
                        throw ObjectMappers.enhanceJacksonException("Error reading response", e);
                    }
                    return object;
                }
            }, this.errorHandler);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public HttpResponseFor<Item> create(@NotNull ItemCreateParams params, @NotNull RequestOptions requestOptions) {
            void jsonMapper$iv;
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
            String[] stringArray = new String[]{"items"};
            HttpRequest.Builder builder = HttpRequest.Companion.builder().method(HttpMethod.POST).addPathSegments(stringArray);
            stringArray = this.clientOptions.jsonMapper();
            ItemCreateParams.Body value$iv = params._body$orb_java_core();
            boolean $i$f$json = false;
            HttpRequest request = PrepareRequest.prepare(builder.body(new HttpRequestBody((JsonMapper)jsonMapper$iv, value$iv){
                private final Lazy bytes$delegate;
                {
                    this.bytes$delegate = LazyKt.lazy((Function0)((Function0)new Function0<byte[]>($jsonMapper, $value){
                        final /* synthetic */ JsonMapper $jsonMapper;
                        final /* synthetic */ T $value;
                        {
                            this.$jsonMapper = $jsonMapper;
                            this.$value = $value;
                        }

                        public final byte[] invoke() {
                            return this.$jsonMapper.writeValueAsBytes(this.$value);
                        }
                    }));
                }

                private final byte[] getBytes() {
                    Lazy lazy = this.bytes$delegate;
                    Object object = lazy.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
                    return (byte[])object;
                }

                public void writeTo(OutputStream outputStream) {
                    Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                    outputStream.write(this.getBytes());
                }

                public String contentType() {
                    return "application/json";
                }

                public long contentLength() {
                    return this.getBytes().length;
                }

                public boolean repeatable() {
                    return true;
                }

                public void close() {
                }
            }).build(), this.clientOptions, params);
            RequestOptions requestOptions2 = requestOptions.applyDefaults(RequestOptions.Companion.from$orb_java_core(this.clientOptions));
            HttpResponse response = this.clientOptions.httpClient().execute(request, requestOptions2);
            return HttpResponseForKt.parseable(response, () -> WithRawResponseImpl.create$lambda$2(response, this, requestOptions2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public HttpResponseFor<Item> update(@NotNull ItemUpdateParams params, @NotNull RequestOptions requestOptions) {
            void jsonMapper$iv;
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
            String[] stringArray = new String[]{"items", params.getPathParam(0)};
            HttpRequest.Builder builder = HttpRequest.Companion.builder().method(HttpMethod.PUT).addPathSegments(stringArray);
            stringArray = this.clientOptions.jsonMapper();
            ItemUpdateParams.Body value$iv = params._body$orb_java_core();
            boolean $i$f$json = false;
            HttpRequest request = PrepareRequest.prepare(builder.body(new /* invalid duplicate definition of identical inner class */).build(), this.clientOptions, params);
            RequestOptions requestOptions2 = requestOptions.applyDefaults(RequestOptions.Companion.from$orb_java_core(this.clientOptions));
            HttpResponse response = this.clientOptions.httpClient().execute(request, requestOptions2);
            return HttpResponseForKt.parseable(response, () -> WithRawResponseImpl.update$lambda$5(response, this, requestOptions2));
        }

        @Override
        @NotNull
        public HttpResponseFor<ItemListPage> list(@NotNull ItemListParams params, @NotNull RequestOptions requestOptions) {
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
            String[] stringArray = new String[]{"items"};
            HttpRequest request = PrepareRequest.prepare(HttpRequest.Companion.builder().method(HttpMethod.GET).addPathSegments(stringArray).build(), this.clientOptions, params);
            RequestOptions requestOptions2 = requestOptions.applyDefaults(RequestOptions.Companion.from$orb_java_core(this.clientOptions));
            HttpResponse response = this.clientOptions.httpClient().execute(request, requestOptions2);
            return HttpResponseForKt.parseable(response, () -> WithRawResponseImpl.list$lambda$9(response, this, requestOptions2, params));
        }

        @Override
        @NotNull
        public HttpResponseFor<Item> fetch(@NotNull ItemFetchParams params, @NotNull RequestOptions requestOptions) {
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
            String[] stringArray = new String[]{"items", params.getPathParam(0)};
            HttpRequest request = PrepareRequest.prepare(HttpRequest.Companion.builder().method(HttpMethod.GET).addPathSegments(stringArray).build(), this.clientOptions, params);
            RequestOptions requestOptions2 = requestOptions.applyDefaults(RequestOptions.Companion.from$orb_java_core(this.clientOptions));
            HttpResponse response = this.clientOptions.httpClient().execute(request, requestOptions2);
            return HttpResponseForKt.parseable(response, () -> WithRawResponseImpl.fetch$lambda$12(response, this, requestOptions2));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final Item create$lambda$2(HttpResponse $response, WithRawResponseImpl this$0, RequestOptions $requestOptions) {
            Object it;
            Object object = $response;
            Throwable throwable = null;
            try {
                it = (HttpResponse)object;
                boolean bl = false;
                it = this$0.createHandler.handle((HttpResponse)it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
            }
            Object it2 = object = it;
            boolean bl = false;
            Boolean bl2 = $requestOptions.getResponseValidation();
            Intrinsics.checkNotNull((Object)bl2);
            if (bl2.booleanValue()) {
                ((Item)it2).validate();
            }
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final Item update$lambda$5(HttpResponse $response, WithRawResponseImpl this$0, RequestOptions $requestOptions) {
            Object it;
            Object object = $response;
            Throwable throwable = null;
            try {
                it = (HttpResponse)object;
                boolean bl = false;
                it = this$0.updateHandler.handle((HttpResponse)it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
            }
            Object it2 = object = it;
            boolean bl = false;
            Boolean bl2 = $requestOptions.getResponseValidation();
            Intrinsics.checkNotNull((Object)bl2);
            if (bl2.booleanValue()) {
                ((Item)it2).validate();
            }
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final ItemListPage list$lambda$9(HttpResponse $response, WithRawResponseImpl this$0, RequestOptions $requestOptions, ItemListParams $params) {
            Object it;
            Object object = $response;
            Throwable throwable = null;
            try {
                it = (HttpResponse)object;
                boolean bl = false;
                it = this$0.listHandler.handle((HttpResponse)it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
            }
            Object it2 = object = it;
            boolean bl = false;
            Boolean bl2 = $requestOptions.getResponseValidation();
            Intrinsics.checkNotNull((Object)bl2);
            if (bl2.booleanValue()) {
                ((ItemListPage.Response)it2).validate();
            }
            it2 = object;
            boolean bl3 = false;
            return ItemListPage.Companion.of(new ItemServiceImpl(this$0.clientOptions), $params, (ItemListPage.Response)it2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final Item fetch$lambda$12(HttpResponse $response, WithRawResponseImpl this$0, RequestOptions $requestOptions) {
            Object it;
            Object object = $response;
            Throwable throwable = null;
            try {
                it = (HttpResponse)object;
                boolean bl = false;
                it = this$0.fetchHandler.handle((HttpResponse)it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
            }
            Object it2 = object = it;
            boolean bl = false;
            Boolean bl2 = $requestOptions.getResponseValidation();
            Intrinsics.checkNotNull((Object)bl2);
            if (bl2.booleanValue()) {
                ((Item)it2).validate();
            }
            return object;
        }
    }
}

