/*
 * Decompiled with CFR 0.152.
 */
package com.withorb.api.models;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.withorb.api.core.BaseDeserializer;
import com.withorb.api.core.BaseSerializer;
import com.withorb.api.core.JsonField;
import com.withorb.api.core.JsonValue;
import com.withorb.api.core.Utils;
import com.withorb.api.errors.OrbInvalidDataException;
import com.withorb.api.models.AmountDiscount;
import com.withorb.api.models.PercentageDiscount;
import com.withorb.api.models.TrialDiscount;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonDeserialize(using=Deserializer.class)
@JsonSerialize(using=Serializer.class)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u0000 !2\u00020\u0001:\u0004!\"#$B9\b\u0002\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00030\fJ\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\fJ\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u000eJ\u0006\u0010\u0010\u001a\u00020\u000eJ\u0006\u0010\u0011\u001a\u00020\u0003J\u0006\u0010\u0012\u001a\u00020\u0005J\u0006\u0010\u0013\u001a\u00020\u0007J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\fJ\u001f\u0010\u0014\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0017\u00a2\u0006\u0002\u0010\u0018J\u0006\u0010\u001a\u001a\u00020\u0000J\u0013\u0010\u001b\u001a\u00020\u000e2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/withorb/api/models/InvoiceLevelDiscount;", "", "percentage", "Lcom/withorb/api/models/PercentageDiscount;", "amount", "Lcom/withorb/api/models/AmountDiscount;", "trial", "Lcom/withorb/api/models/TrialDiscount;", "_json", "Lcom/withorb/api/core/JsonValue;", "<init>", "(Lcom/withorb/api/models/PercentageDiscount;Lcom/withorb/api/models/AmountDiscount;Lcom/withorb/api/models/TrialDiscount;Lcom/withorb/api/core/JsonValue;)V", "Ljava/util/Optional;", "isPercentage", "", "isAmount", "isTrial", "asPercentage", "asAmount", "asTrial", "accept", "T", "visitor", "Lcom/withorb/api/models/InvoiceLevelDiscount$Visitor;", "(Lcom/withorb/api/models/InvoiceLevelDiscount$Visitor;)Ljava/lang/Object;", "validated", "validate", "equals", "other", "hashCode", "", "toString", "", "Companion", "Visitor", "Deserializer", "Serializer", "orb-java-core"})
public final class InvoiceLevelDiscount {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final PercentageDiscount percentage;
    @Nullable
    private final AmountDiscount amount;
    @Nullable
    private final TrialDiscount trial;
    @Nullable
    private final JsonValue _json;
    private boolean validated;

    private InvoiceLevelDiscount(PercentageDiscount percentage, AmountDiscount amount, TrialDiscount trial, JsonValue _json) {
        this.percentage = percentage;
        this.amount = amount;
        this.trial = trial;
        this._json = _json;
    }

    /* synthetic */ InvoiceLevelDiscount(PercentageDiscount percentageDiscount, AmountDiscount amountDiscount, TrialDiscount trialDiscount, JsonValue jsonValue, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            percentageDiscount = null;
        }
        if ((n & 2) != 0) {
            amountDiscount = null;
        }
        if ((n & 4) != 0) {
            trialDiscount = null;
        }
        if ((n & 8) != 0) {
            jsonValue = null;
        }
        this(percentageDiscount, amountDiscount, trialDiscount, jsonValue);
    }

    @NotNull
    public final Optional<PercentageDiscount> percentage() {
        Optional<PercentageDiscount> optional = Optional.ofNullable(this.percentage);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    @NotNull
    public final Optional<AmountDiscount> amount() {
        Optional<AmountDiscount> optional = Optional.ofNullable(this.amount);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    @NotNull
    public final Optional<TrialDiscount> trial() {
        Optional<TrialDiscount> optional = Optional.ofNullable(this.trial);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    public final boolean isPercentage() {
        return this.percentage != null;
    }

    public final boolean isAmount() {
        return this.amount != null;
    }

    public final boolean isTrial() {
        return this.trial != null;
    }

    @NotNull
    public final PercentageDiscount asPercentage() {
        return (PercentageDiscount)Utils.getOrThrow(this.percentage, "percentage");
    }

    @NotNull
    public final AmountDiscount asAmount() {
        return (AmountDiscount)Utils.getOrThrow(this.amount, "amount");
    }

    @NotNull
    public final TrialDiscount asTrial() {
        return (TrialDiscount)Utils.getOrThrow(this.trial, "trial");
    }

    @NotNull
    public final Optional<JsonValue> _json() {
        Optional<JsonValue> optional = Optional.ofNullable(this._json);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    public final <T> T accept(@NotNull Visitor<? extends T> visitor) {
        Intrinsics.checkNotNullParameter(visitor, (String)"visitor");
        return this.percentage != null ? visitor.visitPercentage(this.percentage) : (this.amount != null ? visitor.visitAmount(this.amount) : (this.trial != null ? visitor.visitTrial(this.trial) : visitor.unknown(this._json)));
    }

    @NotNull
    public final InvoiceLevelDiscount validate() {
        InvoiceLevelDiscount invoiceLevelDiscount;
        InvoiceLevelDiscount $this$validate_u24lambda_u240 = invoiceLevelDiscount = this;
        boolean bl = false;
        if (!$this$validate_u24lambda_u240.validated) {
            $this$validate_u24lambda_u240.accept((Visitor)new Visitor<Unit>(){

                public void visitPercentage(PercentageDiscount percentage) {
                    Intrinsics.checkNotNullParameter((Object)percentage, (String)"percentage");
                    percentage.validate();
                }

                public void visitAmount(AmountDiscount amount) {
                    Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
                    amount.validate();
                }

                public void visitTrial(TrialDiscount trial) {
                    Intrinsics.checkNotNullParameter((Object)trial, (String)"trial");
                    trial.validate();
                }
            });
            $this$validate_u24lambda_u240.validated = true;
        }
        return invoiceLevelDiscount;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof InvoiceLevelDiscount && Intrinsics.areEqual((Object)this.percentage, (Object)((InvoiceLevelDiscount)other).percentage) && Intrinsics.areEqual((Object)this.amount, (Object)((InvoiceLevelDiscount)other).amount) && Intrinsics.areEqual((Object)this.trial, (Object)((InvoiceLevelDiscount)other).trial);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.percentage, this.amount, this.trial};
        return Objects.hash(objectArray);
    }

    @NotNull
    public String toString() {
        String string;
        if (this.percentage != null) {
            string = "InvoiceLevelDiscount{percentage=" + this.percentage + '}';
        } else if (this.amount != null) {
            string = "InvoiceLevelDiscount{amount=" + this.amount + '}';
        } else if (this.trial != null) {
            string = "InvoiceLevelDiscount{trial=" + this.trial + '}';
        } else if (this._json != null) {
            string = "InvoiceLevelDiscount{_unknown=" + this._json + '}';
        } else {
            throw new IllegalStateException("Invalid InvoiceLevelDiscount");
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final InvoiceLevelDiscount ofPercentage(@NotNull PercentageDiscount percentage) {
        return Companion.ofPercentage(percentage);
    }

    @JvmStatic
    @NotNull
    public static final InvoiceLevelDiscount ofAmount(@NotNull AmountDiscount amount) {
        return Companion.ofAmount(amount);
    }

    @JvmStatic
    @NotNull
    public static final InvoiceLevelDiscount ofTrial(@NotNull TrialDiscount trial) {
        return Companion.ofTrial(trial);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0007\u00a8\u0006\u000e"}, d2={"Lcom/withorb/api/models/InvoiceLevelDiscount$Companion;", "", "<init>", "()V", "ofPercentage", "Lcom/withorb/api/models/InvoiceLevelDiscount;", "percentage", "Lcom/withorb/api/models/PercentageDiscount;", "ofAmount", "amount", "Lcom/withorb/api/models/AmountDiscount;", "ofTrial", "trial", "Lcom/withorb/api/models/TrialDiscount;", "orb-java-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final InvoiceLevelDiscount ofPercentage(@NotNull PercentageDiscount percentage) {
            Intrinsics.checkNotNullParameter((Object)percentage, (String)"percentage");
            return new InvoiceLevelDiscount(percentage, null, null, null, 14, null);
        }

        @JvmStatic
        @NotNull
        public final InvoiceLevelDiscount ofAmount(@NotNull AmountDiscount amount) {
            Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
            return new InvoiceLevelDiscount(null, amount, null, null, 13, null);
        }

        @JvmStatic
        @NotNull
        public final InvoiceLevelDiscount ofTrial(@NotNull TrialDiscount trial) {
            Intrinsics.checkNotNullParameter((Object)trial, (String)"trial");
            return new InvoiceLevelDiscount(null, null, trial, null, 11, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0014\u0010\u0005\u001a\u00020\u0002*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, d2={"Lcom/withorb/api/models/InvoiceLevelDiscount$Deserializer;", "Lcom/withorb/api/core/BaseDeserializer;", "Lcom/withorb/api/models/InvoiceLevelDiscount;", "<init>", "()V", "deserialize", "Lcom/fasterxml/jackson/core/ObjectCodec;", "node", "Lcom/fasterxml/jackson/databind/JsonNode;", "orb-java-core"})
    @SourceDebugExtension(value={"SMAP\nInvoiceLevelDiscount.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InvoiceLevelDiscount.kt\ncom/withorb/api/models/InvoiceLevelDiscount$Deserializer\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,192:1\n51#2:193\n51#2:194\n51#2:195\n*S KotlinDebug\n*F\n+ 1 InvoiceLevelDiscount.kt\ncom/withorb/api/models/InvoiceLevelDiscount$Deserializer\n*L\n152#1:193\n158#1:194\n164#1:195\n*E\n"})
    public static final class Deserializer
    extends BaseDeserializer<InvoiceLevelDiscount> {
        public Deserializer() {
            super(Reflection.getOrCreateKotlinClass(InvoiceLevelDiscount.class));
        }

        @Override
        @NotNull
        protected InvoiceLevelDiscount deserialize(@NotNull ObjectCodec $this$deserialize, @NotNull JsonNode node) {
            JsonValue json2;
            block13: {
                String discountType;
                Intrinsics.checkNotNullParameter((Object)$this$deserialize, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                json2 = JsonValue.Companion.fromJsonNode(node);
                Object object = (Map)OptionalsKt.getOrNull(json2.asObject());
                String string = discountType = object != null && (object = (JsonValue)object.get("discount_type")) != null && (object = ((JsonField)object).asString()) != null ? (String)OptionalsKt.getOrNull(object) : null;
                if (string == null) break block13;
                int n = -1;
                switch (string.hashCode()) {
                    case -1413853096: {
                        if (string.equals("amount")) {
                            n = 1;
                        }
                        break;
                    }
                    case -921832806: {
                        if (string.equals("percentage")) {
                            n = 2;
                        }
                        break;
                    }
                    case 110628630: {
                        if (string.equals("trial")) {
                            n = 3;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 2: {
                        boolean $i$f$jacksonTypeRef = false;
                        PercentageDiscount percentageDiscount = (PercentageDiscount)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<PercentageDiscount>(){}, Deserializer::deserialize$lambda$0);
                        if (percentageDiscount == null) break;
                        PercentageDiscount it = percentageDiscount;
                        boolean bl = false;
                        return new InvoiceLevelDiscount(it, null, null, json2, 6, null);
                    }
                    case 1: {
                        boolean $i$f$jacksonTypeRef = false;
                        AmountDiscount amountDiscount = (AmountDiscount)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<AmountDiscount>(){}, Deserializer::deserialize$lambda$2);
                        if (amountDiscount == null) break;
                        AmountDiscount it = amountDiscount;
                        boolean bl = false;
                        return new InvoiceLevelDiscount(null, it, null, json2, 5, null);
                    }
                    case 3: {
                        boolean $i$f$jacksonTypeRef = false;
                        TrialDiscount trialDiscount = (TrialDiscount)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<TrialDiscount>(){}, Deserializer::deserialize$lambda$4);
                        if (trialDiscount == null) break;
                        TrialDiscount it = trialDiscount;
                        boolean bl = false;
                        return new InvoiceLevelDiscount(null, null, it, json2, 3, null);
                    }
                }
            }
            return new InvoiceLevelDiscount(null, null, null, json2, 7, null);
        }

        private static final Unit deserialize$lambda$0(PercentageDiscount it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            it.validate();
            return Unit.INSTANCE;
        }

        private static final Unit deserialize$lambda$2(AmountDiscount it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            it.validate();
            return Unit.INSTANCE;
        }

        private static final Unit deserialize$lambda$4(TrialDiscount it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            it.validate();
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/withorb/api/models/InvoiceLevelDiscount$Serializer;", "Lcom/withorb/api/core/BaseSerializer;", "Lcom/withorb/api/models/InvoiceLevelDiscount;", "<init>", "()V", "serialize", "", "value", "generator", "Lcom/fasterxml/jackson/core/JsonGenerator;", "provider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "orb-java-core"})
    public static final class Serializer
    extends BaseSerializer<InvoiceLevelDiscount> {
        public Serializer() {
            super(Reflection.getOrCreateKotlinClass(InvoiceLevelDiscount.class));
        }

        public void serialize(@NotNull InvoiceLevelDiscount value, @NotNull JsonGenerator generator, @NotNull SerializerProvider provider) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            if (value.percentage != null) {
                generator.writeObject((Object)value.percentage);
            } else if (value.amount != null) {
                generator.writeObject((Object)value.amount);
            } else if (value.trial != null) {
                generator.writeObject((Object)value.trial);
            } else if (value._json != null) {
                generator.writeObject((Object)value._json);
            } else {
                throw new IllegalStateException("Invalid InvoiceLevelDiscount");
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002J\u0015\u0010\u0003\u001a\u00028\u00002\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0007\u001a\u00028\u00002\u0006\u0010\b\u001a\u00020\tH&\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\rH&\u00a2\u0006\u0002\u0010\u000eJ\u0017\u0010\u000f\u001a\u00028\u00002\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0013\u00c0\u0006\u0001"}, d2={"Lcom/withorb/api/models/InvoiceLevelDiscount$Visitor;", "T", "", "visitPercentage", "percentage", "Lcom/withorb/api/models/PercentageDiscount;", "(Lcom/withorb/api/models/PercentageDiscount;)Ljava/lang/Object;", "visitAmount", "amount", "Lcom/withorb/api/models/AmountDiscount;", "(Lcom/withorb/api/models/AmountDiscount;)Ljava/lang/Object;", "visitTrial", "trial", "Lcom/withorb/api/models/TrialDiscount;", "(Lcom/withorb/api/models/TrialDiscount;)Ljava/lang/Object;", "unknown", "json", "Lcom/withorb/api/core/JsonValue;", "(Lcom/withorb/api/core/JsonValue;)Ljava/lang/Object;", "orb-java-core"})
    public static interface Visitor<T> {
        public T visitPercentage(@NotNull PercentageDiscount var1);

        public T visitAmount(@NotNull AmountDiscount var1);

        public T visitTrial(@NotNull TrialDiscount var1);

        default public T unknown(@Nullable JsonValue json2) {
            throw new OrbInvalidDataException("Unknown InvoiceLevelDiscount: " + json2, null, 2, null);
        }
    }
}

