/*
 * Decompiled with CFR 0.152.
 */
package com.withorb.api.models;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.withorb.api.core.BaseDeserializer;
import com.withorb.api.core.BaseSerializer;
import com.withorb.api.core.ExcludeMissing;
import com.withorb.api.core.JsonField;
import com.withorb.api.core.JsonMissing;
import com.withorb.api.core.JsonValue;
import com.withorb.api.core.NoAutoDetect;
import com.withorb.api.core.Utils;
import com.withorb.api.errors.OrbInvalidDataException;
import com.withorb.api.models.AmountDiscount;
import com.withorb.api.models.Coupon;
import com.withorb.api.models.PercentageDiscount;
import java.time.OffsetDateTime;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonDeserialize(builder=Builder.class)
@NoAutoDetect
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 &2\u00020\u0001:\u0003%&'B}\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0003\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u0003\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\u0003\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0003\u0012\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\u0010\u0011J\u0014\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00100\u000fH\u0007J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u0003H\u0007J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003H\u0007J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\u0003H\u0007J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0007J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\u0003H\u0007J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0007J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\u0003H\u0007J\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u001eJ\u0006\u0010\u0006\u001a\u00020\u0007J\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u001eJ\u0013\u0010\u001f\u001a\u00020\u00152\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0006\u0010\u0002\u001a\u00020\u0004J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\u001eJ\u0006\u0010\u0005\u001a\u00020\u0004J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010!\u001a\u00020\"J\b\u0010#\u001a\u00020\u0004H\u0016J\u0006\u0010$\u001a\u00020\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/withorb/api/models/Coupon;", "", "id", "Lcom/withorb/api/core/JsonField;", "", "redemptionCode", "discount", "Lcom/withorb/api/models/Coupon$Discount;", "timesRedeemed", "", "durationInMonths", "maxRedemptions", "archivedAt", "Ljava/time/OffsetDateTime;", "additionalProperties", "", "Lcom/withorb/api/core/JsonValue;", "(Lcom/withorb/api/core/JsonField;Lcom/withorb/api/core/JsonField;Lcom/withorb/api/core/JsonField;Lcom/withorb/api/core/JsonField;Lcom/withorb/api/core/JsonField;Lcom/withorb/api/core/JsonField;Lcom/withorb/api/core/JsonField;Ljava/util/Map;)V", "hashCode", "", "validated", "", "_additionalProperties", "_archivedAt", "_discount", "_durationInMonths", "_id", "_maxRedemptions", "_redemptionCode", "_timesRedeemed", "Ljava/util/Optional;", "equals", "other", "toBuilder", "Lcom/withorb/api/models/Coupon$Builder;", "toString", "validate", "Builder", "Companion", "Discount", "orb-java-core"})
public final class Coupon {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JsonField<String> id;
    @NotNull
    private final JsonField<String> redemptionCode;
    @NotNull
    private final JsonField<Discount> discount;
    @NotNull
    private final JsonField<Long> timesRedeemed;
    @NotNull
    private final JsonField<Long> durationInMonths;
    @NotNull
    private final JsonField<Long> maxRedemptions;
    @NotNull
    private final JsonField<OffsetDateTime> archivedAt;
    @NotNull
    private final Map<String, JsonValue> additionalProperties;
    private boolean validated;
    private int hashCode;

    private Coupon(JsonField<String> id, JsonField<String> redemptionCode, JsonField<Discount> discount, JsonField<Long> timesRedeemed, JsonField<Long> durationInMonths, JsonField<Long> maxRedemptions, JsonField<OffsetDateTime> archivedAt, Map<String, ? extends JsonValue> additionalProperties) {
        this.id = id;
        this.redemptionCode = redemptionCode;
        this.discount = discount;
        this.timesRedeemed = timesRedeemed;
        this.durationInMonths = durationInMonths;
        this.maxRedemptions = maxRedemptions;
        this.archivedAt = archivedAt;
        this.additionalProperties = additionalProperties;
    }

    @NotNull
    public final String id() {
        return (String)this.id.getRequired$orb_java_core("id");
    }

    @NotNull
    public final String redemptionCode() {
        return (String)this.redemptionCode.getRequired$orb_java_core("redemption_code");
    }

    @NotNull
    public final Discount discount() {
        return (Discount)this.discount.getRequired$orb_java_core("discount");
    }

    public final long timesRedeemed() {
        return ((Number)this.timesRedeemed.getRequired$orb_java_core("times_redeemed")).longValue();
    }

    @NotNull
    public final Optional<Long> durationInMonths() {
        Optional<Object> optional = Optional.ofNullable(this.durationInMonths.getNullable$orb_java_core("duration_in_months"));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    @NotNull
    public final Optional<Long> maxRedemptions() {
        Optional<Object> optional = Optional.ofNullable(this.maxRedemptions.getNullable$orb_java_core("max_redemptions"));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    @NotNull
    public final Optional<OffsetDateTime> archivedAt() {
        Optional<Object> optional = Optional.ofNullable(this.archivedAt.getNullable$orb_java_core("archived_at"));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    @JsonProperty(value="id")
    @ExcludeMissing
    @NotNull
    public final JsonField<String> _id() {
        return this.id;
    }

    @JsonProperty(value="redemption_code")
    @ExcludeMissing
    @NotNull
    public final JsonField<String> _redemptionCode() {
        return this.redemptionCode;
    }

    @JsonProperty(value="discount")
    @ExcludeMissing
    @NotNull
    public final JsonField<Discount> _discount() {
        return this.discount;
    }

    @JsonProperty(value="times_redeemed")
    @ExcludeMissing
    @NotNull
    public final JsonField<Long> _timesRedeemed() {
        return this.timesRedeemed;
    }

    @JsonProperty(value="duration_in_months")
    @ExcludeMissing
    @NotNull
    public final JsonField<Long> _durationInMonths() {
        return this.durationInMonths;
    }

    @JsonProperty(value="max_redemptions")
    @ExcludeMissing
    @NotNull
    public final JsonField<Long> _maxRedemptions() {
        return this.maxRedemptions;
    }

    @JsonProperty(value="archived_at")
    @ExcludeMissing
    @NotNull
    public final JsonField<OffsetDateTime> _archivedAt() {
        return this.archivedAt;
    }

    @JsonAnyGetter
    @ExcludeMissing
    @NotNull
    public final Map<String, JsonValue> _additionalProperties() {
        return this.additionalProperties;
    }

    @NotNull
    public final Coupon validate() {
        Coupon coupon;
        Coupon $this$validate_u24lambda_u240 = coupon = this;
        boolean bl = false;
        if (!$this$validate_u24lambda_u240.validated) {
            $this$validate_u24lambda_u240.id();
            $this$validate_u24lambda_u240.redemptionCode();
            $this$validate_u24lambda_u240.discount();
            $this$validate_u24lambda_u240.timesRedeemed();
            $this$validate_u24lambda_u240.durationInMonths();
            $this$validate_u24lambda_u240.maxRedemptions();
            $this$validate_u24lambda_u240.archivedAt();
            $this$validate_u24lambda_u240.validated = true;
        }
        return coupon;
    }

    @NotNull
    public final Builder toBuilder() {
        return new Builder().from$orb_java_core(this);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Coupon && Intrinsics.areEqual(this.id, ((Coupon)other).id) && Intrinsics.areEqual(this.redemptionCode, ((Coupon)other).redemptionCode) && Intrinsics.areEqual(this.discount, ((Coupon)other).discount) && Intrinsics.areEqual(this.timesRedeemed, ((Coupon)other).timesRedeemed) && Intrinsics.areEqual(this.durationInMonths, ((Coupon)other).durationInMonths) && Intrinsics.areEqual(this.maxRedemptions, ((Coupon)other).maxRedemptions) && Intrinsics.areEqual(this.archivedAt, ((Coupon)other).archivedAt) && Intrinsics.areEqual(this.additionalProperties, ((Coupon)other).additionalProperties);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            Object[] objectArray = new Object[]{this.id, this.redemptionCode, this.discount, this.timesRedeemed, this.durationInMonths, this.maxRedemptions, this.archivedAt, this.additionalProperties};
            this.hashCode = Objects.hash(objectArray);
        }
        return this.hashCode;
    }

    @NotNull
    public String toString() {
        return "Coupon{id=" + this.id + ", redemptionCode=" + this.redemptionCode + ", discount=" + this.discount + ", timesRedeemed=" + this.timesRedeemed + ", durationInMonths=" + this.durationInMonths + ", maxRedemptions=" + this.maxRedemptions + ", archivedAt=" + this.archivedAt + ", additionalProperties=" + this.additionalProperties + '}';
    }

    @JvmStatic
    @NotNull
    public static final Builder builder() {
        return Companion.builder();
    }

    public /* synthetic */ Coupon(JsonField id, JsonField redemptionCode, JsonField discount, JsonField timesRedeemed, JsonField durationInMonths, JsonField maxRedemptions, JsonField archivedAt, Map additionalProperties, DefaultConstructorMarker $constructor_marker) {
        this(id, redemptionCode, discount, timesRedeemed, durationInMonths, maxRedemptions, archivedAt, additionalProperties);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00002\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0012J\u0016\u0010\u0007\u001a\u00020\u00002\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0007J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\tJ\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\n\u001a\u00020\u00002\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bH\u0007J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\u00002\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\bH\u0007J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u0015\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0017J\u0016\u0010\u000e\u001a\u00020\u00002\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\bH\u0007J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0005J\u0016\u0010\u000f\u001a\u00020\u00002\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\bH\u0007J\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\rJ\u0018\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0006H\u0007J\u001a\u0010\u001b\u001a\u00020\u00002\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0012J\u0016\u0010\u0010\u001a\u00020\u00002\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\bH\u0007J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0005J\u0016\u0010\u0011\u001a\u00020\u00002\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\bH\u0007J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\rR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/withorb/api/models/Coupon$Builder;", "", "()V", "additionalProperties", "", "", "Lcom/withorb/api/core/JsonValue;", "archivedAt", "Lcom/withorb/api/core/JsonField;", "Ljava/time/OffsetDateTime;", "discount", "Lcom/withorb/api/models/Coupon$Discount;", "durationInMonths", "", "id", "maxRedemptions", "redemptionCode", "timesRedeemed", "", "build", "Lcom/withorb/api/models/Coupon;", "from", "coupon", "from$orb_java_core", "putAdditionalProperty", "key", "value", "putAllAdditionalProperties", "orb-java-core"})
    @SourceDebugExtension(value={"SMAP\nCoupon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Coupon.kt\ncom/withorb/api/models/Coupon$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,452:1\n1#2:453\n*E\n"})
    public static final class Builder {
        @NotNull
        private JsonField<String> id = JsonMissing.Companion.of();
        @NotNull
        private JsonField<String> redemptionCode = JsonMissing.Companion.of();
        @NotNull
        private JsonField<Discount> discount = JsonMissing.Companion.of();
        @NotNull
        private JsonField<Long> timesRedeemed = JsonMissing.Companion.of();
        @NotNull
        private JsonField<Long> durationInMonths = JsonMissing.Companion.of();
        @NotNull
        private JsonField<Long> maxRedemptions = JsonMissing.Companion.of();
        @NotNull
        private JsonField<OffsetDateTime> archivedAt = JsonMissing.Companion.of();
        @NotNull
        private Map<String, JsonValue> additionalProperties = new LinkedHashMap();

        public final /* synthetic */ Builder from$orb_java_core(Coupon coupon) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)coupon, (String)"coupon");
            Builder $this$from_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$from_u24lambda_u240.id = coupon.id;
            $this$from_u24lambda_u240.redemptionCode = coupon.redemptionCode;
            $this$from_u24lambda_u240.discount = coupon.discount;
            $this$from_u24lambda_u240.timesRedeemed = coupon.timesRedeemed;
            $this$from_u24lambda_u240.durationInMonths = coupon.durationInMonths;
            $this$from_u24lambda_u240.maxRedemptions = coupon.maxRedemptions;
            $this$from_u24lambda_u240.archivedAt = coupon.archivedAt;
            $this$from_u24lambda_u240.additionalProperties(coupon.additionalProperties);
            return builder;
        }

        @NotNull
        public final Builder id(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return this.id(JsonField.Companion.of(id));
        }

        @JsonProperty(value="id")
        @ExcludeMissing
        @NotNull
        public final Builder id(@NotNull JsonField<String> id) {
            Builder builder;
            Intrinsics.checkNotNullParameter(id, (String)"id");
            Builder $this$id_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$id_u24lambda_u241.id = id;
            return builder;
        }

        @NotNull
        public final Builder redemptionCode(@NotNull String redemptionCode) {
            Intrinsics.checkNotNullParameter((Object)redemptionCode, (String)"redemptionCode");
            return this.redemptionCode(JsonField.Companion.of(redemptionCode));
        }

        @JsonProperty(value="redemption_code")
        @ExcludeMissing
        @NotNull
        public final Builder redemptionCode(@NotNull JsonField<String> redemptionCode) {
            Builder builder;
            Intrinsics.checkNotNullParameter(redemptionCode, (String)"redemptionCode");
            Builder $this$redemptionCode_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$redemptionCode_u24lambda_u242.redemptionCode = redemptionCode;
            return builder;
        }

        @NotNull
        public final Builder discount(@NotNull Discount discount) {
            Intrinsics.checkNotNullParameter((Object)discount, (String)"discount");
            return this.discount(JsonField.Companion.of(discount));
        }

        @JsonProperty(value="discount")
        @ExcludeMissing
        @NotNull
        public final Builder discount(@NotNull JsonField<Discount> discount) {
            Builder builder;
            Intrinsics.checkNotNullParameter(discount, (String)"discount");
            Builder $this$discount_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$discount_u24lambda_u243.discount = discount;
            return builder;
        }

        @NotNull
        public final Builder timesRedeemed(long timesRedeemed) {
            return this.timesRedeemed(JsonField.Companion.of(timesRedeemed));
        }

        @JsonProperty(value="times_redeemed")
        @ExcludeMissing
        @NotNull
        public final Builder timesRedeemed(@NotNull JsonField<Long> timesRedeemed) {
            Builder builder;
            Intrinsics.checkNotNullParameter(timesRedeemed, (String)"timesRedeemed");
            Builder $this$timesRedeemed_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$timesRedeemed_u24lambda_u244.timesRedeemed = timesRedeemed;
            return builder;
        }

        @NotNull
        public final Builder durationInMonths(long durationInMonths) {
            return this.durationInMonths(JsonField.Companion.of(durationInMonths));
        }

        @JsonProperty(value="duration_in_months")
        @ExcludeMissing
        @NotNull
        public final Builder durationInMonths(@NotNull JsonField<Long> durationInMonths) {
            Builder builder;
            Intrinsics.checkNotNullParameter(durationInMonths, (String)"durationInMonths");
            Builder $this$durationInMonths_u24lambda_u245 = builder = this;
            boolean bl = false;
            $this$durationInMonths_u24lambda_u245.durationInMonths = durationInMonths;
            return builder;
        }

        @NotNull
        public final Builder maxRedemptions(long maxRedemptions) {
            return this.maxRedemptions(JsonField.Companion.of(maxRedemptions));
        }

        @JsonProperty(value="max_redemptions")
        @ExcludeMissing
        @NotNull
        public final Builder maxRedemptions(@NotNull JsonField<Long> maxRedemptions) {
            Builder builder;
            Intrinsics.checkNotNullParameter(maxRedemptions, (String)"maxRedemptions");
            Builder $this$maxRedemptions_u24lambda_u246 = builder = this;
            boolean bl = false;
            $this$maxRedemptions_u24lambda_u246.maxRedemptions = maxRedemptions;
            return builder;
        }

        @NotNull
        public final Builder archivedAt(@NotNull OffsetDateTime archivedAt) {
            Intrinsics.checkNotNullParameter((Object)archivedAt, (String)"archivedAt");
            return this.archivedAt(JsonField.Companion.of(archivedAt));
        }

        @JsonProperty(value="archived_at")
        @ExcludeMissing
        @NotNull
        public final Builder archivedAt(@NotNull JsonField<OffsetDateTime> archivedAt) {
            Builder builder;
            Intrinsics.checkNotNullParameter(archivedAt, (String)"archivedAt");
            Builder $this$archivedAt_u24lambda_u247 = builder = this;
            boolean bl = false;
            $this$archivedAt_u24lambda_u247.archivedAt = archivedAt;
            return builder;
        }

        @NotNull
        public final Builder additionalProperties(@NotNull Map<String, ? extends JsonValue> additionalProperties) {
            Builder builder;
            Intrinsics.checkNotNullParameter(additionalProperties, (String)"additionalProperties");
            Builder $this$additionalProperties_u24lambda_u248 = builder = this;
            boolean bl = false;
            $this$additionalProperties_u24lambda_u248.additionalProperties.clear();
            $this$additionalProperties_u24lambda_u248.additionalProperties.putAll(additionalProperties);
            return builder;
        }

        @JsonAnySetter
        @NotNull
        public final Builder putAdditionalProperty(@NotNull String key, @NotNull JsonValue value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$putAdditionalProperty_u24lambda_u249 = builder = this;
            boolean bl = false;
            $this$putAdditionalProperty_u24lambda_u249.additionalProperties.put(key, value);
            return builder;
        }

        @NotNull
        public final Builder putAllAdditionalProperties(@NotNull Map<String, ? extends JsonValue> additionalProperties) {
            Builder builder;
            Intrinsics.checkNotNullParameter(additionalProperties, (String)"additionalProperties");
            Builder $this$putAllAdditionalProperties_u24lambda_u2410 = builder = this;
            boolean bl = false;
            $this$putAllAdditionalProperties_u24lambda_u2410.additionalProperties.putAll(additionalProperties);
            return builder;
        }

        @NotNull
        public final Coupon build() {
            return new Coupon(this.id, this.redemptionCode, this.discount, this.timesRedeemed, this.durationInMonths, this.maxRedemptions, this.archivedAt, Utils.toImmutable(this.additionalProperties), null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/withorb/api/models/Coupon$Companion;", "", "()V", "builder", "Lcom/withorb/api/models/Coupon$Builder;", "orb-java-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Builder builder() {
            return new Builder();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @JsonDeserialize(using=Deserializer.class)
    @JsonSerialize(using=Serializer.class)
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0004\u001c\u001d\u001e\u001fB+\b\u0002\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bJ\u001f\u0010\f\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000f\u00a2\u0006\u0002\u0010\u0010J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bJ\u0006\u0010\u0011\u001a\u00020\u0005J\u0006\u0010\u0012\u001a\u00020\u0003J\u0013\u0010\u0013\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0006\u0010\u0017\u001a\u00020\nJ\u0006\u0010\u0018\u001a\u00020\nJ\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bJ\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0006\u0010\u001b\u001a\u00020\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/withorb/api/models/Coupon$Discount;", "", "percentageDiscount", "Lcom/withorb/api/models/PercentageDiscount;", "amountDiscount", "Lcom/withorb/api/models/AmountDiscount;", "_json", "Lcom/withorb/api/core/JsonValue;", "(Lcom/withorb/api/models/PercentageDiscount;Lcom/withorb/api/models/AmountDiscount;Lcom/withorb/api/core/JsonValue;)V", "validated", "", "Ljava/util/Optional;", "accept", "T", "visitor", "Lcom/withorb/api/models/Coupon$Discount$Visitor;", "(Lcom/withorb/api/models/Coupon$Discount$Visitor;)Ljava/lang/Object;", "asAmountDiscount", "asPercentageDiscount", "equals", "other", "hashCode", "", "isAmountDiscount", "isPercentageDiscount", "toString", "", "validate", "Companion", "Deserializer", "Serializer", "Visitor", "orb-java-core"})
    public static final class Discount {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final PercentageDiscount percentageDiscount;
        @Nullable
        private final AmountDiscount amountDiscount;
        @Nullable
        private final JsonValue _json;
        private boolean validated;

        private Discount(PercentageDiscount percentageDiscount, AmountDiscount amountDiscount, JsonValue _json) {
            this.percentageDiscount = percentageDiscount;
            this.amountDiscount = amountDiscount;
            this._json = _json;
        }

        /* synthetic */ Discount(PercentageDiscount percentageDiscount, AmountDiscount amountDiscount, JsonValue jsonValue, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                percentageDiscount = null;
            }
            if ((n & 2) != 0) {
                amountDiscount = null;
            }
            if ((n & 4) != 0) {
                jsonValue = null;
            }
            this(percentageDiscount, amountDiscount, jsonValue);
        }

        @NotNull
        public final Optional<PercentageDiscount> percentageDiscount() {
            Optional<PercentageDiscount> optional = Optional.ofNullable(this.percentageDiscount);
            Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
            return optional;
        }

        @NotNull
        public final Optional<AmountDiscount> amountDiscount() {
            Optional<AmountDiscount> optional = Optional.ofNullable(this.amountDiscount);
            Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
            return optional;
        }

        public final boolean isPercentageDiscount() {
            return this.percentageDiscount != null;
        }

        public final boolean isAmountDiscount() {
            return this.amountDiscount != null;
        }

        @NotNull
        public final PercentageDiscount asPercentageDiscount() {
            return (PercentageDiscount)Utils.getOrThrow(this.percentageDiscount, "percentageDiscount");
        }

        @NotNull
        public final AmountDiscount asAmountDiscount() {
            return (AmountDiscount)Utils.getOrThrow(this.amountDiscount, "amountDiscount");
        }

        @NotNull
        public final Optional<JsonValue> _json() {
            Optional<JsonValue> optional = Optional.ofNullable(this._json);
            Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
            return optional;
        }

        public final <T> T accept(@NotNull Visitor<? extends T> visitor) {
            Intrinsics.checkNotNullParameter(visitor, (String)"visitor");
            return this.percentageDiscount != null ? visitor.visitPercentageDiscount(this.percentageDiscount) : (this.amountDiscount != null ? visitor.visitAmountDiscount(this.amountDiscount) : visitor.unknown(this._json));
        }

        @NotNull
        public final Discount validate() {
            Discount discount;
            Discount $this$validate_u24lambda_u240 = discount = this;
            boolean bl = false;
            if (!$this$validate_u24lambda_u240.validated) {
                if ($this$validate_u24lambda_u240.percentageDiscount == null && $this$validate_u24lambda_u240.amountDiscount == null) {
                    throw new OrbInvalidDataException("Unknown Discount: " + $this$validate_u24lambda_u240._json, null, 2, null);
                }
                PercentageDiscount percentageDiscount = $this$validate_u24lambda_u240.percentageDiscount;
                if (percentageDiscount != null) {
                    percentageDiscount.validate();
                }
                AmountDiscount amountDiscount = $this$validate_u24lambda_u240.amountDiscount;
                if (amountDiscount != null) {
                    amountDiscount.validate();
                }
                $this$validate_u24lambda_u240.validated = true;
            }
            return discount;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Discount && Intrinsics.areEqual((Object)this.percentageDiscount, (Object)((Discount)other).percentageDiscount) && Intrinsics.areEqual((Object)this.amountDiscount, (Object)((Discount)other).amountDiscount);
        }

        public int hashCode() {
            Object[] objectArray = new Object[]{this.percentageDiscount, this.amountDiscount};
            return Objects.hash(objectArray);
        }

        @NotNull
        public String toString() {
            String string;
            if (this.percentageDiscount != null) {
                string = "Discount{percentageDiscount=" + this.percentageDiscount + '}';
            } else if (this.amountDiscount != null) {
                string = "Discount{amountDiscount=" + this.amountDiscount + '}';
            } else if (this._json != null) {
                string = "Discount{_unknown=" + this._json + '}';
            } else {
                throw new IllegalStateException("Invalid Discount");
            }
            return string;
        }

        @JvmStatic
        @NotNull
        public static final Discount ofPercentageDiscount(@NotNull PercentageDiscount percentageDiscount) {
            return Companion.ofPercentageDiscount(percentageDiscount);
        }

        @JvmStatic
        @NotNull
        public static final Discount ofAmountDiscount(@NotNull AmountDiscount amountDiscount) {
            return Companion.ofAmountDiscount(amountDiscount);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lcom/withorb/api/models/Coupon$Discount$Companion;", "", "()V", "ofAmountDiscount", "Lcom/withorb/api/models/Coupon$Discount;", "amountDiscount", "Lcom/withorb/api/models/AmountDiscount;", "ofPercentageDiscount", "percentageDiscount", "Lcom/withorb/api/models/PercentageDiscount;", "orb-java-core"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final Discount ofPercentageDiscount(@NotNull PercentageDiscount percentageDiscount) {
                Intrinsics.checkNotNullParameter((Object)percentageDiscount, (String)"percentageDiscount");
                return new Discount(percentageDiscount, null, null, 6, null);
            }

            @JvmStatic
            @NotNull
            public final Discount ofAmountDiscount(@NotNull AmountDiscount amountDiscount) {
                Intrinsics.checkNotNullParameter((Object)amountDiscount, (String)"amountDiscount");
                return new Discount(null, amountDiscount, null, 5, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u0002*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lcom/withorb/api/models/Coupon$Discount$Deserializer;", "Lcom/withorb/api/core/BaseDeserializer;", "Lcom/withorb/api/models/Coupon$Discount;", "()V", "deserialize", "Lcom/fasterxml/jackson/core/ObjectCodec;", "node", "Lcom/fasterxml/jackson/databind/JsonNode;", "orb-java-core"})
        @SourceDebugExtension(value={"SMAP\nCoupon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Coupon.kt\ncom/withorb/api/models/Coupon$Discount$Deserializer\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,452:1\n43#2:453\n43#2:454\n*S KotlinDebug\n*F\n+ 1 Coupon.kt\ncom/withorb/api/models/Coupon$Discount$Deserializer\n*L\n397#1:453\n403#1:454\n*E\n"})
        public static final class Deserializer
        extends BaseDeserializer<Discount> {
            public Deserializer() {
                super(Reflection.getOrCreateKotlinClass(Discount.class));
            }

            @Override
            @NotNull
            protected Discount deserialize(@NotNull ObjectCodec $this$deserialize, @NotNull JsonNode node) {
                String discountType;
                Intrinsics.checkNotNullParameter((Object)$this$deserialize, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                JsonValue json2 = JsonValue.Companion.fromJsonNode(node);
                Object object = (Map)OptionalsKt.getOrNull(json2.asObject());
                String string = discountType = object != null && (object = (JsonValue)object.get("discount_type")) != null && (object = ((JsonField)object).asString()) != null ? (String)OptionalsKt.getOrNull(object) : null;
                if (Intrinsics.areEqual(string, (Object)"percentage")) {
                    boolean $i$f$jacksonTypeRef = false;
                    PercentageDiscount percentageDiscount = (PercentageDiscount)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<PercentageDiscount>(){}, (Function1)deserialize.1.INSTANCE);
                    if (percentageDiscount != null) {
                        PercentageDiscount it = percentageDiscount;
                        boolean bl = false;
                        return new Discount(it, null, json2, 2, null);
                    }
                } else if (Intrinsics.areEqual((Object)string, (Object)"amount")) {
                    boolean $i$f$jacksonTypeRef = false;
                    AmountDiscount amountDiscount = (AmountDiscount)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<AmountDiscount>(){}, (Function1)deserialize.3.INSTANCE);
                    if (amountDiscount != null) {
                        AmountDiscount it = amountDiscount;
                        boolean bl = false;
                        return new Discount(null, it, json2, 1, null);
                    }
                }
                return new Discount(null, null, json2, 3, null);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/withorb/api/models/Coupon$Discount$Serializer;", "Lcom/withorb/api/core/BaseSerializer;", "Lcom/withorb/api/models/Coupon$Discount;", "()V", "serialize", "", "value", "generator", "Lcom/fasterxml/jackson/core/JsonGenerator;", "provider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "orb-java-core"})
        public static final class Serializer
        extends BaseSerializer<Discount> {
            public Serializer() {
                super(Reflection.getOrCreateKotlinClass(Discount.class));
            }

            public void serialize(@NotNull Discount value, @NotNull JsonGenerator generator, @NotNull SerializerProvider provider) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
                Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
                if (value.percentageDiscount != null) {
                    generator.writeObject((Object)value.percentageDiscount);
                } else if (value.amountDiscount != null) {
                    generator.writeObject((Object)value.amountDiscount);
                } else if (value._json != null) {
                    generator.writeObject((Object)value._json);
                } else {
                    throw new IllegalStateException("Invalid Discount");
                }
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002J\u0017\u0010\u0003\u001a\u00028\u00002\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0007\u001a\u00028\u00002\u0006\u0010\b\u001a\u00020\tH&\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\rH&\u00a2\u0006\u0002\u0010\u000e\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lcom/withorb/api/models/Coupon$Discount$Visitor;", "T", "", "unknown", "json", "Lcom/withorb/api/core/JsonValue;", "(Lcom/withorb/api/core/JsonValue;)Ljava/lang/Object;", "visitAmountDiscount", "amountDiscount", "Lcom/withorb/api/models/AmountDiscount;", "(Lcom/withorb/api/models/AmountDiscount;)Ljava/lang/Object;", "visitPercentageDiscount", "percentageDiscount", "Lcom/withorb/api/models/PercentageDiscount;", "(Lcom/withorb/api/models/PercentageDiscount;)Ljava/lang/Object;", "orb-java-core"})
        public static interface Visitor<T> {
            public T visitPercentageDiscount(@NotNull PercentageDiscount var1);

            public T visitAmountDiscount(@NotNull AmountDiscount var1);

            default public T unknown(@Nullable JsonValue json2) {
                throw new OrbInvalidDataException("Unknown Discount: " + json2, null, 2, null);
            }
        }
    }
}

