/*
 * Decompiled with CFR 0.152.
 */
package com.withorb.api.services.blocking.customers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.withorb.api.core.ClientOptions;
import com.withorb.api.core.RequestOptions;
import com.withorb.api.core.handlers.ErrorHandler;
import com.withorb.api.core.http.HttpMethod;
import com.withorb.api.core.http.HttpRequest;
import com.withorb.api.core.http.HttpResponse;
import com.withorb.api.errors.OrbError;
import com.withorb.api.errors.OrbException;
import com.withorb.api.models.CustomerCreditListByExternalIdPage;
import com.withorb.api.models.CustomerCreditListByExternalIdParams;
import com.withorb.api.models.CustomerCreditListPage;
import com.withorb.api.models.CustomerCreditListParams;
import com.withorb.api.services.blocking.customers.CreditService;
import com.withorb.api.services.blocking.customers.credits.LedgerService;
import com.withorb.api.services.blocking.customers.credits.LedgerServiceImpl;
import com.withorb.api.services.blocking.customers.credits.TopUpService;
import com.withorb.api.services.blocking.customers.credits.TopUpServiceImpl;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0012\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\r\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006 "}, d2={"Lcom/withorb/api/services/blocking/customers/CreditServiceImpl;", "Lcom/withorb/api/services/blocking/customers/CreditService;", "clientOptions", "Lcom/withorb/api/core/ClientOptions;", "(Lcom/withorb/api/core/ClientOptions;)V", "errorHandler", "Lcom/withorb/api/core/http/HttpResponse$Handler;", "Lcom/withorb/api/errors/OrbError;", "ledger", "Lcom/withorb/api/services/blocking/customers/credits/LedgerService;", "getLedger", "()Lcom/withorb/api/services/blocking/customers/credits/LedgerService;", "ledger$delegate", "Lkotlin/Lazy;", "listByExternalIdHandler", "Lcom/withorb/api/models/CustomerCreditListByExternalIdPage$Response;", "listHandler", "Lcom/withorb/api/models/CustomerCreditListPage$Response;", "topUps", "Lcom/withorb/api/services/blocking/customers/credits/TopUpService;", "getTopUps", "()Lcom/withorb/api/services/blocking/customers/credits/TopUpService;", "topUps$delegate", "list", "Lcom/withorb/api/models/CustomerCreditListPage;", "params", "Lcom/withorb/api/models/CustomerCreditListParams;", "requestOptions", "Lcom/withorb/api/core/RequestOptions;", "listByExternalId", "Lcom/withorb/api/models/CustomerCreditListByExternalIdPage;", "Lcom/withorb/api/models/CustomerCreditListByExternalIdParams;", "orb-java-core"})
@SourceDebugExtension(value={"SMAP\nCreditServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreditServiceImpl.kt\ncom/withorb/api/services/blocking/customers/CreditServiceImpl\n+ 2 JsonHandler.kt\ncom/withorb/api/core/handlers/JsonHandler\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,113:1\n13#2,9:114\n13#2,9:123\n1#3:132\n*S KotlinDebug\n*F\n+ 1 CreditServiceImpl.kt\ncom/withorb/api/services/blocking/customers/CreditServiceImpl\n*L\n39#1:114,9\n74#1:123,9\n*E\n"})
public final class CreditServiceImpl
implements CreditService {
    @NotNull
    private final ClientOptions clientOptions;
    @NotNull
    private final HttpResponse.Handler<OrbError> errorHandler;
    @NotNull
    private final Lazy ledger$delegate;
    @NotNull
    private final Lazy topUps$delegate;
    @NotNull
    private final HttpResponse.Handler<CustomerCreditListPage.Response> listHandler;
    @NotNull
    private final HttpResponse.Handler<CustomerCreditListByExternalIdPage.Response> listByExternalIdHandler;

    public CreditServiceImpl(@NotNull ClientOptions clientOptions) {
        Intrinsics.checkNotNullParameter((Object)clientOptions, (String)"clientOptions");
        this.clientOptions = clientOptions;
        this.errorHandler = ErrorHandler.errorHandler(this.clientOptions.jsonMapper());
        this.ledger$delegate = LazyKt.lazy((Function0)((Function0)new Function0<LedgerServiceImpl>(this){
            final /* synthetic */ CreditServiceImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final LedgerServiceImpl invoke() {
                return new LedgerServiceImpl(CreditServiceImpl.access$getClientOptions$p(this.this$0));
            }
        }));
        this.topUps$delegate = LazyKt.lazy((Function0)((Function0)new Function0<TopUpServiceImpl>(this){
            final /* synthetic */ CreditServiceImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final TopUpServiceImpl invoke() {
                return new TopUpServiceImpl(CreditServiceImpl.access$getClientOptions$p(this.this$0));
            }
        }));
        JsonMapper jsonMapper$iv = this.clientOptions.jsonMapper();
        boolean $i$f$jsonHandler = false;
        this.listHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<CustomerCreditListPage.Response>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public CustomerCreditListPage.Response handle(@NotNull HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<CustomerCreditListPage.Response>(){});
                }
                catch (Exception e) {
                    throw new OrbException("Error reading response", e);
                }
            }
        }, this.errorHandler);
        jsonMapper$iv = this.clientOptions.jsonMapper();
        $i$f$jsonHandler = false;
        this.listByExternalIdHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<CustomerCreditListByExternalIdPage.Response>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public CustomerCreditListByExternalIdPage.Response handle(@NotNull HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<CustomerCreditListByExternalIdPage.Response>(){});
                }
                catch (Exception e) {
                    throw new OrbException("Error reading response", e);
                }
            }
        }, this.errorHandler);
    }

    private final LedgerService getLedger() {
        Lazy lazy = this.ledger$delegate;
        return (LedgerService)lazy.getValue();
    }

    private final TopUpService getTopUps() {
        Lazy lazy = this.topUps$delegate;
        return (TopUpService)lazy.getValue();
    }

    @Override
    @NotNull
    public LedgerService ledger() {
        return this.getLedger();
    }

    @Override
    @NotNull
    public TopUpService topUps() {
        return this.getTopUps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CustomerCreditListPage list(@NotNull CustomerCreditListParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String[] stringArray = new String[]{"customers", params.getPathParam(0), "credits"};
        HttpRequest request2 = HttpRequest.Companion.builder().method(HttpMethod.GET).addPathSegments(stringArray).putAllQueryParams(this.clientOptions.queryParams()).replaceAllQueryParams(params.getQueryParams$orb_java_core()).putAllHeaders(this.clientOptions.headers()).replaceAllHeaders(params.getHeaders$orb_java_core()).build();
        HttpResponse response = this.clientOptions.httpClient().execute(request2, requestOptions);
        boolean bl = false;
        Object object = response;
        Throwable throwable = null;
        try {
            Object it = (HttpResponse)object;
            boolean bl2 = false;
            it = this.listHandler.handle((HttpResponse)it);
        }
        catch (Throwable it) {
            throwable = it;
            throw it;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
        }
        Object $this$list_u24lambda_u243_u24lambda_u241 = object = it;
        boolean bl3 = false;
        Boolean bl4 = requestOptions.getResponseValidation();
        if (bl4 != null ? bl4.booleanValue() : this.clientOptions.responseValidation()) {
            ((CustomerCreditListPage.Response)$this$list_u24lambda_u243_u24lambda_u241).validate();
        }
        Object it = object;
        boolean bl5 = false;
        return CustomerCreditListPage.Companion.of(this, params, (CustomerCreditListPage.Response)it);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CustomerCreditListByExternalIdPage listByExternalId(@NotNull CustomerCreditListByExternalIdParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String[] stringArray = new String[]{"customers", "external_customer_id", params.getPathParam(0), "credits"};
        HttpRequest request2 = HttpRequest.Companion.builder().method(HttpMethod.GET).addPathSegments(stringArray).putAllQueryParams(this.clientOptions.queryParams()).replaceAllQueryParams(params.getQueryParams$orb_java_core()).putAllHeaders(this.clientOptions.headers()).replaceAllHeaders(params.getHeaders$orb_java_core()).build();
        HttpResponse response = this.clientOptions.httpClient().execute(request2, requestOptions);
        boolean bl = false;
        Object object = response;
        Throwable throwable = null;
        try {
            Object it = (HttpResponse)object;
            boolean bl2 = false;
            it = this.listByExternalIdHandler.handle((HttpResponse)it);
        }
        catch (Throwable it) {
            throwable = it;
            throw it;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
        }
        Object $this$listByExternalId_u24lambda_u247_u24lambda_u245 = object = it;
        boolean bl3 = false;
        Boolean bl4 = requestOptions.getResponseValidation();
        if (bl4 != null ? bl4.booleanValue() : this.clientOptions.responseValidation()) {
            ((CustomerCreditListByExternalIdPage.Response)$this$listByExternalId_u24lambda_u247_u24lambda_u245).validate();
        }
        Object it = object;
        boolean bl5 = false;
        return CustomerCreditListByExternalIdPage.Companion.of(this, params, (CustomerCreditListByExternalIdPage.Response)it);
    }

    public static final /* synthetic */ ClientOptions access$getClientOptions$p(CreditServiceImpl $this) {
        return $this.clientOptions;
    }
}

