/*
 * Decompiled with CFR 0.152.
 */
package com.withorb.api.models;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.withorb.api.core.BaseDeserializer;
import com.withorb.api.core.BaseSerializer;
import com.withorb.api.core.Check;
import com.withorb.api.core.ExcludeMissing;
import com.withorb.api.core.JsonField;
import com.withorb.api.core.JsonMissing;
import com.withorb.api.core.JsonValue;
import com.withorb.api.core.Utils;
import com.withorb.api.errors.OrbInvalidDataException;
import com.withorb.api.models.AmountDiscount;
import com.withorb.api.models.PercentageDiscount;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 32\u00020\u0001:\u0003234Bw\b\u0013\u0012\u000e\b\u0003\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0003\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u000e\b\u0003\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u0012\u000e\b\u0003\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u0012\u000e\b\u0003\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u0012\u000e\b\u0003\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0003\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u00a2\u0006\u0002\u0010\u000eB}\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u0012\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\u0002\u0010\u0012J\u0014\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00110\u001cH\u0007J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u0007J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\b0\u0003H\u0007J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\n0\u0003H\u0007J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0007J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\n0\u0003H\u0007J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0007J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\n0\u0003H\u0007J\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060$J\u0006\u0010\u0007\u001a\u00020\bJ\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0$J\u0013\u0010%\u001a\u00020\u001a2\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0006\u0010\u0002\u001a\u00020\u0004J\u0006\u0010'\u001a\u00020\u001aJ\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0$J\u0018\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00042\u0006\u0010+\u001a\u00020\u0011H\u0003J\u0006\u0010\f\u001a\u00020\u0004J\u0006\u0010\r\u001a\u00020\nJ\u0006\u0010,\u001a\u00020-J\b\u0010.\u001a\u00020\u0004H\u0016J\u0006\u0010/\u001a\u00020\u0000J\r\u00100\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b1R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0013\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/withorb/api/models/Coupon;", "", "id", "Lcom/withorb/api/core/JsonField;", "", "archivedAt", "Ljava/time/OffsetDateTime;", "discount", "Lcom/withorb/api/models/Coupon$Discount;", "durationInMonths", "", "maxRedemptions", "redemptionCode", "timesRedeemed", "(Lcom/withorb/api/core/JsonField;Lcom/withorb/api/core/JsonField;Lcom/withorb/api/core/JsonField;Lcom/withorb/api/core/JsonField;Lcom/withorb/api/core/JsonField;Lcom/withorb/api/core/JsonField;Lcom/withorb/api/core/JsonField;)V", "additionalProperties", "", "Lcom/withorb/api/core/JsonValue;", "(Lcom/withorb/api/core/JsonField;Lcom/withorb/api/core/JsonField;Lcom/withorb/api/core/JsonField;Lcom/withorb/api/core/JsonField;Lcom/withorb/api/core/JsonField;Lcom/withorb/api/core/JsonField;Lcom/withorb/api/core/JsonField;Ljava/util/Map;)V", "hashCode", "", "getHashCode", "()I", "hashCode$delegate", "Lkotlin/Lazy;", "validated", "", "_additionalProperties", "", "_archivedAt", "_discount", "_durationInMonths", "_id", "_maxRedemptions", "_redemptionCode", "_timesRedeemed", "Ljava/util/Optional;", "equals", "other", "isValid", "putAdditionalProperty", "", "key", "value", "toBuilder", "Lcom/withorb/api/models/Coupon$Builder;", "toString", "validate", "validity", "validity$orb_java_core", "Builder", "Companion", "Discount", "orb-java-core"})
public final class Coupon {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JsonField<String> id;
    @NotNull
    private final JsonField<OffsetDateTime> archivedAt;
    @NotNull
    private final JsonField<Discount> discount;
    @NotNull
    private final JsonField<Long> durationInMonths;
    @NotNull
    private final JsonField<Long> maxRedemptions;
    @NotNull
    private final JsonField<String> redemptionCode;
    @NotNull
    private final JsonField<Long> timesRedeemed;
    @NotNull
    private final Map<String, JsonValue> additionalProperties;
    private boolean validated;
    @NotNull
    private final Lazy hashCode$delegate;

    private Coupon(JsonField<String> id, JsonField<OffsetDateTime> archivedAt, JsonField<Discount> discount, JsonField<Long> durationInMonths, JsonField<Long> maxRedemptions, JsonField<String> redemptionCode, JsonField<Long> timesRedeemed, Map<String, JsonValue> additionalProperties) {
        this.id = id;
        this.archivedAt = archivedAt;
        this.discount = discount;
        this.durationInMonths = durationInMonths;
        this.maxRedemptions = maxRedemptions;
        this.redemptionCode = redemptionCode;
        this.timesRedeemed = timesRedeemed;
        this.additionalProperties = additionalProperties;
        this.hashCode$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Integer>(this){
            final /* synthetic */ Coupon this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                Object[] objectArray = new Object[]{Coupon.access$getId$p(this.this$0), Coupon.access$getArchivedAt$p(this.this$0), Coupon.access$getDiscount$p(this.this$0), Coupon.access$getDurationInMonths$p(this.this$0), Coupon.access$getMaxRedemptions$p(this.this$0), Coupon.access$getRedemptionCode$p(this.this$0), Coupon.access$getTimesRedeemed$p(this.this$0), Coupon.access$getAdditionalProperties$p(this.this$0)};
                return Objects.hash(objectArray);
            }
        }));
    }

    @JsonCreator
    private Coupon(@JsonProperty(value="id") @ExcludeMissing JsonField<String> id, @JsonProperty(value="archived_at") @ExcludeMissing JsonField<OffsetDateTime> archivedAt, @JsonProperty(value="discount") @ExcludeMissing JsonField<Discount> discount, @JsonProperty(value="duration_in_months") @ExcludeMissing JsonField<Long> durationInMonths, @JsonProperty(value="max_redemptions") @ExcludeMissing JsonField<Long> maxRedemptions, @JsonProperty(value="redemption_code") @ExcludeMissing JsonField<String> redemptionCode, @JsonProperty(value="times_redeemed") @ExcludeMissing JsonField<Long> timesRedeemed) {
        this(id, archivedAt, discount, durationInMonths, maxRedemptions, redemptionCode, timesRedeemed, new LinkedHashMap());
    }

    /* synthetic */ Coupon(JsonField jsonField, JsonField jsonField2, JsonField jsonField3, JsonField jsonField4, JsonField jsonField5, JsonField jsonField6, JsonField jsonField7, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            jsonField = JsonMissing.Companion.of();
        }
        if ((n & 2) != 0) {
            jsonField2 = JsonMissing.Companion.of();
        }
        if ((n & 4) != 0) {
            jsonField3 = JsonMissing.Companion.of();
        }
        if ((n & 8) != 0) {
            jsonField4 = JsonMissing.Companion.of();
        }
        if ((n & 0x10) != 0) {
            jsonField5 = JsonMissing.Companion.of();
        }
        if ((n & 0x20) != 0) {
            jsonField6 = JsonMissing.Companion.of();
        }
        if ((n & 0x40) != 0) {
            jsonField7 = JsonMissing.Companion.of();
        }
        this(jsonField, jsonField2, jsonField3, jsonField4, jsonField5, jsonField6, jsonField7);
    }

    @NotNull
    public final String id() {
        return (String)this.id.getRequired$orb_java_core("id");
    }

    @NotNull
    public final Optional<OffsetDateTime> archivedAt() {
        return this.archivedAt.getOptional$orb_java_core("archived_at");
    }

    @NotNull
    public final Discount discount() {
        return (Discount)this.discount.getRequired$orb_java_core("discount");
    }

    @NotNull
    public final Optional<Long> durationInMonths() {
        return this.durationInMonths.getOptional$orb_java_core("duration_in_months");
    }

    @NotNull
    public final Optional<Long> maxRedemptions() {
        return this.maxRedemptions.getOptional$orb_java_core("max_redemptions");
    }

    @NotNull
    public final String redemptionCode() {
        return (String)this.redemptionCode.getRequired$orb_java_core("redemption_code");
    }

    public final long timesRedeemed() {
        return ((Number)this.timesRedeemed.getRequired$orb_java_core("times_redeemed")).longValue();
    }

    @JsonProperty(value="id")
    @ExcludeMissing
    @NotNull
    public final JsonField<String> _id() {
        return this.id;
    }

    @JsonProperty(value="archived_at")
    @ExcludeMissing
    @NotNull
    public final JsonField<OffsetDateTime> _archivedAt() {
        return this.archivedAt;
    }

    @JsonProperty(value="discount")
    @ExcludeMissing
    @NotNull
    public final JsonField<Discount> _discount() {
        return this.discount;
    }

    @JsonProperty(value="duration_in_months")
    @ExcludeMissing
    @NotNull
    public final JsonField<Long> _durationInMonths() {
        return this.durationInMonths;
    }

    @JsonProperty(value="max_redemptions")
    @ExcludeMissing
    @NotNull
    public final JsonField<Long> _maxRedemptions() {
        return this.maxRedemptions;
    }

    @JsonProperty(value="redemption_code")
    @ExcludeMissing
    @NotNull
    public final JsonField<String> _redemptionCode() {
        return this.redemptionCode;
    }

    @JsonProperty(value="times_redeemed")
    @ExcludeMissing
    @NotNull
    public final JsonField<Long> _timesRedeemed() {
        return this.timesRedeemed;
    }

    @JsonAnySetter
    private final void putAdditionalProperty(String key, JsonValue value) {
        this.additionalProperties.put(key, value);
    }

    @JsonAnyGetter
    @ExcludeMissing
    @NotNull
    public final Map<String, JsonValue> _additionalProperties() {
        Map<String, JsonValue> map2 = Collections.unmodifiableMap(this.additionalProperties);
        Intrinsics.checkNotNullExpressionValue(map2, (String)"unmodifiableMap(...)");
        return map2;
    }

    @NotNull
    public final Builder toBuilder() {
        return new Builder().from$orb_java_core(this);
    }

    @NotNull
    public final Coupon validate() {
        Coupon coupon;
        Coupon $this$validate_u24lambda_u240 = coupon = this;
        boolean bl = false;
        if (!$this$validate_u24lambda_u240.validated) {
            $this$validate_u24lambda_u240.id();
            $this$validate_u24lambda_u240.archivedAt();
            $this$validate_u24lambda_u240.discount().validate();
            $this$validate_u24lambda_u240.durationInMonths();
            $this$validate_u24lambda_u240.maxRedemptions();
            $this$validate_u24lambda_u240.redemptionCode();
            $this$validate_u24lambda_u240.timesRedeemed();
            $this$validate_u24lambda_u240.validated = true;
        }
        return coupon;
    }

    public final boolean isValid() {
        boolean bl;
        try {
            this.validate();
            bl = true;
        }
        catch (OrbInvalidDataException e) {
            bl = false;
        }
        return bl;
    }

    public final /* synthetic */ int validity$orb_java_core() {
        Discount discount = (Discount)OptionalsKt.getOrNull(this.discount.asKnown());
        return (this.id.asKnown().isPresent() ? 1 : 0) + (this.archivedAt.asKnown().isPresent() ? 1 : 0) + (discount != null ? discount.validity$orb_java_core() : 0) + (this.durationInMonths.asKnown().isPresent() ? 1 : 0) + (this.maxRedemptions.asKnown().isPresent() ? 1 : 0) + (this.redemptionCode.asKnown().isPresent() ? 1 : 0) + (this.timesRedeemed.asKnown().isPresent() ? 1 : 0);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Coupon && Intrinsics.areEqual(this.id, ((Coupon)other).id) && Intrinsics.areEqual(this.archivedAt, ((Coupon)other).archivedAt) && Intrinsics.areEqual(this.discount, ((Coupon)other).discount) && Intrinsics.areEqual(this.durationInMonths, ((Coupon)other).durationInMonths) && Intrinsics.areEqual(this.maxRedemptions, ((Coupon)other).maxRedemptions) && Intrinsics.areEqual(this.redemptionCode, ((Coupon)other).redemptionCode) && Intrinsics.areEqual(this.timesRedeemed, ((Coupon)other).timesRedeemed) && Intrinsics.areEqual(this.additionalProperties, ((Coupon)other).additionalProperties);
    }

    private final int getHashCode() {
        Lazy lazy = this.hashCode$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    public int hashCode() {
        return this.getHashCode();
    }

    @NotNull
    public String toString() {
        return "Coupon{id=" + this.id + ", archivedAt=" + this.archivedAt + ", discount=" + this.discount + ", durationInMonths=" + this.durationInMonths + ", maxRedemptions=" + this.maxRedemptions + ", redemptionCode=" + this.redemptionCode + ", timesRedeemed=" + this.timesRedeemed + ", additionalProperties=" + this.additionalProperties + '}';
    }

    @JvmStatic
    @NotNull
    public static final Builder builder() {
        return Companion.builder();
    }

    public /* synthetic */ Coupon(JsonField id, JsonField archivedAt, JsonField discount, JsonField durationInMonths, JsonField maxRedemptions, JsonField redemptionCode, JsonField timesRedeemed, Map additionalProperties, DefaultConstructorMarker $constructor_marker) {
        this(id, archivedAt, discount, durationInMonths, maxRedemptions, redemptionCode, timesRedeemed, additionalProperties);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\"\n\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00002\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0012J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0005J\u0014\u0010\u0007\u001a\u00020\u00002\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u0010\u0010\u0007\u001a\u00020\u00002\b\u0010\u0007\u001a\u0004\u0018\u00010\tJ\u0014\u0010\u0007\u001a\u00020\u00002\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\u0014J\u0006\u0010\u0015\u001a\u00020\u0016J\u0014\u0010\n\u001a\u00020\u00002\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001aJ\u0014\u0010\f\u001a\u00020\u00002\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\bJ\u0014\u0010\f\u001a\u00020\u00002\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0014J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u0015\u0010\f\u001a\u00020\u00002\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u001eJ\u0014\u0010\u000e\u001a\u00020\u00002\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\bJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0005J\u0014\u0010\u000f\u001a\u00020\u00002\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\bJ\u0014\u0010\u000f\u001a\u00020\u00002\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u0014J\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\rJ\u0015\u0010\u000f\u001a\u00020\u00002\b\u0010\u000f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u001bJ\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020 J\u0016\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u0006J\u001a\u0010$\u001a\u00020\u00002\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0012J\u0014\u0010\u0010\u001a\u00020\u00002\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\bJ\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0005J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0005J\u0014\u0010&\u001a\u00020\u00002\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00050(J\u0014\u0010\u0011\u001a\u00020\u00002\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\bJ\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\rR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/withorb/api/models/Coupon$Builder;", "", "()V", "additionalProperties", "", "", "Lcom/withorb/api/core/JsonValue;", "archivedAt", "Lcom/withorb/api/core/JsonField;", "Ljava/time/OffsetDateTime;", "discount", "Lcom/withorb/api/models/Coupon$Discount;", "durationInMonths", "", "id", "maxRedemptions", "redemptionCode", "timesRedeemed", "", "amountDiscount", "Ljava/util/Optional;", "build", "Lcom/withorb/api/models/Coupon;", "amount", "Lcom/withorb/api/models/AmountDiscount;", "percentage", "Lcom/withorb/api/models/PercentageDiscount;", "(Ljava/lang/Long;)Lcom/withorb/api/models/Coupon$Builder;", "from", "coupon", "from$orb_java_core", "percentageDiscount", "", "putAdditionalProperty", "key", "value", "putAllAdditionalProperties", "removeAdditionalProperty", "removeAllAdditionalProperties", "keys", "", "orb-java-core"})
    @SourceDebugExtension(value={"SMAP\nCoupon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Coupon.kt\ncom/withorb/api/models/Coupon$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,695:1\n1#2:696\n1855#3,2:697\n*S KotlinDebug\n*F\n+ 1 Coupon.kt\ncom/withorb/api/models/Coupon$Builder\n*L\n435#1:697,2\n*E\n"})
    public static final class Builder {
        @Nullable
        private JsonField<String> id;
        @Nullable
        private JsonField<OffsetDateTime> archivedAt;
        @Nullable
        private JsonField<Discount> discount;
        @Nullable
        private JsonField<Long> durationInMonths;
        @Nullable
        private JsonField<Long> maxRedemptions;
        @Nullable
        private JsonField<String> redemptionCode;
        @Nullable
        private JsonField<Long> timesRedeemed;
        @NotNull
        private Map<String, JsonValue> additionalProperties = new LinkedHashMap();

        public final /* synthetic */ Builder from$orb_java_core(Coupon coupon) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)coupon, (String)"coupon");
            Builder $this$from_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$from_u24lambda_u240.id = coupon.id;
            $this$from_u24lambda_u240.archivedAt = coupon.archivedAt;
            $this$from_u24lambda_u240.discount = coupon.discount;
            $this$from_u24lambda_u240.durationInMonths = coupon.durationInMonths;
            $this$from_u24lambda_u240.maxRedemptions = coupon.maxRedemptions;
            $this$from_u24lambda_u240.redemptionCode = coupon.redemptionCode;
            $this$from_u24lambda_u240.timesRedeemed = coupon.timesRedeemed;
            $this$from_u24lambda_u240.additionalProperties = MapsKt.toMutableMap((Map)coupon.additionalProperties);
            return builder;
        }

        @NotNull
        public final Builder id(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return this.id(JsonField.Companion.of(id));
        }

        @NotNull
        public final Builder id(@NotNull JsonField<String> id) {
            Builder builder;
            Intrinsics.checkNotNullParameter(id, (String)"id");
            Builder $this$id_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$id_u24lambda_u241.id = id;
            return builder;
        }

        @NotNull
        public final Builder archivedAt(@Nullable OffsetDateTime archivedAt) {
            return this.archivedAt(JsonField.Companion.ofNullable(archivedAt));
        }

        @NotNull
        public final Builder archivedAt(@NotNull Optional<OffsetDateTime> archivedAt) {
            Intrinsics.checkNotNullParameter(archivedAt, (String)"archivedAt");
            return this.archivedAt((OffsetDateTime)OptionalsKt.getOrNull(archivedAt));
        }

        @NotNull
        public final Builder archivedAt(@NotNull JsonField<OffsetDateTime> archivedAt) {
            Builder builder;
            Intrinsics.checkNotNullParameter(archivedAt, (String)"archivedAt");
            Builder $this$archivedAt_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$archivedAt_u24lambda_u242.archivedAt = archivedAt;
            return builder;
        }

        @NotNull
        public final Builder discount(@NotNull Discount discount) {
            Intrinsics.checkNotNullParameter((Object)discount, (String)"discount");
            return this.discount(JsonField.Companion.of(discount));
        }

        @NotNull
        public final Builder discount(@NotNull JsonField<Discount> discount) {
            Builder builder;
            Intrinsics.checkNotNullParameter(discount, (String)"discount");
            Builder $this$discount_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$discount_u24lambda_u243.discount = discount;
            return builder;
        }

        @NotNull
        public final Builder discount(@NotNull PercentageDiscount percentage) {
            Intrinsics.checkNotNullParameter((Object)percentage, (String)"percentage");
            return this.discount(Discount.Companion.ofPercentage(percentage));
        }

        @NotNull
        public final Builder percentageDiscount(double percentageDiscount) {
            return this.discount(PercentageDiscount.Companion.builder().discountType(PercentageDiscount.DiscountType.PERCENTAGE).percentageDiscount(percentageDiscount).build());
        }

        @NotNull
        public final Builder discount(@NotNull AmountDiscount amount) {
            Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
            return this.discount(Discount.Companion.ofAmount(amount));
        }

        @NotNull
        public final Builder amountDiscount(@NotNull String amountDiscount) {
            Intrinsics.checkNotNullParameter((Object)amountDiscount, (String)"amountDiscount");
            return this.discount(AmountDiscount.Companion.builder().discountType(AmountDiscount.DiscountType.AMOUNT).amountDiscount(amountDiscount).build());
        }

        @NotNull
        public final Builder durationInMonths(@Nullable Long durationInMonths) {
            return this.durationInMonths(JsonField.Companion.ofNullable(durationInMonths));
        }

        @NotNull
        public final Builder durationInMonths(long durationInMonths) {
            return this.durationInMonths((Long)durationInMonths);
        }

        @NotNull
        public final Builder durationInMonths(@NotNull Optional<Long> durationInMonths) {
            Intrinsics.checkNotNullParameter(durationInMonths, (String)"durationInMonths");
            return this.durationInMonths((Long)OptionalsKt.getOrNull(durationInMonths));
        }

        @NotNull
        public final Builder durationInMonths(@NotNull JsonField<Long> durationInMonths) {
            Builder builder;
            Intrinsics.checkNotNullParameter(durationInMonths, (String)"durationInMonths");
            Builder $this$durationInMonths_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$durationInMonths_u24lambda_u244.durationInMonths = durationInMonths;
            return builder;
        }

        @NotNull
        public final Builder maxRedemptions(@Nullable Long maxRedemptions) {
            return this.maxRedemptions(JsonField.Companion.ofNullable(maxRedemptions));
        }

        @NotNull
        public final Builder maxRedemptions(long maxRedemptions) {
            return this.maxRedemptions((Long)maxRedemptions);
        }

        @NotNull
        public final Builder maxRedemptions(@NotNull Optional<Long> maxRedemptions) {
            Intrinsics.checkNotNullParameter(maxRedemptions, (String)"maxRedemptions");
            return this.maxRedemptions((Long)OptionalsKt.getOrNull(maxRedemptions));
        }

        @NotNull
        public final Builder maxRedemptions(@NotNull JsonField<Long> maxRedemptions) {
            Builder builder;
            Intrinsics.checkNotNullParameter(maxRedemptions, (String)"maxRedemptions");
            Builder $this$maxRedemptions_u24lambda_u245 = builder = this;
            boolean bl = false;
            $this$maxRedemptions_u24lambda_u245.maxRedemptions = maxRedemptions;
            return builder;
        }

        @NotNull
        public final Builder redemptionCode(@NotNull String redemptionCode) {
            Intrinsics.checkNotNullParameter((Object)redemptionCode, (String)"redemptionCode");
            return this.redemptionCode(JsonField.Companion.of(redemptionCode));
        }

        @NotNull
        public final Builder redemptionCode(@NotNull JsonField<String> redemptionCode) {
            Builder builder;
            Intrinsics.checkNotNullParameter(redemptionCode, (String)"redemptionCode");
            Builder $this$redemptionCode_u24lambda_u246 = builder = this;
            boolean bl = false;
            $this$redemptionCode_u24lambda_u246.redemptionCode = redemptionCode;
            return builder;
        }

        @NotNull
        public final Builder timesRedeemed(long timesRedeemed) {
            return this.timesRedeemed(JsonField.Companion.of(timesRedeemed));
        }

        @NotNull
        public final Builder timesRedeemed(@NotNull JsonField<Long> timesRedeemed) {
            Builder builder;
            Intrinsics.checkNotNullParameter(timesRedeemed, (String)"timesRedeemed");
            Builder $this$timesRedeemed_u24lambda_u247 = builder = this;
            boolean bl = false;
            $this$timesRedeemed_u24lambda_u247.timesRedeemed = timesRedeemed;
            return builder;
        }

        @NotNull
        public final Builder additionalProperties(@NotNull Map<String, ? extends JsonValue> additionalProperties) {
            Builder builder;
            Intrinsics.checkNotNullParameter(additionalProperties, (String)"additionalProperties");
            Builder $this$additionalProperties_u24lambda_u248 = builder = this;
            boolean bl = false;
            $this$additionalProperties_u24lambda_u248.additionalProperties.clear();
            $this$additionalProperties_u24lambda_u248.putAllAdditionalProperties(additionalProperties);
            return builder;
        }

        @NotNull
        public final Builder putAdditionalProperty(@NotNull String key, @NotNull JsonValue value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$putAdditionalProperty_u24lambda_u249 = builder = this;
            boolean bl = false;
            $this$putAdditionalProperty_u24lambda_u249.additionalProperties.put(key, value);
            return builder;
        }

        @NotNull
        public final Builder putAllAdditionalProperties(@NotNull Map<String, ? extends JsonValue> additionalProperties) {
            Builder builder;
            Intrinsics.checkNotNullParameter(additionalProperties, (String)"additionalProperties");
            Builder $this$putAllAdditionalProperties_u24lambda_u2410 = builder = this;
            boolean bl = false;
            $this$putAllAdditionalProperties_u24lambda_u2410.additionalProperties.putAll(additionalProperties);
            return builder;
        }

        @NotNull
        public final Builder removeAdditionalProperty(@NotNull String key) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Builder $this$removeAdditionalProperty_u24lambda_u2411 = builder = this;
            boolean bl = false;
            $this$removeAdditionalProperty_u24lambda_u2411.additionalProperties.remove(key);
            return builder;
        }

        @NotNull
        public final Builder removeAllAdditionalProperties(@NotNull Set<String> keys) {
            Builder builder;
            Intrinsics.checkNotNullParameter(keys, (String)"keys");
            Builder $this$removeAllAdditionalProperties_u24lambda_u2412 = builder = this;
            boolean bl = false;
            Iterable $this$forEach$iv = keys;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String p0 = (String)element$iv;
                boolean bl2 = false;
                $this$removeAllAdditionalProperties_u24lambda_u2412.removeAdditionalProperty(p0);
            }
            return builder;
        }

        @NotNull
        public final Coupon build() {
            return new Coupon(Check.checkRequired("id", this.id), Check.checkRequired("archivedAt", this.archivedAt), Check.checkRequired("discount", this.discount), Check.checkRequired("durationInMonths", this.durationInMonths), Check.checkRequired("maxRedemptions", this.maxRedemptions), Check.checkRequired("redemptionCode", this.redemptionCode), Check.checkRequired("timesRedeemed", this.timesRedeemed), MapsKt.toMutableMap(this.additionalProperties), null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/withorb/api/models/Coupon$Companion;", "", "()V", "builder", "Lcom/withorb/api/models/Coupon$Builder;", "orb-java-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Builder builder() {
            return new Builder();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @JsonDeserialize(using=Deserializer.class)
    @JsonSerialize(using=Serializer.class)
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\b\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0004\u001f !\"B+\b\u0002\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bJ\u001f\u0010\f\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000f\u00a2\u0006\u0002\u0010\u0010J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bJ\u0006\u0010\u0011\u001a\u00020\u0005J\u0006\u0010\u0012\u001a\u00020\u0003J\u0013\u0010\u0013\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0006\u0010\u0017\u001a\u00020\nJ\u0006\u0010\u0018\u001a\u00020\nJ\u0006\u0010\u0019\u001a\u00020\nJ\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bJ\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0006\u0010\u001c\u001a\u00020\u0000J\r\u0010\u001d\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u001eR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/withorb/api/models/Coupon$Discount;", "", "percentage", "Lcom/withorb/api/models/PercentageDiscount;", "amount", "Lcom/withorb/api/models/AmountDiscount;", "_json", "Lcom/withorb/api/core/JsonValue;", "(Lcom/withorb/api/models/PercentageDiscount;Lcom/withorb/api/models/AmountDiscount;Lcom/withorb/api/core/JsonValue;)V", "validated", "", "Ljava/util/Optional;", "accept", "T", "visitor", "Lcom/withorb/api/models/Coupon$Discount$Visitor;", "(Lcom/withorb/api/models/Coupon$Discount$Visitor;)Ljava/lang/Object;", "asAmount", "asPercentage", "equals", "other", "hashCode", "", "isAmount", "isPercentage", "isValid", "toString", "", "validate", "validity", "validity$orb_java_core", "Companion", "Deserializer", "Serializer", "Visitor", "orb-java-core"})
    public static final class Discount {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final PercentageDiscount percentage;
        @Nullable
        private final AmountDiscount amount;
        @Nullable
        private final JsonValue _json;
        private boolean validated;

        private Discount(PercentageDiscount percentage, AmountDiscount amount, JsonValue _json) {
            this.percentage = percentage;
            this.amount = amount;
            this._json = _json;
        }

        /* synthetic */ Discount(PercentageDiscount percentageDiscount, AmountDiscount amountDiscount, JsonValue jsonValue, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                percentageDiscount = null;
            }
            if ((n & 2) != 0) {
                amountDiscount = null;
            }
            if ((n & 4) != 0) {
                jsonValue = null;
            }
            this(percentageDiscount, amountDiscount, jsonValue);
        }

        @NotNull
        public final Optional<PercentageDiscount> percentage() {
            Optional<PercentageDiscount> optional = Optional.ofNullable(this.percentage);
            Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
            return optional;
        }

        @NotNull
        public final Optional<AmountDiscount> amount() {
            Optional<AmountDiscount> optional = Optional.ofNullable(this.amount);
            Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
            return optional;
        }

        public final boolean isPercentage() {
            return this.percentage != null;
        }

        public final boolean isAmount() {
            return this.amount != null;
        }

        @NotNull
        public final PercentageDiscount asPercentage() {
            return (PercentageDiscount)Utils.getOrThrow(this.percentage, "percentage");
        }

        @NotNull
        public final AmountDiscount asAmount() {
            return (AmountDiscount)Utils.getOrThrow(this.amount, "amount");
        }

        @NotNull
        public final Optional<JsonValue> _json() {
            Optional<JsonValue> optional = Optional.ofNullable(this._json);
            Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
            return optional;
        }

        public final <T> T accept(@NotNull Visitor<? extends T> visitor) {
            Intrinsics.checkNotNullParameter(visitor, (String)"visitor");
            return this.percentage != null ? visitor.visitPercentage(this.percentage) : (this.amount != null ? visitor.visitAmount(this.amount) : visitor.unknown(this._json));
        }

        @NotNull
        public final Discount validate() {
            Discount discount;
            Discount $this$validate_u24lambda_u240 = discount = this;
            boolean bl = false;
            if (!$this$validate_u24lambda_u240.validated) {
                $this$validate_u24lambda_u240.accept((Visitor)new Visitor<Unit>(){

                    public void visitPercentage(@NotNull PercentageDiscount percentage) {
                        Intrinsics.checkNotNullParameter((Object)percentage, (String)"percentage");
                        percentage.validate();
                    }

                    public void visitAmount(@NotNull AmountDiscount amount) {
                        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
                        amount.validate();
                    }
                });
                $this$validate_u24lambda_u240.validated = true;
            }
            return discount;
        }

        public final boolean isValid() {
            boolean bl;
            try {
                this.validate();
                bl = true;
            }
            catch (OrbInvalidDataException e) {
                bl = false;
            }
            return bl;
        }

        public final /* synthetic */ int validity$orb_java_core() {
            return ((Number)this.accept((Visitor)new Visitor<Integer>(){

                @NotNull
                public Integer visitPercentage(@NotNull PercentageDiscount percentage) {
                    Intrinsics.checkNotNullParameter((Object)percentage, (String)"percentage");
                    return percentage.validity$orb_java_core();
                }

                @NotNull
                public Integer visitAmount(@NotNull AmountDiscount amount) {
                    Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
                    return amount.validity$orb_java_core();
                }

                @NotNull
                public Integer unknown(@Nullable JsonValue json2) {
                    return 0;
                }
            })).intValue();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Discount && Intrinsics.areEqual((Object)this.percentage, (Object)((Discount)other).percentage) && Intrinsics.areEqual((Object)this.amount, (Object)((Discount)other).amount);
        }

        public int hashCode() {
            Object[] objectArray = new Object[]{this.percentage, this.amount};
            return Objects.hash(objectArray);
        }

        @NotNull
        public String toString() {
            String string;
            if (this.percentage != null) {
                string = "Discount{percentage=" + this.percentage + '}';
            } else if (this.amount != null) {
                string = "Discount{amount=" + this.amount + '}';
            } else if (this._json != null) {
                string = "Discount{_unknown=" + this._json + '}';
            } else {
                throw new IllegalStateException("Invalid Discount");
            }
            return string;
        }

        @JvmStatic
        @NotNull
        public static final Discount ofPercentage(@NotNull PercentageDiscount percentage) {
            return Companion.ofPercentage(percentage);
        }

        @JvmStatic
        @NotNull
        public static final Discount ofAmount(@NotNull AmountDiscount amount) {
            return Companion.ofAmount(amount);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lcom/withorb/api/models/Coupon$Discount$Companion;", "", "()V", "ofAmount", "Lcom/withorb/api/models/Coupon$Discount;", "amount", "Lcom/withorb/api/models/AmountDiscount;", "ofPercentage", "percentage", "Lcom/withorb/api/models/PercentageDiscount;", "orb-java-core"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final Discount ofPercentage(@NotNull PercentageDiscount percentage) {
                Intrinsics.checkNotNullParameter((Object)percentage, (String)"percentage");
                return new Discount(percentage, null, null, 6, null);
            }

            @JvmStatic
            @NotNull
            public final Discount ofAmount(@NotNull AmountDiscount amount) {
                Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
                return new Discount(null, amount, null, 5, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u0002*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lcom/withorb/api/models/Coupon$Discount$Deserializer;", "Lcom/withorb/api/core/BaseDeserializer;", "Lcom/withorb/api/models/Coupon$Discount;", "()V", "deserialize", "Lcom/fasterxml/jackson/core/ObjectCodec;", "node", "Lcom/fasterxml/jackson/databind/JsonNode;", "orb-java-core"})
        @SourceDebugExtension(value={"SMAP\nCoupon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Coupon.kt\ncom/withorb/api/models/Coupon$Discount$Deserializer\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,695:1\n43#2:696\n43#2:697\n*S KotlinDebug\n*F\n+ 1 Coupon.kt\ncom/withorb/api/models/Coupon$Discount$Deserializer\n*L\n646#1:696\n651#1:697\n*E\n"})
        public static final class Deserializer
        extends BaseDeserializer<Discount> {
            public Deserializer() {
                super(Reflection.getOrCreateKotlinClass(Discount.class));
            }

            @Override
            @NotNull
            protected Discount deserialize(@NotNull ObjectCodec $this$deserialize, @NotNull JsonNode node) {
                String discountType;
                Intrinsics.checkNotNullParameter((Object)$this$deserialize, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                JsonValue json2 = JsonValue.Companion.fromJsonNode(node);
                Object object = (Map)OptionalsKt.getOrNull(json2.asObject());
                String string = discountType = object != null && (object = (JsonValue)object.get("discount_type")) != null && (object = ((JsonField)object).asString()) != null ? (String)OptionalsKt.getOrNull(object) : null;
                if (Intrinsics.areEqual(string, (Object)"percentage")) {
                    Discount discount;
                    boolean $i$f$jacksonTypeRef = false;
                    PercentageDiscount percentageDiscount = (PercentageDiscount)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<PercentageDiscount>(){});
                    if (percentageDiscount != null) {
                        PercentageDiscount it = percentageDiscount;
                        boolean bl = false;
                        discount = new Discount(it, null, json2, 2, null);
                    } else {
                        discount = new Discount(null, null, json2, 3, null);
                    }
                    return discount;
                }
                if (Intrinsics.areEqual((Object)string, (Object)"amount")) {
                    Discount discount;
                    boolean $i$f$jacksonTypeRef = false;
                    AmountDiscount amountDiscount = (AmountDiscount)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<AmountDiscount>(){});
                    if (amountDiscount != null) {
                        AmountDiscount it = amountDiscount;
                        boolean bl = false;
                        discount = new Discount(null, it, json2, 1, null);
                    } else {
                        discount = new Discount(null, null, json2, 3, null);
                    }
                    return discount;
                }
                return new Discount(null, null, json2, 3, null);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/withorb/api/models/Coupon$Discount$Serializer;", "Lcom/withorb/api/core/BaseSerializer;", "Lcom/withorb/api/models/Coupon$Discount;", "()V", "serialize", "", "value", "generator", "Lcom/fasterxml/jackson/core/JsonGenerator;", "provider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "orb-java-core"})
        public static final class Serializer
        extends BaseSerializer<Discount> {
            public Serializer() {
                super(Reflection.getOrCreateKotlinClass(Discount.class));
            }

            public void serialize(@NotNull Discount value, @NotNull JsonGenerator generator, @NotNull SerializerProvider provider) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
                Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
                if (value.percentage != null) {
                    generator.writeObject((Object)value.percentage);
                } else if (value.amount != null) {
                    generator.writeObject((Object)value.amount);
                } else if (value._json != null) {
                    generator.writeObject((Object)value._json);
                } else {
                    throw new IllegalStateException("Invalid Discount");
                }
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002J\u0017\u0010\u0003\u001a\u00028\u00002\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0007\u001a\u00028\u00002\u0006\u0010\b\u001a\u00020\tH&\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\rH&\u00a2\u0006\u0002\u0010\u000e\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lcom/withorb/api/models/Coupon$Discount$Visitor;", "T", "", "unknown", "json", "Lcom/withorb/api/core/JsonValue;", "(Lcom/withorb/api/core/JsonValue;)Ljava/lang/Object;", "visitAmount", "amount", "Lcom/withorb/api/models/AmountDiscount;", "(Lcom/withorb/api/models/AmountDiscount;)Ljava/lang/Object;", "visitPercentage", "percentage", "Lcom/withorb/api/models/PercentageDiscount;", "(Lcom/withorb/api/models/PercentageDiscount;)Ljava/lang/Object;", "orb-java-core"})
        public static interface Visitor<T> {
            public T visitPercentage(@NotNull PercentageDiscount var1);

            public T visitAmount(@NotNull AmountDiscount var1);

            default public T unknown(@Nullable JsonValue json2) {
                throw new OrbInvalidDataException("Unknown Discount: " + json2, null, 2, null);
            }
        }
    }
}

