/*
 * Decompiled with CFR 0.152.
 */
package com.withorb.api.models;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.withorb.api.core.BaseDeserializer;
import com.withorb.api.core.BaseSerializer;
import com.withorb.api.core.JsonField;
import com.withorb.api.core.JsonValue;
import com.withorb.api.core.Utils;
import com.withorb.api.errors.OrbInvalidDataException;
import com.withorb.api.models.AmountDiscount;
import com.withorb.api.models.PercentageDiscount;
import com.withorb.api.models.TrialDiscount;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonDeserialize(using=Deserializer.class)
@JsonSerialize(using=Serializer.class)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\b\b\u0007\u0018\u0000 #2\u00020\u0001:\u0004#$%&B7\b\u0002\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\rJ\u001f\u0010\u000e\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0011\u00a2\u0006\u0002\u0010\u0012J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\rJ\u0006\u0010\u0013\u001a\u00020\u0005J\u0006\u0010\u0014\u001a\u00020\u0003J\u0006\u0010\u0015\u001a\u00020\u0007J\u0013\u0010\u0016\u001a\u00020\f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0006\u0010\u001a\u001a\u00020\fJ\u0006\u0010\u001b\u001a\u00020\fJ\u0006\u0010\u001c\u001a\u00020\fJ\u0006\u0010\u001d\u001a\u00020\fJ\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00030\rJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\rJ\u0006\u0010 \u001a\u00020\u0000J\r\u0010!\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\"R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/withorb/api/models/InvoiceLevelDiscount;", "", "percentage", "Lcom/withorb/api/models/PercentageDiscount;", "amount", "Lcom/withorb/api/models/AmountDiscount;", "trial", "Lcom/withorb/api/models/TrialDiscount;", "_json", "Lcom/withorb/api/core/JsonValue;", "(Lcom/withorb/api/models/PercentageDiscount;Lcom/withorb/api/models/AmountDiscount;Lcom/withorb/api/models/TrialDiscount;Lcom/withorb/api/core/JsonValue;)V", "validated", "", "Ljava/util/Optional;", "accept", "T", "visitor", "Lcom/withorb/api/models/InvoiceLevelDiscount$Visitor;", "(Lcom/withorb/api/models/InvoiceLevelDiscount$Visitor;)Ljava/lang/Object;", "asAmount", "asPercentage", "asTrial", "equals", "other", "hashCode", "", "isAmount", "isPercentage", "isTrial", "isValid", "toString", "", "validate", "validity", "validity$orb_java_core", "Companion", "Deserializer", "Serializer", "Visitor", "orb-java-core"})
public final class InvoiceLevelDiscount {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final PercentageDiscount percentage;
    @Nullable
    private final AmountDiscount amount;
    @Nullable
    private final TrialDiscount trial;
    @Nullable
    private final JsonValue _json;
    private boolean validated;

    private InvoiceLevelDiscount(PercentageDiscount percentage, AmountDiscount amount, TrialDiscount trial, JsonValue _json) {
        this.percentage = percentage;
        this.amount = amount;
        this.trial = trial;
        this._json = _json;
    }

    /* synthetic */ InvoiceLevelDiscount(PercentageDiscount percentageDiscount, AmountDiscount amountDiscount, TrialDiscount trialDiscount, JsonValue jsonValue, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            percentageDiscount = null;
        }
        if ((n & 2) != 0) {
            amountDiscount = null;
        }
        if ((n & 4) != 0) {
            trialDiscount = null;
        }
        if ((n & 8) != 0) {
            jsonValue = null;
        }
        this(percentageDiscount, amountDiscount, trialDiscount, jsonValue);
    }

    @NotNull
    public final Optional<PercentageDiscount> percentage() {
        Optional<PercentageDiscount> optional = Optional.ofNullable(this.percentage);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    @NotNull
    public final Optional<AmountDiscount> amount() {
        Optional<AmountDiscount> optional = Optional.ofNullable(this.amount);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    @NotNull
    public final Optional<TrialDiscount> trial() {
        Optional<TrialDiscount> optional = Optional.ofNullable(this.trial);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    public final boolean isPercentage() {
        return this.percentage != null;
    }

    public final boolean isAmount() {
        return this.amount != null;
    }

    public final boolean isTrial() {
        return this.trial != null;
    }

    @NotNull
    public final PercentageDiscount asPercentage() {
        return (PercentageDiscount)Utils.getOrThrow(this.percentage, "percentage");
    }

    @NotNull
    public final AmountDiscount asAmount() {
        return (AmountDiscount)Utils.getOrThrow(this.amount, "amount");
    }

    @NotNull
    public final TrialDiscount asTrial() {
        return (TrialDiscount)Utils.getOrThrow(this.trial, "trial");
    }

    @NotNull
    public final Optional<JsonValue> _json() {
        Optional<JsonValue> optional = Optional.ofNullable(this._json);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    public final <T> T accept(@NotNull Visitor<? extends T> visitor) {
        Intrinsics.checkNotNullParameter(visitor, (String)"visitor");
        return this.percentage != null ? visitor.visitPercentage(this.percentage) : (this.amount != null ? visitor.visitAmount(this.amount) : (this.trial != null ? visitor.visitTrial(this.trial) : visitor.unknown(this._json)));
    }

    @NotNull
    public final InvoiceLevelDiscount validate() {
        InvoiceLevelDiscount invoiceLevelDiscount;
        InvoiceLevelDiscount $this$validate_u24lambda_u240 = invoiceLevelDiscount = this;
        boolean bl = false;
        if (!$this$validate_u24lambda_u240.validated) {
            $this$validate_u24lambda_u240.accept((Visitor)new Visitor<Unit>(){

                public void visitPercentage(@NotNull PercentageDiscount percentage) {
                    Intrinsics.checkNotNullParameter((Object)percentage, (String)"percentage");
                    percentage.validate();
                }

                public void visitAmount(@NotNull AmountDiscount amount) {
                    Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
                    amount.validate();
                }

                public void visitTrial(@NotNull TrialDiscount trial) {
                    Intrinsics.checkNotNullParameter((Object)trial, (String)"trial");
                    trial.validate();
                }
            });
            $this$validate_u24lambda_u240.validated = true;
        }
        return invoiceLevelDiscount;
    }

    public final boolean isValid() {
        boolean bl;
        try {
            this.validate();
            bl = true;
        }
        catch (OrbInvalidDataException e) {
            bl = false;
        }
        return bl;
    }

    public final /* synthetic */ int validity$orb_java_core() {
        return ((Number)this.accept((Visitor)new Visitor<Integer>(){

            @NotNull
            public Integer visitPercentage(@NotNull PercentageDiscount percentage) {
                Intrinsics.checkNotNullParameter((Object)percentage, (String)"percentage");
                return percentage.validity$orb_java_core();
            }

            @NotNull
            public Integer visitAmount(@NotNull AmountDiscount amount) {
                Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
                return amount.validity$orb_java_core();
            }

            @NotNull
            public Integer visitTrial(@NotNull TrialDiscount trial) {
                Intrinsics.checkNotNullParameter((Object)trial, (String)"trial");
                return trial.validity$orb_java_core();
            }

            @NotNull
            public Integer unknown(@Nullable JsonValue json2) {
                return 0;
            }
        })).intValue();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof InvoiceLevelDiscount && Intrinsics.areEqual((Object)this.percentage, (Object)((InvoiceLevelDiscount)other).percentage) && Intrinsics.areEqual((Object)this.amount, (Object)((InvoiceLevelDiscount)other).amount) && Intrinsics.areEqual((Object)this.trial, (Object)((InvoiceLevelDiscount)other).trial);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.percentage, this.amount, this.trial};
        return Objects.hash(objectArray);
    }

    @NotNull
    public String toString() {
        String string;
        if (this.percentage != null) {
            string = "InvoiceLevelDiscount{percentage=" + this.percentage + '}';
        } else if (this.amount != null) {
            string = "InvoiceLevelDiscount{amount=" + this.amount + '}';
        } else if (this.trial != null) {
            string = "InvoiceLevelDiscount{trial=" + this.trial + '}';
        } else if (this._json != null) {
            string = "InvoiceLevelDiscount{_unknown=" + this._json + '}';
        } else {
            throw new IllegalStateException("Invalid InvoiceLevelDiscount");
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final InvoiceLevelDiscount ofPercentage(@NotNull PercentageDiscount percentage) {
        return Companion.ofPercentage(percentage);
    }

    @JvmStatic
    @NotNull
    public static final InvoiceLevelDiscount ofAmount(@NotNull AmountDiscount amount) {
        return Companion.ofAmount(amount);
    }

    @JvmStatic
    @NotNull
    public static final InvoiceLevelDiscount ofTrial(@NotNull TrialDiscount trial) {
        return Companion.ofTrial(trial);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0007\u00a8\u0006\r"}, d2={"Lcom/withorb/api/models/InvoiceLevelDiscount$Companion;", "", "()V", "ofAmount", "Lcom/withorb/api/models/InvoiceLevelDiscount;", "amount", "Lcom/withorb/api/models/AmountDiscount;", "ofPercentage", "percentage", "Lcom/withorb/api/models/PercentageDiscount;", "ofTrial", "trial", "Lcom/withorb/api/models/TrialDiscount;", "orb-java-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final InvoiceLevelDiscount ofPercentage(@NotNull PercentageDiscount percentage) {
            Intrinsics.checkNotNullParameter((Object)percentage, (String)"percentage");
            return new InvoiceLevelDiscount(percentage, null, null, null, 14, null);
        }

        @JvmStatic
        @NotNull
        public final InvoiceLevelDiscount ofAmount(@NotNull AmountDiscount amount) {
            Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
            return new InvoiceLevelDiscount(null, amount, null, null, 13, null);
        }

        @JvmStatic
        @NotNull
        public final InvoiceLevelDiscount ofTrial(@NotNull TrialDiscount trial) {
            Intrinsics.checkNotNullParameter((Object)trial, (String)"trial");
            return new InvoiceLevelDiscount(null, null, trial, null, 11, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u0002*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lcom/withorb/api/models/InvoiceLevelDiscount$Deserializer;", "Lcom/withorb/api/core/BaseDeserializer;", "Lcom/withorb/api/models/InvoiceLevelDiscount;", "()V", "deserialize", "Lcom/fasterxml/jackson/core/ObjectCodec;", "node", "Lcom/fasterxml/jackson/databind/JsonNode;", "orb-java-core"})
    @SourceDebugExtension(value={"SMAP\nInvoiceLevelDiscount.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InvoiceLevelDiscount.kt\ncom/withorb/api/models/InvoiceLevelDiscount$Deserializer\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,215:1\n43#2:216\n43#2:217\n43#2:218\n*S KotlinDebug\n*F\n+ 1 InvoiceLevelDiscount.kt\ncom/withorb/api/models/InvoiceLevelDiscount$Deserializer\n*L\n178#1:216\n183#1:217\n188#1:218\n*E\n"})
    public static final class Deserializer
    extends BaseDeserializer<InvoiceLevelDiscount> {
        public Deserializer() {
            super(Reflection.getOrCreateKotlinClass(InvoiceLevelDiscount.class));
        }

        @Override
        @NotNull
        protected InvoiceLevelDiscount deserialize(@NotNull ObjectCodec $this$deserialize, @NotNull JsonNode node) {
            JsonValue json2;
            block19: {
                String discountType;
                Intrinsics.checkNotNullParameter((Object)$this$deserialize, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                json2 = JsonValue.Companion.fromJsonNode(node);
                Object object = (Map)OptionalsKt.getOrNull(json2.asObject());
                String string = discountType = object != null && (object = (JsonValue)object.get("discount_type")) != null && (object = ((JsonField)object).asString()) != null ? (String)OptionalsKt.getOrNull(object) : null;
                if (string == null) break block19;
                int n = -1;
                switch (string.hashCode()) {
                    case -1413853096: {
                        if (string.equals("amount")) {
                            n = 1;
                        }
                        break;
                    }
                    case -921832806: {
                        if (string.equals("percentage")) {
                            n = 2;
                        }
                        break;
                    }
                    case 110628630: {
                        if (string.equals("trial")) {
                            n = 3;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 2: {
                        InvoiceLevelDiscount invoiceLevelDiscount;
                        boolean $i$f$jacksonTypeRef = false;
                        PercentageDiscount percentageDiscount = (PercentageDiscount)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<PercentageDiscount>(){});
                        if (percentageDiscount != null) {
                            PercentageDiscount it = percentageDiscount;
                            boolean bl = false;
                            invoiceLevelDiscount = new InvoiceLevelDiscount(it, null, null, json2, 6, null);
                        } else {
                            invoiceLevelDiscount = new InvoiceLevelDiscount(null, null, null, json2, 7, null);
                        }
                        return invoiceLevelDiscount;
                    }
                    case 1: {
                        InvoiceLevelDiscount invoiceLevelDiscount;
                        boolean $i$f$jacksonTypeRef = false;
                        AmountDiscount amountDiscount = (AmountDiscount)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<AmountDiscount>(){});
                        if (amountDiscount != null) {
                            AmountDiscount it = amountDiscount;
                            boolean bl = false;
                            invoiceLevelDiscount = new InvoiceLevelDiscount(null, it, null, json2, 5, null);
                        } else {
                            invoiceLevelDiscount = new InvoiceLevelDiscount(null, null, null, json2, 7, null);
                        }
                        return invoiceLevelDiscount;
                    }
                    case 3: {
                        InvoiceLevelDiscount invoiceLevelDiscount;
                        boolean $i$f$jacksonTypeRef = false;
                        TrialDiscount trialDiscount = (TrialDiscount)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<TrialDiscount>(){});
                        if (trialDiscount != null) {
                            TrialDiscount it = trialDiscount;
                            boolean bl = false;
                            invoiceLevelDiscount = new InvoiceLevelDiscount(null, null, it, json2, 3, null);
                        } else {
                            invoiceLevelDiscount = new InvoiceLevelDiscount(null, null, null, json2, 7, null);
                        }
                        return invoiceLevelDiscount;
                    }
                }
            }
            return new InvoiceLevelDiscount(null, null, null, json2, 7, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/withorb/api/models/InvoiceLevelDiscount$Serializer;", "Lcom/withorb/api/core/BaseSerializer;", "Lcom/withorb/api/models/InvoiceLevelDiscount;", "()V", "serialize", "", "value", "generator", "Lcom/fasterxml/jackson/core/JsonGenerator;", "provider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "orb-java-core"})
    public static final class Serializer
    extends BaseSerializer<InvoiceLevelDiscount> {
        public Serializer() {
            super(Reflection.getOrCreateKotlinClass(InvoiceLevelDiscount.class));
        }

        public void serialize(@NotNull InvoiceLevelDiscount value, @NotNull JsonGenerator generator, @NotNull SerializerProvider provider) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            if (value.percentage != null) {
                generator.writeObject((Object)value.percentage);
            } else if (value.amount != null) {
                generator.writeObject((Object)value.amount);
            } else if (value.trial != null) {
                generator.writeObject((Object)value.trial);
            } else if (value._json != null) {
                generator.writeObject((Object)value._json);
            } else {
                throw new IllegalStateException("Invalid InvoiceLevelDiscount");
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002J\u0017\u0010\u0003\u001a\u00028\u00002\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0007\u001a\u00028\u00002\u0006\u0010\b\u001a\u00020\tH&\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\rH&\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\u0011H&\u00a2\u0006\u0002\u0010\u0012\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0013\u00c0\u0006\u0001"}, d2={"Lcom/withorb/api/models/InvoiceLevelDiscount$Visitor;", "T", "", "unknown", "json", "Lcom/withorb/api/core/JsonValue;", "(Lcom/withorb/api/core/JsonValue;)Ljava/lang/Object;", "visitAmount", "amount", "Lcom/withorb/api/models/AmountDiscount;", "(Lcom/withorb/api/models/AmountDiscount;)Ljava/lang/Object;", "visitPercentage", "percentage", "Lcom/withorb/api/models/PercentageDiscount;", "(Lcom/withorb/api/models/PercentageDiscount;)Ljava/lang/Object;", "visitTrial", "trial", "Lcom/withorb/api/models/TrialDiscount;", "(Lcom/withorb/api/models/TrialDiscount;)Ljava/lang/Object;", "orb-java-core"})
    public static interface Visitor<T> {
        public T visitPercentage(@NotNull PercentageDiscount var1);

        public T visitAmount(@NotNull AmountDiscount var1);

        public T visitTrial(@NotNull TrialDiscount var1);

        default public T unknown(@Nullable JsonValue json2) {
            throw new OrbInvalidDataException("Unknown InvoiceLevelDiscount: " + json2, null, 2, null);
        }
    }
}

