/*
 * Decompiled with CFR 0.152.
 */
package com.withorb.api.services.blocking;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.withorb.api.core.Check;
import com.withorb.api.core.ClientOptions;
import com.withorb.api.core.JsonValue;
import com.withorb.api.core.PrepareRequest;
import com.withorb.api.core.RequestOptions;
import com.withorb.api.core.handlers.EmptyHandler;
import com.withorb.api.core.handlers.ErrorHandler;
import com.withorb.api.core.http.HttpMethod;
import com.withorb.api.core.http.HttpRequest;
import com.withorb.api.core.http.HttpRequestBody;
import com.withorb.api.core.http.HttpResponse;
import com.withorb.api.core.http.HttpResponseFor;
import com.withorb.api.core.http.HttpResponseForKt;
import com.withorb.api.errors.OrbInvalidDataException;
import com.withorb.api.models.Customer;
import com.withorb.api.models.CustomerCreateParams;
import com.withorb.api.models.CustomerDeleteParams;
import com.withorb.api.models.CustomerFetchByExternalIdParams;
import com.withorb.api.models.CustomerFetchParams;
import com.withorb.api.models.CustomerListPage;
import com.withorb.api.models.CustomerListPageResponse;
import com.withorb.api.models.CustomerListParams;
import com.withorb.api.models.CustomerSyncPaymentMethodsFromGatewayByExternalCustomerIdParams;
import com.withorb.api.models.CustomerSyncPaymentMethodsFromGatewayParams;
import com.withorb.api.models.CustomerUpdateByExternalIdParams;
import com.withorb.api.models.CustomerUpdateParams;
import com.withorb.api.services.blocking.CustomerService;
import com.withorb.api.services.blocking.customers.BalanceTransactionService;
import com.withorb.api.services.blocking.customers.BalanceTransactionServiceImpl;
import com.withorb.api.services.blocking.customers.CostService;
import com.withorb.api.services.blocking.customers.CostServiceImpl;
import com.withorb.api.services.blocking.customers.CreditService;
import com.withorb.api.services.blocking.customers.CreditServiceImpl;
import java.io.OutputStream;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00016B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010 \u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010#\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010%\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020&2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010'\u001a\u00020(2\u0006\u0010\u001c\u001a\u00020)2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010*\u001a\u00020!2\u0006\u0010\u001c\u001a\u00020+2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010,\u001a\u00020!2\u0006\u0010\u001c\u001a\u00020-2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010.\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020/2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u00100\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u0002012\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0016\u00102\u001a\u00020\u00012\f\u00103\u001a\b\u0012\u0004\u0012\u00020504H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\n\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0015\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\n\u001a\u0004\b\u0017\u0010\u0018\u00a8\u00067"}, d2={"Lcom/withorb/api/services/blocking/CustomerServiceImpl;", "Lcom/withorb/api/services/blocking/CustomerService;", "clientOptions", "Lcom/withorb/api/core/ClientOptions;", "(Lcom/withorb/api/core/ClientOptions;)V", "balanceTransactions", "Lcom/withorb/api/services/blocking/customers/BalanceTransactionService;", "getBalanceTransactions", "()Lcom/withorb/api/services/blocking/customers/BalanceTransactionService;", "balanceTransactions$delegate", "Lkotlin/Lazy;", "costs", "Lcom/withorb/api/services/blocking/customers/CostService;", "getCosts", "()Lcom/withorb/api/services/blocking/customers/CostService;", "costs$delegate", "credits", "Lcom/withorb/api/services/blocking/customers/CreditService;", "getCredits", "()Lcom/withorb/api/services/blocking/customers/CreditService;", "credits$delegate", "withRawResponse", "Lcom/withorb/api/services/blocking/CustomerService$WithRawResponse;", "getWithRawResponse", "()Lcom/withorb/api/services/blocking/CustomerService$WithRawResponse;", "withRawResponse$delegate", "create", "Lcom/withorb/api/models/Customer;", "params", "Lcom/withorb/api/models/CustomerCreateParams;", "requestOptions", "Lcom/withorb/api/core/RequestOptions;", "delete", "", "Lcom/withorb/api/models/CustomerDeleteParams;", "fetch", "Lcom/withorb/api/models/CustomerFetchParams;", "fetchByExternalId", "Lcom/withorb/api/models/CustomerFetchByExternalIdParams;", "list", "Lcom/withorb/api/models/CustomerListPage;", "Lcom/withorb/api/models/CustomerListParams;", "syncPaymentMethodsFromGateway", "Lcom/withorb/api/models/CustomerSyncPaymentMethodsFromGatewayParams;", "syncPaymentMethodsFromGatewayByExternalCustomerId", "Lcom/withorb/api/models/CustomerSyncPaymentMethodsFromGatewayByExternalCustomerIdParams;", "update", "Lcom/withorb/api/models/CustomerUpdateParams;", "updateByExternalId", "Lcom/withorb/api/models/CustomerUpdateByExternalIdParams;", "withOptions", "modifier", "Ljava/util/function/Consumer;", "Lcom/withorb/api/core/ClientOptions$Builder;", "WithRawResponseImpl", "orb-java-core"})
@SourceDebugExtension(value={"SMAP\nCustomerServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomerServiceImpl.kt\ncom/withorb/api/services/blocking/CustomerServiceImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,421:1\n1#2:422\n*E\n"})
public final class CustomerServiceImpl
implements CustomerService {
    @NotNull
    private final ClientOptions clientOptions;
    @NotNull
    private final Lazy withRawResponse$delegate;
    @NotNull
    private final Lazy costs$delegate;
    @NotNull
    private final Lazy credits$delegate;
    @NotNull
    private final Lazy balanceTransactions$delegate;

    public CustomerServiceImpl(@NotNull ClientOptions clientOptions) {
        Intrinsics.checkNotNullParameter((Object)clientOptions, (String)"clientOptions");
        this.clientOptions = clientOptions;
        this.withRawResponse$delegate = LazyKt.lazy((Function0)((Function0)new Function0<WithRawResponseImpl>(this){
            final /* synthetic */ CustomerServiceImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final WithRawResponseImpl invoke() {
                return new WithRawResponseImpl(CustomerServiceImpl.access$getClientOptions$p(this.this$0));
            }
        }));
        this.costs$delegate = LazyKt.lazy((Function0)((Function0)new Function0<CostServiceImpl>(this){
            final /* synthetic */ CustomerServiceImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final CostServiceImpl invoke() {
                return new CostServiceImpl(CustomerServiceImpl.access$getClientOptions$p(this.this$0));
            }
        }));
        this.credits$delegate = LazyKt.lazy((Function0)((Function0)new Function0<CreditServiceImpl>(this){
            final /* synthetic */ CustomerServiceImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final CreditServiceImpl invoke() {
                return new CreditServiceImpl(CustomerServiceImpl.access$getClientOptions$p(this.this$0));
            }
        }));
        this.balanceTransactions$delegate = LazyKt.lazy((Function0)((Function0)new Function0<BalanceTransactionServiceImpl>(this){
            final /* synthetic */ CustomerServiceImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final BalanceTransactionServiceImpl invoke() {
                return new BalanceTransactionServiceImpl(CustomerServiceImpl.access$getClientOptions$p(this.this$0));
            }
        }));
    }

    private final CustomerService.WithRawResponse getWithRawResponse() {
        Lazy lazy = this.withRawResponse$delegate;
        return (CustomerService.WithRawResponse)lazy.getValue();
    }

    private final CostService getCosts() {
        Lazy lazy = this.costs$delegate;
        return (CostService)lazy.getValue();
    }

    private final CreditService getCredits() {
        Lazy lazy = this.credits$delegate;
        return (CreditService)lazy.getValue();
    }

    private final BalanceTransactionService getBalanceTransactions() {
        Lazy lazy = this.balanceTransactions$delegate;
        return (BalanceTransactionService)lazy.getValue();
    }

    @Override
    @NotNull
    public CustomerService.WithRawResponse withRawResponse() {
        return this.getWithRawResponse();
    }

    @Override
    @NotNull
    public CustomerService withOptions(@NotNull Consumer<ClientOptions.Builder> modifier) {
        ClientOptions.Builder builder;
        Intrinsics.checkNotNullParameter(modifier, (String)"modifier");
        ClientOptions.Builder p0 = builder = this.clientOptions.toBuilder();
        boolean bl = false;
        modifier.accept(p0);
        ClientOptions clientOptions = builder.build();
        return new CustomerServiceImpl(clientOptions);
    }

    @Override
    @NotNull
    public CostService costs() {
        return this.getCosts();
    }

    @Override
    @NotNull
    public CreditService credits() {
        return this.getCredits();
    }

    @Override
    @NotNull
    public BalanceTransactionService balanceTransactions() {
        return this.getBalanceTransactions();
    }

    @Override
    @NotNull
    public Customer create(@NotNull CustomerCreateParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        return this.withRawResponse().create(params, requestOptions).parse();
    }

    @Override
    @NotNull
    public Customer update(@NotNull CustomerUpdateParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        return this.withRawResponse().update(params, requestOptions).parse();
    }

    @Override
    @NotNull
    public CustomerListPage list(@NotNull CustomerListParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        return this.withRawResponse().list(params, requestOptions).parse();
    }

    @Override
    public void delete(@NotNull CustomerDeleteParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        this.withRawResponse().delete(params, requestOptions);
    }

    @Override
    @NotNull
    public Customer fetch(@NotNull CustomerFetchParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        return this.withRawResponse().fetch(params, requestOptions).parse();
    }

    @Override
    @NotNull
    public Customer fetchByExternalId(@NotNull CustomerFetchByExternalIdParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        return this.withRawResponse().fetchByExternalId(params, requestOptions).parse();
    }

    @Override
    public void syncPaymentMethodsFromGateway(@NotNull CustomerSyncPaymentMethodsFromGatewayParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        this.withRawResponse().syncPaymentMethodsFromGateway(params, requestOptions);
    }

    @Override
    public void syncPaymentMethodsFromGatewayByExternalCustomerId(@NotNull CustomerSyncPaymentMethodsFromGatewayByExternalCustomerIdParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        this.withRawResponse().syncPaymentMethodsFromGatewayByExternalCustomerId(params, requestOptions);
    }

    @Override
    @NotNull
    public Customer updateByExternalId(@NotNull CustomerUpdateByExternalIdParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        return this.withRawResponse().updateByExternalId(params, requestOptions).parse();
    }

    public static final /* synthetic */ ClientOptions access$getClientOptions$p(CustomerServiceImpl $this) {
        return $this.clientOptions;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00120%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010*\u001a\u00020+2\u0006\u0010&\u001a\u00020,2\u0006\u0010(\u001a\u00020)H\u0016J\u001e\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00120%2\u0006\u0010&\u001a\u00020.2\u0006\u0010(\u001a\u00020)H\u0016J\u001e\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00120%2\u0006\u0010&\u001a\u0002002\u0006\u0010(\u001a\u00020)H\u0016J\u001e\u00101\u001a\b\u0012\u0004\u0012\u0002020%2\u0006\u0010&\u001a\u0002032\u0006\u0010(\u001a\u00020)H\u0016J\u0018\u00104\u001a\u00020+2\u0006\u0010&\u001a\u0002052\u0006\u0010(\u001a\u00020)H\u0016J\u0018\u00106\u001a\u00020+2\u0006\u0010&\u001a\u0002072\u0006\u0010(\u001a\u00020)H\u0016J\u001e\u00108\u001a\b\u0012\u0004\u0012\u00020\u00120%2\u0006\u0010&\u001a\u0002092\u0006\u0010(\u001a\u00020)H\u0016J\u001e\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00120%2\u0006\u0010&\u001a\u00020;2\u0006\u0010(\u001a\u00020)H\u0016J\u0016\u0010<\u001a\u00020\u00012\f\u0010=\u001a\b\u0012\u0004\u0012\u00020?0>H\u0016R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0013\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\n\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/withorb/api/services/blocking/CustomerServiceImpl$WithRawResponseImpl;", "Lcom/withorb/api/services/blocking/CustomerService$WithRawResponse;", "clientOptions", "Lcom/withorb/api/core/ClientOptions;", "(Lcom/withorb/api/core/ClientOptions;)V", "balanceTransactions", "Lcom/withorb/api/services/blocking/customers/BalanceTransactionService$WithRawResponse;", "getBalanceTransactions", "()Lcom/withorb/api/services/blocking/customers/BalanceTransactionService$WithRawResponse;", "balanceTransactions$delegate", "Lkotlin/Lazy;", "costs", "Lcom/withorb/api/services/blocking/customers/CostService$WithRawResponse;", "getCosts", "()Lcom/withorb/api/services/blocking/customers/CostService$WithRawResponse;", "costs$delegate", "createHandler", "Lcom/withorb/api/core/http/HttpResponse$Handler;", "Lcom/withorb/api/models/Customer;", "credits", "Lcom/withorb/api/services/blocking/customers/CreditService$WithRawResponse;", "getCredits", "()Lcom/withorb/api/services/blocking/customers/CreditService$WithRawResponse;", "credits$delegate", "deleteHandler", "Ljava/lang/Void;", "errorHandler", "Lcom/withorb/api/core/JsonValue;", "fetchByExternalIdHandler", "fetchHandler", "listHandler", "Lcom/withorb/api/models/CustomerListPageResponse;", "syncPaymentMethodsFromGatewayByExternalCustomerIdHandler", "syncPaymentMethodsFromGatewayHandler", "updateByExternalIdHandler", "updateHandler", "create", "Lcom/withorb/api/core/http/HttpResponseFor;", "params", "Lcom/withorb/api/models/CustomerCreateParams;", "requestOptions", "Lcom/withorb/api/core/RequestOptions;", "delete", "Lcom/withorb/api/core/http/HttpResponse;", "Lcom/withorb/api/models/CustomerDeleteParams;", "fetch", "Lcom/withorb/api/models/CustomerFetchParams;", "fetchByExternalId", "Lcom/withorb/api/models/CustomerFetchByExternalIdParams;", "list", "Lcom/withorb/api/models/CustomerListPage;", "Lcom/withorb/api/models/CustomerListParams;", "syncPaymentMethodsFromGateway", "Lcom/withorb/api/models/CustomerSyncPaymentMethodsFromGatewayParams;", "syncPaymentMethodsFromGatewayByExternalCustomerId", "Lcom/withorb/api/models/CustomerSyncPaymentMethodsFromGatewayByExternalCustomerIdParams;", "update", "Lcom/withorb/api/models/CustomerUpdateParams;", "updateByExternalId", "Lcom/withorb/api/models/CustomerUpdateByExternalIdParams;", "withOptions", "modifier", "Ljava/util/function/Consumer;", "Lcom/withorb/api/core/ClientOptions$Builder;", "orb-java-core"})
    @SourceDebugExtension(value={"SMAP\nCustomerServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomerServiceImpl.kt\ncom/withorb/api/services/blocking/CustomerServiceImpl$WithRawResponseImpl\n+ 2 JsonHandler.kt\ncom/withorb/api/core/handlers/JsonHandler\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 HttpRequestBodies.kt\ncom/withorb/api/core/http/HttpRequestBodies\n*L\n1#1,421:1\n13#2,8:422\n13#2,8:430\n13#2,8:438\n13#2,8:446\n13#2,8:454\n13#2,8:462\n1#3:470\n21#4:471\n33#4:472\n21#4:473\n33#4:474\n21#4:475\n33#4:476\n*S KotlinDebug\n*F\n+ 1 CustomerServiceImpl.kt\ncom/withorb/api/services/blocking/CustomerServiceImpl$WithRawResponseImpl\n*L\n155#1:422,8\n183#1:430,8\n214#1:438,8\n271#1:446,8\n301#1:454,8\n390#1:462,8\n166#1:471\n166#1:472\n197#1:473\n197#1:474\n404#1:475\n404#1:476\n*E\n"})
    public static final class WithRawResponseImpl
    implements CustomerService.WithRawResponse {
        @NotNull
        private final ClientOptions clientOptions;
        @NotNull
        private final HttpResponse.Handler<JsonValue> errorHandler;
        @NotNull
        private final Lazy costs$delegate;
        @NotNull
        private final Lazy credits$delegate;
        @NotNull
        private final Lazy balanceTransactions$delegate;
        @NotNull
        private final HttpResponse.Handler<Customer> createHandler;
        @NotNull
        private final HttpResponse.Handler<Customer> updateHandler;
        @NotNull
        private final HttpResponse.Handler<CustomerListPageResponse> listHandler;
        @NotNull
        private final HttpResponse.Handler<Void> deleteHandler;
        @NotNull
        private final HttpResponse.Handler<Customer> fetchHandler;
        @NotNull
        private final HttpResponse.Handler<Customer> fetchByExternalIdHandler;
        @NotNull
        private final HttpResponse.Handler<Void> syncPaymentMethodsFromGatewayHandler;
        @NotNull
        private final HttpResponse.Handler<Void> syncPaymentMethodsFromGatewayByExternalCustomerIdHandler;
        @NotNull
        private final HttpResponse.Handler<Customer> updateByExternalIdHandler;

        public WithRawResponseImpl(@NotNull ClientOptions clientOptions) {
            Intrinsics.checkNotNullParameter((Object)clientOptions, (String)"clientOptions");
            this.clientOptions = clientOptions;
            this.errorHandler = ErrorHandler.errorHandler(this.clientOptions.jsonMapper());
            this.costs$delegate = LazyKt.lazy((Function0)((Function0)new Function0<CostServiceImpl.WithRawResponseImpl>(this){
                final /* synthetic */ WithRawResponseImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final CostServiceImpl.WithRawResponseImpl invoke() {
                    return new CostServiceImpl.WithRawResponseImpl(WithRawResponseImpl.access$getClientOptions$p(this.this$0));
                }
            }));
            this.credits$delegate = LazyKt.lazy((Function0)((Function0)new Function0<CreditServiceImpl.WithRawResponseImpl>(this){
                final /* synthetic */ WithRawResponseImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final CreditServiceImpl.WithRawResponseImpl invoke() {
                    return new CreditServiceImpl.WithRawResponseImpl(WithRawResponseImpl.access$getClientOptions$p(this.this$0));
                }
            }));
            this.balanceTransactions$delegate = LazyKt.lazy((Function0)((Function0)new Function0<BalanceTransactionServiceImpl.WithRawResponseImpl>(this){
                final /* synthetic */ WithRawResponseImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final BalanceTransactionServiceImpl.WithRawResponseImpl invoke() {
                    return new BalanceTransactionServiceImpl.WithRawResponseImpl(WithRawResponseImpl.access$getClientOptions$p(this.this$0));
                }
            }));
            JsonMapper jsonMapper$iv = this.clientOptions.jsonMapper();
            boolean $i$f$jsonHandler = false;
            this.createHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<Customer>(jsonMapper$iv){
                final /* synthetic */ JsonMapper $jsonMapper;
                {
                    this.$jsonMapper = $jsonMapper;
                }

                public Customer handle(@NotNull HttpResponse response) {
                    Object object;
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    try {
                        boolean $i$f$jacksonTypeRef = false;
                        object = this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<Customer>(){});
                    }
                    catch (Exception e) {
                        throw new OrbInvalidDataException("Error reading response", e);
                    }
                    return object;
                }
            }, this.errorHandler);
            jsonMapper$iv = this.clientOptions.jsonMapper();
            $i$f$jsonHandler = false;
            this.updateHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<Customer>(jsonMapper$iv){
                final /* synthetic */ JsonMapper $jsonMapper;
                {
                    this.$jsonMapper = $jsonMapper;
                }

                public Customer handle(@NotNull HttpResponse response) {
                    Object object;
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    try {
                        boolean $i$f$jacksonTypeRef = false;
                        object = this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<Customer>(){});
                    }
                    catch (Exception e) {
                        throw new OrbInvalidDataException("Error reading response", e);
                    }
                    return object;
                }
            }, this.errorHandler);
            jsonMapper$iv = this.clientOptions.jsonMapper();
            $i$f$jsonHandler = false;
            this.listHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<CustomerListPageResponse>(jsonMapper$iv){
                final /* synthetic */ JsonMapper $jsonMapper;
                {
                    this.$jsonMapper = $jsonMapper;
                }

                public CustomerListPageResponse handle(@NotNull HttpResponse response) {
                    Object object;
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    try {
                        boolean $i$f$jacksonTypeRef = false;
                        object = this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<CustomerListPageResponse>(){});
                    }
                    catch (Exception e) {
                        throw new OrbInvalidDataException("Error reading response", e);
                    }
                    return object;
                }
            }, this.errorHandler);
            this.deleteHandler = ErrorHandler.withErrorHandler(EmptyHandler.emptyHandler(), this.errorHandler);
            jsonMapper$iv = this.clientOptions.jsonMapper();
            $i$f$jsonHandler = false;
            this.fetchHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<Customer>(jsonMapper$iv){
                final /* synthetic */ JsonMapper $jsonMapper;
                {
                    this.$jsonMapper = $jsonMapper;
                }

                public Customer handle(@NotNull HttpResponse response) {
                    Object object;
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    try {
                        boolean $i$f$jacksonTypeRef = false;
                        object = this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<Customer>(){});
                    }
                    catch (Exception e) {
                        throw new OrbInvalidDataException("Error reading response", e);
                    }
                    return object;
                }
            }, this.errorHandler);
            jsonMapper$iv = this.clientOptions.jsonMapper();
            $i$f$jsonHandler = false;
            this.fetchByExternalIdHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<Customer>(jsonMapper$iv){
                final /* synthetic */ JsonMapper $jsonMapper;
                {
                    this.$jsonMapper = $jsonMapper;
                }

                public Customer handle(@NotNull HttpResponse response) {
                    Object object;
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    try {
                        boolean $i$f$jacksonTypeRef = false;
                        object = this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<Customer>(){});
                    }
                    catch (Exception e) {
                        throw new OrbInvalidDataException("Error reading response", e);
                    }
                    return object;
                }
            }, this.errorHandler);
            this.syncPaymentMethodsFromGatewayHandler = ErrorHandler.withErrorHandler(EmptyHandler.emptyHandler(), this.errorHandler);
            this.syncPaymentMethodsFromGatewayByExternalCustomerIdHandler = ErrorHandler.withErrorHandler(EmptyHandler.emptyHandler(), this.errorHandler);
            jsonMapper$iv = this.clientOptions.jsonMapper();
            $i$f$jsonHandler = false;
            this.updateByExternalIdHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<Customer>(jsonMapper$iv){
                final /* synthetic */ JsonMapper $jsonMapper;
                {
                    this.$jsonMapper = $jsonMapper;
                }

                public Customer handle(@NotNull HttpResponse response) {
                    Object object;
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    try {
                        boolean $i$f$jacksonTypeRef = false;
                        object = this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<Customer>(){});
                    }
                    catch (Exception e) {
                        throw new OrbInvalidDataException("Error reading response", e);
                    }
                    return object;
                }
            }, this.errorHandler);
        }

        private final CostService.WithRawResponse getCosts() {
            Lazy lazy = this.costs$delegate;
            return (CostService.WithRawResponse)lazy.getValue();
        }

        private final CreditService.WithRawResponse getCredits() {
            Lazy lazy = this.credits$delegate;
            return (CreditService.WithRawResponse)lazy.getValue();
        }

        private final BalanceTransactionService.WithRawResponse getBalanceTransactions() {
            Lazy lazy = this.balanceTransactions$delegate;
            return (BalanceTransactionService.WithRawResponse)lazy.getValue();
        }

        @Override
        @NotNull
        public CustomerService.WithRawResponse withOptions(@NotNull Consumer<ClientOptions.Builder> modifier) {
            ClientOptions.Builder builder;
            Intrinsics.checkNotNullParameter(modifier, (String)"modifier");
            ClientOptions.Builder p0 = builder = this.clientOptions.toBuilder();
            boolean bl = false;
            modifier.accept(p0);
            ClientOptions clientOptions = builder.build();
            return new WithRawResponseImpl(clientOptions);
        }

        @Override
        @NotNull
        public CostService.WithRawResponse costs() {
            return this.getCosts();
        }

        @Override
        @NotNull
        public CreditService.WithRawResponse credits() {
            return this.getCredits();
        }

        @Override
        @NotNull
        public BalanceTransactionService.WithRawResponse balanceTransactions() {
            return this.getBalanceTransactions();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public HttpResponseFor<Customer> create(@NotNull CustomerCreateParams params, @NotNull RequestOptions requestOptions) {
            void jsonMapper$iv;
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
            String[] stringArray = new String[]{"customers"};
            HttpRequest.Builder builder = HttpRequest.Companion.builder().method(HttpMethod.POST).baseUrl(this.clientOptions.baseUrl()).addPathSegments(stringArray);
            stringArray = this.clientOptions.jsonMapper();
            CustomerCreateParams.Body value$iv = params._body();
            boolean $i$f$json = false;
            HttpRequest request2 = PrepareRequest.prepare(builder.body(new HttpRequestBody((JsonMapper)jsonMapper$iv, value$iv){
                @NotNull
                private final Lazy bytes$delegate;
                {
                    this.bytes$delegate = LazyKt.lazy((Function0)((Function0)new Function0<byte[]>($jsonMapper, $value){
                        final /* synthetic */ JsonMapper $jsonMapper;
                        final /* synthetic */ T $value;
                        {
                            this.$jsonMapper = $jsonMapper;
                            this.$value = $value;
                            super(0);
                        }

                        public final byte[] invoke() {
                            return this.$jsonMapper.writeValueAsBytes(this.$value);
                        }
                    }));
                }

                private final byte[] getBytes() {
                    Lazy lazy = this.bytes$delegate;
                    Object object = lazy.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
                    return (byte[])object;
                }

                public void writeTo(@NotNull OutputStream outputStream) {
                    Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                    outputStream.write(this.getBytes());
                }

                @NotNull
                public String contentType() {
                    return "application/json";
                }

                public long contentLength() {
                    return this.getBytes().length;
                }

                public boolean repeatable() {
                    return true;
                }

                public void close() {
                }
            }).build(), this.clientOptions, params);
            RequestOptions requestOptions2 = requestOptions.applyDefaults(RequestOptions.Companion.from$orb_java_core(this.clientOptions));
            HttpResponse response = this.clientOptions.httpClient().execute(request2, requestOptions2);
            return HttpResponseForKt.parseable(response, (Function0)new Function0<Customer>(response, this, requestOptions2){
                final /* synthetic */ HttpResponse $response;
                final /* synthetic */ WithRawResponseImpl this$0;
                final /* synthetic */ RequestOptions $requestOptions;
                {
                    this.$response = $response;
                    this.this$0 = $receiver;
                    this.$requestOptions = $requestOptions;
                    super(0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @NotNull
                public final Customer invoke() {
                    Object object = this.$response;
                    Object object2 = this.this$0;
                    Throwable throwable = null;
                    try {
                        Object it = (HttpResponse)object;
                        boolean bl = false;
                        it = (Customer)WithRawResponseImpl.access$getCreateHandler$p((WithRawResponseImpl)object2).handle((HttpResponse)it);
                    }
                    catch (Throwable it) {
                        throwable = it;
                        throw it;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
                    }
                    object = it;
                    object2 = this.$requestOptions;
                    Object it = object;
                    boolean bl = false;
                    Boolean bl2 = ((RequestOptions)object2).getResponseValidation();
                    Intrinsics.checkNotNull((Object)bl2);
                    if (bl2.booleanValue()) {
                        ((Customer)it).validate();
                    }
                    return object;
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public HttpResponseFor<Customer> update(@NotNull CustomerUpdateParams params, @NotNull RequestOptions requestOptions) {
            void jsonMapper$iv;
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
            Check.checkRequired("customerId", OptionalsKt.getOrNull(params.customerId()));
            String[] stringArray = new String[]{"customers", params._pathParam(0)};
            HttpRequest.Builder builder = HttpRequest.Companion.builder().method(HttpMethod.PUT).baseUrl(this.clientOptions.baseUrl()).addPathSegments(stringArray);
            stringArray = this.clientOptions.jsonMapper();
            CustomerUpdateParams.Body value$iv = params._body();
            boolean $i$f$json = false;
            HttpRequest request2 = PrepareRequest.prepare(builder.body(new /* invalid duplicate definition of identical inner class */).build(), this.clientOptions, params);
            RequestOptions requestOptions2 = requestOptions.applyDefaults(RequestOptions.Companion.from$orb_java_core(this.clientOptions));
            HttpResponse response = this.clientOptions.httpClient().execute(request2, requestOptions2);
            return HttpResponseForKt.parseable(response, (Function0)new Function0<Customer>(response, this, requestOptions2){
                final /* synthetic */ HttpResponse $response;
                final /* synthetic */ WithRawResponseImpl this$0;
                final /* synthetic */ RequestOptions $requestOptions;
                {
                    this.$response = $response;
                    this.this$0 = $receiver;
                    this.$requestOptions = $requestOptions;
                    super(0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @NotNull
                public final Customer invoke() {
                    Object object = this.$response;
                    Object object2 = this.this$0;
                    Throwable throwable = null;
                    try {
                        Object it = (HttpResponse)object;
                        boolean bl = false;
                        it = (Customer)WithRawResponseImpl.access$getUpdateHandler$p((WithRawResponseImpl)object2).handle((HttpResponse)it);
                    }
                    catch (Throwable it) {
                        throwable = it;
                        throw it;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
                    }
                    object = it;
                    object2 = this.$requestOptions;
                    Object it = object;
                    boolean bl = false;
                    Boolean bl2 = ((RequestOptions)object2).getResponseValidation();
                    Intrinsics.checkNotNull((Object)bl2);
                    if (bl2.booleanValue()) {
                        ((Customer)it).validate();
                    }
                    return object;
                }
            });
        }

        @Override
        @NotNull
        public HttpResponseFor<CustomerListPage> list(@NotNull CustomerListParams params, @NotNull RequestOptions requestOptions) {
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
            String[] stringArray = new String[]{"customers"};
            HttpRequest request2 = PrepareRequest.prepare(HttpRequest.Companion.builder().method(HttpMethod.GET).baseUrl(this.clientOptions.baseUrl()).addPathSegments(stringArray).build(), this.clientOptions, params);
            RequestOptions requestOptions2 = requestOptions.applyDefaults(RequestOptions.Companion.from$orb_java_core(this.clientOptions));
            HttpResponse response = this.clientOptions.httpClient().execute(request2, requestOptions2);
            return HttpResponseForKt.parseable(response, (Function0)new Function0<CustomerListPage>(response, this, requestOptions2, params){
                final /* synthetic */ HttpResponse $response;
                final /* synthetic */ WithRawResponseImpl this$0;
                final /* synthetic */ RequestOptions $requestOptions;
                final /* synthetic */ CustomerListParams $params;
                {
                    this.$response = $response;
                    this.this$0 = $receiver;
                    this.$requestOptions = $requestOptions;
                    this.$params = $params;
                    super(0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @NotNull
                public final CustomerListPage invoke() {
                    Object object = this.$response;
                    Object object2 = this.this$0;
                    Object object3 = null;
                    try {
                        Object it = (HttpResponse)object;
                        boolean bl = false;
                        it = (CustomerListPageResponse)WithRawResponseImpl.access$getListHandler$p((WithRawResponseImpl)object2).handle((HttpResponse)it);
                    }
                    catch (Throwable it) {
                        object3 = it;
                        throw it;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)object3);
                    }
                    object = it;
                    object2 = this.$requestOptions;
                    Object it = object;
                    boolean bl = false;
                    Boolean bl2 = ((RequestOptions)object2).getResponseValidation();
                    Intrinsics.checkNotNull((Object)bl2);
                    if (bl2.booleanValue()) {
                        ((CustomerListPageResponse)it).validate();
                    }
                    object2 = this.this$0;
                    object3 = this.$params;
                    Object it2 = object;
                    boolean bl3 = false;
                    return CustomerListPage.Companion.builder().service(new CustomerServiceImpl(WithRawResponseImpl.access$getClientOptions$p((WithRawResponseImpl)object2))).params((CustomerListParams)object3).response((CustomerListPageResponse)it2).build();
                }
            });
        }

        @Override
        @NotNull
        public HttpResponse delete(@NotNull CustomerDeleteParams params, @NotNull RequestOptions requestOptions) {
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
            Check.checkRequired("customerId", OptionalsKt.getOrNull(params.customerId()));
            Object object = new String[]{"customers", params._pathParam(0)};
            Object $this$delete_u24lambda_u241 = object = HttpRequest.Companion.builder().method(HttpMethod.DELETE).baseUrl(this.clientOptions.baseUrl()).addPathSegments((String[])object);
            boolean bl = false;
            params._body().ifPresent(arg_0 -> WithRawResponseImpl.delete$lambda$1$lambda$0((Function1)new Function1<Map<String, ? extends JsonValue>, Unit>((HttpRequest.Builder)$this$delete_u24lambda_u241, this){
                final /* synthetic */ HttpRequest.Builder $this_apply;
                final /* synthetic */ WithRawResponseImpl this$0;
                {
                    this.$this_apply = $receiver;
                    this.this$0 = $receiver2;
                    super(1);
                }

                public final void invoke(@NotNull Map<String, ? extends JsonValue> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    JsonMapper jsonMapper$iv = WithRawResponseImpl.access$getClientOptions$p(this.this$0).jsonMapper();
                    boolean $i$f$json = false;
                    this.$this_apply.body(new /* invalid duplicate definition of identical inner class */);
                }
            }, arg_0));
            HttpRequest request2 = PrepareRequest.prepare(((HttpRequest.Builder)object).build(), this.clientOptions, params);
            RequestOptions requestOptions2 = requestOptions.applyDefaults(RequestOptions.Companion.from$orb_java_core(this.clientOptions));
            HttpResponse response = this.clientOptions.httpClient().execute(request2, requestOptions2);
            return HttpResponseForKt.parseable(response, (Function0)new Function0<Void>(response, this){
                final /* synthetic */ HttpResponse $response;
                final /* synthetic */ WithRawResponseImpl this$0;
                {
                    this.$response = $response;
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Nullable
                public final Void invoke() {
                    Void void_;
                    AutoCloseable autoCloseable = this.$response;
                    WithRawResponseImpl withRawResponseImpl = this.this$0;
                    Throwable throwable = null;
                    try {
                        HttpResponse it = (HttpResponse)autoCloseable;
                        boolean bl = false;
                        void_ = (Void)WithRawResponseImpl.access$getDeleteHandler$p(withRawResponseImpl).handle(it);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                    }
                    return void_;
                }
            });
        }

        @Override
        @NotNull
        public HttpResponseFor<Customer> fetch(@NotNull CustomerFetchParams params, @NotNull RequestOptions requestOptions) {
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
            Check.checkRequired("customerId", OptionalsKt.getOrNull(params.customerId()));
            String[] stringArray = new String[]{"customers", params._pathParam(0)};
            HttpRequest request2 = PrepareRequest.prepare(HttpRequest.Companion.builder().method(HttpMethod.GET).baseUrl(this.clientOptions.baseUrl()).addPathSegments(stringArray).build(), this.clientOptions, params);
            RequestOptions requestOptions2 = requestOptions.applyDefaults(RequestOptions.Companion.from$orb_java_core(this.clientOptions));
            HttpResponse response = this.clientOptions.httpClient().execute(request2, requestOptions2);
            return HttpResponseForKt.parseable(response, (Function0)new Function0<Customer>(response, this, requestOptions2){
                final /* synthetic */ HttpResponse $response;
                final /* synthetic */ WithRawResponseImpl this$0;
                final /* synthetic */ RequestOptions $requestOptions;
                {
                    this.$response = $response;
                    this.this$0 = $receiver;
                    this.$requestOptions = $requestOptions;
                    super(0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @NotNull
                public final Customer invoke() {
                    Object object = this.$response;
                    Object object2 = this.this$0;
                    Throwable throwable = null;
                    try {
                        Object it = (HttpResponse)object;
                        boolean bl = false;
                        it = (Customer)WithRawResponseImpl.access$getFetchHandler$p((WithRawResponseImpl)object2).handle((HttpResponse)it);
                    }
                    catch (Throwable it) {
                        throwable = it;
                        throw it;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
                    }
                    object = it;
                    object2 = this.$requestOptions;
                    Object it = object;
                    boolean bl = false;
                    Boolean bl2 = ((RequestOptions)object2).getResponseValidation();
                    Intrinsics.checkNotNull((Object)bl2);
                    if (bl2.booleanValue()) {
                        ((Customer)it).validate();
                    }
                    return object;
                }
            });
        }

        @Override
        @NotNull
        public HttpResponseFor<Customer> fetchByExternalId(@NotNull CustomerFetchByExternalIdParams params, @NotNull RequestOptions requestOptions) {
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
            Check.checkRequired("externalCustomerId", OptionalsKt.getOrNull(params.externalCustomerId()));
            String[] stringArray = new String[]{"customers", "external_customer_id", params._pathParam(0)};
            HttpRequest request2 = PrepareRequest.prepare(HttpRequest.Companion.builder().method(HttpMethod.GET).baseUrl(this.clientOptions.baseUrl()).addPathSegments(stringArray).build(), this.clientOptions, params);
            RequestOptions requestOptions2 = requestOptions.applyDefaults(RequestOptions.Companion.from$orb_java_core(this.clientOptions));
            HttpResponse response = this.clientOptions.httpClient().execute(request2, requestOptions2);
            return HttpResponseForKt.parseable(response, (Function0)new Function0<Customer>(response, this, requestOptions2){
                final /* synthetic */ HttpResponse $response;
                final /* synthetic */ WithRawResponseImpl this$0;
                final /* synthetic */ RequestOptions $requestOptions;
                {
                    this.$response = $response;
                    this.this$0 = $receiver;
                    this.$requestOptions = $requestOptions;
                    super(0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @NotNull
                public final Customer invoke() {
                    Object object = this.$response;
                    Object object2 = this.this$0;
                    Throwable throwable = null;
                    try {
                        Object it = (HttpResponse)object;
                        boolean bl = false;
                        it = (Customer)WithRawResponseImpl.access$getFetchByExternalIdHandler$p((WithRawResponseImpl)object2).handle((HttpResponse)it);
                    }
                    catch (Throwable it) {
                        throwable = it;
                        throw it;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
                    }
                    object = it;
                    object2 = this.$requestOptions;
                    Object it = object;
                    boolean bl = false;
                    Boolean bl2 = ((RequestOptions)object2).getResponseValidation();
                    Intrinsics.checkNotNull((Object)bl2);
                    if (bl2.booleanValue()) {
                        ((Customer)it).validate();
                    }
                    return object;
                }
            });
        }

        @Override
        @NotNull
        public HttpResponse syncPaymentMethodsFromGateway(@NotNull CustomerSyncPaymentMethodsFromGatewayParams params, @NotNull RequestOptions requestOptions) {
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
            Check.checkRequired("customerId", OptionalsKt.getOrNull(params.customerId()));
            Object object = new String[]{"customers", params._pathParam(0), "sync_payment_methods_from_gateway"};
            Object $this$syncPaymentMethodsFromGateway_u24lambda_u243 = object = HttpRequest.Companion.builder().method(HttpMethod.POST).baseUrl(this.clientOptions.baseUrl()).addPathSegments((String[])object);
            boolean bl = false;
            params._body().ifPresent(arg_0 -> WithRawResponseImpl.syncPaymentMethodsFromGateway$lambda$3$lambda$2((Function1)new Function1<Map<String, ? extends JsonValue>, Unit>((HttpRequest.Builder)$this$syncPaymentMethodsFromGateway_u24lambda_u243, this){
                final /* synthetic */ HttpRequest.Builder $this_apply;
                final /* synthetic */ WithRawResponseImpl this$0;
                {
                    this.$this_apply = $receiver;
                    this.this$0 = $receiver2;
                    super(1);
                }

                public final void invoke(@NotNull Map<String, ? extends JsonValue> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    JsonMapper jsonMapper$iv = WithRawResponseImpl.access$getClientOptions$p(this.this$0).jsonMapper();
                    boolean $i$f$json = false;
                    this.$this_apply.body(new /* invalid duplicate definition of identical inner class */);
                }
            }, arg_0));
            HttpRequest request2 = PrepareRequest.prepare(((HttpRequest.Builder)object).build(), this.clientOptions, params);
            RequestOptions requestOptions2 = requestOptions.applyDefaults(RequestOptions.Companion.from$orb_java_core(this.clientOptions));
            HttpResponse response = this.clientOptions.httpClient().execute(request2, requestOptions2);
            return HttpResponseForKt.parseable(response, (Function0)new Function0<Void>(response, this){
                final /* synthetic */ HttpResponse $response;
                final /* synthetic */ WithRawResponseImpl this$0;
                {
                    this.$response = $response;
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Nullable
                public final Void invoke() {
                    Void void_;
                    AutoCloseable autoCloseable = this.$response;
                    WithRawResponseImpl withRawResponseImpl = this.this$0;
                    Throwable throwable = null;
                    try {
                        HttpResponse it = (HttpResponse)autoCloseable;
                        boolean bl = false;
                        void_ = (Void)WithRawResponseImpl.access$getSyncPaymentMethodsFromGatewayHandler$p(withRawResponseImpl).handle(it);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                    }
                    return void_;
                }
            });
        }

        @Override
        @NotNull
        public HttpResponse syncPaymentMethodsFromGatewayByExternalCustomerId(@NotNull CustomerSyncPaymentMethodsFromGatewayByExternalCustomerIdParams params, @NotNull RequestOptions requestOptions) {
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
            Check.checkRequired("externalCustomerId", OptionalsKt.getOrNull(params.externalCustomerId()));
            Object object = new String[]{"customers", "external_customer_id", params._pathParam(0), "sync_payment_methods_from_gateway"};
            Object $this$syncPaymentMethodsFromGatewayByExternalCustomerId_u24lambda_u245 = object = HttpRequest.Companion.builder().method(HttpMethod.POST).baseUrl(this.clientOptions.baseUrl()).addPathSegments((String[])object);
            boolean bl = false;
            params._body().ifPresent(arg_0 -> WithRawResponseImpl.syncPaymentMethodsFromGatewayByExternalCustomerId$lambda$5$lambda$4((Function1)new Function1<Map<String, ? extends JsonValue>, Unit>((HttpRequest.Builder)$this$syncPaymentMethodsFromGatewayByExternalCustomerId_u24lambda_u245, this){
                final /* synthetic */ HttpRequest.Builder $this_apply;
                final /* synthetic */ WithRawResponseImpl this$0;
                {
                    this.$this_apply = $receiver;
                    this.this$0 = $receiver2;
                    super(1);
                }

                public final void invoke(@NotNull Map<String, ? extends JsonValue> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    JsonMapper jsonMapper$iv = WithRawResponseImpl.access$getClientOptions$p(this.this$0).jsonMapper();
                    boolean $i$f$json = false;
                    this.$this_apply.body(new /* invalid duplicate definition of identical inner class */);
                }
            }, arg_0));
            HttpRequest request2 = PrepareRequest.prepare(((HttpRequest.Builder)object).build(), this.clientOptions, params);
            RequestOptions requestOptions2 = requestOptions.applyDefaults(RequestOptions.Companion.from$orb_java_core(this.clientOptions));
            HttpResponse response = this.clientOptions.httpClient().execute(request2, requestOptions2);
            return HttpResponseForKt.parseable(response, (Function0)new Function0<Void>(response, this){
                final /* synthetic */ HttpResponse $response;
                final /* synthetic */ WithRawResponseImpl this$0;
                {
                    this.$response = $response;
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Nullable
                public final Void invoke() {
                    Void void_;
                    AutoCloseable autoCloseable = this.$response;
                    WithRawResponseImpl withRawResponseImpl = this.this$0;
                    Throwable throwable = null;
                    try {
                        HttpResponse it = (HttpResponse)autoCloseable;
                        boolean bl = false;
                        void_ = (Void)WithRawResponseImpl.access$getSyncPaymentMethodsFromGatewayByExternalCustomerIdHandler$p(withRawResponseImpl).handle(it);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                    }
                    return void_;
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public HttpResponseFor<Customer> updateByExternalId(@NotNull CustomerUpdateByExternalIdParams params, @NotNull RequestOptions requestOptions) {
            void jsonMapper$iv;
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
            Check.checkRequired("id", OptionalsKt.getOrNull(params.id()));
            String[] stringArray = new String[]{"customers", "external_customer_id", params._pathParam(0)};
            HttpRequest.Builder builder = HttpRequest.Companion.builder().method(HttpMethod.PUT).baseUrl(this.clientOptions.baseUrl()).addPathSegments(stringArray);
            stringArray = this.clientOptions.jsonMapper();
            CustomerUpdateByExternalIdParams.Body value$iv = params._body();
            boolean $i$f$json = false;
            HttpRequest request2 = PrepareRequest.prepare(builder.body(new /* invalid duplicate definition of identical inner class */).build(), this.clientOptions, params);
            RequestOptions requestOptions2 = requestOptions.applyDefaults(RequestOptions.Companion.from$orb_java_core(this.clientOptions));
            HttpResponse response = this.clientOptions.httpClient().execute(request2, requestOptions2);
            return HttpResponseForKt.parseable(response, (Function0)new Function0<Customer>(response, this, requestOptions2){
                final /* synthetic */ HttpResponse $response;
                final /* synthetic */ WithRawResponseImpl this$0;
                final /* synthetic */ RequestOptions $requestOptions;
                {
                    this.$response = $response;
                    this.this$0 = $receiver;
                    this.$requestOptions = $requestOptions;
                    super(0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @NotNull
                public final Customer invoke() {
                    Object object = this.$response;
                    Object object2 = this.this$0;
                    Throwable throwable = null;
                    try {
                        Object it = (HttpResponse)object;
                        boolean bl = false;
                        it = (Customer)WithRawResponseImpl.access$getUpdateByExternalIdHandler$p((WithRawResponseImpl)object2).handle((HttpResponse)it);
                    }
                    catch (Throwable it) {
                        throwable = it;
                        throw it;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
                    }
                    object = it;
                    object2 = this.$requestOptions;
                    Object it = object;
                    boolean bl = false;
                    Boolean bl2 = ((RequestOptions)object2).getResponseValidation();
                    Intrinsics.checkNotNull((Object)bl2);
                    if (bl2.booleanValue()) {
                        ((Customer)it).validate();
                    }
                    return object;
                }
            });
        }

        private static final void delete$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }

        private static final void syncPaymentMethodsFromGateway$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }

        private static final void syncPaymentMethodsFromGatewayByExternalCustomerId$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }

        public static final /* synthetic */ HttpResponse.Handler access$getCreateHandler$p(WithRawResponseImpl $this) {
            return $this.createHandler;
        }

        public static final /* synthetic */ HttpResponse.Handler access$getUpdateHandler$p(WithRawResponseImpl $this) {
            return $this.updateHandler;
        }

        public static final /* synthetic */ HttpResponse.Handler access$getListHandler$p(WithRawResponseImpl $this) {
            return $this.listHandler;
        }

        public static final /* synthetic */ ClientOptions access$getClientOptions$p(WithRawResponseImpl $this) {
            return $this.clientOptions;
        }

        public static final /* synthetic */ HttpResponse.Handler access$getDeleteHandler$p(WithRawResponseImpl $this) {
            return $this.deleteHandler;
        }

        public static final /* synthetic */ HttpResponse.Handler access$getFetchHandler$p(WithRawResponseImpl $this) {
            return $this.fetchHandler;
        }

        public static final /* synthetic */ HttpResponse.Handler access$getFetchByExternalIdHandler$p(WithRawResponseImpl $this) {
            return $this.fetchByExternalIdHandler;
        }

        public static final /* synthetic */ HttpResponse.Handler access$getSyncPaymentMethodsFromGatewayHandler$p(WithRawResponseImpl $this) {
            return $this.syncPaymentMethodsFromGatewayHandler;
        }

        public static final /* synthetic */ HttpResponse.Handler access$getSyncPaymentMethodsFromGatewayByExternalCustomerIdHandler$p(WithRawResponseImpl $this) {
            return $this.syncPaymentMethodsFromGatewayByExternalCustomerIdHandler;
        }

        public static final /* synthetic */ HttpResponse.Handler access$getUpdateByExternalIdHandler$p(WithRawResponseImpl $this) {
            return $this.updateByExternalIdHandler;
        }
    }
}

