/*
 * Decompiled with CFR 0.152.
 */
package com.withorb.api.services.blocking;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.withorb.api.core.ClientOptions;
import com.withorb.api.core.JsonValue;
import com.withorb.api.core.Utils;
import com.withorb.api.core.http.Headers;
import com.withorb.api.errors.OrbException;
import com.withorb.api.services.blocking.WebhookService;
import java.security.MessageDigest;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.ExperimentalStdlibApi;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.HexExtensionsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0017J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/withorb/api/services/blocking/WebhookServiceImpl;", "Lcom/withorb/api/services/blocking/WebhookService;", "clientOptions", "Lcom/withorb/api/core/ClientOptions;", "(Lcom/withorb/api/core/ClientOptions;)V", "unwrap", "Lcom/withorb/api/core/JsonValue;", "payload", "", "headers", "Lcom/withorb/api/core/http/Headers;", "secret", "verifySignature", "", "orb-java-core"})
@SourceDebugExtension(value={"SMAP\nWebhookServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebhookServiceImpl.kt\ncom/withorb/api/services/blocking/WebhookServiceImpl\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,97:1\n1313#2,2:98\n*S KotlinDebug\n*F\n+ 1 WebhookServiceImpl.kt\ncom/withorb/api/services/blocking/WebhookServiceImpl\n*L\n73#1:98,2\n*E\n"})
public final class WebhookServiceImpl
implements WebhookService {
    @NotNull
    private final ClientOptions clientOptions;

    public WebhookServiceImpl(@NotNull ClientOptions clientOptions) {
        Intrinsics.checkNotNullParameter((Object)clientOptions, (String)"clientOptions");
        this.clientOptions = clientOptions;
    }

    @Override
    @ExperimentalStdlibApi
    @NotNull
    public JsonValue unwrap(@NotNull String payload, @NotNull Headers headers, @Nullable String secret) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        this.verifySignature(payload, headers, secret);
        try {
            object = this.clientOptions.jsonMapper().readValue(payload, JsonValue.class);
            Intrinsics.checkNotNull((Object)object);
            object = (JsonValue)object;
        }
        catch (JsonProcessingException e) {
            throw new OrbException("Invalid event payload", e);
        }
        return object;
    }

    @Override
    @ExperimentalStdlibApi
    public void verifySignature(@NotNull String payload, @NotNull Headers headers, @Nullable String secret) {
        Instant instant;
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        String string = secret;
        if (string == null && (string = (String)OptionalsKt.getOrNull(this.clientOptions.webhookSecret())) == null) {
            throw new OrbException("The webhook secret must either be set using the env var, ORB_WEBHOOK_SECRET, on the client class, or passed to this method", null, 2, null);
        }
        String webhookSecret = string;
        String msgSignature = Utils.getRequiredHeader(headers, "X-Orb-Signature");
        String msgTimestamp = Utils.getRequiredHeader(headers, "X-Orb-Timestamp");
        try {
            instant = LocalDateTime.parse(msgTimestamp).toInstant(ZoneOffset.UTC);
        }
        catch (RuntimeException e) {
            throw new OrbException("Invalid timestamp header", e);
        }
        Instant timestamp = instant;
        Instant now = Instant.now(this.clientOptions.clock());
        if (timestamp.isBefore(now.minus(Duration.ofMinutes(5L)))) {
            throw new OrbException("Webhook timestamp too old", null, 2, null);
        }
        if (timestamp.isAfter(now.plus(Duration.ofMinutes(5L)))) {
            throw new OrbException("Webhook timestamp too new", null, 2, null);
        }
        Mac mac = Mac.getInstance("HmacSHA256");
        byte[] byArray = webhookSecret.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        mac.init(new SecretKeySpec(byArray, "HmacSHA256"));
        byte[] byArray2 = ("v1:" + msgTimestamp + ':' + payload).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        byte[] byArray3 = mac.doFinal(byArray2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"doFinal(...)");
        String expectedSignature = HexExtensionsKt.toHexString$default((byte[])byArray3, null, (int)1, null);
        String[] stringArray = new String[]{" "};
        Sequence $this$forEach$iv = StringsKt.splitToSequence$default((CharSequence)msgSignature, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            byte[] actualSignature;
            String it = (String)element$iv;
            boolean bl = false;
            String[] stringArray2 = new String[]{"="};
            List parts = StringsKt.split$default((CharSequence)it, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
            if (parts.size() != 2 || !Intrinsics.areEqual(parts.get(0), (Object)"v1")) continue;
            Intrinsics.checkNotNullExpressionValue((Object)((String)parts.get(1)).getBytes(Charsets.UTF_8), (String)"getBytes(...)");
            byte[] byArray4 = expectedSignature.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"getBytes(...)");
            if (!MessageDigest.isEqual(actualSignature, byArray4)) continue;
            return;
        }
        throw new OrbException("None of the given webhook signatures match the expected signature", null, 2, null);
    }
}

