/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.ucloud.core;

import com.xiaoleilu.hutool.Conver;
import com.xiaoleilu.hutool.HttpUtil;
import com.xiaoleilu.hutool.SecureUtil;
import com.xiaoleilu.hutool.StrUtil;
import com.xiaoleilu.ucloud.core.Action;
import com.xiaoleilu.ucloud.core.enums.PubName;
import com.xiaoleilu.ucloud.core.enums.Region;
import com.xiaoleilu.ucloud.exception.ParamException;
import com.xiaoleilu.ucloud.util.Config;
import com.xiaoleilu.ucloud.util.SignatureUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class Param
extends TreeMap<String, Object> {
    private static final long serialVersionUID = 1190594719758105119L;

    public static Param create() {
        return new Param();
    }

    public static Param create(String name, Object value) {
        return new Param().set(name, value);
    }

    public static Param create(Name name, Object value) {
        return new Param().set(name, value);
    }

    public static Param create(Map<String, Object> paramMap) {
        return new Param().setAll(paramMap);
    }

    public Param set(String name, Object value) {
        if (null != name && null != value) {
            this.put(name, value);
        }
        return this;
    }

    public Param set(Name paramName, Object value) {
        return this.set(paramName.toString(), value);
    }

    public Param setAction(Action action) {
        return this.set(PubName.Action, (Object)action);
    }

    public Param setRegion(Region region) {
        return this.set(PubName.Region, (Object)region);
    }

    public Param setPassword(String password) {
        return this.set(PubName.Password, (Object)SecureUtil.base64((String)password, (String)"UTF-8"));
    }

    public Param setOffset(int offset) {
        return this.set(PubName.Offset, (Object)offset);
    }

    public Param setLimit(int limit) {
        return this.set(PubName.Limit, (Object)limit);
    }

    public Param setAll(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public <T> T get(String attr, T defaultValue) {
        Object result = this.get(attr);
        return (T)(result != null ? result : defaultValue);
    }

    public String getStr(String attr) {
        return Conver.toStr(this.get(attr), null);
    }

    public Integer getInt(String attr) {
        return Conver.toInt(this.get(attr), null);
    }

    public Long getLong(String attr) {
        return Conver.toLong(this.get(attr), null);
    }

    public Float getFloat(String attr) {
        return Conver.toFloat(this.get(attr), null);
    }

    public Boolean getBool(String attr) {
        return Conver.toBool(this.get(attr), null);
    }

    public byte[] getBytes(String attr) {
        return this.get(attr, null);
    }

    public Date getDate(String attr) {
        return this.get(attr, null);
    }

    public Time getTime(String attr) {
        return this.get(attr, null);
    }

    public Timestamp getTimestamp(String attr) {
        return this.get(attr, null);
    }

    public Number getNumber(String attr) {
        return this.get(attr, null);
    }

    public BigDecimal getBigDecimal(String attr) {
        return this.get(attr, null);
    }

    public BigInteger getBigInteger(String attr) {
        return this.get(attr, null);
    }

    @Override
    public Param clone() {
        return (Param)super.clone();
    }

    public String signature(String privateKey) {
        return SignatureUtil.sign(this, privateKey);
    }

    public String encode() {
        Param param = this.clone();
        Set keys = param.keySet();
        for (String key : keys) {
            Object value = param.get(key);
            param.put(key, HttpUtil.encode((String)StrUtil.str((Object[])new Object[]{value}), (String)"UTF-8"));
        }
        return HttpUtil.toParams((Map)param);
    }

    public String genHttpParam(Config config) {
        this.assertParams(PubName.Action);
        this.set(PubName.PublicKey, (Object)config.getPublicKey());
        this.set(PubName.Signature, (Object)this.signature(config.getPrivateKey()));
        return this.encode();
    }

    private void assertParams(PubName ... paramNames) {
        for (PubName paramName : paramNames) {
            if (this.containsKey(paramName.name())) continue;
            throw new ParamException("Parameter '{}' not found!", paramName);
        }
    }

    public static interface Name {
        public String toString();
    }
}

