/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.ucloud.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xiaoleilu.hutool.StrUtil;
import com.xiaoleilu.ucloud.core.Response;

public class StandardResponse
implements Response {
    private JSONObject json;

    public static StandardResponse parse(String jsonStr) {
        return new StandardResponse(jsonStr);
    }

    public StandardResponse(String jsonStr) {
        if (StrUtil.isBlank((String)jsonStr)) {
            this.json = new JSONObject();
            this.json.put("RetCode", (Object)0);
        } else {
            this.json = JSON.parseObject((String)jsonStr);
        }
    }

    @Override
    public Object get(String key) {
        return this.json.get((Object)key);
    }

    @Override
    public int getRetCode() {
        return this.json.getIntValue("RetCode");
    }

    @Override
    public String getAction() {
        return this.json.getString("Action");
    }

    @Override
    public String getMessage() {
        return this.json.getString("Message");
    }

    @Override
    public int getTotalCount() {
        return this.json.getIntValue("TotalCount");
    }

    @Override
    public JSONObject getJson() {
        return this.json;
    }

    @Override
    public boolean isOk() {
        return 0 == this.getRetCode();
    }

    @Override
    public String toPretty() {
        return JSON.toJSONString((Object)this.json, (boolean)true);
    }

    public String toString() {
        return this.json.toJSONString();
    }
}

