/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.ucloud.core;

import com.alibaba.fastjson.JSONObject;
import com.xiaoleilu.hutool.HttpUtil;
import com.xiaoleilu.hutool.Log;
import com.xiaoleilu.hutool.StrUtil;
import com.xiaoleilu.hutool.log.LogWrapper;
import com.xiaoleilu.ucloud.core.Action;
import com.xiaoleilu.ucloud.core.Param;
import com.xiaoleilu.ucloud.core.StandardResponse;
import com.xiaoleilu.ucloud.util.Config;
import java.io.IOException;

public class UcloudApiClient {
    private static final LogWrapper log = Log.get();
    private Config config;

    public UcloudApiClient(Config config) {
        this.config = config;
    }

    public UcloudApiClient() {
        this.config = Config.createFromSetting();
    }

    public Config getConfig() {
        return this.config;
    }

    public String getForStr(String resource, Param param) {
        String uri = StrUtil.format((String)"{}{}?{}", (Object[])new Object[]{this.config.getBaseUrl(), resource, param.genHttpParam(this.config)});
        log.debug("Get: {}", (Object)uri);
        String resStr = null;
        try {
            resStr = HttpUtil.get((String)uri, (String)"UTF-8", (boolean)false);
        }
        catch (IOException e) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("RetCode", (Object)-1);
            jsonObject.put("Message", (Object)e.getMessage());
            resStr = jsonObject.toString();
        }
        return resStr;
    }

    public StandardResponse get(String resource, Param param) {
        if (param == null) {
            param = Param.create();
        }
        return StandardResponse.parse(this.getForStr(resource, param));
    }

    public StandardResponse get(Param param) {
        return this.get("/", param);
    }

    public StandardResponse get(Action action, Param param) {
        if (param == null) {
            param = Param.create();
        }
        param.setAction(action);
        return this.get("/", param);
    }
}

