/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.ucloud.ufile;

import com.xiaoleilu.hutool.Log;
import com.xiaoleilu.hutool.StrUtil;
import com.xiaoleilu.ucloud.core.Param;
import com.xiaoleilu.ucloud.util.Config;
import com.xiaoleilu.ucloud.util.SignatureUtil;
import java.util.Map;
import jodd.http.HttpRequest;
import org.slf4j.Logger;

public class Auth
implements Cloneable {
    private static final Logger log = Log.get();
    private String bucket;
    private String key;
    private String contentMd5 = "";
    private String date = "";
    private Config config;
    private HttpRequest request;

    public static Auth build() {
        return new Auth();
    }

    public static Auth build(String bucket, String key, String contentMd5, String date, Config config, HttpRequest request) {
        return new Auth(bucket, key, contentMd5, date, config, request);
    }

    public static String strToSign(String bucket, String key, String contentMd5, String date, HttpRequest request) {
        String contentType = request.contentType();
        if (StrUtil.isBlank((String)contentType)) {
            contentType = "text/plain";
            request.contentType(contentType);
            log.warn("Content-Type header is empty, use default Content-Type: {}", (Object)contentType);
        }
        return StrUtil.builder().append(request.method()).append("\n").append(StrUtil.nullToEmpty((String)contentMd5)).append("\n").append(contentType).append("\n").append(StrUtil.nullToEmpty((String)date)).append("\n").append(Auth.canonicalizedUcloudHeaders(request)).append(Auth.canonicalizedResource(bucket, key)).toString();
    }

    public static String sign(String privateKey, String strToSign) {
        return SignatureUtil.macSign(privateKey, strToSign);
    }

    public static String authorization(String publicKey, String signature) {
        return StrUtil.builder().append("UCloud ").append(publicKey).append(":").append(signature).toString();
    }

    public static String canonicalizedUcloudHeaders(HttpRequest request) {
        Param param = Param.create();
        Map headers = request.headers();
        for (Map.Entry headerEntry : headers.entrySet()) {
            String[] value;
            String name = ((String)headerEntry.getKey()).toLowerCase();
            if (!name.startsWith("x-ucloud-") || (value = (String[])headerEntry.getValue()) == null || value.length <= 0) continue;
            param.set(name, (Object)value[0]);
        }
        StringBuilder builder = StrUtil.builder();
        for (Map.Entry entry : param.entrySet()) {
            builder.append((String)entry.getKey()).append(":").append(entry.getValue()).append("\n");
        }
        return builder.toString();
    }

    public static String canonicalizedResource(String bucket, String key) {
        return StrUtil.builder().append("/").append(bucket).append("/").append(key).toString();
    }

    public Auth() {
    }

    public Auth(String bucket, String key, String contentMd5, String date, Config config, HttpRequest request) {
        this.bucket = bucket;
        this.key = key;
        this.contentMd5 = contentMd5;
        this.date = date;
        this.config = config;
        this.request = request;
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getContentMd5() {
        return this.contentMd5;
    }

    public void setContentMd5(String contentMd5) {
        this.contentMd5 = contentMd5;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpRequest request) {
        this.request = request;
    }

    public String toString() {
        String strToSign = Auth.strToSign(this.bucket, this.key, this.contentMd5, this.date, this.request);
        String signature = Auth.sign(this.config.getPrivateKey(), strToSign);
        String authorization = Auth.authorization(this.config.getPublicKey(), signature);
        return authorization;
    }

    public Auth clone() {
        try {
            return (Auth)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

