/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.ucloud.ufile;

import com.xiaoleilu.hutool.FileUtil;
import com.xiaoleilu.hutool.StrUtil;
import com.xiaoleilu.ucloud.core.Param;
import com.xiaoleilu.ucloud.core.Response;
import com.xiaoleilu.ucloud.core.StandardResponse;
import com.xiaoleilu.ucloud.core.Ucloud;
import com.xiaoleilu.ucloud.core.UcloudApiClient;
import com.xiaoleilu.ucloud.exception.UFileException;
import com.xiaoleilu.ucloud.ufile.Auth;
import com.xiaoleilu.ucloud.ufile.UFileAction;
import com.xiaoleilu.ucloud.ufile.UFileName;
import com.xiaoleilu.ucloud.util.Config;
import com.xiaoleilu.ucloud.util.HttpRequestUtil;
import java.io.File;
import java.io.IOException;
import jodd.http.HttpRequest;

public class UFile
extends Ucloud {
    public UFile() {
    }

    public UFile(Config config) {
        super(config);
    }

    public UFile(UcloudApiClient client) {
        super(client);
    }

    public Response createBucket(Param param) {
        return this.client.get(UFileAction.CreateBucket, param);
    }

    public Response createBucket(String bucketName) {
        return this.createBucket(Param.create(UFileName.BucketName, (Object)bucketName));
    }

    public Response describeBucket(Param param) {
        return this.client.get(UFileAction.DescribeBucket, param);
    }

    public Response updateBucket(Param param) {
        return this.client.get(UFileAction.UpdateBucket, param);
    }

    public Response deleteBucket(String bucketName) {
        return this.client.get(UFileAction.DeleteBucket, Param.create().set(UFileName.BucketName, (Object)bucketName));
    }

    public Response getFileList(Param param) {
        return this.client.get(UFileAction.GetFileList, param);
    }

    public Response getFileList(String bucketName) {
        return this.getFileList(Param.create(UFileName.BucketName, (Object)bucketName));
    }

    public String buildFileUrl(String bucket, String key) {
        return StrUtil.format((String)"http://{}.ufile.ucloud.cn/{}", (Object[])new Object[]{bucket, key});
    }

    public Response putFile(String bucket, File file, String key, String contentType) {
        byte[] fileBytes;
        try {
            fileBytes = FileUtil.readBytes((File)file);
        }
        catch (IOException e) {
            throw new UFileException(e.getMessage(), e);
        }
        HttpRequest put = (HttpRequest)HttpRequestUtil.preparePut(this.buildFileUrl(bucket, key)).body(fileBytes, contentType);
        put.header("Authorization", Auth.build(bucket, key, "", "", this.client.getConfig(), put).toString());
        return StandardResponse.parse(put.send().bodyText());
    }

    public Response putFile(String bucket, File file, String contentType) {
        return this.putFile(bucket, file, file.getName(), contentType);
    }

    public Response postFile(String bucket, File file, String key, String contentType) {
        HttpRequest post = HttpRequestUtil.preparePost(this.buildFileUrl(bucket, key));
        ((HttpRequest)((HttpRequest)((HttpRequest)post.contentType(contentType)).form("FileName", (Object)key)).form("Authorization", (Object)Auth.build(bucket, key, "", "", this.client.getConfig(), post).toString())).form("file", (Object)file);
        return StandardResponse.parse(post.send().bodyText());
    }

    public Response postFile(String bucket, File file, String contentType) {
        return this.postFile(bucket, file, file.getName(), contentType);
    }

    public File getFile(String bucket, String key, File dest, boolean isOverWrite) {
        if (dest == null) {
            throw new UFileException("Destination file is null!");
        }
        if (dest.isDirectory()) {
            dest = new File(dest, key);
        }
        if (!isOverWrite && dest.exists()) {
            throw new UFileException("Destination file [{}] exist!", dest.getAbsolutePath());
        }
        HttpRequest get = HttpRequestUtil.prepareGet(this.buildFileUrl(bucket, key));
        get.header("Authorization", Auth.build(bucket, key, "", "", this.client.getConfig(), get).toString());
        try {
            FileUtil.writeBytes((File)dest, (byte[])get.send().bodyBytes());
        }
        catch (IOException e) {
            // empty catch block
        }
        return dest;
    }
}

