/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.ucloud.uhost;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaoleilu.ucloud.core.Param;
import com.xiaoleilu.ucloud.core.Response;
import com.xiaoleilu.ucloud.core.StandardResponse;
import com.xiaoleilu.ucloud.core.Ucloud;
import com.xiaoleilu.ucloud.core.UcloudApiClient;
import com.xiaoleilu.ucloud.core.enums.PubName;
import com.xiaoleilu.ucloud.core.enums.Region;
import com.xiaoleilu.ucloud.uhost.UHostAction;
import com.xiaoleilu.ucloud.uhost.UHostName;
import com.xiaoleilu.ucloud.uhost.image.Image;
import com.xiaoleilu.ucloud.uhost.image.ImageFilter;
import com.xiaoleilu.ucloud.util.Config;

public class UHost
extends Ucloud {
    public static final String NAME_IMAGE_SET = "ImageSet";

    public UHost() {
    }

    public UHost(Config config) {
        super(config);
    }

    public UHost(UcloudApiClient client) {
        super(client);
    }

    public Response createUHostInstance(Param param) {
        return this.client.get(UHostAction.CreateUHostInstance, param);
    }

    public Response describeUHostInstance(Param param) {
        return this.client.get(UHostAction.DescribeUHostInstance, param);
    }

    public Response terminateUHostInstance(Region region, String uHostId) {
        Param param = Param.create().set(PubName.Region, (Object)region).set(UHostName.UHostId, (Object)uHostId);
        return this.client.get(UHostAction.DescribeUHostInstance, param);
    }

    public Response resizeUHostInstance(Param param) {
        return this.client.get(UHostAction.ResizeUHostInstance, param);
    }

    public Response reinstallUHostInstance(Param param) {
        return this.client.get(UHostAction.ReinstallUHostInstance, param);
    }

    public Response startUHostInstance(Region region, String uHostId) {
        Param param = Param.create().set(PubName.Region, (Object)region).set(UHostName.UHostId, (Object)uHostId);
        return this.client.get(UHostAction.StartUHostInstance, param);
    }

    public Response stopUHostInstance(Region region, String uHostId) {
        Param param = Param.create().set(PubName.Region, (Object)region).set(UHostName.UHostId, (Object)uHostId);
        return this.client.get(UHostAction.StopUHostInstance, param);
    }

    public Response rebootUHostInstance(Region region, String uHostId) {
        Param param = Param.create().set(PubName.Region, (Object)region).set(UHostName.UHostId, (Object)uHostId);
        return this.client.get(UHostAction.RebootUHostInstance, param);
    }

    public Response resetUHostInstancePassword(Region region, String uHostId, String password) {
        Param param = Param.create().set(PubName.Region, (Object)region).set(UHostName.UHostId, (Object)uHostId).setPassword(password);
        return this.client.get(UHostAction.ResetUHostInstancePassword, param);
    }

    public Response modifyUHostInstanceName(Region region, String uHostId, String name) {
        Param param = Param.create().set(PubName.Region, (Object)region).set(UHostName.UHostId, (Object)uHostId).set(UHostName.Name, (Object)name);
        return this.client.get(UHostAction.ModifyUHostInstanceName, param);
    }

    public Response modifyUHostInstanceTag(Region region, String uHostId, String tag) {
        Param param = Param.create().set(PubName.Region, (Object)region).set(UHostName.UHostId, (Object)uHostId).set(UHostName.Tag, (Object)tag);
        return this.client.get(UHostAction.ModifyUHostInstanceTag, param);
    }

    public Response modifyUHostInstanceRemark(Region region, String uHostId, String remark) {
        Param param = Param.create().set(PubName.Region, (Object)region).set(UHostName.UHostId, (Object)uHostId).set(UHostName.Remark, (Object)remark);
        return this.client.get(UHostAction.ModifyUHostInstanceRemark, param);
    }

    public Response getUHostInstancePrice(Param param) {
        return this.client.get(UHostAction.GetUHostInstancePrice, param);
    }

    public Response getUHostInstanceVncInfo(Region region, String uHostId) {
        Param param = Param.create().set(PubName.Region, (Object)region).set(UHostName.UHostId, (Object)uHostId);
        return this.client.get(UHostAction.GetUHostInstanceVncInfo, param);
    }

    public Response describeImage(Param param) {
        return this.describeImage(param, null);
    }

    public Response describeImage(Param param, ImageFilter filter) {
        StandardResponse resp = this.client.get(UHostAction.DescribeImage, param);
        JSONArray imageSet = resp.getJson().getJSONArray(NAME_IMAGE_SET);
        if (null != filter) {
            JSONArray filteredImageSet = new JSONArray();
            for (int i = 0; i < imageSet.size(); ++i) {
                JSONObject imageJson = imageSet.getJSONObject(i);
                if (!filter.filter(Image.parse(imageJson))) continue;
                filteredImageSet.add((Object)imageJson);
            }
            resp.getJson().put(NAME_IMAGE_SET, (Object)filteredImageSet);
        }
        return resp;
    }

    public Response createCustomImage(Param param) {
        return this.client.get(UHostAction.CreateCustomImage, param);
    }

    public Response terminateCustomImage(Region region, String uHostId) {
        Param param = Param.create().set(PubName.Region, (Object)region).set(UHostName.UHostId, (Object)uHostId);
        return this.client.get(UHostAction.TerminateCustomImage, param);
    }

    public Response attachUdisk(Region region, String uHostId, String uDiskId) {
        Param param = Param.create().set(PubName.Region, (Object)region).set(UHostName.UHostId, (Object)uHostId).set(UHostName.UDiskId, (Object)uDiskId);
        return this.client.get(UHostAction.AttachUdisk, param);
    }

    public Response detachUdisk(Region region, String uHostId, String uDiskId) {
        Param param = Param.create().set(PubName.Region, (Object)region).set(UHostName.UHostId, (Object)uHostId).set(UHostName.UDiskId, (Object)uDiskId);
        return this.client.get(UHostAction.DetachUdisk, param);
    }

    public Response createUHostInstanceSnapshot(Region region, String uHostId) {
        Param param = Param.create().set(PubName.Region, (Object)region).set(UHostName.UHostId, (Object)uHostId);
        return this.client.get(UHostAction.CreateUHostInstanceSnapshot, param);
    }

    public Response describeUHostInstanceSnapshot(Region region, String uHostId) {
        Param param = Param.create().set(PubName.Region, (Object)region).set(UHostName.UHostId, (Object)uHostId);
        return this.client.get(UHostAction.DescribeUHostInstanceSnapshot, param);
    }
}

