/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.ucloud.uhost.image;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xiaoleilu.hutool.Log;
import com.xiaoleilu.hutool.StrUtil;
import com.xiaoleilu.ucloud.uhost.image.ImageType;
import com.xiaoleilu.ucloud.uhost.image.OsType;
import org.slf4j.Logger;

public class Image {
    private static final Logger log = Log.get();
    private String imageId;
    private String imageName;
    private ImageType imageType;
    private String state;
    private String imageDescription;
    private String osName;
    private OsType osType;
    private long createTime;

    public String getImageId() {
        return this.imageId;
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public String getImageName() {
        return this.imageName;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public ImageType getImageType() {
        return this.imageType;
    }

    public void setImageType(ImageType imageType) {
        this.imageType = imageType;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getImageDescription() {
        return this.imageDescription;
    }

    public void setImageDescription(String imageDescription) {
        this.imageDescription = imageDescription;
    }

    public String getOsName() {
        return this.osName;
    }

    public void setOsName(String osName) {
        this.osName = osName;
    }

    public OsType getOsType() {
        return this.osType;
    }

    public void setOsType(OsType osType) {
        this.osType = osType;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public String toString() {
        return JSON.toJSONString((Object)this);
    }

    public static Image parse(JSONObject jsonObj) {
        if (null == jsonObj) {
            return null;
        }
        Image image = new Image();
        image.imageId = jsonObj.getString("ImageId");
        image.imageName = jsonObj.getString("ImageName");
        image.state = jsonObj.getString("State");
        image.osName = jsonObj.getString("OsName");
        image.createTime = jsonObj.getLong("CreateTime");
        image.imageDescription = jsonObj.getString("ImageDescription");
        String osType = null;
        try {
            osType = jsonObj.getString("OsType");
            if (StrUtil.isNotBlank((String)osType)) {
                image.osType = OsType.valueOf(osType);
            }
        }
        catch (Exception e) {
            log.warn("Unknown OS Type {}, error: {}", (Object)osType, (Object)e.getMessage());
        }
        String imageType = null;
        try {
            imageType = jsonObj.getString("ImageType");
            if (StrUtil.isNotBlank((String)imageType)) {
                image.imageType = ImageType.valueOf(imageType);
            }
        }
        catch (Exception e) {
            log.warn("Unknown Image Type {}, error: {}", (Object)imageType, (Object)e.getMessage());
        }
        return image;
    }
}

