/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.ucloud.unet;

import com.xiaoleilu.ucloud.core.Param;
import com.xiaoleilu.ucloud.core.Response;
import com.xiaoleilu.ucloud.core.Ucloud;
import com.xiaoleilu.ucloud.core.UcloudApiClient;
import com.xiaoleilu.ucloud.core.enums.PubName;
import com.xiaoleilu.ucloud.core.enums.Region;
import com.xiaoleilu.ucloud.core.enums.ResourceType;
import com.xiaoleilu.ucloud.unet.UNetAction;
import com.xiaoleilu.ucloud.unet.UNetName;
import com.xiaoleilu.ucloud.unet.security.SecurityRule;
import com.xiaoleilu.ucloud.util.Config;

public class UNet
extends Ucloud {
    public UNet() {
    }

    public UNet(Config config) {
        super(config);
    }

    public UNet(UcloudApiClient client) {
        super(client);
    }

    public Response allocateEIP(Param param) {
        return this.client.get(UNetAction.AllocateEIP, param);
    }

    public Response describeEIP(Param param) {
        return this.client.get(UNetAction.DescribeEIP, param);
    }

    public Response UpdateEIPAttribute(Param param) {
        return this.client.get(UNetAction.UpdateEIPAttribute, param);
    }

    public Response releaseEIP(Region region, String eipId) {
        Param param = Param.create().set(PubName.Region, (Object)region).set(UNetName.EIPId, (Object)eipId);
        return this.client.get(UNetAction.ReleaseEIP, param);
    }

    public Response bindEIP(Region region, String eipId, ResourceType resourceType, String resourceId) {
        Param param = Param.create().set(PubName.Region, (Object)region).set(UNetName.EIPId, (Object)eipId).set(UNetName.ResourceType, (Object)resourceType).set(UNetName.ResourceId, (Object)resourceId);
        return this.client.get(UNetAction.BindEIP, param);
    }

    public Response unBindEIP(Region region, String eipId, ResourceType resourceType, String resourceId) {
        Param param = Param.create().set(PubName.Region, (Object)region).set(UNetName.EIPId, (Object)eipId).set(UNetName.ResourceType, (Object)resourceType).set(UNetName.ResourceId, (Object)resourceId);
        return this.client.get(UNetAction.UnBindEIP, param);
    }

    public Response modifyEIPBandwidth(Region region, String eipId, int bandwidth) {
        Param param = Param.create().set(PubName.Region, (Object)region).set(UNetName.EIPId, (Object)eipId).set(UNetName.Bandwidth, (Object)bandwidth);
        return this.client.get(UNetAction.ModifyEIPBandwidth, param);
    }

    public Response modifyEIPWeight(Region region, String eipId, int weight) {
        Param param = Param.create().set(PubName.Region, (Object)region).set(UNetName.EIPId, (Object)eipId).set(UNetName.Bandwidth, (Object)weight);
        return this.client.get(UNetAction.ModifyEIPWeight, param);
    }

    public Response getEIPPrice(Param param) {
        return this.client.get(UNetAction.GetEIPPrice, param);
    }

    public Response allocateVIP(Param param) {
        return this.client.get(UNetAction.AllocateVIP, param);
    }

    public Response describeVIP(Region region) {
        Param param = Param.create().set(PubName.Region, (Object)region);
        return this.client.get(UNetAction.DescribeVIP, param);
    }

    public Response releaseVIP(Region region, String vip) {
        Param param = Param.create().set(PubName.Region, (Object)region);
        return this.client.get(UNetAction.ReleaseVIP, param);
    }

    public Response describeSecurityGroup(Param param) {
        return this.client.get(UNetAction.DescribeSecurityGroup, param);
    }

    public Response describeSecurityGroupResource(Param param) {
        return this.client.get(UNetAction.DescribeSecurityGroupResource, param);
    }

    public Response createSecurityGroup(Region region, String groupName, String description, SecurityRule ... rules) {
        Param param = Param.create().set(PubName.Region, (Object)region).set(UNetName.GroupName, (Object)groupName).set(UNetName.Description, (Object)description);
        for (int i = 0; i < rules.length; ++i) {
            param.set("Rule." + i, (Object)rules[i]);
        }
        return this.client.get(UNetAction.CreateSecurityGroup, param);
    }

    public Response updateSecurityGroup(Region region, String groupId, SecurityRule ... rules) {
        Param param = Param.create().set(PubName.Region, (Object)region).set(UNetName.GroupId, (Object)groupId);
        for (int i = 0; i < rules.length; ++i) {
            param.set("Rule." + i, (Object)rules[i]);
        }
        return this.client.get(UNetAction.UpdateSecurityGroup, param);
    }

    public Response grantSecurityGroup(Region region, String groupId, ResourceType resourceType, String resourceId) {
        Param param = Param.create().set(PubName.Region, (Object)region).set(UNetName.GroupId, (Object)groupId).set(UNetName.ResourceType, (Object)resourceType).set(UNetName.ResourceId, (Object)resourceId);
        return this.client.get(UNetAction.GrantSecurityGroup, param);
    }

    public Response deleteSecurityGroup(Region region, String groupId) {
        Param param = Param.create().set(PubName.Region, (Object)region).set(UNetName.GroupId, (Object)groupId);
        return this.client.get(UNetAction.DeleteSecurityGroup, param);
    }
}

