/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.ucloud.util;

import com.xiaoleilu.hutool.Setting;
import com.xiaoleilu.ucloud.exception.ConfigException;

public class Config
implements Cloneable {
    private static final String DEFAULT_CONFIG_PATH = "config.setting";
    private String publicKey;
    private String privateKey;
    private String baseUrl;

    public Config(String publicKey, String privateKey, String baseUrl) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.baseUrl = baseUrl;
    }

    public Config(String publicKey, String privateKey) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.baseUrl = "https://api.ucloud.cn";
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public Config clone() {
        try {
            return (Config)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public static Config createFromSetting(Setting setting) {
        return new Config(setting.getString("public_key"), setting.getString("private_key"), setting.getString("base_url"));
    }

    public static Config createFromSetting() {
        Setting setting = null;
        try {
            setting = new Setting(DEFAULT_CONFIG_PATH);
        }
        catch (Exception e) {
            throw new ConfigException(e.getMessage(), e);
        }
        return Config.createFromSetting(setting);
    }
}

