/*
 * Decompiled with CFR 0.152.
 */
package com.xwl41.common.basic.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class Decimal
extends Number
implements Comparable<Decimal> {
    private static final long serialVersionUID = 20220401L;
    private BigDecimal value;
    private RoundingMode roundingMode = RoundingMode.HALF_UP;

    public Decimal() {
        this.value = BigDecimal.ZERO;
    }

    public Decimal(String value) {
        this.value = new BigDecimal(value);
    }

    public Decimal(BigDecimal value) {
        this.value = Decimal.newDecimal(value);
    }

    public <T extends Number> Decimal(T t) {
        this.value = Decimal.newDecimal(t);
    }

    public <T extends Number> Decimal(T t, int scale) {
        this.value = Decimal.newDecimal(t).setScale(scale);
    }

    public <T extends Number> Decimal(T t, int scale, RoundingMode roundingMode) {
        this.value = Decimal.newDecimal(t).setScale(scale, roundingMode);
    }

    public <T extends Number> Decimal add(T t) {
        this.value = this.value.add(Decimal.nullToZero(t));
        return this;
    }

    public <T extends Number> Decimal subtract(T subtrahend) {
        this.value = this.value.subtract(Decimal.nullToZero(subtrahend));
        return this;
    }

    public <T extends Number> Decimal multiply(T t) {
        this.value = this.value.multiply(Decimal.nullToZero(t));
        return this;
    }

    public <T extends Number> Decimal divide(T t) {
        this.value = this.value.divide(Decimal.newDecimal(t), this.value.scale(), this.roundingMode);
        return this;
    }

    public <T extends Number> Decimal divide(T t, int scale) {
        this.value = this.value.divide(Decimal.newDecimal(t), scale, this.roundingMode);
        return this;
    }

    public <T extends Number> Decimal divide(T t, int scale, RoundingMode roundingMode) {
        this.value = this.value.divide(Decimal.newDecimal(t), scale, roundingMode);
        return this;
    }

    public BigDecimal get() {
        return this.value;
    }

    public Decimal setScale(int newScale) {
        this.value = this.value.setScale(newScale);
        return this;
    }

    public Decimal setScale(int newScale, RoundingMode roundingMode) {
        this.value = this.value.setScale(newScale, roundingMode);
        this.roundingMode = roundingMode;
        return this;
    }

    public static Decimal newDecimal() {
        return new Decimal();
    }

    private static <T extends Number> BigDecimal newDecimal(T value) {
        return new BigDecimal(String.valueOf(value));
    }

    private static <T extends Number> BigDecimal nullToZero(T value) {
        return value == null ? BigDecimal.ZERO : Decimal.newDecimal(value);
    }

    @Override
    public int compareTo(Decimal o) {
        return this.get().compareTo(o.get());
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    @Override
    public long longValue() {
        return this.value.longValue();
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }

    public String toString() {
        return this.value.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Decimal that = (Decimal)o;
        return this.value.equals(that.get());
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

