/*
 * Decompiled with CFR 0.152.
 */
package com.xwl41.common.basic.helper;

import com.xwl41.common.basic.constant.Algorithms;
import com.xwl41.common.basic.util.CoreUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class RSAHelper {
    public static Map<String, Key> genRSAKeyPair(int keySize) throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(Algorithms.RSA.toString());
        keyPairGen.initialize(keySize);
        KeyPair keyPair = keyPairGen.generateKeyPair();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        HashMap<String, Key> keyMap = new HashMap<String, Key>(2);
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        keyMap.put(RSAKeyType.PUBLIC.toString(), publicKey);
        keyMap.put(RSAKeyType.PRIVATE.toString(), privateKey);
        return keyMap;
    }

    public static Map<String, String> genRSAKeyStringPair(int keySize) throws NoSuchAlgorithmException {
        Map<String, Key> keyMap = RSAHelper.genRSAKeyPair(keySize);
        HashMap<String, String> keyStringMap = new HashMap<String, String>();
        keyStringMap.put(RSAKeyType.PUBLIC.toString(), RSAHelper.toEncodedString(keyMap.get(RSAKeyType.PUBLIC.toString())));
        keyStringMap.put(RSAKeyType.PRIVATE.toString(), RSAHelper.toEncodedString(keyMap.get(RSAKeyType.PRIVATE.toString())));
        return keyStringMap;
    }

    public static boolean saveKeyPair(Map<String, Key> keyMap, String path) {
        boolean saved = false;
        Key publicKey = keyMap.get(RSAKeyType.PUBLIC.toString());
        Key privateKey = keyMap.get(RSAKeyType.PRIVATE.toString());
        String keyPairStr = publicKey.toString() + "\r\n[" + Base64.getEncoder().encodeToString(publicKey.getEncoded()) + "]\r\n" + privateKey.toString() + "\r\n[" + Base64.getEncoder().encodeToString(privateKey.getEncoded()) + "]\r\n";
        String publicKeyStr = RSAHelper.genKeyContent(RSAHelper.toEncodedString(publicKey), RSAKeyType.PUBLIC);
        String privateKeyStr = RSAHelper.genKeyContent(RSAHelper.toEncodedString(privateKey), RSAKeyType.PRIVATE);
        File p = new File(path);
        if (p.isDirectory() && (p.exists() || p.mkdirs())) {
            CoreUtil.FILE.saveToFile(new ByteArrayInputStream(keyPairStr.getBytes()), path + File.separator + "keypair.txt");
            CoreUtil.FILE.saveToFile(new ByteArrayInputStream(publicKeyStr.getBytes()), path + File.separator + "publicKey.pem");
            CoreUtil.FILE.saveToFile(new ByteArrayInputStream(privateKeyStr.getBytes()), path + File.separator + "privateKey.pem");
            saved = true;
        }
        return saved;
    }

    public static RSAPublicKey convertToPublicKey(String encodedBase64KeyStr) {
        RSAPublicKey key = null;
        try {
            byte[] keyBytes = Base64.getDecoder().decode(encodedBase64KeyStr);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(Algorithms.RSA.toString());
            key = (RSAPublicKey)keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            e.printStackTrace();
        }
        return key;
    }

    public static RSAPrivateKey convertToPrivateKey(String encodedBase64KeyStr) {
        RSAPrivateKey key = null;
        try {
            PKCS8EncodedKeySpec priPKCS8 = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(encodedBase64KeyStr));
            KeyFactory keyf = KeyFactory.getInstance(Algorithms.RSA.toString());
            key = (RSAPrivateKey)keyf.generatePrivate(priPKCS8);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            e.printStackTrace();
        }
        return key;
    }

    public static RSAPublicKey getRSAPublicKey(String keyFileContent) {
        return RSAHelper.convertToPublicKey(RSAHelper.keyContentProcess(keyFileContent, RSAKeyType.PUBLIC.beginStr(), RSAKeyType.PUBLIC.endStr()));
    }

    public static RSAPrivateKey getRSAPrivateKey(String keyFileContent) {
        return RSAHelper.convertToPrivateKey(RSAHelper.keyContentProcess(keyFileContent, RSAKeyType.PRIVATE.beginStr(), RSAKeyType.PRIVATE.endStr()));
    }

    public static byte[] decrypt(PrivateKey key, byte[] cipherData) {
        byte[] plainData = null;
        try {
            Cipher c = Cipher.getInstance(Algorithms.RSA.toString());
            c.init(2, key);
            plainData = c.doFinal(cipherData);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            e.printStackTrace();
        }
        return plainData;
    }

    public static String decryptFromBase64String(PrivateKey key, String base64Ciphertext) {
        String plaintext = "";
        try {
            Cipher c = Cipher.getInstance(Algorithms.RSA.toString());
            c.init(2, key);
            byte[] cipherBytes = Base64.getDecoder().decode(base64Ciphertext);
            byte[] content = c.doFinal(cipherBytes);
            plaintext = new String(content);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            e.printStackTrace();
        }
        return plaintext;
    }

    public static byte[] encrypt(PublicKey key, byte[] plainData) {
        byte[] cipherData = null;
        try {
            Cipher c = Cipher.getInstance(Algorithms.RSA.toString());
            c.init(1, key);
            cipherData = c.doFinal(plainData);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            e.printStackTrace();
        }
        return cipherData;
    }

    public static String encryptToBase64String(PublicKey key, String plaintext) {
        return RSAHelper.encryptToBase64String(key, plaintext, StandardCharsets.UTF_8);
    }

    public static String encryptToBase64String(PublicKey key, String plaintext, Charset charset) {
        byte[] cipherData = RSAHelper.encrypt(key, plaintext.getBytes(charset));
        return Base64.getEncoder().encodeToString(cipherData);
    }

    public static String encryptToBase64String(String publicKeyStr, String plaintext) {
        return RSAHelper.encryptToBase64String(RSAHelper.convertToPublicKey(publicKeyStr), plaintext);
    }

    public static String encryptToBase64String(String publicKeyStr, String plaintext, Charset charset) {
        return RSAHelper.encryptToBase64String(RSAHelper.convertToPublicKey(publicKeyStr), plaintext, charset);
    }

    private static String sign(String plainText, byte[] keyEncoded, String signAlgorithm) {
        try {
            PKCS8EncodedKeySpec priPKCS8 = new PKCS8EncodedKeySpec(keyEncoded);
            KeyFactory keyf = KeyFactory.getInstance("RSA");
            PrivateKey priKey = keyf.generatePrivate(priPKCS8);
            Signature signature = Signature.getInstance(signAlgorithm);
            signature.initSign(priKey);
            signature.update(plainText.getBytes(StandardCharsets.UTF_8));
            byte[] signed = signature.sign();
            return Base64.getEncoder().encodeToString(signed);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String sign(String plainText, String privateKey, String signAlgorithm) {
        byte[] keyEncoded = Base64.getDecoder().decode(privateKey);
        return RSAHelper.sign(plainText, keyEncoded, signAlgorithm);
    }

    public static String sign(String plainText, PrivateKey privateKey, String signAlgorithm) {
        return RSAHelper.sign(plainText, privateKey.getEncoded(), signAlgorithm);
    }

    public static String sign(String plainText, String privateKey) {
        return RSAHelper.sign(plainText, privateKey, "MD5withRSA");
    }

    public static String sign(String plainText, PrivateKey privateKey) {
        return RSAHelper.sign(plainText, privateKey.getEncoded(), "MD5withRSA");
    }

    public static boolean check(String plainText, String encodedSign, String encodedPublicKey, String signAlgorithm) {
        try {
            RSAPublicKey key = RSAHelper.convertToPublicKey(encodedPublicKey);
            Signature signatureChecker = Signature.getInstance(signAlgorithm);
            signatureChecker.initVerify(key);
            signatureChecker.update(plainText.getBytes(StandardCharsets.UTF_8));
            return signatureChecker.verify(Base64.getDecoder().decode(encodedSign));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean check(String plainText, String encodedSign, String encodedPublicKey) {
        return RSAHelper.check(plainText, encodedSign, encodedPublicKey, "MD5withRSA");
    }

    public static boolean check(String plainText, String encodedSign, PublicKey publicKey, String signAlgorithm) {
        try {
            Signature signatureChecker = Signature.getInstance(signAlgorithm);
            signatureChecker.initVerify(publicKey);
            signatureChecker.update(plainText.getBytes(StandardCharsets.UTF_8));
            return signatureChecker.verify(Base64.getDecoder().decode(encodedSign));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean check(String plainText, String encodedSign, PublicKey publicKey) {
        return RSAHelper.check(plainText, encodedSign, publicKey, "MD5withRSA");
    }

    public static String toEncodedString(Key key) {
        return Base64.getEncoder().encodeToString(key.getEncoded());
    }

    private static String keyContentProcess(String keyContent, String beginStr, String endStr) {
        return keyContent.replace(beginStr, "").replace(endStr, "").replace("\n", "").replace("\r", "");
    }

    private static String genKeyContent(String encodedBase64KeyStr, RSAKeyType keyType) {
        String beginStr = RSAKeyType.PUBLIC.equals((Object)keyType) ? RSAKeyType.PUBLIC.beginStr() : RSAKeyType.PRIVATE.beginStr();
        StringBuilder keyStr = new StringBuilder(beginStr).append("\r\n");
        int i = 0;
        while (i + 64 < encodedBase64KeyStr.length()) {
            keyStr.append(encodedBase64KeyStr, i, i + 64).append("\n");
            i += 64;
        }
        keyStr.append(encodedBase64KeyStr.substring(i)).append("\n").append(RSAKeyType.PUBLIC.equals((Object)keyType) ? RSAKeyType.PUBLIC.endStr() : RSAKeyType.PRIVATE.endStr());
        return keyStr.toString();
    }

    static enum RSAKeyType {
        PUBLIC("-----BEGIN RSA PUBLIC KEY-----", "-----END RSA PUBLIC KEY-----"),
        PRIVATE("-----BEGIN RSA PRIVATE KEY-----", "-----END RSA PRIVATE KEY-----");

        private final String beginStr;
        private final String endStr;

        private RSAKeyType(String beginStr, String endStr) {
            this.beginStr = beginStr;
            this.endStr = endStr;
        }

        public String beginStr() {
            return this.beginStr;
        }

        public String endStr() {
            return this.endStr;
        }
    }
}

